# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPlanResult',
    'AwaitableGetPlanResult',
    'get_plan',
    'get_plan_output',
]

@pulumi.output_type
class GetPlanResult:
    """
    A collection of values returned by getPlan.
    """
    def __init__(__self__, arn=None, id=None, name=None, plan_id=None, region=None, rules=None, tags=None, version=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the backup plan.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Display name of a backup plan.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> _builtins.str:
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetPlanRuleResult']:
        """
        Rules of a backup plan.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Metadata that you can assign to help organize the plans you create.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Unique, randomly generated, Unicode, UTF-8 encoded string that serves as the version ID of the backup plan.
        """
        return pulumi.get(self, "version")


class AwaitableGetPlanResult(GetPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlanResult(
            arn=self.arn,
            id=self.id,
            name=self.name,
            plan_id=self.plan_id,
            region=self.region,
            rules=self.rules,
            tags=self.tags,
            version=self.version)


def get_plan(plan_id: Optional[_builtins.str] = None,
             region: Optional[_builtins.str] = None,
             tags: Optional[Mapping[str, _builtins.str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlanResult:
    """
    Use this data source to get information on an existing backup plan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.backup.get_plan(plan_id="my_example_backup_plan_id")
    ```


    :param _builtins.str plan_id: Backup plan ID.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Metadata that you can assign to help organize the plans you create.
    """
    __args__ = dict()
    __args__['planId'] = plan_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:backup/getPlan:getPlan', __args__, opts=opts, typ=GetPlanResult).value

    return AwaitableGetPlanResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        plan_id=pulumi.get(__ret__, 'plan_id'),
        region=pulumi.get(__ret__, 'region'),
        rules=pulumi.get(__ret__, 'rules'),
        tags=pulumi.get(__ret__, 'tags'),
        version=pulumi.get(__ret__, 'version'))
def get_plan_output(plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlanResult]:
    """
    Use this data source to get information on an existing backup plan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.backup.get_plan(plan_id="my_example_backup_plan_id")
    ```


    :param _builtins.str plan_id: Backup plan ID.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Metadata that you can assign to help organize the plans you create.
    """
    __args__ = dict()
    __args__['planId'] = plan_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:backup/getPlan:getPlan', __args__, opts=opts, typ=GetPlanResult)
    return __ret__.apply(lambda __response__: GetPlanResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        plan_id=pulumi.get(__response__, 'plan_id'),
        region=pulumi.get(__response__, 'region'),
        rules=pulumi.get(__response__, 'rules'),
        tags=pulumi.get(__response__, 'tags'),
        version=pulumi.get(__response__, 'version')))
