# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegionSettingsArgs', 'RegionSettings']

@pulumi.input_type
class RegionSettingsArgs:
    def __init__(__self__, *,
                 resource_type_opt_in_preference: pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None):
        """
        The set of arguments for constructing a RegionSettings resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] resource_type_opt_in_preference: A map of service names to their opt-in preferences for the Region. See [AWS Documentation on which services support backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html).
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] resource_type_management_preference: A map of service names to their full management preferences for the Region. For more information, see the AWS Documentation on [what full management is](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management) and [which services support full management](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource).
        """
        pulumi.set(__self__, "resource_type_opt_in_preference", resource_type_opt_in_preference)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_type_management_preference is not None:
            pulumi.set(__self__, "resource_type_management_preference", resource_type_management_preference)

    @_builtins.property
    @pulumi.getter(name="resourceTypeOptInPreference")
    def resource_type_opt_in_preference(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]:
        """
        A map of service names to their opt-in preferences for the Region. See [AWS Documentation on which services support backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html).
        """
        return pulumi.get(self, "resource_type_opt_in_preference")

    @resource_type_opt_in_preference.setter
    def resource_type_opt_in_preference(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]):
        pulumi.set(self, "resource_type_opt_in_preference", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypeManagementPreference")
    def resource_type_management_preference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]]:
        """
        A map of service names to their full management preferences for the Region. For more information, see the AWS Documentation on [what full management is](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management) and [which services support full management](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource).
        """
        return pulumi.get(self, "resource_type_management_preference")

    @resource_type_management_preference.setter
    def resource_type_management_preference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]]):
        pulumi.set(self, "resource_type_management_preference", value)


@pulumi.input_type
class _RegionSettingsState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None,
                 resource_type_opt_in_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None):
        """
        Input properties used for looking up and filtering RegionSettings resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] resource_type_management_preference: A map of service names to their full management preferences for the Region. For more information, see the AWS Documentation on [what full management is](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management) and [which services support full management](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] resource_type_opt_in_preference: A map of service names to their opt-in preferences for the Region. See [AWS Documentation on which services support backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html).
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_type_management_preference is not None:
            pulumi.set(__self__, "resource_type_management_preference", resource_type_management_preference)
        if resource_type_opt_in_preference is not None:
            pulumi.set(__self__, "resource_type_opt_in_preference", resource_type_opt_in_preference)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypeManagementPreference")
    def resource_type_management_preference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]]:
        """
        A map of service names to their full management preferences for the Region. For more information, see the AWS Documentation on [what full management is](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management) and [which services support full management](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource).
        """
        return pulumi.get(self, "resource_type_management_preference")

    @resource_type_management_preference.setter
    def resource_type_management_preference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]]):
        pulumi.set(self, "resource_type_management_preference", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypeOptInPreference")
    def resource_type_opt_in_preference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]]:
        """
        A map of service names to their opt-in preferences for the Region. See [AWS Documentation on which services support backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html).
        """
        return pulumi.get(self, "resource_type_opt_in_preference")

    @resource_type_opt_in_preference.setter
    def resource_type_opt_in_preference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]]):
        pulumi.set(self, "resource_type_opt_in_preference", value)


@pulumi.type_token("aws:backup/regionSettings:RegionSettings")
class RegionSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None,
                 resource_type_opt_in_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None,
                 __props__=None):
        """
        Provides an AWS Backup Region Settings resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.backup.RegionSettings("test",
            resource_type_opt_in_preference={
                "Aurora": True,
                "CloudFormation": True,
                "DocumentDB": True,
                "DSQL": True,
                "DynamoDB": True,
                "EBS": True,
                "EC2": True,
                "EFS": True,
                "FSx": True,
                "Neptune": True,
                "Redshift": True,
                "Redshift Serverless": False,
                "RDS": False,
                "S3": False,
                "SAP HANA on Amazon EC2": False,
                "Storage Gateway": False,
                "VirtualMachine": False,
            },
            resource_type_management_preference={
                "CloudFormation": True,
                "DSQL": True,
                "DynamoDB": False,
                "EFS": False,
            })
        ```

        ## Import

        Using `pulumi import`, import Backup Region Settings using the `region`. For example:

        ```sh
        $ pulumi import aws:backup/regionSettings:RegionSettings test us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] resource_type_management_preference: A map of service names to their full management preferences for the Region. For more information, see the AWS Documentation on [what full management is](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management) and [which services support full management](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] resource_type_opt_in_preference: A map of service names to their opt-in preferences for the Region. See [AWS Documentation on which services support backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Backup Region Settings resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.backup.RegionSettings("test",
            resource_type_opt_in_preference={
                "Aurora": True,
                "CloudFormation": True,
                "DocumentDB": True,
                "DSQL": True,
                "DynamoDB": True,
                "EBS": True,
                "EC2": True,
                "EFS": True,
                "FSx": True,
                "Neptune": True,
                "Redshift": True,
                "Redshift Serverless": False,
                "RDS": False,
                "S3": False,
                "SAP HANA on Amazon EC2": False,
                "Storage Gateway": False,
                "VirtualMachine": False,
            },
            resource_type_management_preference={
                "CloudFormation": True,
                "DSQL": True,
                "DynamoDB": False,
                "EFS": False,
            })
        ```

        ## Import

        Using `pulumi import`, import Backup Region Settings using the `region`. For example:

        ```sh
        $ pulumi import aws:backup/regionSettings:RegionSettings test us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param RegionSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None,
                 resource_type_opt_in_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionSettingsArgs.__new__(RegionSettingsArgs)

            __props__.__dict__["region"] = region
            __props__.__dict__["resource_type_management_preference"] = resource_type_management_preference
            if resource_type_opt_in_preference is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type_opt_in_preference'")
            __props__.__dict__["resource_type_opt_in_preference"] = resource_type_opt_in_preference
        super(RegionSettings, __self__).__init__(
            'aws:backup/regionSettings:RegionSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None,
            resource_type_opt_in_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None) -> 'RegionSettings':
        """
        Get an existing RegionSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] resource_type_management_preference: A map of service names to their full management preferences for the Region. For more information, see the AWS Documentation on [what full management is](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management) and [which services support full management](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] resource_type_opt_in_preference: A map of service names to their opt-in preferences for the Region. See [AWS Documentation on which services support backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionSettingsState.__new__(_RegionSettingsState)

        __props__.__dict__["region"] = region
        __props__.__dict__["resource_type_management_preference"] = resource_type_management_preference
        __props__.__dict__["resource_type_opt_in_preference"] = resource_type_opt_in_preference
        return RegionSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceTypeManagementPreference")
    def resource_type_management_preference(self) -> pulumi.Output[Mapping[str, _builtins.bool]]:
        """
        A map of service names to their full management preferences for the Region. For more information, see the AWS Documentation on [what full management is](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management) and [which services support full management](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource).
        """
        return pulumi.get(self, "resource_type_management_preference")

    @_builtins.property
    @pulumi.getter(name="resourceTypeOptInPreference")
    def resource_type_opt_in_preference(self) -> pulumi.Output[Mapping[str, _builtins.bool]]:
        """
        A map of service names to their opt-in preferences for the Region. See [AWS Documentation on which services support backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html).
        """
        return pulumi.get(self, "resource_type_opt_in_preference")

