# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RestoreTestingPlanArgs', 'RestoreTestingPlan']

@pulumi.input_type
class RestoreTestingPlanArgs:
    def __init__(__self__, *,
                 schedule_expression: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_selection: Optional[pulumi.Input['RestoreTestingPlanRecoveryPointSelectionArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 start_window_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RestoreTestingPlan resource.
        :param pulumi.Input[_builtins.str] schedule_expression: The schedule expression for the restore testing plan.
        :param pulumi.Input[_builtins.str] name: The name of the restore testing plan. Must be between 1 and 50 characters long and contain only alphanumeric characters and underscores.
        :param pulumi.Input['RestoreTestingPlanRecoveryPointSelectionArgs'] recovery_point_selection: Specifies the recovery point selection configuration. See RecoveryPointSelection section for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] schedule_expression_timezone: The timezone for the schedule expression. If not provided, the state value will be used.
        :param pulumi.Input[_builtins.int] start_window_hours: The number of hours in the start window for the restore testing plan. Must be between 1 and 168.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_point_selection is not None:
            pulumi.set(__self__, "recovery_point_selection", recovery_point_selection)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule_expression_timezone is not None:
            pulumi.set(__self__, "schedule_expression_timezone", schedule_expression_timezone)
        if start_window_hours is not None:
            pulumi.set(__self__, "start_window_hours", start_window_hours)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Input[_builtins.str]:
        """
        The schedule expression for the restore testing plan.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schedule_expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the restore testing plan. Must be between 1 and 50 characters long and contain only alphanumeric characters and underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryPointSelection")
    def recovery_point_selection(self) -> Optional[pulumi.Input['RestoreTestingPlanRecoveryPointSelectionArgs']]:
        """
        Specifies the recovery point selection configuration. See RecoveryPointSelection section for more details.
        """
        return pulumi.get(self, "recovery_point_selection")

    @recovery_point_selection.setter
    def recovery_point_selection(self, value: Optional[pulumi.Input['RestoreTestingPlanRecoveryPointSelectionArgs']]):
        pulumi.set(self, "recovery_point_selection", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scheduleExpressionTimezone")
    def schedule_expression_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timezone for the schedule expression. If not provided, the state value will be used.
        """
        return pulumi.get(self, "schedule_expression_timezone")

    @schedule_expression_timezone.setter
    def schedule_expression_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_expression_timezone", value)

    @_builtins.property
    @pulumi.getter(name="startWindowHours")
    def start_window_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of hours in the start window for the restore testing plan. Must be between 1 and 168.
        """
        return pulumi.get(self, "start_window_hours")

    @start_window_hours.setter
    def start_window_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_window_hours", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RestoreTestingPlanState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_selection: Optional[pulumi.Input['RestoreTestingPlanRecoveryPointSelectionArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 start_window_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RestoreTestingPlan resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Restore Testing Plan.
        :param pulumi.Input[_builtins.str] name: The name of the restore testing plan. Must be between 1 and 50 characters long and contain only alphanumeric characters and underscores.
        :param pulumi.Input['RestoreTestingPlanRecoveryPointSelectionArgs'] recovery_point_selection: Specifies the recovery point selection configuration. See RecoveryPointSelection section for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] schedule_expression: The schedule expression for the restore testing plan.
        :param pulumi.Input[_builtins.str] schedule_expression_timezone: The timezone for the schedule expression. If not provided, the state value will be used.
        :param pulumi.Input[_builtins.int] start_window_hours: The number of hours in the start window for the restore testing plan. Must be between 1 and 168.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_point_selection is not None:
            pulumi.set(__self__, "recovery_point_selection", recovery_point_selection)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if schedule_expression_timezone is not None:
            pulumi.set(__self__, "schedule_expression_timezone", schedule_expression_timezone)
        if start_window_hours is not None:
            pulumi.set(__self__, "start_window_hours", start_window_hours)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Restore Testing Plan.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the restore testing plan. Must be between 1 and 50 characters long and contain only alphanumeric characters and underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryPointSelection")
    def recovery_point_selection(self) -> Optional[pulumi.Input['RestoreTestingPlanRecoveryPointSelectionArgs']]:
        """
        Specifies the recovery point selection configuration. See RecoveryPointSelection section for more details.
        """
        return pulumi.get(self, "recovery_point_selection")

    @recovery_point_selection.setter
    def recovery_point_selection(self, value: Optional[pulumi.Input['RestoreTestingPlanRecoveryPointSelectionArgs']]):
        pulumi.set(self, "recovery_point_selection", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule expression for the restore testing plan.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_expression", value)

    @_builtins.property
    @pulumi.getter(name="scheduleExpressionTimezone")
    def schedule_expression_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timezone for the schedule expression. If not provided, the state value will be used.
        """
        return pulumi.get(self, "schedule_expression_timezone")

    @schedule_expression_timezone.setter
    def schedule_expression_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_expression_timezone", value)

    @_builtins.property
    @pulumi.getter(name="startWindowHours")
    def start_window_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of hours in the start window for the restore testing plan. Must be between 1 and 168.
        """
        return pulumi.get(self, "start_window_hours")

    @start_window_hours.setter
    def start_window_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_window_hours", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:backup/restoreTestingPlan:RestoreTestingPlan")
class RestoreTestingPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_selection: Optional[pulumi.Input[Union['RestoreTestingPlanRecoveryPointSelectionArgs', 'RestoreTestingPlanRecoveryPointSelectionArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 start_window_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Backup Restore Testing Plan.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.backup.RestoreTestingPlan("example",
            name="example_restore_testing_plan",
            recovery_point_selection={
                "algorithm": "LATEST_WITHIN_WINDOW",
                "include_vaults": ["*"],
                "recovery_point_types": ["CONTINUOUS"],
            },
            schedule_expression="cron(0 12 ? * * *)")
        ```

        ## Import

        Using `pulumi import`, import Backup Restore Testing Plan using the `name`. For example:

        ```sh
        $ pulumi import aws:backup/restoreTestingPlan:RestoreTestingPlan example my_testing_plan
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the restore testing plan. Must be between 1 and 50 characters long and contain only alphanumeric characters and underscores.
        :param pulumi.Input[Union['RestoreTestingPlanRecoveryPointSelectionArgs', 'RestoreTestingPlanRecoveryPointSelectionArgsDict']] recovery_point_selection: Specifies the recovery point selection configuration. See RecoveryPointSelection section for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] schedule_expression: The schedule expression for the restore testing plan.
        :param pulumi.Input[_builtins.str] schedule_expression_timezone: The timezone for the schedule expression. If not provided, the state value will be used.
        :param pulumi.Input[_builtins.int] start_window_hours: The number of hours in the start window for the restore testing plan. Must be between 1 and 168.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestoreTestingPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Backup Restore Testing Plan.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.backup.RestoreTestingPlan("example",
            name="example_restore_testing_plan",
            recovery_point_selection={
                "algorithm": "LATEST_WITHIN_WINDOW",
                "include_vaults": ["*"],
                "recovery_point_types": ["CONTINUOUS"],
            },
            schedule_expression="cron(0 12 ? * * *)")
        ```

        ## Import

        Using `pulumi import`, import Backup Restore Testing Plan using the `name`. For example:

        ```sh
        $ pulumi import aws:backup/restoreTestingPlan:RestoreTestingPlan example my_testing_plan
        ```

        :param str resource_name: The name of the resource.
        :param RestoreTestingPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestoreTestingPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_selection: Optional[pulumi.Input[Union['RestoreTestingPlanRecoveryPointSelectionArgs', 'RestoreTestingPlanRecoveryPointSelectionArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 start_window_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestoreTestingPlanArgs.__new__(RestoreTestingPlanArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["recovery_point_selection"] = recovery_point_selection
            __props__.__dict__["region"] = region
            if schedule_expression is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_expression'")
            __props__.__dict__["schedule_expression"] = schedule_expression
            __props__.__dict__["schedule_expression_timezone"] = schedule_expression_timezone
            __props__.__dict__["start_window_hours"] = start_window_hours
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(RestoreTestingPlan, __self__).__init__(
            'aws:backup/restoreTestingPlan:RestoreTestingPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_point_selection: Optional[pulumi.Input[Union['RestoreTestingPlanRecoveryPointSelectionArgs', 'RestoreTestingPlanRecoveryPointSelectionArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_expression: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_expression_timezone: Optional[pulumi.Input[_builtins.str]] = None,
            start_window_hours: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'RestoreTestingPlan':
        """
        Get an existing RestoreTestingPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Restore Testing Plan.
        :param pulumi.Input[_builtins.str] name: The name of the restore testing plan. Must be between 1 and 50 characters long and contain only alphanumeric characters and underscores.
        :param pulumi.Input[Union['RestoreTestingPlanRecoveryPointSelectionArgs', 'RestoreTestingPlanRecoveryPointSelectionArgsDict']] recovery_point_selection: Specifies the recovery point selection configuration. See RecoveryPointSelection section for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] schedule_expression: The schedule expression for the restore testing plan.
        :param pulumi.Input[_builtins.str] schedule_expression_timezone: The timezone for the schedule expression. If not provided, the state value will be used.
        :param pulumi.Input[_builtins.int] start_window_hours: The number of hours in the start window for the restore testing plan. Must be between 1 and 168.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RestoreTestingPlanState.__new__(_RestoreTestingPlanState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["name"] = name
        __props__.__dict__["recovery_point_selection"] = recovery_point_selection
        __props__.__dict__["region"] = region
        __props__.__dict__["schedule_expression"] = schedule_expression
        __props__.__dict__["schedule_expression_timezone"] = schedule_expression_timezone
        __props__.__dict__["start_window_hours"] = start_window_hours
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return RestoreTestingPlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Restore Testing Plan.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the restore testing plan. Must be between 1 and 50 characters long and contain only alphanumeric characters and underscores.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recoveryPointSelection")
    def recovery_point_selection(self) -> pulumi.Output[Optional['outputs.RestoreTestingPlanRecoveryPointSelection']]:
        """
        Specifies the recovery point selection configuration. See RecoveryPointSelection section for more details.
        """
        return pulumi.get(self, "recovery_point_selection")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Output[_builtins.str]:
        """
        The schedule expression for the restore testing plan.
        """
        return pulumi.get(self, "schedule_expression")

    @_builtins.property
    @pulumi.getter(name="scheduleExpressionTimezone")
    def schedule_expression_timezone(self) -> pulumi.Output[_builtins.str]:
        """
        The timezone for the schedule expression. If not provided, the state value will be used.
        """
        return pulumi.get(self, "schedule_expression_timezone")

    @_builtins.property
    @pulumi.getter(name="startWindowHours")
    def start_window_hours(self) -> pulumi.Output[_builtins.int]:
        """
        The number of hours in the start window for the restore testing plan. Must be between 1 and 168.
        """
        return pulumi.get(self, "start_window_hours")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

