# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentFlowArgs', 'AgentFlow']

@pulumi.input_type
class AgentFlowArgs:
    def __init__(__self__, *,
                 execution_role_arn: pulumi.Input[_builtins.str],
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 definition: Optional[pulumi.Input['AgentFlowDefinitionArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentFlowTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentFlow resource.
        :param pulumi.Input[_builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the service role with permissions to create and manage a flow. For more information, see [Create a service role for flows in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html) in the Amazon Bedrock User Guide.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
        :param pulumi.Input['AgentFlowDefinitionArgs'] definition: A definition of the nodes and connections between nodes in the flow. See Definition for more information.
        :param pulumi.Input[_builtins.str] description: A description for the flow.
        :param pulumi.Input[_builtins.str] name: A name for the flow.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if customer_encryption_key_arn is not None:
            pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if definition is not None:
            pulumi.set(__self__, "definition", definition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the service role with permissions to create and manage a flow. For more information, see [Create a service role for flows in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html) in the Amazon Bedrock User Guide.

        The following arguments are optional:
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "execution_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @customer_encryption_key_arn.setter
    def customer_encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter
    def definition(self) -> Optional[pulumi.Input['AgentFlowDefinitionArgs']]:
        """
        A definition of the nodes and connections between nodes in the flow. See Definition for more information.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: Optional[pulumi.Input['AgentFlowDefinitionArgs']]):
        pulumi.set(self, "definition", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the flow.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentFlowTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentFlowTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentFlowState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 definition: Optional[pulumi.Input['AgentFlowDefinitionArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentFlowTimeoutsArgs']] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentFlow resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the flow.
        :param pulumi.Input[_builtins.str] created_at: The time at which the flow was created.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
        :param pulumi.Input['AgentFlowDefinitionArgs'] definition: A definition of the nodes and connections between nodes in the flow. See Definition for more information.
        :param pulumi.Input[_builtins.str] description: A description for the flow.
        :param pulumi.Input[_builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the service role with permissions to create and manage a flow. For more information, see [Create a service role for flows in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html) in the Amazon Bedrock User Guide.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] name: A name for the flow.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The status of the flow.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] updated_at: The time at which the flow was last updated.
        :param pulumi.Input[_builtins.str] version: The version of the flow.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if customer_encryption_key_arn is not None:
            pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if definition is not None:
            pulumi.set(__self__, "definition", definition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the flow.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the flow was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @customer_encryption_key_arn.setter
    def customer_encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter
    def definition(self) -> Optional[pulumi.Input['AgentFlowDefinitionArgs']]:
        """
        A definition of the nodes and connections between nodes in the flow. See Definition for more information.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: Optional[pulumi.Input['AgentFlowDefinitionArgs']]):
        pulumi.set(self, "definition", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the flow.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the service role with permissions to create and manage a flow. For more information, see [Create a service role for flows in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html) in the Amazon Bedrock User Guide.

        The following arguments are optional:
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the flow.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentFlowTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentFlowTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the flow was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the flow.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws:bedrock/agentFlow:AgentFlow")
class AgentFlow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 definition: Optional[pulumi.Input[Union['AgentFlowDefinitionArgs', 'AgentFlowDefinitionArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentFlowTimeoutsArgs', 'AgentFlowTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Bedrock Agents Flow.

        ## Example Usage

        The default definition:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentFlow("example",
            name="example",
            execution_role_arn=example_aws_iam_role["arn"],
            definition={
                "connections": [
                    {
                        "name": "FlowInputNodeFlowInputNode0ToPrompt_1PromptsNode0",
                        "source": "FlowInputNode",
                        "target": "Prompt_1",
                        "type": "Data",
                        "configuration": {
                            "data": {
                                "source_output": "document",
                                "target_input": "topic",
                            },
                        },
                    },
                    {
                        "name": "Prompt_1PromptsNode0ToFlowOutputNodeFlowOutputNode0",
                        "source": "Prompt_1",
                        "target": "FlowOutputNode",
                        "type": "Data",
                        "configuration": {
                            "data": {
                                "source_output": "modelCompletion",
                                "target_input": "document",
                            },
                        },
                    },
                ],
                "nodes": [
                    {
                        "name": "FlowInputNode",
                        "type": "Input",
                        "configuration": {
                            "input": {},
                        },
                        "outputs": [{
                            "name": "document",
                            "type": "String",
                        }],
                    },
                    {
                        "name": "Prompt_1",
                        "type": "Prompt",
                        "configuration": {
                            "prompt": {
                                "source_configuration": {
                                    "inline": {
                                        "model_id": "amazon.titan-text-express-v1",
                                        "template_type": "TEXT",
                                        "inference_configuration": {
                                            "text": {
                                                "max_tokens": 2048,
                                                "stop_sequences": ["User:"],
                                                "temperature": 0,
                                                "top_p": 0.8999999761581421,
                                            },
                                        },
                                        "template_configuration": {
                                            "text": {
                                                "text": "Write a paragraph about {{topic}}.",
                                                "input_variables": [{
                                                    "name": "topic",
                                                }],
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "inputs": [{
                            "expression": "$.data",
                            "name": "topic",
                            "type": "String",
                        }],
                        "outputs": [{
                            "name": "modelCompletion",
                            "type": "String",
                        }],
                    },
                    {
                        "name": "FlowOutputNode",
                        "type": "Output",
                        "configuration": {
                            "output": {},
                        },
                        "inputs": [{
                            "expression": "$.data",
                            "name": "document",
                            "type": "String",
                        }],
                    },
                ],
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock Agents Flow using the `id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentFlow:AgentFlow example ABCDEFGHIJ
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
        :param pulumi.Input[Union['AgentFlowDefinitionArgs', 'AgentFlowDefinitionArgsDict']] definition: A definition of the nodes and connections between nodes in the flow. See Definition for more information.
        :param pulumi.Input[_builtins.str] description: A description for the flow.
        :param pulumi.Input[_builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the service role with permissions to create and manage a flow. For more information, see [Create a service role for flows in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html) in the Amazon Bedrock User Guide.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] name: A name for the flow.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentFlowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Bedrock Agents Flow.

        ## Example Usage

        The default definition:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentFlow("example",
            name="example",
            execution_role_arn=example_aws_iam_role["arn"],
            definition={
                "connections": [
                    {
                        "name": "FlowInputNodeFlowInputNode0ToPrompt_1PromptsNode0",
                        "source": "FlowInputNode",
                        "target": "Prompt_1",
                        "type": "Data",
                        "configuration": {
                            "data": {
                                "source_output": "document",
                                "target_input": "topic",
                            },
                        },
                    },
                    {
                        "name": "Prompt_1PromptsNode0ToFlowOutputNodeFlowOutputNode0",
                        "source": "Prompt_1",
                        "target": "FlowOutputNode",
                        "type": "Data",
                        "configuration": {
                            "data": {
                                "source_output": "modelCompletion",
                                "target_input": "document",
                            },
                        },
                    },
                ],
                "nodes": [
                    {
                        "name": "FlowInputNode",
                        "type": "Input",
                        "configuration": {
                            "input": {},
                        },
                        "outputs": [{
                            "name": "document",
                            "type": "String",
                        }],
                    },
                    {
                        "name": "Prompt_1",
                        "type": "Prompt",
                        "configuration": {
                            "prompt": {
                                "source_configuration": {
                                    "inline": {
                                        "model_id": "amazon.titan-text-express-v1",
                                        "template_type": "TEXT",
                                        "inference_configuration": {
                                            "text": {
                                                "max_tokens": 2048,
                                                "stop_sequences": ["User:"],
                                                "temperature": 0,
                                                "top_p": 0.8999999761581421,
                                            },
                                        },
                                        "template_configuration": {
                                            "text": {
                                                "text": "Write a paragraph about {{topic}}.",
                                                "input_variables": [{
                                                    "name": "topic",
                                                }],
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "inputs": [{
                            "expression": "$.data",
                            "name": "topic",
                            "type": "String",
                        }],
                        "outputs": [{
                            "name": "modelCompletion",
                            "type": "String",
                        }],
                    },
                    {
                        "name": "FlowOutputNode",
                        "type": "Output",
                        "configuration": {
                            "output": {},
                        },
                        "inputs": [{
                            "expression": "$.data",
                            "name": "document",
                            "type": "String",
                        }],
                    },
                ],
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock Agents Flow using the `id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentFlow:AgentFlow example ABCDEFGHIJ
        ```

        :param str resource_name: The name of the resource.
        :param AgentFlowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentFlowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 definition: Optional[pulumi.Input[Union['AgentFlowDefinitionArgs', 'AgentFlowDefinitionArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentFlowTimeoutsArgs', 'AgentFlowTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentFlowArgs.__new__(AgentFlowArgs)

            __props__.__dict__["customer_encryption_key_arn"] = customer_encryption_key_arn
            __props__.__dict__["definition"] = definition
            __props__.__dict__["description"] = description
            if execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'execution_role_arn'")
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["version"] = None
        super(AgentFlow, __self__).__init__(
            'aws:bedrock/agentFlow:AgentFlow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            definition: Optional[pulumi.Input[Union['AgentFlowDefinitionArgs', 'AgentFlowDefinitionArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentFlowTimeoutsArgs', 'AgentFlowTimeoutsArgsDict']]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'AgentFlow':
        """
        Get an existing AgentFlow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the flow.
        :param pulumi.Input[_builtins.str] created_at: The time at which the flow was created.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
        :param pulumi.Input[Union['AgentFlowDefinitionArgs', 'AgentFlowDefinitionArgsDict']] definition: A definition of the nodes and connections between nodes in the flow. See Definition for more information.
        :param pulumi.Input[_builtins.str] description: A description for the flow.
        :param pulumi.Input[_builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the service role with permissions to create and manage a flow. For more information, see [Create a service role for flows in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html) in the Amazon Bedrock User Guide.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] name: A name for the flow.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The status of the flow.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] updated_at: The time at which the flow was last updated.
        :param pulumi.Input[_builtins.str] version: The version of the flow.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentFlowState.__new__(_AgentFlowState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["customer_encryption_key_arn"] = customer_encryption_key_arn
        __props__.__dict__["definition"] = definition
        __props__.__dict__["description"] = description
        __props__.__dict__["execution_role_arn"] = execution_role_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["version"] = version
        return AgentFlow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the flow.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the flow was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @_builtins.property
    @pulumi.getter
    def definition(self) -> pulumi.Output[Optional['outputs.AgentFlowDefinition']]:
        """
        A definition of the nodes and connections between nodes in the flow. See Definition for more information.
        """
        return pulumi.get(self, "definition")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description for the flow.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the service role with permissions to create and manage a flow. For more information, see [Create a service role for flows in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html) in the Amazon Bedrock User Guide.

        The following arguments are optional:
        """
        return pulumi.get(self, "execution_role_arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A name for the flow.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the flow.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentFlowTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the flow was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the flow.
        """
        return pulumi.get(self, "version")

