# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SlackChannelConfigurationArgs', 'SlackChannelConfiguration']

@pulumi.input_type
class SlackChannelConfigurationArgs:
    def __init__(__self__, *,
                 configuration_name: pulumi.Input[_builtins.str],
                 iam_role_arn: pulumi.Input[_builtins.str],
                 slack_channel_id: pulumi.Input[_builtins.str],
                 slack_team_id: pulumi.Input[_builtins.str],
                 guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 logging_level: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['SlackChannelConfigurationTimeoutsArgs']] = None,
                 user_authorization_required: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SlackChannelConfiguration resource.
        :param pulumi.Input[_builtins.str] configuration_name: Name of the Slack channel configuration.
        :param pulumi.Input[_builtins.str] iam_role_arn: User-defined role that AWS Chatbot assumes. This is not the service-linked role.
        :param pulumi.Input[_builtins.str] slack_channel_id: ID of the Slack channel. For example, `C07EZ1ABC23`.
        :param pulumi.Input[_builtins.str] slack_team_id: ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guardrail_policy_arns: List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        :param pulumi.Input[_builtins.str] logging_level: Logging levels include `ERROR`, `INFO`, or `NONE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sns_topic_arns: ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource.
        :param pulumi.Input[_builtins.bool] user_authorization_required: Enables use of a user role requirement in your chat configuration.
        """
        pulumi.set(__self__, "configuration_name", configuration_name)
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        pulumi.set(__self__, "slack_channel_id", slack_channel_id)
        pulumi.set(__self__, "slack_team_id", slack_team_id)
        if guardrail_policy_arns is not None:
            pulumi.set(__self__, "guardrail_policy_arns", guardrail_policy_arns)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sns_topic_arns is not None:
            pulumi.set(__self__, "sns_topic_arns", sns_topic_arns)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_authorization_required is not None:
            pulumi.set(__self__, "user_authorization_required", user_authorization_required)

    @_builtins.property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Slack channel configuration.
        """
        return pulumi.get(self, "configuration_name")

    @configuration_name.setter
    def configuration_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        User-defined role that AWS Chatbot assumes. This is not the service-linked role.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iam_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="slackChannelId")
    def slack_channel_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the Slack channel. For example, `C07EZ1ABC23`.
        """
        return pulumi.get(self, "slack_channel_id")

    @slack_channel_id.setter
    def slack_channel_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "slack_channel_id", value)

    @_builtins.property
    @pulumi.getter(name="slackTeamId")
    def slack_team_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.

        The following arguments are optional:
        """
        return pulumi.get(self, "slack_team_id")

    @slack_team_id.setter
    def slack_team_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "slack_team_id", value)

    @_builtins.property
    @pulumi.getter(name="guardrailPolicyArns")
    def guardrail_policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        """
        return pulumi.get(self, "guardrail_policy_arns")

    @guardrail_policy_arns.setter
    def guardrail_policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guardrail_policy_arns", value)

    @_builtins.property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logging levels include `ERROR`, `INFO`, or `NONE`.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logging_level", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="snsTopicArns")
    def sns_topic_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        """
        return pulumi.get(self, "sns_topic_arns")

    @sns_topic_arns.setter
    def sns_topic_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sns_topic_arns", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SlackChannelConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SlackChannelConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="userAuthorizationRequired")
    def user_authorization_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables use of a user role requirement in your chat configuration.
        """
        return pulumi.get(self, "user_authorization_required")

    @user_authorization_required.setter
    def user_authorization_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "user_authorization_required", value)


@pulumi.input_type
class _SlackChannelConfigurationState:
    def __init__(__self__, *,
                 chat_configuration_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_level: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_team_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['SlackChannelConfigurationTimeoutsArgs']] = None,
                 user_authorization_required: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SlackChannelConfiguration resources.
        :param pulumi.Input[_builtins.str] chat_configuration_arn: ARN of the Slack channel configuration.
        :param pulumi.Input[_builtins.str] configuration_name: Name of the Slack channel configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guardrail_policy_arns: List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        :param pulumi.Input[_builtins.str] iam_role_arn: User-defined role that AWS Chatbot assumes. This is not the service-linked role.
        :param pulumi.Input[_builtins.str] logging_level: Logging levels include `ERROR`, `INFO`, or `NONE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] slack_channel_id: ID of the Slack channel. For example, `C07EZ1ABC23`.
        :param pulumi.Input[_builtins.str] slack_channel_name: Name of the Slack channel.
        :param pulumi.Input[_builtins.str] slack_team_id: ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] slack_team_name: Name of the Slack team.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sns_topic_arns: ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] user_authorization_required: Enables use of a user role requirement in your chat configuration.
        """
        if chat_configuration_arn is not None:
            pulumi.set(__self__, "chat_configuration_arn", chat_configuration_arn)
        if configuration_name is not None:
            pulumi.set(__self__, "configuration_name", configuration_name)
        if guardrail_policy_arns is not None:
            pulumi.set(__self__, "guardrail_policy_arns", guardrail_policy_arns)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if slack_channel_id is not None:
            pulumi.set(__self__, "slack_channel_id", slack_channel_id)
        if slack_channel_name is not None:
            pulumi.set(__self__, "slack_channel_name", slack_channel_name)
        if slack_team_id is not None:
            pulumi.set(__self__, "slack_team_id", slack_team_id)
        if slack_team_name is not None:
            pulumi.set(__self__, "slack_team_name", slack_team_name)
        if sns_topic_arns is not None:
            pulumi.set(__self__, "sns_topic_arns", sns_topic_arns)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_authorization_required is not None:
            pulumi.set(__self__, "user_authorization_required", user_authorization_required)

    @_builtins.property
    @pulumi.getter(name="chatConfigurationArn")
    def chat_configuration_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Slack channel configuration.
        """
        return pulumi.get(self, "chat_configuration_arn")

    @chat_configuration_arn.setter
    def chat_configuration_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chat_configuration_arn", value)

    @_builtins.property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Slack channel configuration.
        """
        return pulumi.get(self, "configuration_name")

    @configuration_name.setter
    def configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="guardrailPolicyArns")
    def guardrail_policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        """
        return pulumi.get(self, "guardrail_policy_arns")

    @guardrail_policy_arns.setter
    def guardrail_policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guardrail_policy_arns", value)

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined role that AWS Chatbot assumes. This is not the service-linked role.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logging levels include `ERROR`, `INFO`, or `NONE`.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logging_level", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="slackChannelId")
    def slack_channel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Slack channel. For example, `C07EZ1ABC23`.
        """
        return pulumi.get(self, "slack_channel_id")

    @slack_channel_id.setter
    def slack_channel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slack_channel_id", value)

    @_builtins.property
    @pulumi.getter(name="slackChannelName")
    def slack_channel_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Slack channel.
        """
        return pulumi.get(self, "slack_channel_name")

    @slack_channel_name.setter
    def slack_channel_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slack_channel_name", value)

    @_builtins.property
    @pulumi.getter(name="slackTeamId")
    def slack_team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.

        The following arguments are optional:
        """
        return pulumi.get(self, "slack_team_id")

    @slack_team_id.setter
    def slack_team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slack_team_id", value)

    @_builtins.property
    @pulumi.getter(name="slackTeamName")
    def slack_team_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Slack team.
        """
        return pulumi.get(self, "slack_team_name")

    @slack_team_name.setter
    def slack_team_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slack_team_name", value)

    @_builtins.property
    @pulumi.getter(name="snsTopicArns")
    def sns_topic_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        """
        return pulumi.get(self, "sns_topic_arns")

    @sns_topic_arns.setter
    def sns_topic_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sns_topic_arns", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SlackChannelConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SlackChannelConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="userAuthorizationRequired")
    def user_authorization_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables use of a user role requirement in your chat configuration.
        """
        return pulumi.get(self, "user_authorization_required")

    @user_authorization_required.setter
    def user_authorization_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "user_authorization_required", value)


@pulumi.type_token("aws:chatbot/slackChannelConfiguration:SlackChannelConfiguration")
class SlackChannelConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_level: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['SlackChannelConfigurationTimeoutsArgs', 'SlackChannelConfigurationTimeoutsArgsDict']]] = None,
                 user_authorization_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Chatbot Slack Channel Configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.chatbot.SlackChannelConfiguration("test",
            configuration_name="min-slaka-kanal",
            iam_role_arn=test_aws_iam_role["arn"],
            slack_channel_id="C07EZ1ABC23",
            slack_team_id="T07EA123LEP",
            tags={
                "Name": "min-slaka-kanal",
            })
        ```

        ## Import

        Using `pulumi import`, import Chatbot Slack Channel Configuration using the `chat_configuration_arn`. For example:

        ```sh
        $ pulumi import aws:chatbot/slackChannelConfiguration:SlackChannelConfiguration example arn:aws:chatbot::123456789012:chat-configuration/slack-channel/min-slaka-kanal
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] configuration_name: Name of the Slack channel configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guardrail_policy_arns: List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        :param pulumi.Input[_builtins.str] iam_role_arn: User-defined role that AWS Chatbot assumes. This is not the service-linked role.
        :param pulumi.Input[_builtins.str] logging_level: Logging levels include `ERROR`, `INFO`, or `NONE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] slack_channel_id: ID of the Slack channel. For example, `C07EZ1ABC23`.
        :param pulumi.Input[_builtins.str] slack_team_id: ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sns_topic_arns: ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource.
        :param pulumi.Input[_builtins.bool] user_authorization_required: Enables use of a user role requirement in your chat configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SlackChannelConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Chatbot Slack Channel Configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.chatbot.SlackChannelConfiguration("test",
            configuration_name="min-slaka-kanal",
            iam_role_arn=test_aws_iam_role["arn"],
            slack_channel_id="C07EZ1ABC23",
            slack_team_id="T07EA123LEP",
            tags={
                "Name": "min-slaka-kanal",
            })
        ```

        ## Import

        Using `pulumi import`, import Chatbot Slack Channel Configuration using the `chat_configuration_arn`. For example:

        ```sh
        $ pulumi import aws:chatbot/slackChannelConfiguration:SlackChannelConfiguration example arn:aws:chatbot::123456789012:chat-configuration/slack-channel/min-slaka-kanal
        ```

        :param str resource_name: The name of the resource.
        :param SlackChannelConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SlackChannelConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_level: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slack_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['SlackChannelConfigurationTimeoutsArgs', 'SlackChannelConfigurationTimeoutsArgsDict']]] = None,
                 user_authorization_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SlackChannelConfigurationArgs.__new__(SlackChannelConfigurationArgs)

            if configuration_name is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_name'")
            __props__.__dict__["configuration_name"] = configuration_name
            __props__.__dict__["guardrail_policy_arns"] = guardrail_policy_arns
            if iam_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'iam_role_arn'")
            __props__.__dict__["iam_role_arn"] = iam_role_arn
            __props__.__dict__["logging_level"] = logging_level
            __props__.__dict__["region"] = region
            if slack_channel_id is None and not opts.urn:
                raise TypeError("Missing required property 'slack_channel_id'")
            __props__.__dict__["slack_channel_id"] = slack_channel_id
            if slack_team_id is None and not opts.urn:
                raise TypeError("Missing required property 'slack_team_id'")
            __props__.__dict__["slack_team_id"] = slack_team_id
            __props__.__dict__["sns_topic_arns"] = sns_topic_arns
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["user_authorization_required"] = user_authorization_required
            __props__.__dict__["chat_configuration_arn"] = None
            __props__.__dict__["slack_channel_name"] = None
            __props__.__dict__["slack_team_name"] = None
            __props__.__dict__["tags_all"] = None
        super(SlackChannelConfiguration, __self__).__init__(
            'aws:chatbot/slackChannelConfiguration:SlackChannelConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            chat_configuration_arn: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
            guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            logging_level: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            slack_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
            slack_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
            slack_team_id: Optional[pulumi.Input[_builtins.str]] = None,
            slack_team_name: Optional[pulumi.Input[_builtins.str]] = None,
            sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['SlackChannelConfigurationTimeoutsArgs', 'SlackChannelConfigurationTimeoutsArgsDict']]] = None,
            user_authorization_required: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SlackChannelConfiguration':
        """
        Get an existing SlackChannelConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] chat_configuration_arn: ARN of the Slack channel configuration.
        :param pulumi.Input[_builtins.str] configuration_name: Name of the Slack channel configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guardrail_policy_arns: List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        :param pulumi.Input[_builtins.str] iam_role_arn: User-defined role that AWS Chatbot assumes. This is not the service-linked role.
        :param pulumi.Input[_builtins.str] logging_level: Logging levels include `ERROR`, `INFO`, or `NONE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] slack_channel_id: ID of the Slack channel. For example, `C07EZ1ABC23`.
        :param pulumi.Input[_builtins.str] slack_channel_name: Name of the Slack channel.
        :param pulumi.Input[_builtins.str] slack_team_id: ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] slack_team_name: Name of the Slack team.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sns_topic_arns: ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] user_authorization_required: Enables use of a user role requirement in your chat configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SlackChannelConfigurationState.__new__(_SlackChannelConfigurationState)

        __props__.__dict__["chat_configuration_arn"] = chat_configuration_arn
        __props__.__dict__["configuration_name"] = configuration_name
        __props__.__dict__["guardrail_policy_arns"] = guardrail_policy_arns
        __props__.__dict__["iam_role_arn"] = iam_role_arn
        __props__.__dict__["logging_level"] = logging_level
        __props__.__dict__["region"] = region
        __props__.__dict__["slack_channel_id"] = slack_channel_id
        __props__.__dict__["slack_channel_name"] = slack_channel_name
        __props__.__dict__["slack_team_id"] = slack_team_id
        __props__.__dict__["slack_team_name"] = slack_team_name
        __props__.__dict__["sns_topic_arns"] = sns_topic_arns
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["user_authorization_required"] = user_authorization_required
        return SlackChannelConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="chatConfigurationArn")
    def chat_configuration_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Slack channel configuration.
        """
        return pulumi.get(self, "chat_configuration_arn")

    @_builtins.property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Slack channel configuration.
        """
        return pulumi.get(self, "configuration_name")

    @_builtins.property
    @pulumi.getter(name="guardrailPolicyArns")
    def guardrail_policy_arns(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        """
        return pulumi.get(self, "guardrail_policy_arns")

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        User-defined role that AWS Chatbot assumes. This is not the service-linked role.
        """
        return pulumi.get(self, "iam_role_arn")

    @_builtins.property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> pulumi.Output[_builtins.str]:
        """
        Logging levels include `ERROR`, `INFO`, or `NONE`.
        """
        return pulumi.get(self, "logging_level")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="slackChannelId")
    def slack_channel_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Slack channel. For example, `C07EZ1ABC23`.
        """
        return pulumi.get(self, "slack_channel_id")

    @_builtins.property
    @pulumi.getter(name="slackChannelName")
    def slack_channel_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Slack channel.
        """
        return pulumi.get(self, "slack_channel_name")

    @_builtins.property
    @pulumi.getter(name="slackTeamId")
    def slack_team_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.

        The following arguments are optional:
        """
        return pulumi.get(self, "slack_team_id")

    @_builtins.property
    @pulumi.getter(name="slackTeamName")
    def slack_team_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Slack team.
        """
        return pulumi.get(self, "slack_team_name")

    @_builtins.property
    @pulumi.getter(name="snsTopicArns")
    def sns_topic_arns(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        """
        return pulumi.get(self, "sns_topic_arns")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.SlackChannelConfigurationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="userAuthorizationRequired")
    def user_authorization_required(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables use of a user role requirement in your chat configuration.
        """
        return pulumi.get(self, "user_authorization_required")

