# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetStackResult',
    'AwaitableGetStackResult',
    'get_stack',
    'get_stack_output',
]

@pulumi.output_type
class GetStackResult:
    """
    A collection of values returned by getStack.
    """
    def __init__(__self__, capabilities=None, description=None, disable_rollback=None, iam_role_arn=None, id=None, name=None, notification_arns=None, outputs=None, parameters=None, region=None, tags=None, template_body=None, timeout_in_minutes=None):
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disable_rollback and not isinstance(disable_rollback, bool):
            raise TypeError("Expected argument 'disable_rollback' to be a bool")
        pulumi.set(__self__, "disable_rollback", disable_rollback)
        if iam_role_arn and not isinstance(iam_role_arn, str):
            raise TypeError("Expected argument 'iam_role_arn' to be a str")
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notification_arns and not isinstance(notification_arns, list):
            raise TypeError("Expected argument 'notification_arns' to be a list")
        pulumi.set(__self__, "notification_arns", notification_arns)
        if outputs and not isinstance(outputs, dict):
            raise TypeError("Expected argument 'outputs' to be a dict")
        pulumi.set(__self__, "outputs", outputs)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if template_body and not isinstance(template_body, str):
            raise TypeError("Expected argument 'template_body' to be a str")
        pulumi.set(__self__, "template_body", template_body)
        if timeout_in_minutes and not isinstance(timeout_in_minutes, int):
            raise TypeError("Expected argument 'timeout_in_minutes' to be a int")
        pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Sequence[_builtins.str]:
        """
        List of capabilities
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the stack
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> _builtins.bool:
        """
        Whether the rollback of the stack is disabled when stack creation fails
        """
        return pulumi.get(self, "disable_rollback")

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> _builtins.str:
        """
        ARN of the IAM role used to create the stack.
        """
        return pulumi.get(self, "iam_role_arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationArns")
    def notification_arns(self) -> Sequence[_builtins.str]:
        """
        List of SNS topic ARNs to publish stack related events
        """
        return pulumi.get(self, "notification_arns")

    @_builtins.property
    @pulumi.getter
    def outputs(self) -> Mapping[str, _builtins.str]:
        """
        Map of outputs from the stack.
        """
        return pulumi.get(self, "outputs")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Mapping[str, _builtins.str]:
        """
        Map of parameters that specify input parameters for the stack.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags associated with this stack.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> _builtins.str:
        """
        Structure containing the template body.
        """
        return pulumi.get(self, "template_body")

    @_builtins.property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> _builtins.int:
        """
        Amount of time that can pass before the stack status becomes `CREATE_FAILED`
        """
        return pulumi.get(self, "timeout_in_minutes")


class AwaitableGetStackResult(GetStackResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStackResult(
            capabilities=self.capabilities,
            description=self.description,
            disable_rollback=self.disable_rollback,
            iam_role_arn=self.iam_role_arn,
            id=self.id,
            name=self.name,
            notification_arns=self.notification_arns,
            outputs=self.outputs,
            parameters=self.parameters,
            region=self.region,
            tags=self.tags,
            template_body=self.template_body,
            timeout_in_minutes=self.timeout_in_minutes)


def get_stack(name: Optional[_builtins.str] = None,
              region: Optional[_builtins.str] = None,
              tags: Optional[Mapping[str, _builtins.str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStackResult:
    """
    The CloudFormation Stack data source allows access to stack
    outputs and other useful data including the template body.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    network = aws.cloudformation.get_stack(name="my-network-stack")
    web = aws.ec2.Instance("web",
        ami="ami-abb07bcb",
        instance_type=aws.ec2.InstanceType.T2_MICRO,
        subnet_id=network.outputs["SubnetId"],
        tags={
            "Name": "HelloWorld",
        })
    ```


    :param _builtins.str name: Name of the stack
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags associated with this stack.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudformation/getStack:getStack', __args__, opts=opts, typ=GetStackResult).value

    return AwaitableGetStackResult(
        capabilities=pulumi.get(__ret__, 'capabilities'),
        description=pulumi.get(__ret__, 'description'),
        disable_rollback=pulumi.get(__ret__, 'disable_rollback'),
        iam_role_arn=pulumi.get(__ret__, 'iam_role_arn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        notification_arns=pulumi.get(__ret__, 'notification_arns'),
        outputs=pulumi.get(__ret__, 'outputs'),
        parameters=pulumi.get(__ret__, 'parameters'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        template_body=pulumi.get(__ret__, 'template_body'),
        timeout_in_minutes=pulumi.get(__ret__, 'timeout_in_minutes'))
def get_stack_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStackResult]:
    """
    The CloudFormation Stack data source allows access to stack
    outputs and other useful data including the template body.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    network = aws.cloudformation.get_stack(name="my-network-stack")
    web = aws.ec2.Instance("web",
        ami="ami-abb07bcb",
        instance_type=aws.ec2.InstanceType.T2_MICRO,
        subnet_id=network.outputs["SubnetId"],
        tags={
            "Name": "HelloWorld",
        })
    ```


    :param _builtins.str name: Name of the stack
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags associated with this stack.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudformation/getStack:getStack', __args__, opts=opts, typ=GetStackResult)
    return __ret__.apply(lambda __response__: GetStackResult(
        capabilities=pulumi.get(__response__, 'capabilities'),
        description=pulumi.get(__response__, 'description'),
        disable_rollback=pulumi.get(__response__, 'disable_rollback'),
        iam_role_arn=pulumi.get(__response__, 'iam_role_arn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        notification_arns=pulumi.get(__response__, 'notification_arns'),
        outputs=pulumi.get(__response__, 'outputs'),
        parameters=pulumi.get(__response__, 'parameters'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        template_body=pulumi.get(__response__, 'template_body'),
        timeout_in_minutes=pulumi.get(__response__, 'timeout_in_minutes')))
