# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFunctionResult',
    'AwaitableGetFunctionResult',
    'get_function',
    'get_function_output',
]

@pulumi.output_type
class GetFunctionResult:
    """
    A collection of values returned by getFunction.
    """
    def __init__(__self__, arn=None, code=None, comment=None, etag=None, id=None, key_value_store_associations=None, last_modified_time=None, name=None, runtime=None, stage=None, status=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if code and not isinstance(code, str):
            raise TypeError("Expected argument 'code' to be a str")
        pulumi.set(__self__, "code", code)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_value_store_associations and not isinstance(key_value_store_associations, list):
            raise TypeError("Expected argument 'key_value_store_associations' to be a list")
        pulumi.set(__self__, "key_value_store_associations", key_value_store_associations)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if runtime and not isinstance(runtime, str):
            raise TypeError("Expected argument 'runtime' to be a str")
        pulumi.set(__self__, "runtime", runtime)
        if stage and not isinstance(stage, str):
            raise TypeError("Expected argument 'stage' to be a str")
        pulumi.set(__self__, "stage", stage)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN identifying your CloudFront Function.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        Source code of the function
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Comment.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        ETag hash of the function
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyValueStoreAssociations")
    def key_value_store_associations(self) -> Sequence[_builtins.str]:
        """
        List of `cloudfront.KeyValueStore` ARNs associated to the function.
        """
        return pulumi.get(self, "key_value_store_associations")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> _builtins.str:
        """
        When this resource was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> _builtins.str:
        """
        Identifier of the function's runtime.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def stage(self) -> _builtins.str:
        return pulumi.get(self, "stage")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the function. Can be `UNPUBLISHED`, `UNASSOCIATED` or `ASSOCIATED`.
        """
        return pulumi.get(self, "status")


class AwaitableGetFunctionResult(GetFunctionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionResult(
            arn=self.arn,
            code=self.code,
            comment=self.comment,
            etag=self.etag,
            id=self.id,
            key_value_store_associations=self.key_value_store_associations,
            last_modified_time=self.last_modified_time,
            name=self.name,
            runtime=self.runtime,
            stage=self.stage,
            status=self.status)


def get_function(name: Optional[_builtins.str] = None,
                 stage: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionResult:
    """
    Provides information about a CloudFront Function.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    function_name = config.require("functionName")
    existing = aws.cloudfront.get_function(name=function_name,
        stage="LIVE")
    ```


    :param _builtins.str name: Name of the CloudFront function.
    :param _builtins.str stage: Function’s stage, either `DEVELOPMENT` or `LIVE`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['stage'] = stage
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudfront/getFunction:getFunction', __args__, opts=opts, typ=GetFunctionResult).value

    return AwaitableGetFunctionResult(
        arn=pulumi.get(__ret__, 'arn'),
        code=pulumi.get(__ret__, 'code'),
        comment=pulumi.get(__ret__, 'comment'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        key_value_store_associations=pulumi.get(__ret__, 'key_value_store_associations'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        name=pulumi.get(__ret__, 'name'),
        runtime=pulumi.get(__ret__, 'runtime'),
        stage=pulumi.get(__ret__, 'stage'),
        status=pulumi.get(__ret__, 'status'))
def get_function_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                        stage: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionResult]:
    """
    Provides information about a CloudFront Function.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    function_name = config.require("functionName")
    existing = aws.cloudfront.get_function(name=function_name,
        stage="LIVE")
    ```


    :param _builtins.str name: Name of the CloudFront function.
    :param _builtins.str stage: Function’s stage, either `DEVELOPMENT` or `LIVE`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['stage'] = stage
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudfront/getFunction:getFunction', __args__, opts=opts, typ=GetFunctionResult)
    return __ret__.apply(lambda __response__: GetFunctionResult(
        arn=pulumi.get(__response__, 'arn'),
        code=pulumi.get(__response__, 'code'),
        comment=pulumi.get(__response__, 'comment'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        key_value_store_associations=pulumi.get(__response__, 'key_value_store_associations'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        name=pulumi.get(__response__, 'name'),
        runtime=pulumi.get(__response__, 'runtime'),
        stage=pulumi.get(__response__, 'stage'),
        status=pulumi.get(__response__, 'status')))
