# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 base_capacity: pulumi.Input[_builtins.int],
                 compute_type: pulumi.Input[_builtins.str],
                 environment_type: pulumi.Input[_builtins.str],
                 compute_configuration: Optional[pulumi.Input['FleetComputeConfigurationArgs']] = None,
                 fleet_service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 overflow_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration: Optional[pulumi.Input['FleetScalingConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input[_builtins.int] base_capacity: Number of machines allocated to the ﬂeet.
        :param pulumi.Input[_builtins.str] compute_type: Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        :param pulumi.Input[_builtins.str] environment_type: Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
               
               The following arguments are optional:
        :param pulumi.Input['FleetComputeConfigurationArgs'] compute_configuration: The compute configuration of the compute fleet. This is only required if `compute_type` is set to `ATTRIBUTE_BASED_COMPUTE` or `CUSTOM_INSTANCE_TYPE`. See `compute_configuration` below.
        :param pulumi.Input[_builtins.str] fleet_service_role: The service role associated with the compute fleet.
        :param pulumi.Input[_builtins.str] image_id: The Amazon Machine Image (AMI) of the compute fleet.
        :param pulumi.Input[_builtins.str] name: Fleet name.
        :param pulumi.Input[_builtins.str] overflow_behavior: Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['FleetScalingConfigurationArgs'] scaling_configuration: Configuration block. This option is only valid when your overflow behavior is `QUEUE`. See `scaling_configuration` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]] vpc_configs: Configuration block. See `vpc_config` below.
        """
        pulumi.set(__self__, "base_capacity", base_capacity)
        pulumi.set(__self__, "compute_type", compute_type)
        pulumi.set(__self__, "environment_type", environment_type)
        if compute_configuration is not None:
            pulumi.set(__self__, "compute_configuration", compute_configuration)
        if fleet_service_role is not None:
            pulumi.set(__self__, "fleet_service_role", fleet_service_role)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overflow_behavior is not None:
            pulumi.set(__self__, "overflow_behavior", overflow_behavior)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_configuration is not None:
            pulumi.set(__self__, "scaling_configuration", scaling_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_configs is not None:
            pulumi.set(__self__, "vpc_configs", vpc_configs)

    @_builtins.property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> pulumi.Input[_builtins.int]:
        """
        Number of machines allocated to the ﬂeet.
        """
        return pulumi.get(self, "base_capacity")

    @base_capacity.setter
    def base_capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[_builtins.str]:
        """
        Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_type", value)

    @_builtins.property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> pulumi.Input[_builtins.str]:
        """
        Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.

        The following arguments are optional:
        """
        return pulumi.get(self, "environment_type")

    @environment_type.setter
    def environment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment_type", value)

    @_builtins.property
    @pulumi.getter(name="computeConfiguration")
    def compute_configuration(self) -> Optional[pulumi.Input['FleetComputeConfigurationArgs']]:
        """
        The compute configuration of the compute fleet. This is only required if `compute_type` is set to `ATTRIBUTE_BASED_COMPUTE` or `CUSTOM_INSTANCE_TYPE`. See `compute_configuration` below.
        """
        return pulumi.get(self, "compute_configuration")

    @compute_configuration.setter
    def compute_configuration(self, value: Optional[pulumi.Input['FleetComputeConfigurationArgs']]):
        pulumi.set(self, "compute_configuration", value)

    @_builtins.property
    @pulumi.getter(name="fleetServiceRole")
    def fleet_service_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service role associated with the compute fleet.
        """
        return pulumi.get(self, "fleet_service_role")

    @fleet_service_role.setter
    def fleet_service_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_service_role", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Machine Image (AMI) of the compute fleet.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fleet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="overflowBehavior")
    def overflow_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        """
        return pulumi.get(self, "overflow_behavior")

    @overflow_behavior.setter
    def overflow_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "overflow_behavior", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> Optional[pulumi.Input['FleetScalingConfigurationArgs']]:
        """
        Configuration block. This option is only valid when your overflow behavior is `QUEUE`. See `scaling_configuration` below.
        """
        return pulumi.get(self, "scaling_configuration")

    @scaling_configuration.setter
    def scaling_configuration(self, value: Optional[pulumi.Input['FleetScalingConfigurationArgs']]):
        pulumi.set(self, "scaling_configuration", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfigs")
    def vpc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]]:
        """
        Configuration block. See `vpc_config` below.
        """
        return pulumi.get(self, "vpc_configs")

    @vpc_configs.setter
    def vpc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]]):
        pulumi.set(self, "vpc_configs", value)


@pulumi.input_type
class _FleetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 compute_configuration: Optional[pulumi.Input['FleetComputeConfigurationArgs']] = None,
                 compute_type: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 overflow_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration: Optional[pulumi.Input['FleetScalingConfigurationArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['FleetStatusArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering Fleet resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Fleet.
        :param pulumi.Input[_builtins.int] base_capacity: Number of machines allocated to the ﬂeet.
        :param pulumi.Input['FleetComputeConfigurationArgs'] compute_configuration: The compute configuration of the compute fleet. This is only required if `compute_type` is set to `ATTRIBUTE_BASED_COMPUTE` or `CUSTOM_INSTANCE_TYPE`. See `compute_configuration` below.
        :param pulumi.Input[_builtins.str] compute_type: Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        :param pulumi.Input[_builtins.str] created: Creation time of the fleet.
        :param pulumi.Input[_builtins.str] environment_type: Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] fleet_service_role: The service role associated with the compute fleet.
        :param pulumi.Input[_builtins.str] image_id: The Amazon Machine Image (AMI) of the compute fleet.
        :param pulumi.Input[_builtins.str] last_modified: Last modification time of the fleet.
        :param pulumi.Input[_builtins.str] name: Fleet name.
        :param pulumi.Input[_builtins.str] overflow_behavior: Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['FleetScalingConfigurationArgs'] scaling_configuration: Configuration block. This option is only valid when your overflow behavior is `QUEUE`. See `scaling_configuration` below.
        :param pulumi.Input[Sequence[pulumi.Input['FleetStatusArgs']]] statuses: Nested attribute containing information about the current status of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]] vpc_configs: Configuration block. See `vpc_config` below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if base_capacity is not None:
            pulumi.set(__self__, "base_capacity", base_capacity)
        if compute_configuration is not None:
            pulumi.set(__self__, "compute_configuration", compute_configuration)
        if compute_type is not None:
            pulumi.set(__self__, "compute_type", compute_type)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if environment_type is not None:
            pulumi.set(__self__, "environment_type", environment_type)
        if fleet_service_role is not None:
            pulumi.set(__self__, "fleet_service_role", fleet_service_role)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overflow_behavior is not None:
            pulumi.set(__self__, "overflow_behavior", overflow_behavior)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_configuration is not None:
            pulumi.set(__self__, "scaling_configuration", scaling_configuration)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_configs is not None:
            pulumi.set(__self__, "vpc_configs", vpc_configs)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Fleet.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of machines allocated to the ﬂeet.
        """
        return pulumi.get(self, "base_capacity")

    @base_capacity.setter
    def base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="computeConfiguration")
    def compute_configuration(self) -> Optional[pulumi.Input['FleetComputeConfigurationArgs']]:
        """
        The compute configuration of the compute fleet. This is only required if `compute_type` is set to `ATTRIBUTE_BASED_COMPUTE` or `CUSTOM_INSTANCE_TYPE`. See `compute_configuration` below.
        """
        return pulumi.get(self, "compute_configuration")

    @compute_configuration.setter
    def compute_configuration(self, value: Optional[pulumi.Input['FleetComputeConfigurationArgs']]):
        pulumi.set(self, "compute_configuration", value)

    @_builtins.property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_type", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time of the fleet.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.

        The following arguments are optional:
        """
        return pulumi.get(self, "environment_type")

    @environment_type.setter
    def environment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_type", value)

    @_builtins.property
    @pulumi.getter(name="fleetServiceRole")
    def fleet_service_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service role associated with the compute fleet.
        """
        return pulumi.get(self, "fleet_service_role")

    @fleet_service_role.setter
    def fleet_service_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_service_role", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Machine Image (AMI) of the compute fleet.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last modification time of the fleet.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fleet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="overflowBehavior")
    def overflow_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        """
        return pulumi.get(self, "overflow_behavior")

    @overflow_behavior.setter
    def overflow_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "overflow_behavior", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> Optional[pulumi.Input['FleetScalingConfigurationArgs']]:
        """
        Configuration block. This option is only valid when your overflow behavior is `QUEUE`. See `scaling_configuration` below.
        """
        return pulumi.get(self, "scaling_configuration")

    @scaling_configuration.setter
    def scaling_configuration(self, value: Optional[pulumi.Input['FleetScalingConfigurationArgs']]):
        pulumi.set(self, "scaling_configuration", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetStatusArgs']]]]:
        """
        Nested attribute containing information about the current status of the fleet.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfigs")
    def vpc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]]:
        """
        Configuration block. See `vpc_config` below.
        """
        return pulumi.get(self, "vpc_configs")

    @vpc_configs.setter
    def vpc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]]):
        pulumi.set(self, "vpc_configs", value)


@pulumi.type_token("aws:codebuild/fleet:Fleet")
class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 compute_configuration: Optional[pulumi.Input[Union['FleetComputeConfigurationArgs', 'FleetComputeConfigurationArgsDict']]] = None,
                 compute_type: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 overflow_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration: Optional[pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a CodeBuild Fleet Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codebuild.Fleet("test",
            base_capacity=2,
            compute_type="BUILD_GENERAL1_SMALL",
            environment_type="LINUX_CONTAINER",
            name="full-example-codebuild-fleet",
            overflow_behavior="QUEUE",
            scaling_configuration={
                "max_capacity": 5,
                "scaling_type": "TARGET_TRACKING_SCALING",
                "target_tracking_scaling_configs": [{
                    "metric_type": "FLEET_UTILIZATION_RATE",
                    "target_value": 97.5,
                }],
            })
        ```

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codebuild.Fleet("example", name="example-codebuild-fleet")
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the CodeBuild fleet.

        Using `pulumi import`, import CodeBuild Fleet using the `name`. For example:

        console

        % pulumi import aws_codebuild_fleet.name fleet-name

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] base_capacity: Number of machines allocated to the ﬂeet.
        :param pulumi.Input[Union['FleetComputeConfigurationArgs', 'FleetComputeConfigurationArgsDict']] compute_configuration: The compute configuration of the compute fleet. This is only required if `compute_type` is set to `ATTRIBUTE_BASED_COMPUTE` or `CUSTOM_INSTANCE_TYPE`. See `compute_configuration` below.
        :param pulumi.Input[_builtins.str] compute_type: Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        :param pulumi.Input[_builtins.str] environment_type: Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] fleet_service_role: The service role associated with the compute fleet.
        :param pulumi.Input[_builtins.str] image_id: The Amazon Machine Image (AMI) of the compute fleet.
        :param pulumi.Input[_builtins.str] name: Fleet name.
        :param pulumi.Input[_builtins.str] overflow_behavior: Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']] scaling_configuration: Configuration block. This option is only valid when your overflow behavior is `QUEUE`. See `scaling_configuration` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]] vpc_configs: Configuration block. See `vpc_config` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CodeBuild Fleet Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codebuild.Fleet("test",
            base_capacity=2,
            compute_type="BUILD_GENERAL1_SMALL",
            environment_type="LINUX_CONTAINER",
            name="full-example-codebuild-fleet",
            overflow_behavior="QUEUE",
            scaling_configuration={
                "max_capacity": 5,
                "scaling_type": "TARGET_TRACKING_SCALING",
                "target_tracking_scaling_configs": [{
                    "metric_type": "FLEET_UTILIZATION_RATE",
                    "target_value": 97.5,
                }],
            })
        ```

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codebuild.Fleet("example", name="example-codebuild-fleet")
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the CodeBuild fleet.

        Using `pulumi import`, import CodeBuild Fleet using the `name`. For example:

        console

        % pulumi import aws_codebuild_fleet.name fleet-name

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 compute_configuration: Optional[pulumi.Input[Union['FleetComputeConfigurationArgs', 'FleetComputeConfigurationArgsDict']]] = None,
                 compute_type: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 overflow_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration: Optional[pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            if base_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'base_capacity'")
            __props__.__dict__["base_capacity"] = base_capacity
            __props__.__dict__["compute_configuration"] = compute_configuration
            if compute_type is None and not opts.urn:
                raise TypeError("Missing required property 'compute_type'")
            __props__.__dict__["compute_type"] = compute_type
            if environment_type is None and not opts.urn:
                raise TypeError("Missing required property 'environment_type'")
            __props__.__dict__["environment_type"] = environment_type
            __props__.__dict__["fleet_service_role"] = fleet_service_role
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["name"] = name
            __props__.__dict__["overflow_behavior"] = overflow_behavior
            __props__.__dict__["region"] = region
            __props__.__dict__["scaling_configuration"] = scaling_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_configs"] = vpc_configs
            __props__.__dict__["arn"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["tags_all"] = None
        super(Fleet, __self__).__init__(
            'aws:codebuild/fleet:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            compute_configuration: Optional[pulumi.Input[Union['FleetComputeConfigurationArgs', 'FleetComputeConfigurationArgsDict']]] = None,
            compute_type: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            environment_type: Optional[pulumi.Input[_builtins.str]] = None,
            fleet_service_role: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            overflow_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_configuration: Optional[pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetStatusArgs', 'FleetStatusArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]]] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Fleet.
        :param pulumi.Input[_builtins.int] base_capacity: Number of machines allocated to the ﬂeet.
        :param pulumi.Input[Union['FleetComputeConfigurationArgs', 'FleetComputeConfigurationArgsDict']] compute_configuration: The compute configuration of the compute fleet. This is only required if `compute_type` is set to `ATTRIBUTE_BASED_COMPUTE` or `CUSTOM_INSTANCE_TYPE`. See `compute_configuration` below.
        :param pulumi.Input[_builtins.str] compute_type: Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        :param pulumi.Input[_builtins.str] created: Creation time of the fleet.
        :param pulumi.Input[_builtins.str] environment_type: Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] fleet_service_role: The service role associated with the compute fleet.
        :param pulumi.Input[_builtins.str] image_id: The Amazon Machine Image (AMI) of the compute fleet.
        :param pulumi.Input[_builtins.str] last_modified: Last modification time of the fleet.
        :param pulumi.Input[_builtins.str] name: Fleet name.
        :param pulumi.Input[_builtins.str] overflow_behavior: Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']] scaling_configuration: Configuration block. This option is only valid when your overflow behavior is `QUEUE`. See `scaling_configuration` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetStatusArgs', 'FleetStatusArgsDict']]]] statuses: Nested attribute containing information about the current status of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]] vpc_configs: Configuration block. See `vpc_config` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetState.__new__(_FleetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["base_capacity"] = base_capacity
        __props__.__dict__["compute_configuration"] = compute_configuration
        __props__.__dict__["compute_type"] = compute_type
        __props__.__dict__["created"] = created
        __props__.__dict__["environment_type"] = environment_type
        __props__.__dict__["fleet_service_role"] = fleet_service_role
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["name"] = name
        __props__.__dict__["overflow_behavior"] = overflow_behavior
        __props__.__dict__["region"] = region
        __props__.__dict__["scaling_configuration"] = scaling_configuration
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_configs"] = vpc_configs
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Fleet.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        Number of machines allocated to the ﬂeet.
        """
        return pulumi.get(self, "base_capacity")

    @_builtins.property
    @pulumi.getter(name="computeConfiguration")
    def compute_configuration(self) -> pulumi.Output[Optional['outputs.FleetComputeConfiguration']]:
        """
        The compute configuration of the compute fleet. This is only required if `compute_type` is set to `ATTRIBUTE_BASED_COMPUTE` or `CUSTOM_INSTANCE_TYPE`. See `compute_configuration` below.
        """
        return pulumi.get(self, "compute_configuration")

    @_builtins.property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Output[_builtins.str]:
        """
        Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        """
        return pulumi.get(self, "compute_type")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time of the fleet.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.

        The following arguments are optional:
        """
        return pulumi.get(self, "environment_type")

    @_builtins.property
    @pulumi.getter(name="fleetServiceRole")
    def fleet_service_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service role associated with the compute fleet.
        """
        return pulumi.get(self, "fleet_service_role")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Amazon Machine Image (AMI) of the compute fleet.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[_builtins.str]:
        """
        Last modification time of the fleet.
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Fleet name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="overflowBehavior")
    def overflow_behavior(self) -> pulumi.Output[_builtins.str]:
        """
        Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        """
        return pulumi.get(self, "overflow_behavior")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> pulumi.Output[Optional['outputs.FleetScalingConfiguration']]:
        """
        Configuration block. This option is only valid when your overflow behavior is `QUEUE`. See `scaling_configuration` below.
        """
        return pulumi.get(self, "scaling_configuration")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.FleetStatus']]:
        """
        Nested attribute containing information about the current status of the fleet.
        """
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="vpcConfigs")
    def vpc_configs(self) -> pulumi.Output[Optional[Sequence['outputs.FleetVpcConfig']]]:
        """
        Configuration block. See `vpc_config` below.
        """
        return pulumi.get(self, "vpc_configs")

