# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IdentityPoolProviderPrincipalTagArgs', 'IdentityPoolProviderPrincipalTag']

@pulumi.input_type
class IdentityPoolProviderPrincipalTagArgs:
    def __init__(__self__, *,
                 identity_pool_id: pulumi.Input[_builtins.str],
                 identity_provider_name: pulumi.Input[_builtins.str],
                 principal_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 use_defaults: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a IdentityPoolProviderPrincipalTag resource.
        :param pulumi.Input[_builtins.str] identity_pool_id: An identity pool ID.
        :param pulumi.Input[_builtins.str] identity_provider_name: The name of the identity provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] principal_tags: String to string map of variables.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] use_defaults: use default (username and clientID) attribute mappings.
        """
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "identity_provider_name", identity_provider_name)
        if principal_tags is not None:
            pulumi.set(__self__, "principal_tags", principal_tags)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if use_defaults is not None:
            pulumi.set(__self__, "use_defaults", use_defaults)

    @_builtins.property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        An identity pool ID.
        """
        return pulumi.get(self, "identity_pool_id")

    @identity_pool_id.setter
    def identity_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the identity provider.
        """
        return pulumi.get(self, "identity_provider_name")

    @identity_provider_name.setter
    def identity_provider_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity_provider_name", value)

    @_builtins.property
    @pulumi.getter(name="principalTags")
    def principal_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        String to string map of variables.
        """
        return pulumi.get(self, "principal_tags")

    @principal_tags.setter
    def principal_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "principal_tags", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="useDefaults")
    def use_defaults(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        use default (username and clientID) attribute mappings.
        """
        return pulumi.get(self, "use_defaults")

    @use_defaults.setter
    def use_defaults(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_defaults", value)


@pulumi.input_type
class _IdentityPoolProviderPrincipalTagState:
    def __init__(__self__, *,
                 identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 use_defaults: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering IdentityPoolProviderPrincipalTag resources.
        :param pulumi.Input[_builtins.str] identity_pool_id: An identity pool ID.
        :param pulumi.Input[_builtins.str] identity_provider_name: The name of the identity provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] principal_tags: String to string map of variables.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] use_defaults: use default (username and clientID) attribute mappings.
        """
        if identity_pool_id is not None:
            pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        if identity_provider_name is not None:
            pulumi.set(__self__, "identity_provider_name", identity_provider_name)
        if principal_tags is not None:
            pulumi.set(__self__, "principal_tags", principal_tags)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if use_defaults is not None:
            pulumi.set(__self__, "use_defaults", use_defaults)

    @_builtins.property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An identity pool ID.
        """
        return pulumi.get(self, "identity_pool_id")

    @identity_pool_id.setter
    def identity_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the identity provider.
        """
        return pulumi.get(self, "identity_provider_name")

    @identity_provider_name.setter
    def identity_provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_provider_name", value)

    @_builtins.property
    @pulumi.getter(name="principalTags")
    def principal_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        String to string map of variables.
        """
        return pulumi.get(self, "principal_tags")

    @principal_tags.setter
    def principal_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "principal_tags", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="useDefaults")
    def use_defaults(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        use default (username and clientID) attribute mappings.
        """
        return pulumi.get(self, "use_defaults")

    @use_defaults.setter
    def use_defaults(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_defaults", value)


@pulumi.type_token("aws:cognito/identityPoolProviderPrincipalTag:IdentityPoolProviderPrincipalTag")
class IdentityPoolProviderPrincipalTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 use_defaults: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides an AWS Cognito Identity Principal Mapping.

        ## Import

        Using `pulumi import`, import Cognito Identity Pool Roles Attachment using the Identity Pool ID and provider name. For example:

        ```sh
        $ pulumi import aws:cognito/identityPoolProviderPrincipalTag:IdentityPoolProviderPrincipalTag example us-west-2_abc123:CorpAD
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity_pool_id: An identity pool ID.
        :param pulumi.Input[_builtins.str] identity_provider_name: The name of the identity provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] principal_tags: String to string map of variables.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] use_defaults: use default (username and clientID) attribute mappings.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityPoolProviderPrincipalTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Cognito Identity Principal Mapping.

        ## Import

        Using `pulumi import`, import Cognito Identity Pool Roles Attachment using the Identity Pool ID and provider name. For example:

        ```sh
        $ pulumi import aws:cognito/identityPoolProviderPrincipalTag:IdentityPoolProviderPrincipalTag example us-west-2_abc123:CorpAD
        ```

        :param str resource_name: The name of the resource.
        :param IdentityPoolProviderPrincipalTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityPoolProviderPrincipalTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 use_defaults: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityPoolProviderPrincipalTagArgs.__new__(IdentityPoolProviderPrincipalTagArgs)

            if identity_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'identity_pool_id'")
            __props__.__dict__["identity_pool_id"] = identity_pool_id
            if identity_provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'identity_provider_name'")
            __props__.__dict__["identity_provider_name"] = identity_provider_name
            __props__.__dict__["principal_tags"] = principal_tags
            __props__.__dict__["region"] = region
            __props__.__dict__["use_defaults"] = use_defaults
        super(IdentityPoolProviderPrincipalTag, __self__).__init__(
            'aws:cognito/identityPoolProviderPrincipalTag:IdentityPoolProviderPrincipalTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
            principal_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            use_defaults: Optional[pulumi.Input[_builtins.bool]] = None) -> 'IdentityPoolProviderPrincipalTag':
        """
        Get an existing IdentityPoolProviderPrincipalTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity_pool_id: An identity pool ID.
        :param pulumi.Input[_builtins.str] identity_provider_name: The name of the identity provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] principal_tags: String to string map of variables.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] use_defaults: use default (username and clientID) attribute mappings.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityPoolProviderPrincipalTagState.__new__(_IdentityPoolProviderPrincipalTagState)

        __props__.__dict__["identity_pool_id"] = identity_pool_id
        __props__.__dict__["identity_provider_name"] = identity_provider_name
        __props__.__dict__["principal_tags"] = principal_tags
        __props__.__dict__["region"] = region
        __props__.__dict__["use_defaults"] = use_defaults
        return IdentityPoolProviderPrincipalTag(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        An identity pool ID.
        """
        return pulumi.get(self, "identity_pool_id")

    @_builtins.property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the identity provider.
        """
        return pulumi.get(self, "identity_provider_name")

    @_builtins.property
    @pulumi.getter(name="principalTags")
    def principal_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        String to string map of variables.
        """
        return pulumi.get(self, "principal_tags")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="useDefaults")
    def use_defaults(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        use default (username and clientID) attribute mappings.
        """
        return pulumi.get(self, "use_defaults")

