# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedLoginBrandingArgs', 'ManagedLoginBranding']

@pulumi.input_type
class ManagedLoginBrandingArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 user_pool_id: pulumi.Input[_builtins.str],
                 assets: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedLoginBrandingAssetArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cognito_provided_values: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ManagedLoginBranding resource.
        :param pulumi.Input[_builtins.str] client_id: App client that the branding style is for.
        :param pulumi.Input[_builtins.str] user_pool_id: User pool the client belongs to.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['ManagedLoginBrandingAssetArgs']]] assets: Image files to apply to roles like backgrounds, logos, and icons. See details below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] settings: JSON document with the the settings to apply to the style.
        :param pulumi.Input[_builtins.bool] use_cognito_provided_values: When `true`, applies the default branding style options.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if use_cognito_provided_values is not None:
            pulumi.set(__self__, "use_cognito_provided_values", use_cognito_provided_values)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        App client that the branding style is for.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        User pool the client belongs to.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedLoginBrandingAssetArgs']]]]:
        """
        Image files to apply to roles like backgrounds, logos, and icons. See details below.
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedLoginBrandingAssetArgs']]]]):
        pulumi.set(self, "assets", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON document with the the settings to apply to the style.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter(name="useCognitoProvidedValues")
    def use_cognito_provided_values(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, applies the default branding style options.
        """
        return pulumi.get(self, "use_cognito_provided_values")

    @use_cognito_provided_values.setter
    def use_cognito_provided_values(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_cognito_provided_values", value)


@pulumi.input_type
class _ManagedLoginBrandingState:
    def __init__(__self__, *,
                 assets: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedLoginBrandingAssetArgs']]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_login_branding_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 settings_all: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cognito_provided_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_pool_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedLoginBranding resources.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedLoginBrandingAssetArgs']]] assets: Image files to apply to roles like backgrounds, logos, and icons. See details below.
        :param pulumi.Input[_builtins.str] client_id: App client that the branding style is for.
        :param pulumi.Input[_builtins.str] managed_login_branding_id: ID of the managed login branding style.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] settings: JSON document with the the settings to apply to the style.
        :param pulumi.Input[_builtins.str] settings_all: Settings including Amazon Cognito defaults.
        :param pulumi.Input[_builtins.bool] use_cognito_provided_values: When `true`, applies the default branding style options.
        :param pulumi.Input[_builtins.str] user_pool_id: User pool the client belongs to.
               
               The following arguments are optional:
        """
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if managed_login_branding_id is not None:
            pulumi.set(__self__, "managed_login_branding_id", managed_login_branding_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if settings_all is not None:
            pulumi.set(__self__, "settings_all", settings_all)
        if use_cognito_provided_values is not None:
            pulumi.set(__self__, "use_cognito_provided_values", use_cognito_provided_values)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)

    @_builtins.property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedLoginBrandingAssetArgs']]]]:
        """
        Image files to apply to roles like backgrounds, logos, and icons. See details below.
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedLoginBrandingAssetArgs']]]]):
        pulumi.set(self, "assets", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App client that the branding style is for.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="managedLoginBrandingId")
    def managed_login_branding_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the managed login branding style.
        """
        return pulumi.get(self, "managed_login_branding_id")

    @managed_login_branding_id.setter
    def managed_login_branding_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_login_branding_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON document with the the settings to apply to the style.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter(name="settingsAll")
    def settings_all(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Settings including Amazon Cognito defaults.
        """
        return pulumi.get(self, "settings_all")

    @settings_all.setter
    def settings_all(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "settings_all", value)

    @_builtins.property
    @pulumi.getter(name="useCognitoProvidedValues")
    def use_cognito_provided_values(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, applies the default branding style options.
        """
        return pulumi.get(self, "use_cognito_provided_values")

    @use_cognito_provided_values.setter
    def use_cognito_provided_values(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_cognito_provided_values", value)

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User pool the client belongs to.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pool_id", value)


@pulumi.type_token("aws:cognito/managedLoginBranding:ManagedLoginBranding")
class ManagedLoginBranding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedLoginBrandingAssetArgs', 'ManagedLoginBrandingAssetArgsDict']]]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cognito_provided_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages branding settings for a user pool style and associates it with an app client.

        ## Example Usage

        ### Default Branding Style

        ```python
        import pulumi
        import pulumi_aws as aws

        client = aws.cognito.ManagedLoginBranding("client",
            client_id=example["id"],
            user_pool_id=example_aws_cognito_user_pool["id"],
            use_cognito_provided_values=True)
        ```

        ### Custom Branding Style

        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_std as std

        client = aws.cognito.ManagedLoginBranding("client",
            client_id=example["id"],
            user_pool_id=example_aws_cognito_user_pool["id"],
            assets=[{
                "bytes": std.filebase64(input="login_branding_asset.svg").result,
                "category": "PAGE_HEADER_BACKGROUND",
                "color_mode": "DARK",
                "extension": "SVG",
            }],
            settings=json.dumps({}))
        ```

        ## Import

        Using `pulumi import`, import Cognito branding settings using `user_pool_id` and `managed_login_branding_id` separated by `,`. For example:

        ```sh
        $ pulumi import aws:cognito/managedLoginBranding:ManagedLoginBranding example us-west-2_rSss9Zltr,06c6ae7b-1e66-46d2-87a9-1203ea3307bd
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedLoginBrandingAssetArgs', 'ManagedLoginBrandingAssetArgsDict']]]] assets: Image files to apply to roles like backgrounds, logos, and icons. See details below.
        :param pulumi.Input[_builtins.str] client_id: App client that the branding style is for.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] settings: JSON document with the the settings to apply to the style.
        :param pulumi.Input[_builtins.bool] use_cognito_provided_values: When `true`, applies the default branding style options.
        :param pulumi.Input[_builtins.str] user_pool_id: User pool the client belongs to.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedLoginBrandingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages branding settings for a user pool style and associates it with an app client.

        ## Example Usage

        ### Default Branding Style

        ```python
        import pulumi
        import pulumi_aws as aws

        client = aws.cognito.ManagedLoginBranding("client",
            client_id=example["id"],
            user_pool_id=example_aws_cognito_user_pool["id"],
            use_cognito_provided_values=True)
        ```

        ### Custom Branding Style

        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_std as std

        client = aws.cognito.ManagedLoginBranding("client",
            client_id=example["id"],
            user_pool_id=example_aws_cognito_user_pool["id"],
            assets=[{
                "bytes": std.filebase64(input="login_branding_asset.svg").result,
                "category": "PAGE_HEADER_BACKGROUND",
                "color_mode": "DARK",
                "extension": "SVG",
            }],
            settings=json.dumps({}))
        ```

        ## Import

        Using `pulumi import`, import Cognito branding settings using `user_pool_id` and `managed_login_branding_id` separated by `,`. For example:

        ```sh
        $ pulumi import aws:cognito/managedLoginBranding:ManagedLoginBranding example us-west-2_rSss9Zltr,06c6ae7b-1e66-46d2-87a9-1203ea3307bd
        ```

        :param str resource_name: The name of the resource.
        :param ManagedLoginBrandingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedLoginBrandingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedLoginBrandingAssetArgs', 'ManagedLoginBrandingAssetArgsDict']]]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cognito_provided_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedLoginBrandingArgs.__new__(ManagedLoginBrandingArgs)

            __props__.__dict__["assets"] = assets
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["region"] = region
            __props__.__dict__["settings"] = settings
            __props__.__dict__["use_cognito_provided_values"] = use_cognito_provided_values
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
            __props__.__dict__["managed_login_branding_id"] = None
            __props__.__dict__["settings_all"] = None
        super(ManagedLoginBranding, __self__).__init__(
            'aws:cognito/managedLoginBranding:ManagedLoginBranding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedLoginBrandingAssetArgs', 'ManagedLoginBrandingAssetArgsDict']]]]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_login_branding_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            settings: Optional[pulumi.Input[_builtins.str]] = None,
            settings_all: Optional[pulumi.Input[_builtins.str]] = None,
            use_cognito_provided_values: Optional[pulumi.Input[_builtins.bool]] = None,
            user_pool_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedLoginBranding':
        """
        Get an existing ManagedLoginBranding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedLoginBrandingAssetArgs', 'ManagedLoginBrandingAssetArgsDict']]]] assets: Image files to apply to roles like backgrounds, logos, and icons. See details below.
        :param pulumi.Input[_builtins.str] client_id: App client that the branding style is for.
        :param pulumi.Input[_builtins.str] managed_login_branding_id: ID of the managed login branding style.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] settings: JSON document with the the settings to apply to the style.
        :param pulumi.Input[_builtins.str] settings_all: Settings including Amazon Cognito defaults.
        :param pulumi.Input[_builtins.bool] use_cognito_provided_values: When `true`, applies the default branding style options.
        :param pulumi.Input[_builtins.str] user_pool_id: User pool the client belongs to.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedLoginBrandingState.__new__(_ManagedLoginBrandingState)

        __props__.__dict__["assets"] = assets
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["managed_login_branding_id"] = managed_login_branding_id
        __props__.__dict__["region"] = region
        __props__.__dict__["settings"] = settings
        __props__.__dict__["settings_all"] = settings_all
        __props__.__dict__["use_cognito_provided_values"] = use_cognito_provided_values
        __props__.__dict__["user_pool_id"] = user_pool_id
        return ManagedLoginBranding(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def assets(self) -> pulumi.Output[Optional[Sequence['outputs.ManagedLoginBrandingAsset']]]:
        """
        Image files to apply to roles like backgrounds, logos, and icons. See details below.
        """
        return pulumi.get(self, "assets")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        App client that the branding style is for.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="managedLoginBrandingId")
    def managed_login_branding_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the managed login branding style.
        """
        return pulumi.get(self, "managed_login_branding_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON document with the the settings to apply to the style.
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter(name="settingsAll")
    def settings_all(self) -> pulumi.Output[_builtins.str]:
        """
        Settings including Amazon Cognito defaults.
        """
        return pulumi.get(self, "settings_all")

    @_builtins.property
    @pulumi.getter(name="useCognitoProvidedValues")
    def use_cognito_provided_values(self) -> pulumi.Output[_builtins.bool]:
        """
        When `true`, applies the default branding style options.
        """
        return pulumi.get(self, "use_cognito_provided_values")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        User pool the client belongs to.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_id")

