# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnrollmentStatusArgs', 'EnrollmentStatus']

@pulumi.input_type
class EnrollmentStatusArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[_builtins.str],
                 include_member_accounts: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['EnrollmentStatusTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a EnrollmentStatus resource.
        :param pulumi.Input[_builtins.str] status: The enrollment status of the account. Valid values: `Active`, `Inactive`.
        :param pulumi.Input[_builtins.bool] include_member_accounts: Whether to enroll member accounts of the organization if the account is the management account of an organization. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "status", status)
        if include_member_accounts is not None:
            pulumi.set(__self__, "include_member_accounts", include_member_accounts)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        The enrollment status of the account. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="includeMemberAccounts")
    def include_member_accounts(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enroll member accounts of the organization if the account is the management account of an organization. Default is `false`.
        """
        return pulumi.get(self, "include_member_accounts")

    @include_member_accounts.setter
    def include_member_accounts(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_member_accounts", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EnrollmentStatusTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EnrollmentStatusTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _EnrollmentStatusState:
    def __init__(__self__, *,
                 include_member_accounts: Optional[pulumi.Input[_builtins.bool]] = None,
                 number_of_member_accounts_opted_in: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['EnrollmentStatusTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering EnrollmentStatus resources.
        :param pulumi.Input[_builtins.bool] include_member_accounts: Whether to enroll member accounts of the organization if the account is the management account of an organization. Default is `false`.
        :param pulumi.Input[_builtins.int] number_of_member_accounts_opted_in: The count of organization member accounts that are opted in to the service, if your account is an organization management account.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The enrollment status of the account. Valid values: `Active`, `Inactive`.
        """
        if include_member_accounts is not None:
            pulumi.set(__self__, "include_member_accounts", include_member_accounts)
        if number_of_member_accounts_opted_in is not None:
            pulumi.set(__self__, "number_of_member_accounts_opted_in", number_of_member_accounts_opted_in)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="includeMemberAccounts")
    def include_member_accounts(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enroll member accounts of the organization if the account is the management account of an organization. Default is `false`.
        """
        return pulumi.get(self, "include_member_accounts")

    @include_member_accounts.setter
    def include_member_accounts(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_member_accounts", value)

    @_builtins.property
    @pulumi.getter(name="numberOfMemberAccountsOptedIn")
    def number_of_member_accounts_opted_in(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The count of organization member accounts that are opted in to the service, if your account is an organization management account.
        """
        return pulumi.get(self, "number_of_member_accounts_opted_in")

    @number_of_member_accounts_opted_in.setter
    def number_of_member_accounts_opted_in(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_member_accounts_opted_in", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enrollment status of the account. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EnrollmentStatusTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EnrollmentStatusTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:computeoptimizer/enrollmentStatus:EnrollmentStatus")
class EnrollmentStatus(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_member_accounts: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['EnrollmentStatusTimeoutsArgs', 'EnrollmentStatusTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages AWS Compute Optimizer enrollment status.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.computeoptimizer.EnrollmentStatus("example", status="Active")
        ```

        ## Import

        Using `pulumi import`, import enrollment status using the account ID. For example:

        ```sh
        $ pulumi import aws:computeoptimizer/enrollmentStatus:EnrollmentStatus example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] include_member_accounts: Whether to enroll member accounts of the organization if the account is the management account of an organization. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The enrollment status of the account. Valid values: `Active`, `Inactive`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnrollmentStatusArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages AWS Compute Optimizer enrollment status.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.computeoptimizer.EnrollmentStatus("example", status="Active")
        ```

        ## Import

        Using `pulumi import`, import enrollment status using the account ID. For example:

        ```sh
        $ pulumi import aws:computeoptimizer/enrollmentStatus:EnrollmentStatus example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param EnrollmentStatusArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnrollmentStatusArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_member_accounts: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['EnrollmentStatusTimeoutsArgs', 'EnrollmentStatusTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnrollmentStatusArgs.__new__(EnrollmentStatusArgs)

            __props__.__dict__["include_member_accounts"] = include_member_accounts
            __props__.__dict__["region"] = region
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["number_of_member_accounts_opted_in"] = None
        super(EnrollmentStatus, __self__).__init__(
            'aws:computeoptimizer/enrollmentStatus:EnrollmentStatus',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            include_member_accounts: Optional[pulumi.Input[_builtins.bool]] = None,
            number_of_member_accounts_opted_in: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['EnrollmentStatusTimeoutsArgs', 'EnrollmentStatusTimeoutsArgsDict']]] = None) -> 'EnrollmentStatus':
        """
        Get an existing EnrollmentStatus resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] include_member_accounts: Whether to enroll member accounts of the organization if the account is the management account of an organization. Default is `false`.
        :param pulumi.Input[_builtins.int] number_of_member_accounts_opted_in: The count of organization member accounts that are opted in to the service, if your account is an organization management account.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The enrollment status of the account. Valid values: `Active`, `Inactive`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnrollmentStatusState.__new__(_EnrollmentStatusState)

        __props__.__dict__["include_member_accounts"] = include_member_accounts
        __props__.__dict__["number_of_member_accounts_opted_in"] = number_of_member_accounts_opted_in
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["timeouts"] = timeouts
        return EnrollmentStatus(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="includeMemberAccounts")
    def include_member_accounts(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enroll member accounts of the organization if the account is the management account of an organization. Default is `false`.
        """
        return pulumi.get(self, "include_member_accounts")

    @_builtins.property
    @pulumi.getter(name="numberOfMemberAccountsOptedIn")
    def number_of_member_accounts_opted_in(self) -> pulumi.Output[_builtins.int]:
        """
        The count of organization member accounts that are opted in to the service, if your account is an organization management account.
        """
        return pulumi.get(self, "number_of_member_accounts_opted_in")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The enrollment status of the account. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.EnrollmentStatusTimeouts']]:
        return pulumi.get(self, "timeouts")

