# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetQueueResult',
    'AwaitableGetQueueResult',
    'get_queue',
    'get_queue_output',
]

@pulumi.output_type
class GetQueueResult:
    """
    A collection of values returned by getQueue.
    """
    def __init__(__self__, arn=None, description=None, hours_of_operation_id=None, id=None, instance_id=None, max_contacts=None, name=None, outbound_caller_configs=None, queue_id=None, region=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if hours_of_operation_id and not isinstance(hours_of_operation_id, str):
            raise TypeError("Expected argument 'hours_of_operation_id' to be a str")
        pulumi.set(__self__, "hours_of_operation_id", hours_of_operation_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if max_contacts and not isinstance(max_contacts, int):
            raise TypeError("Expected argument 'max_contacts' to be a int")
        pulumi.set(__self__, "max_contacts", max_contacts)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outbound_caller_configs and not isinstance(outbound_caller_configs, list):
            raise TypeError("Expected argument 'outbound_caller_configs' to be a list")
        pulumi.set(__self__, "outbound_caller_configs", outbound_caller_configs)
        if queue_id and not isinstance(queue_id, str):
            raise TypeError("Expected argument 'queue_id' to be a str")
        pulumi.set(__self__, "queue_id", queue_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the Queue.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Queue.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hoursOfOperationId")
    def hours_of_operation_id(self) -> _builtins.str:
        """
        Specifies the identifier of the Hours of Operation.
        """
        return pulumi.get(self, "hours_of_operation_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="maxContacts")
    def max_contacts(self) -> _builtins.int:
        """
        Maximum number of contacts that can be in the queue before it is considered full. Minimum value of 0.
        """
        return pulumi.get(self, "max_contacts")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outboundCallerConfigs")
    def outbound_caller_configs(self) -> Sequence['outputs.GetQueueOutboundCallerConfigResult']:
        """
        A block that defines the outbound caller ID name, number, and outbound whisper flow. The Outbound Caller Config block is documented below.
        """
        return pulumi.get(self, "outbound_caller_configs")

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> _builtins.str:
        """
        Identifier for the Queue.
        """
        return pulumi.get(self, "queue_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Description of the Queue. Values are `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags assigned to the Queue.
        """
        return pulumi.get(self, "tags")


class AwaitableGetQueueResult(GetQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueResult(
            arn=self.arn,
            description=self.description,
            hours_of_operation_id=self.hours_of_operation_id,
            id=self.id,
            instance_id=self.instance_id,
            max_contacts=self.max_contacts,
            name=self.name,
            outbound_caller_configs=self.outbound_caller_configs,
            queue_id=self.queue_id,
            region=self.region,
            status=self.status,
            tags=self.tags)


def get_queue(instance_id: Optional[_builtins.str] = None,
              name: Optional[_builtins.str] = None,
              queue_id: Optional[_builtins.str] = None,
              region: Optional[_builtins.str] = None,
              tags: Optional[Mapping[str, _builtins.str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueResult:
    """
    Provides details about a specific Amazon Connect Queue.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `queue_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        queue_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Queue by name
           
           > **NOTE:** `instance_id` and one of either `name` or `queue_id` is required.
    :param _builtins.str queue_id: Returns information on a specific Queue by Queue id
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the Queue.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['queueId'] = queue_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult).value

    return AwaitableGetQueueResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        hours_of_operation_id=pulumi.get(__ret__, 'hours_of_operation_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        max_contacts=pulumi.get(__ret__, 'max_contacts'),
        name=pulumi.get(__ret__, 'name'),
        outbound_caller_configs=pulumi.get(__ret__, 'outbound_caller_configs'),
        queue_id=pulumi.get(__ret__, 'queue_id'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_queue_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     queue_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQueueResult]:
    """
    Provides details about a specific Amazon Connect Queue.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `queue_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        queue_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Queue by name
           
           > **NOTE:** `instance_id` and one of either `name` or `queue_id` is required.
    :param _builtins.str queue_id: Returns information on a specific Queue by Queue id
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the Queue.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['queueId'] = queue_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:connect/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult)
    return __ret__.apply(lambda __response__: GetQueueResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        hours_of_operation_id=pulumi.get(__response__, 'hours_of_operation_id'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        max_contacts=pulumi.get(__response__, 'max_contacts'),
        name=pulumi.get(__response__, 'name'),
        outbound_caller_configs=pulumi.get(__response__, 'outbound_caller_configs'),
        queue_id=pulumi.get(__response__, 'queue_id'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
