# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetQuickConnectResult',
    'AwaitableGetQuickConnectResult',
    'get_quick_connect',
    'get_quick_connect_output',
]

@pulumi.output_type
class GetQuickConnectResult:
    """
    A collection of values returned by getQuickConnect.
    """
    def __init__(__self__, arn=None, description=None, id=None, instance_id=None, name=None, quick_connect_configs=None, quick_connect_id=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if quick_connect_configs and not isinstance(quick_connect_configs, list):
            raise TypeError("Expected argument 'quick_connect_configs' to be a list")
        pulumi.set(__self__, "quick_connect_configs", quick_connect_configs)
        if quick_connect_id and not isinstance(quick_connect_id, str):
            raise TypeError("Expected argument 'quick_connect_id' to be a str")
        pulumi.set(__self__, "quick_connect_id", quick_connect_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the Quick Connect.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Quick Connect.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="quickConnectConfigs")
    def quick_connect_configs(self) -> Sequence['outputs.GetQuickConnectQuickConnectConfigResult']:
        """
        A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
        """
        return pulumi.get(self, "quick_connect_configs")

    @_builtins.property
    @pulumi.getter(name="quickConnectId")
    def quick_connect_id(self) -> _builtins.str:
        """
        Identifier for the Quick Connect.
        """
        return pulumi.get(self, "quick_connect_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags to assign to the Quick Connect.
        """
        return pulumi.get(self, "tags")


class AwaitableGetQuickConnectResult(GetQuickConnectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQuickConnectResult(
            arn=self.arn,
            description=self.description,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            quick_connect_configs=self.quick_connect_configs,
            quick_connect_id=self.quick_connect_id,
            region=self.region,
            tags=self.tags)


def get_quick_connect(instance_id: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      quick_connect_id: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      tags: Optional[Mapping[str, _builtins.str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQuickConnectResult:
    """
    Provides details about a specific Amazon Connect Quick Connect.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_quick_connect(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `quick_connect_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_quick_connect(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        quick_connect_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Quick Connect by name
           
           > **NOTE:** `instance_id` and one of either `name` or `quick_connect_id` is required.
    :param _builtins.str quick_connect_id: Returns information on a specific Quick Connect by Quick Connect id
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags to assign to the Quick Connect.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['quickConnectId'] = quick_connect_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getQuickConnect:getQuickConnect', __args__, opts=opts, typ=GetQuickConnectResult).value

    return AwaitableGetQuickConnectResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        quick_connect_configs=pulumi.get(__ret__, 'quick_connect_configs'),
        quick_connect_id=pulumi.get(__ret__, 'quick_connect_id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_quick_connect_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             quick_connect_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQuickConnectResult]:
    """
    Provides details about a specific Amazon Connect Quick Connect.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_quick_connect(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `quick_connect_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_quick_connect(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        quick_connect_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Quick Connect by name
           
           > **NOTE:** `instance_id` and one of either `name` or `quick_connect_id` is required.
    :param _builtins.str quick_connect_id: Returns information on a specific Quick Connect by Quick Connect id
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags to assign to the Quick Connect.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['quickConnectId'] = quick_connect_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:connect/getQuickConnect:getQuickConnect', __args__, opts=opts, typ=GetQuickConnectResult)
    return __ret__.apply(lambda __response__: GetQuickConnectResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        quick_connect_configs=pulumi.get(__response__, 'quick_connect_configs'),
        quick_connect_id=pulumi.get(__response__, 'quick_connect_id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
