# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVocabularyResult',
    'AwaitableGetVocabularyResult',
    'get_vocabulary',
    'get_vocabulary_output',
]

@pulumi.output_type
class GetVocabularyResult:
    """
    A collection of values returned by getVocabulary.
    """
    def __init__(__self__, arn=None, content=None, failure_reason=None, id=None, instance_id=None, language_code=None, last_modified_time=None, name=None, region=None, state=None, tags=None, vocabulary_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if failure_reason and not isinstance(failure_reason, str):
            raise TypeError("Expected argument 'failure_reason' to be a str")
        pulumi.set(__self__, "failure_reason", failure_reason)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if language_code and not isinstance(language_code, str):
            raise TypeError("Expected argument 'language_code' to be a str")
        pulumi.set(__self__, "language_code", language_code)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vocabulary_id and not isinstance(vocabulary_id, str):
            raise TypeError("Expected argument 'vocabulary_id' to be a str")
        pulumi.set(__self__, "vocabulary_id", vocabulary_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) of the Vocabulary.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with Phrase, IPA, SoundsLike, and DisplayAs fields. Separate the fields with TAB characters. For more information, see [Create a custom vocabulary using a table](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> _builtins.str:
        """
        The reason why the custom vocabulary was not created.
        """
        return pulumi.get(self, "failure_reason")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> _builtins.str:
        """
        The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see [What is Amazon Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html). Valid Values are `ar-AE`, `de-CH`, `de-DE`, `en-AB`, `en-AU`, `en-GB`, `en-IE`, `en-IN`, `en-US`, `en-WL`, `es-ES`, `es-US`, `fr-CA`, `fr-FR`, `hi-IN`, `it-IT`, `ja-JP`, `ko-KR`, `pt-BR`, `pt-PT`, `zh-CN`.
        """
        return pulumi.get(self, "language_code")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> _builtins.str:
        """
        The timestamp when the custom vocabulary was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the custom vocabulary. Valid values are `CREATION_IN_PROGRESS`, `ACTIVE`, `CREATION_FAILED`, `DELETE_IN_PROGRESS`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags to assign to the Vocabulary.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vocabularyId")
    def vocabulary_id(self) -> _builtins.str:
        """
        The identifier of the custom vocabulary.
        """
        return pulumi.get(self, "vocabulary_id")


class AwaitableGetVocabularyResult(GetVocabularyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVocabularyResult(
            arn=self.arn,
            content=self.content,
            failure_reason=self.failure_reason,
            id=self.id,
            instance_id=self.instance_id,
            language_code=self.language_code,
            last_modified_time=self.last_modified_time,
            name=self.name,
            region=self.region,
            state=self.state,
            tags=self.tags,
            vocabulary_id=self.vocabulary_id)


def get_vocabulary(instance_id: Optional[_builtins.str] = None,
                   name: Optional[_builtins.str] = None,
                   region: Optional[_builtins.str] = None,
                   tags: Optional[Mapping[str, _builtins.str]] = None,
                   vocabulary_id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVocabularyResult:
    """
    Provides details about a specific Amazon Connect Vocabulary.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_vocabulary(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `vocabulary_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_vocabulary(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        vocabulary_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Vocabulary by name
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: A map of tags to assign to the Vocabulary.
    :param _builtins.str vocabulary_id: Returns information on a specific Vocabulary by Vocabulary id
           
           > **NOTE:** `instance_id` and one of either `name` or `vocabulary_id` is required.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['vocabularyId'] = vocabulary_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getVocabulary:getVocabulary', __args__, opts=opts, typ=GetVocabularyResult).value

    return AwaitableGetVocabularyResult(
        arn=pulumi.get(__ret__, 'arn'),
        content=pulumi.get(__ret__, 'content'),
        failure_reason=pulumi.get(__ret__, 'failure_reason'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        language_code=pulumi.get(__ret__, 'language_code'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'),
        vocabulary_id=pulumi.get(__ret__, 'vocabulary_id'))
def get_vocabulary_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                          name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                          vocabulary_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVocabularyResult]:
    """
    Provides details about a specific Amazon Connect Vocabulary.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_vocabulary(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `vocabulary_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_vocabulary(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        vocabulary_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Vocabulary by name
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: A map of tags to assign to the Vocabulary.
    :param _builtins.str vocabulary_id: Returns information on a specific Vocabulary by Vocabulary id
           
           > **NOTE:** `instance_id` and one of either `name` or `vocabulary_id` is required.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['vocabularyId'] = vocabulary_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:connect/getVocabulary:getVocabulary', __args__, opts=opts, typ=GetVocabularyResult)
    return __ret__.apply(lambda __response__: GetVocabularyResult(
        arn=pulumi.get(__response__, 'arn'),
        content=pulumi.get(__response__, 'content'),
        failure_reason=pulumi.get(__response__, 'failure_reason'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        language_code=pulumi.get(__response__, 'language_code'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags'),
        vocabulary_id=pulumi.get(__response__, 'vocabulary_id')))
