# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 identity_management_type: pulumi.Input[_builtins.str],
                 inbound_calls_enabled: pulumi.Input[_builtins.bool],
                 outbound_calls_enabled: pulumi.Input[_builtins.bool],
                 auto_resolve_best_voices_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_flow_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_lens_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 early_media_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_party_conference_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] identity_management_type: Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
        :param pulumi.Input[_builtins.bool] inbound_calls_enabled: Specifies whether inbound calls are enabled.
        :param pulumi.Input[_builtins.bool] outbound_calls_enabled: Specifies whether outbound calls are enabled.
        :param pulumi.Input[_builtins.bool] auto_resolve_best_voices_enabled: Specifies whether auto resolve best voices is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] contact_flow_logs_enabled: Specifies whether contact flow logs are enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] contact_lens_enabled: Specifies whether contact lens is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] directory_id: The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
        :param pulumi.Input[_builtins.bool] early_media_enabled: Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
        :param pulumi.Input[_builtins.str] instance_alias: Specifies the name of the instance. Required if `directory_id` not specified.
        :param pulumi.Input[_builtins.bool] multi_party_conference_enabled: Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the Instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
        """
        pulumi.set(__self__, "identity_management_type", identity_management_type)
        pulumi.set(__self__, "inbound_calls_enabled", inbound_calls_enabled)
        pulumi.set(__self__, "outbound_calls_enabled", outbound_calls_enabled)
        if auto_resolve_best_voices_enabled is not None:
            pulumi.set(__self__, "auto_resolve_best_voices_enabled", auto_resolve_best_voices_enabled)
        if contact_flow_logs_enabled is not None:
            pulumi.set(__self__, "contact_flow_logs_enabled", contact_flow_logs_enabled)
        if contact_lens_enabled is not None:
            pulumi.set(__self__, "contact_lens_enabled", contact_lens_enabled)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if early_media_enabled is not None:
            pulumi.set(__self__, "early_media_enabled", early_media_enabled)
        if instance_alias is not None:
            pulumi.set(__self__, "instance_alias", instance_alias)
        if multi_party_conference_enabled is not None:
            pulumi.set(__self__, "multi_party_conference_enabled", multi_party_conference_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="identityManagementType")
    def identity_management_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
        """
        return pulumi.get(self, "identity_management_type")

    @identity_management_type.setter
    def identity_management_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity_management_type", value)

    @_builtins.property
    @pulumi.getter(name="inboundCallsEnabled")
    def inbound_calls_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether inbound calls are enabled.
        """
        return pulumi.get(self, "inbound_calls_enabled")

    @inbound_calls_enabled.setter
    def inbound_calls_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "inbound_calls_enabled", value)

    @_builtins.property
    @pulumi.getter(name="outboundCallsEnabled")
    def outbound_calls_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether outbound calls are enabled.
        """
        return pulumi.get(self, "outbound_calls_enabled")

    @outbound_calls_enabled.setter
    def outbound_calls_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "outbound_calls_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoResolveBestVoicesEnabled")
    def auto_resolve_best_voices_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether auto resolve best voices is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "auto_resolve_best_voices_enabled")

    @auto_resolve_best_voices_enabled.setter
    def auto_resolve_best_voices_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_resolve_best_voices_enabled", value)

    @_builtins.property
    @pulumi.getter(name="contactFlowLogsEnabled")
    def contact_flow_logs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether contact flow logs are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "contact_flow_logs_enabled")

    @contact_flow_logs_enabled.setter
    def contact_flow_logs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "contact_flow_logs_enabled", value)

    @_builtins.property
    @pulumi.getter(name="contactLensEnabled")
    def contact_lens_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether contact lens is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "contact_lens_enabled")

    @contact_lens_enabled.setter
    def contact_lens_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "contact_lens_enabled", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="earlyMediaEnabled")
    def early_media_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
        """
        return pulumi.get(self, "early_media_enabled")

    @early_media_enabled.setter
    def early_media_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "early_media_enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the instance. Required if `directory_id` not specified.
        """
        return pulumi.get(self, "instance_alias")

    @instance_alias.setter
    def instance_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_alias", value)

    @_builtins.property
    @pulumi.getter(name="multiPartyConferenceEnabled")
    def multi_party_conference_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "multi_party_conference_enabled")

    @multi_party_conference_enabled.setter
    def multi_party_conference_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_party_conference_enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the Instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_resolve_best_voices_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_flow_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_lens_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 early_media_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_management_type: Optional[pulumi.Input[_builtins.str]] = None,
                 inbound_calls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_party_conference_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 outbound_calls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the instance.
        :param pulumi.Input[_builtins.bool] auto_resolve_best_voices_enabled: Specifies whether auto resolve best voices is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] contact_flow_logs_enabled: Specifies whether contact flow logs are enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] contact_lens_enabled: Specifies whether contact lens is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] created_time: When the instance was created.
        :param pulumi.Input[_builtins.str] directory_id: The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
        :param pulumi.Input[_builtins.bool] early_media_enabled: Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
        :param pulumi.Input[_builtins.str] identity_management_type: Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
        :param pulumi.Input[_builtins.bool] inbound_calls_enabled: Specifies whether inbound calls are enabled.
        :param pulumi.Input[_builtins.str] instance_alias: Specifies the name of the instance. Required if `directory_id` not specified.
        :param pulumi.Input[_builtins.bool] multi_party_conference_enabled: Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] outbound_calls_enabled: Specifies whether outbound calls are enabled.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] service_role: The service role of the instance.
        :param pulumi.Input[_builtins.str] status: The state of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the Instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_resolve_best_voices_enabled is not None:
            pulumi.set(__self__, "auto_resolve_best_voices_enabled", auto_resolve_best_voices_enabled)
        if contact_flow_logs_enabled is not None:
            pulumi.set(__self__, "contact_flow_logs_enabled", contact_flow_logs_enabled)
        if contact_lens_enabled is not None:
            pulumi.set(__self__, "contact_lens_enabled", contact_lens_enabled)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if early_media_enabled is not None:
            pulumi.set(__self__, "early_media_enabled", early_media_enabled)
        if identity_management_type is not None:
            pulumi.set(__self__, "identity_management_type", identity_management_type)
        if inbound_calls_enabled is not None:
            pulumi.set(__self__, "inbound_calls_enabled", inbound_calls_enabled)
        if instance_alias is not None:
            pulumi.set(__self__, "instance_alias", instance_alias)
        if multi_party_conference_enabled is not None:
            pulumi.set(__self__, "multi_party_conference_enabled", multi_party_conference_enabled)
        if outbound_calls_enabled is not None:
            pulumi.set(__self__, "outbound_calls_enabled", outbound_calls_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the instance.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="autoResolveBestVoicesEnabled")
    def auto_resolve_best_voices_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether auto resolve best voices is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "auto_resolve_best_voices_enabled")

    @auto_resolve_best_voices_enabled.setter
    def auto_resolve_best_voices_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_resolve_best_voices_enabled", value)

    @_builtins.property
    @pulumi.getter(name="contactFlowLogsEnabled")
    def contact_flow_logs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether contact flow logs are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "contact_flow_logs_enabled")

    @contact_flow_logs_enabled.setter
    def contact_flow_logs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "contact_flow_logs_enabled", value)

    @_builtins.property
    @pulumi.getter(name="contactLensEnabled")
    def contact_lens_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether contact lens is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "contact_lens_enabled")

    @contact_lens_enabled.setter
    def contact_lens_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "contact_lens_enabled", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the instance was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="earlyMediaEnabled")
    def early_media_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
        """
        return pulumi.get(self, "early_media_enabled")

    @early_media_enabled.setter
    def early_media_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "early_media_enabled", value)

    @_builtins.property
    @pulumi.getter(name="identityManagementType")
    def identity_management_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
        """
        return pulumi.get(self, "identity_management_type")

    @identity_management_type.setter
    def identity_management_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_management_type", value)

    @_builtins.property
    @pulumi.getter(name="inboundCallsEnabled")
    def inbound_calls_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether inbound calls are enabled.
        """
        return pulumi.get(self, "inbound_calls_enabled")

    @inbound_calls_enabled.setter
    def inbound_calls_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inbound_calls_enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the instance. Required if `directory_id` not specified.
        """
        return pulumi.get(self, "instance_alias")

    @instance_alias.setter
    def instance_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_alias", value)

    @_builtins.property
    @pulumi.getter(name="multiPartyConferenceEnabled")
    def multi_party_conference_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "multi_party_conference_enabled")

    @multi_party_conference_enabled.setter
    def multi_party_conference_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_party_conference_enabled", value)

    @_builtins.property
    @pulumi.getter(name="outboundCallsEnabled")
    def outbound_calls_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether outbound calls are enabled.
        """
        return pulumi.get(self, "outbound_calls_enabled")

    @outbound_calls_enabled.setter
    def outbound_calls_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "outbound_calls_enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service role of the instance.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_role", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the Instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:connect/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resolve_best_voices_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_flow_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_lens_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 early_media_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_management_type: Optional[pulumi.Input[_builtins.str]] = None,
                 inbound_calls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_party_conference_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 outbound_calls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an Amazon Connect instance resource. For more information see
        [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)

        !> **WARN:** Amazon Connect enforces a limit of [100 combined instance creation and deletions every 30 days](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits). For example, if you create 80 instances and delete 20 of them, you must wait 30 days to create or delete another instance. Use care when creating or deleting instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.connect.Instance("test",
            identity_management_type="CONNECT_MANAGED",
            inbound_calls_enabled=True,
            instance_alias="friendly-name-connect",
            outbound_calls_enabled=True,
            tags={
                "hello": "world",
            })
        ```

        ### With Existing Active Directory

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.connect.Instance("test",
            directory_id=test_aws_directory_service_directory["id"],
            identity_management_type="EXISTING_DIRECTORY",
            inbound_calls_enabled=True,
            instance_alias="friendly-name-connect",
            outbound_calls_enabled=True)
        ```

        ### With SAML

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.connect.Instance("test",
            identity_management_type="SAML",
            inbound_calls_enabled=True,
            instance_alias="friendly-name-connect",
            outbound_calls_enabled=True)
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `id` - (String) ID of the connect instance.

        #### Optional

        - `account_id` (String) AWS Account where this resource is managed.

        - `region` (String) Region where this resource is managed.

        Using `pulumi import`, import Connect instances using the `id`. For example:

        console

        % pulumi import aws_connect_instance.example f1288a1f-6193-445a-b47e-af739b2

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_resolve_best_voices_enabled: Specifies whether auto resolve best voices is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] contact_flow_logs_enabled: Specifies whether contact flow logs are enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] contact_lens_enabled: Specifies whether contact lens is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] directory_id: The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
        :param pulumi.Input[_builtins.bool] early_media_enabled: Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
        :param pulumi.Input[_builtins.str] identity_management_type: Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
        :param pulumi.Input[_builtins.bool] inbound_calls_enabled: Specifies whether inbound calls are enabled.
        :param pulumi.Input[_builtins.str] instance_alias: Specifies the name of the instance. Required if `directory_id` not specified.
        :param pulumi.Input[_builtins.bool] multi_party_conference_enabled: Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] outbound_calls_enabled: Specifies whether outbound calls are enabled.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the Instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amazon Connect instance resource. For more information see
        [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)

        !> **WARN:** Amazon Connect enforces a limit of [100 combined instance creation and deletions every 30 days](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits). For example, if you create 80 instances and delete 20 of them, you must wait 30 days to create or delete another instance. Use care when creating or deleting instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.connect.Instance("test",
            identity_management_type="CONNECT_MANAGED",
            inbound_calls_enabled=True,
            instance_alias="friendly-name-connect",
            outbound_calls_enabled=True,
            tags={
                "hello": "world",
            })
        ```

        ### With Existing Active Directory

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.connect.Instance("test",
            directory_id=test_aws_directory_service_directory["id"],
            identity_management_type="EXISTING_DIRECTORY",
            inbound_calls_enabled=True,
            instance_alias="friendly-name-connect",
            outbound_calls_enabled=True)
        ```

        ### With SAML

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.connect.Instance("test",
            identity_management_type="SAML",
            inbound_calls_enabled=True,
            instance_alias="friendly-name-connect",
            outbound_calls_enabled=True)
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `id` - (String) ID of the connect instance.

        #### Optional

        - `account_id` (String) AWS Account where this resource is managed.

        - `region` (String) Region where this resource is managed.

        Using `pulumi import`, import Connect instances using the `id`. For example:

        console

        % pulumi import aws_connect_instance.example f1288a1f-6193-445a-b47e-af739b2

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resolve_best_voices_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_flow_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_lens_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 early_media_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_management_type: Optional[pulumi.Input[_builtins.str]] = None,
                 inbound_calls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_party_conference_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 outbound_calls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_resolve_best_voices_enabled"] = auto_resolve_best_voices_enabled
            __props__.__dict__["contact_flow_logs_enabled"] = contact_flow_logs_enabled
            __props__.__dict__["contact_lens_enabled"] = contact_lens_enabled
            __props__.__dict__["directory_id"] = directory_id
            __props__.__dict__["early_media_enabled"] = early_media_enabled
            if identity_management_type is None and not opts.urn:
                raise TypeError("Missing required property 'identity_management_type'")
            __props__.__dict__["identity_management_type"] = identity_management_type
            if inbound_calls_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'inbound_calls_enabled'")
            __props__.__dict__["inbound_calls_enabled"] = inbound_calls_enabled
            __props__.__dict__["instance_alias"] = instance_alias
            __props__.__dict__["multi_party_conference_enabled"] = multi_party_conference_enabled
            if outbound_calls_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'outbound_calls_enabled'")
            __props__.__dict__["outbound_calls_enabled"] = outbound_calls_enabled
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["service_role"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(Instance, __self__).__init__(
            'aws:connect/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            auto_resolve_best_voices_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            contact_flow_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            contact_lens_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            early_media_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            identity_management_type: Optional[pulumi.Input[_builtins.str]] = None,
            inbound_calls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_alias: Optional[pulumi.Input[_builtins.str]] = None,
            multi_party_conference_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            outbound_calls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_role: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the instance.
        :param pulumi.Input[_builtins.bool] auto_resolve_best_voices_enabled: Specifies whether auto resolve best voices is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] contact_flow_logs_enabled: Specifies whether contact flow logs are enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] contact_lens_enabled: Specifies whether contact lens is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] created_time: When the instance was created.
        :param pulumi.Input[_builtins.str] directory_id: The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
        :param pulumi.Input[_builtins.bool] early_media_enabled: Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
        :param pulumi.Input[_builtins.str] identity_management_type: Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
        :param pulumi.Input[_builtins.bool] inbound_calls_enabled: Specifies whether inbound calls are enabled.
        :param pulumi.Input[_builtins.str] instance_alias: Specifies the name of the instance. Required if `directory_id` not specified.
        :param pulumi.Input[_builtins.bool] multi_party_conference_enabled: Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] outbound_calls_enabled: Specifies whether outbound calls are enabled.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] service_role: The service role of the instance.
        :param pulumi.Input[_builtins.str] status: The state of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the Instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_resolve_best_voices_enabled"] = auto_resolve_best_voices_enabled
        __props__.__dict__["contact_flow_logs_enabled"] = contact_flow_logs_enabled
        __props__.__dict__["contact_lens_enabled"] = contact_lens_enabled
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["early_media_enabled"] = early_media_enabled
        __props__.__dict__["identity_management_type"] = identity_management_type
        __props__.__dict__["inbound_calls_enabled"] = inbound_calls_enabled
        __props__.__dict__["instance_alias"] = instance_alias
        __props__.__dict__["multi_party_conference_enabled"] = multi_party_conference_enabled
        __props__.__dict__["outbound_calls_enabled"] = outbound_calls_enabled
        __props__.__dict__["region"] = region
        __props__.__dict__["service_role"] = service_role
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the instance.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="autoResolveBestVoicesEnabled")
    def auto_resolve_best_voices_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether auto resolve best voices is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "auto_resolve_best_voices_enabled")

    @_builtins.property
    @pulumi.getter(name="contactFlowLogsEnabled")
    def contact_flow_logs_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether contact flow logs are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "contact_flow_logs_enabled")

    @_builtins.property
    @pulumi.getter(name="contactLensEnabled")
    def contact_lens_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether contact lens is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "contact_lens_enabled")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        When the instance was created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="earlyMediaEnabled")
    def early_media_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
        """
        return pulumi.get(self, "early_media_enabled")

    @_builtins.property
    @pulumi.getter(name="identityManagementType")
    def identity_management_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
        """
        return pulumi.get(self, "identity_management_type")

    @_builtins.property
    @pulumi.getter(name="inboundCallsEnabled")
    def inbound_calls_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether inbound calls are enabled.
        """
        return pulumi.get(self, "inbound_calls_enabled")

    @_builtins.property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the instance. Required if `directory_id` not specified.
        """
        return pulumi.get(self, "instance_alias")

    @_builtins.property
    @pulumi.getter(name="multiPartyConferenceEnabled")
    def multi_party_conference_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "multi_party_conference_enabled")

    @_builtins.property
    @pulumi.getter(name="outboundCallsEnabled")
    def outbound_calls_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether outbound calls are enabled.
        """
        return pulumi.get(self, "outbound_calls_enabled")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Output[_builtins.str]:
        """
        The service role of the instance.
        """
        return pulumi.get(self, "service_role")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Tags to apply to the Instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

