# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PhoneNumberContactFlowAssociationArgs', 'PhoneNumberContactFlowAssociation']

@pulumi.input_type
class PhoneNumberContactFlowAssociationArgs:
    def __init__(__self__, *,
                 contact_flow_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 phone_number_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PhoneNumberContactFlowAssociation resource.
        :param pulumi.Input[_builtins.str] contact_flow_id: Contact flow ID.
        :param pulumi.Input[_builtins.str] instance_id: Amazon Connect instance ID.
        :param pulumi.Input[_builtins.str] phone_number_id: Phone number ID.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "phone_number_id", phone_number_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> pulumi.Input[_builtins.str]:
        """
        Contact flow ID.
        """
        return pulumi.get(self, "contact_flow_id")

    @contact_flow_id.setter
    def contact_flow_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contact_flow_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Amazon Connect instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumberId")
    def phone_number_id(self) -> pulumi.Input[_builtins.str]:
        """
        Phone number ID.
        """
        return pulumi.get(self, "phone_number_id")

    @phone_number_id.setter
    def phone_number_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "phone_number_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PhoneNumberContactFlowAssociationState:
    def __init__(__self__, *,
                 contact_flow_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PhoneNumberContactFlowAssociation resources.
        :param pulumi.Input[_builtins.str] contact_flow_id: Contact flow ID.
        :param pulumi.Input[_builtins.str] instance_id: Amazon Connect instance ID.
        :param pulumi.Input[_builtins.str] phone_number_id: Phone number ID.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if contact_flow_id is not None:
            pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if phone_number_id is not None:
            pulumi.set(__self__, "phone_number_id", phone_number_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contact flow ID.
        """
        return pulumi.get(self, "contact_flow_id")

    @contact_flow_id.setter
    def contact_flow_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contact_flow_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Connect instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumberId")
    def phone_number_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Phone number ID.
        """
        return pulumi.get(self, "phone_number_id")

    @phone_number_id.setter
    def phone_number_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:connect/phoneNumberContactFlowAssociation:PhoneNumberContactFlowAssociation")
class PhoneNumberContactFlowAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_flow_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Associates a flow with a phone number claimed to an Amazon Connect instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.PhoneNumberContactFlowAssociation("example",
            phone_number_id=example_aws_connect_phone_number["id"],
            instance_id=example_aws_connect_instance["id"],
            contact_flow_id=example_aws_connect_contact_flow["contactFlowId"])
        ```

        ## Import

        Using `pulumi import`, import `aws_connect_phone_number_contact_flow_association` using the `phone_number_id`, `instance_id` and `contact_flow_id` separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:connect/phoneNumberContactFlowAssociation:PhoneNumberContactFlowAssociation example 36727a4c-4683-4e49-880c-3347c61110a4,fa6c1691-e2eb-4487-bdb9-1aaed6268ebd,c4acdc79-395e-4280-a294-9062f56b07bb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contact_flow_id: Contact flow ID.
        :param pulumi.Input[_builtins.str] instance_id: Amazon Connect instance ID.
        :param pulumi.Input[_builtins.str] phone_number_id: Phone number ID.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PhoneNumberContactFlowAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates a flow with a phone number claimed to an Amazon Connect instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.PhoneNumberContactFlowAssociation("example",
            phone_number_id=example_aws_connect_phone_number["id"],
            instance_id=example_aws_connect_instance["id"],
            contact_flow_id=example_aws_connect_contact_flow["contactFlowId"])
        ```

        ## Import

        Using `pulumi import`, import `aws_connect_phone_number_contact_flow_association` using the `phone_number_id`, `instance_id` and `contact_flow_id` separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:connect/phoneNumberContactFlowAssociation:PhoneNumberContactFlowAssociation example 36727a4c-4683-4e49-880c-3347c61110a4,fa6c1691-e2eb-4487-bdb9-1aaed6268ebd,c4acdc79-395e-4280-a294-9062f56b07bb
        ```

        :param str resource_name: The name of the resource.
        :param PhoneNumberContactFlowAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PhoneNumberContactFlowAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_flow_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PhoneNumberContactFlowAssociationArgs.__new__(PhoneNumberContactFlowAssociationArgs)

            if contact_flow_id is None and not opts.urn:
                raise TypeError("Missing required property 'contact_flow_id'")
            __props__.__dict__["contact_flow_id"] = contact_flow_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if phone_number_id is None and not opts.urn:
                raise TypeError("Missing required property 'phone_number_id'")
            __props__.__dict__["phone_number_id"] = phone_number_id
            __props__.__dict__["region"] = region
        super(PhoneNumberContactFlowAssociation, __self__).__init__(
            'aws:connect/phoneNumberContactFlowAssociation:PhoneNumberContactFlowAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contact_flow_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            phone_number_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'PhoneNumberContactFlowAssociation':
        """
        Get an existing PhoneNumberContactFlowAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contact_flow_id: Contact flow ID.
        :param pulumi.Input[_builtins.str] instance_id: Amazon Connect instance ID.
        :param pulumi.Input[_builtins.str] phone_number_id: Phone number ID.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PhoneNumberContactFlowAssociationState.__new__(_PhoneNumberContactFlowAssociationState)

        __props__.__dict__["contact_flow_id"] = contact_flow_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["phone_number_id"] = phone_number_id
        __props__.__dict__["region"] = region
        return PhoneNumberContactFlowAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> pulumi.Output[_builtins.str]:
        """
        Contact flow ID.
        """
        return pulumi.get(self, "contact_flow_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Connect instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="phoneNumberId")
    def phone_number_id(self) -> pulumi.Output[_builtins.str]:
        """
        Phone number ID.
        """
        return pulumi.get(self, "phone_number_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

