# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BaselineArgs', 'Baseline']

@pulumi.input_type
class BaselineArgs:
    def __init__(__self__, *,
                 baseline_identifier: pulumi.Input[_builtins.str],
                 baseline_version: pulumi.Input[_builtins.str],
                 target_identifier: pulumi.Input[_builtins.str],
                 parameters: Optional[pulumi.Input['BaselineParametersArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['BaselineTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Baseline resource.
        :param pulumi.Input[_builtins.str] baseline_identifier: The ARN of the baseline to be enabled.
        :param pulumi.Input[_builtins.str] baseline_version: The version of the baseline to be enabled.
        :param pulumi.Input[_builtins.str] target_identifier: The ARN of the target on which the baseline will be enabled. Only OUs are supported as targets.
               
               The following arguments are optional:
        :param pulumi.Input['BaselineParametersArgs'] parameters: A list of key-value objects that specify enablement parameters, where key is a string and value is a document of any type. See Parameter below for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "baseline_identifier", baseline_identifier)
        pulumi.set(__self__, "baseline_version", baseline_version)
        pulumi.set(__self__, "target_identifier", target_identifier)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="baselineIdentifier")
    def baseline_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the baseline to be enabled.
        """
        return pulumi.get(self, "baseline_identifier")

    @baseline_identifier.setter
    def baseline_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "baseline_identifier", value)

    @_builtins.property
    @pulumi.getter(name="baselineVersion")
    def baseline_version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the baseline to be enabled.
        """
        return pulumi.get(self, "baseline_version")

    @baseline_version.setter
    def baseline_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "baseline_version", value)

    @_builtins.property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the target on which the baseline will be enabled. Only OUs are supported as targets.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_identifier")

    @target_identifier.setter
    def target_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_identifier", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input['BaselineParametersArgs']]:
        """
        A list of key-value objects that specify enablement parameters, where key is a string and value is a document of any type. See Parameter below for details.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input['BaselineParametersArgs']]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['BaselineTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['BaselineTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _BaselineState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 baseline_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 baseline_version: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input['BaselineParametersArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['BaselineTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering Baseline resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Baseline.
        :param pulumi.Input[_builtins.str] baseline_identifier: The ARN of the baseline to be enabled.
        :param pulumi.Input[_builtins.str] baseline_version: The version of the baseline to be enabled.
        :param pulumi.Input['BaselineParametersArgs'] parameters: A list of key-value objects that specify enablement parameters, where key is a string and value is a document of any type. See Parameter below for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the landing zone, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] target_identifier: The ARN of the target on which the baseline will be enabled. Only OUs are supported as targets.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if baseline_identifier is not None:
            pulumi.set(__self__, "baseline_identifier", baseline_identifier)
        if baseline_version is not None:
            pulumi.set(__self__, "baseline_version", baseline_version)
        if operation_identifier is not None:
            pulumi.set(__self__, "operation_identifier", operation_identifier)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_identifier is not None:
            pulumi.set(__self__, "target_identifier", target_identifier)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Baseline.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="baselineIdentifier")
    def baseline_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the baseline to be enabled.
        """
        return pulumi.get(self, "baseline_identifier")

    @baseline_identifier.setter
    def baseline_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_identifier", value)

    @_builtins.property
    @pulumi.getter(name="baselineVersion")
    def baseline_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the baseline to be enabled.
        """
        return pulumi.get(self, "baseline_version")

    @baseline_version.setter
    def baseline_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_version", value)

    @_builtins.property
    @pulumi.getter(name="operationIdentifier")
    def operation_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "operation_identifier")

    @operation_identifier.setter
    def operation_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_identifier", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input['BaselineParametersArgs']]:
        """
        A list of key-value objects that specify enablement parameters, where key is a string and value is a document of any type. See Parameter below for details.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input['BaselineParametersArgs']]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the landing zone, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the target on which the baseline will be enabled. Only OUs are supported as targets.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_identifier")

    @target_identifier.setter
    def target_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_identifier", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['BaselineTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['BaselineTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:controltower/baseline:Baseline")
class Baseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 baseline_version: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Union['BaselineParametersArgs', 'BaselineParametersArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['BaselineTimeoutsArgs', 'BaselineTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Control Tower Baseline.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.controltower.Baseline("example",
            baseline_identifier="arn:aws:controltower:us-east-1::baseline/17BSJV3IGJ2QSGA2",
            baseline_version="4.0",
            target_identifier=test["arn"],
            parameters={
                "key": "IdentityCenterEnabledBaselineArn",
                "value": "arn:aws:controltower:us-east-1:664418989480:enabledbaseline/XALULM96QHI525UOC",
            })
        ```

        ## Import

        Using `pulumi import`, import Control Tower Baseline using the `arn`. For example:

        ```sh
        $ pulumi import aws:controltower/baseline:Baseline example arn:aws:controltower:us-east-1:012345678912:enabledbaseline/XALULM96QHI525UOC
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] baseline_identifier: The ARN of the baseline to be enabled.
        :param pulumi.Input[_builtins.str] baseline_version: The version of the baseline to be enabled.
        :param pulumi.Input[Union['BaselineParametersArgs', 'BaselineParametersArgsDict']] parameters: A list of key-value objects that specify enablement parameters, where key is a string and value is a document of any type. See Parameter below for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] target_identifier: The ARN of the target on which the baseline will be enabled. Only OUs are supported as targets.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BaselineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Control Tower Baseline.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.controltower.Baseline("example",
            baseline_identifier="arn:aws:controltower:us-east-1::baseline/17BSJV3IGJ2QSGA2",
            baseline_version="4.0",
            target_identifier=test["arn"],
            parameters={
                "key": "IdentityCenterEnabledBaselineArn",
                "value": "arn:aws:controltower:us-east-1:664418989480:enabledbaseline/XALULM96QHI525UOC",
            })
        ```

        ## Import

        Using `pulumi import`, import Control Tower Baseline using the `arn`. For example:

        ```sh
        $ pulumi import aws:controltower/baseline:Baseline example arn:aws:controltower:us-east-1:012345678912:enabledbaseline/XALULM96QHI525UOC
        ```

        :param str resource_name: The name of the resource.
        :param BaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 baseline_version: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Union['BaselineParametersArgs', 'BaselineParametersArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['BaselineTimeoutsArgs', 'BaselineTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BaselineArgs.__new__(BaselineArgs)

            if baseline_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_identifier'")
            __props__.__dict__["baseline_identifier"] = baseline_identifier
            if baseline_version is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_version'")
            __props__.__dict__["baseline_version"] = baseline_version
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if target_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'target_identifier'")
            __props__.__dict__["target_identifier"] = target_identifier
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["operation_identifier"] = None
            __props__.__dict__["tags_all"] = None
        super(Baseline, __self__).__init__(
            'aws:controltower/baseline:Baseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            baseline_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            baseline_version: Optional[pulumi.Input[_builtins.str]] = None,
            operation_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Union['BaselineParametersArgs', 'BaselineParametersArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['BaselineTimeoutsArgs', 'BaselineTimeoutsArgsDict']]] = None) -> 'Baseline':
        """
        Get an existing Baseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Baseline.
        :param pulumi.Input[_builtins.str] baseline_identifier: The ARN of the baseline to be enabled.
        :param pulumi.Input[_builtins.str] baseline_version: The version of the baseline to be enabled.
        :param pulumi.Input[Union['BaselineParametersArgs', 'BaselineParametersArgsDict']] parameters: A list of key-value objects that specify enablement parameters, where key is a string and value is a document of any type. See Parameter below for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the landing zone, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] target_identifier: The ARN of the target on which the baseline will be enabled. Only OUs are supported as targets.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BaselineState.__new__(_BaselineState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["baseline_identifier"] = baseline_identifier
        __props__.__dict__["baseline_version"] = baseline_version
        __props__.__dict__["operation_identifier"] = operation_identifier
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_identifier"] = target_identifier
        __props__.__dict__["timeouts"] = timeouts
        return Baseline(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Baseline.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="baselineIdentifier")
    def baseline_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the baseline to be enabled.
        """
        return pulumi.get(self, "baseline_identifier")

    @_builtins.property
    @pulumi.getter(name="baselineVersion")
    def baseline_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the baseline to be enabled.
        """
        return pulumi.get(self, "baseline_version")

    @_builtins.property
    @pulumi.getter(name="operationIdentifier")
    def operation_identifier(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "operation_identifier")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional['outputs.BaselineParameters']]:
        """
        A list of key-value objects that specify enablement parameters, where key is a string and value is a document of any type. See Parameter below for details.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the landing zone, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the target on which the baseline will be enabled. Only OUs are supported as targets.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_identifier")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.BaselineTimeouts']]:
        return pulumi.get(self, "timeouts")

