# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LandingZoneArgs', 'LandingZone']

@pulumi.input_type
class LandingZoneArgs:
    def __init__(__self__, *,
                 manifest_json: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LandingZone resource.
        :param pulumi.Input[_builtins.str] manifest_json: The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
        :param pulumi.Input[_builtins.str] version: The landing zone version.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "manifest_json", manifest_json)
        pulumi.set(__self__, "version", version)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="manifestJson")
    def manifest_json(self) -> pulumi.Input[_builtins.str]:
        """
        The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
        """
        return pulumi.get(self, "manifest_json")

    @manifest_json.setter
    def manifest_json(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "manifest_json", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The landing zone version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LandingZoneState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 drift_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['LandingZoneDriftStatusArgs']]]] = None,
                 latest_available_version: Optional[pulumi.Input[_builtins.str]] = None,
                 manifest_json: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LandingZone resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the landing zone.
        :param pulumi.Input[Sequence[pulumi.Input['LandingZoneDriftStatusArgs']]] drift_statuses: The drift status summary of the landing zone.
        :param pulumi.Input[_builtins.str] latest_available_version: The latest available version of the landing zone.
        :param pulumi.Input[_builtins.str] manifest_json: The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the landing zone, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] version: The landing zone version.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if drift_statuses is not None:
            pulumi.set(__self__, "drift_statuses", drift_statuses)
        if latest_available_version is not None:
            pulumi.set(__self__, "latest_available_version", latest_available_version)
        if manifest_json is not None:
            pulumi.set(__self__, "manifest_json", manifest_json)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the landing zone.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="driftStatuses")
    def drift_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LandingZoneDriftStatusArgs']]]]:
        """
        The drift status summary of the landing zone.
        """
        return pulumi.get(self, "drift_statuses")

    @drift_statuses.setter
    def drift_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LandingZoneDriftStatusArgs']]]]):
        pulumi.set(self, "drift_statuses", value)

    @_builtins.property
    @pulumi.getter(name="latestAvailableVersion")
    def latest_available_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest available version of the landing zone.
        """
        return pulumi.get(self, "latest_available_version")

    @latest_available_version.setter
    def latest_available_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_available_version", value)

    @_builtins.property
    @pulumi.getter(name="manifestJson")
    def manifest_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
        """
        return pulumi.get(self, "manifest_json")

    @manifest_json.setter
    def manifest_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manifest_json", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the landing zone, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The landing zone version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws:controltower/landingZone:LandingZone")
class LandingZone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 manifest_json: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a new landing zone using Control Tower. For more information on usage, please see the
        [AWS Control Tower Landing Zone User Guide](https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html).

        ## Import

        Using `pulumi import`, import a Control Tower Landing Zone using the `id`. For example:

        ```sh
        $ pulumi import aws:controltower/landingZone:LandingZone example 1A2B3C4D5E6F7G8H
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] manifest_json: The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] version: The landing zone version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LandingZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new landing zone using Control Tower. For more information on usage, please see the
        [AWS Control Tower Landing Zone User Guide](https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html).

        ## Import

        Using `pulumi import`, import a Control Tower Landing Zone using the `id`. For example:

        ```sh
        $ pulumi import aws:controltower/landingZone:LandingZone example 1A2B3C4D5E6F7G8H
        ```

        :param str resource_name: The name of the resource.
        :param LandingZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LandingZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 manifest_json: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LandingZoneArgs.__new__(LandingZoneArgs)

            if manifest_json is None and not opts.urn:
                raise TypeError("Missing required property 'manifest_json'")
            __props__.__dict__["manifest_json"] = manifest_json
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["arn"] = None
            __props__.__dict__["drift_statuses"] = None
            __props__.__dict__["latest_available_version"] = None
            __props__.__dict__["tags_all"] = None
        super(LandingZone, __self__).__init__(
            'aws:controltower/landingZone:LandingZone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            drift_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LandingZoneDriftStatusArgs', 'LandingZoneDriftStatusArgsDict']]]]] = None,
            latest_available_version: Optional[pulumi.Input[_builtins.str]] = None,
            manifest_json: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'LandingZone':
        """
        Get an existing LandingZone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the landing zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LandingZoneDriftStatusArgs', 'LandingZoneDriftStatusArgsDict']]]] drift_statuses: The drift status summary of the landing zone.
        :param pulumi.Input[_builtins.str] latest_available_version: The latest available version of the landing zone.
        :param pulumi.Input[_builtins.str] manifest_json: The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the landing zone, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] version: The landing zone version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LandingZoneState.__new__(_LandingZoneState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["drift_statuses"] = drift_statuses
        __props__.__dict__["latest_available_version"] = latest_available_version
        __props__.__dict__["manifest_json"] = manifest_json
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["version"] = version
        return LandingZone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the landing zone.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="driftStatuses")
    def drift_statuses(self) -> pulumi.Output[Sequence['outputs.LandingZoneDriftStatus']]:
        """
        The drift status summary of the landing zone.
        """
        return pulumi.get(self, "drift_statuses")

    @_builtins.property
    @pulumi.getter(name="latestAvailableVersion")
    def latest_available_version(self) -> pulumi.Output[_builtins.str]:
        """
        The latest available version of the landing zone.
        """
        return pulumi.get(self, "latest_available_version")

    @_builtins.property
    @pulumi.getter(name="manifestJson")
    def manifest_json(self) -> pulumi.Output[_builtins.str]:
        """
        The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
        """
        return pulumi.get(self, "manifest_json")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the landing zone, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The landing zone version.
        """
        return pulumi.get(self, "version")

