# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ReportDefinitionArgs', 'ReportDefinition']

@pulumi.input_type
class ReportDefinitionArgs:
    def __init__(__self__, *,
                 additional_schema_elements: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 compression: pulumi.Input[_builtins.str],
                 format: pulumi.Input[_builtins.str],
                 report_name: pulumi.Input[_builtins.str],
                 s3_bucket: pulumi.Input[_builtins.str],
                 s3_prefix: pulumi.Input[_builtins.str],
                 s3_region: pulumi.Input[_builtins.str],
                 time_unit: pulumi.Input[_builtins.str],
                 additional_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 refresh_closed_reports: Optional[pulumi.Input[_builtins.bool]] = None,
                 report_versioning: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ReportDefinition resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_schema_elements: A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`, `MANUAL_DISCOUNT_COMPATIBILITY`.
        :param pulumi.Input[_builtins.str] compression: Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
        :param pulumi.Input[_builtins.str] format: Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
        :param pulumi.Input[_builtins.str] report_name: Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
        :param pulumi.Input[_builtins.str] s3_bucket: Name of the existing S3 bucket to hold generated reports.
        :param pulumi.Input[_builtins.str] s3_prefix: Report path prefix. Limited to 256 characters. May be empty (`""`) but the resource can then not be modified via the AWS Console.
        :param pulumi.Input[_builtins.str] s3_region: Region of the existing S3 bucket to hold generated reports.
        :param pulumi.Input[_builtins.str] time_unit: The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_artifacts: A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
        :param pulumi.Input[_builtins.bool] refresh_closed_reports: Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
        :param pulumi.Input[_builtins.str] report_versioning: Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "additional_schema_elements", additional_schema_elements)
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "report_name", report_name)
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_prefix", s3_prefix)
        pulumi.set(__self__, "s3_region", s3_region)
        pulumi.set(__self__, "time_unit", time_unit)
        if additional_artifacts is not None:
            pulumi.set(__self__, "additional_artifacts", additional_artifacts)
        if refresh_closed_reports is not None:
            pulumi.set(__self__, "refresh_closed_reports", refresh_closed_reports)
        if report_versioning is not None:
            pulumi.set(__self__, "report_versioning", report_versioning)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="additionalSchemaElements")
    def additional_schema_elements(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`, `MANUAL_DISCOUNT_COMPATIBILITY`.
        """
        return pulumi.get(self, "additional_schema_elements")

    @additional_schema_elements.setter
    def additional_schema_elements(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "additional_schema_elements", value)

    @_builtins.property
    @pulumi.getter
    def compression(self) -> pulumi.Input[_builtins.str]:
        """
        Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compression", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Input[_builtins.str]:
        """
        Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="reportName")
    def report_name(self) -> pulumi.Input[_builtins.str]:
        """
        Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
        """
        return pulumi.get(self, "report_name")

    @report_name.setter
    def report_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "report_name", value)

    @_builtins.property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the existing S3 bucket to hold generated reports.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "s3_bucket", value)

    @_builtins.property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        Report path prefix. Limited to 256 characters. May be empty (`""`) but the resource can then not be modified via the AWS Console.
        """
        return pulumi.get(self, "s3_prefix")

    @s3_prefix.setter
    def s3_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "s3_prefix", value)

    @_builtins.property
    @pulumi.getter(name="s3Region")
    def s3_region(self) -> pulumi.Input[_builtins.str]:
        """
        Region of the existing S3 bucket to hold generated reports.
        """
        return pulumi.get(self, "s3_region")

    @s3_region.setter
    def s3_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "s3_region", value)

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> pulumi.Input[_builtins.str]:
        """
        The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
        """
        return pulumi.get(self, "time_unit")

    @time_unit.setter
    def time_unit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_unit", value)

    @_builtins.property
    @pulumi.getter(name="additionalArtifacts")
    def additional_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
        """
        return pulumi.get(self, "additional_artifacts")

    @additional_artifacts.setter
    def additional_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_artifacts", value)

    @_builtins.property
    @pulumi.getter(name="refreshClosedReports")
    def refresh_closed_reports(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
        """
        return pulumi.get(self, "refresh_closed_reports")

    @refresh_closed_reports.setter
    def refresh_closed_reports(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "refresh_closed_reports", value)

    @_builtins.property
    @pulumi.getter(name="reportVersioning")
    def report_versioning(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
        """
        return pulumi.get(self, "report_versioning")

    @report_versioning.setter
    def report_versioning(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "report_versioning", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ReportDefinitionState:
    def __init__(__self__, *,
                 additional_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 additional_schema_elements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_closed_reports: Optional[pulumi.Input[_builtins.bool]] = None,
                 report_name: Optional[pulumi.Input[_builtins.str]] = None,
                 report_versioning: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReportDefinition resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_artifacts: A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_schema_elements: A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`, `MANUAL_DISCOUNT_COMPATIBILITY`.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) specifying the cur report.
        :param pulumi.Input[_builtins.str] compression: Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
        :param pulumi.Input[_builtins.str] format: Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
        :param pulumi.Input[_builtins.bool] refresh_closed_reports: Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
        :param pulumi.Input[_builtins.str] report_name: Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
        :param pulumi.Input[_builtins.str] report_versioning: Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
        :param pulumi.Input[_builtins.str] s3_bucket: Name of the existing S3 bucket to hold generated reports.
        :param pulumi.Input[_builtins.str] s3_prefix: Report path prefix. Limited to 256 characters. May be empty (`""`) but the resource can then not be modified via the AWS Console.
        :param pulumi.Input[_builtins.str] s3_region: Region of the existing S3 bucket to hold generated reports.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] time_unit: The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
        """
        if additional_artifacts is not None:
            pulumi.set(__self__, "additional_artifacts", additional_artifacts)
        if additional_schema_elements is not None:
            pulumi.set(__self__, "additional_schema_elements", additional_schema_elements)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if refresh_closed_reports is not None:
            pulumi.set(__self__, "refresh_closed_reports", refresh_closed_reports)
        if report_name is not None:
            pulumi.set(__self__, "report_name", report_name)
        if report_versioning is not None:
            pulumi.set(__self__, "report_versioning", report_versioning)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_prefix is not None:
            pulumi.set(__self__, "s3_prefix", s3_prefix)
        if s3_region is not None:
            pulumi.set(__self__, "s3_region", s3_region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if time_unit is not None:
            pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter(name="additionalArtifacts")
    def additional_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
        """
        return pulumi.get(self, "additional_artifacts")

    @additional_artifacts.setter
    def additional_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_artifacts", value)

    @_builtins.property
    @pulumi.getter(name="additionalSchemaElements")
    def additional_schema_elements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`, `MANUAL_DISCOUNT_COMPATIBILITY`.
        """
        return pulumi.get(self, "additional_schema_elements")

    @additional_schema_elements.setter
    def additional_schema_elements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_schema_elements", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) specifying the cur report.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="refreshClosedReports")
    def refresh_closed_reports(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
        """
        return pulumi.get(self, "refresh_closed_reports")

    @refresh_closed_reports.setter
    def refresh_closed_reports(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "refresh_closed_reports", value)

    @_builtins.property
    @pulumi.getter(name="reportName")
    def report_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
        """
        return pulumi.get(self, "report_name")

    @report_name.setter
    def report_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "report_name", value)

    @_builtins.property
    @pulumi.getter(name="reportVersioning")
    def report_versioning(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
        """
        return pulumi.get(self, "report_versioning")

    @report_versioning.setter
    def report_versioning(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "report_versioning", value)

    @_builtins.property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the existing S3 bucket to hold generated reports.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_bucket", value)

    @_builtins.property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Report path prefix. Limited to 256 characters. May be empty (`""`) but the resource can then not be modified via the AWS Console.
        """
        return pulumi.get(self, "s3_prefix")

    @s3_prefix.setter
    def s3_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_prefix", value)

    @_builtins.property
    @pulumi.getter(name="s3Region")
    def s3_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region of the existing S3 bucket to hold generated reports.
        """
        return pulumi.get(self, "s3_region")

    @s3_region.setter
    def s3_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
        """
        return pulumi.get(self, "time_unit")

    @time_unit.setter
    def time_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_unit", value)


@pulumi.type_token("aws:cur/reportDefinition:ReportDefinition")
class ReportDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 additional_schema_elements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_closed_reports: Optional[pulumi.Input[_builtins.bool]] = None,
                 report_name: Optional[pulumi.Input[_builtins.str]] = None,
                 report_versioning: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Cost and Usage Report Definitions.

        > *NOTE:* The AWS Cost and Usage Report service is only available in `us-east-1` currently.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_cur_report_definition = aws.cur.ReportDefinition("example_cur_report_definition",
            report_name="example-cur-report-definition",
            time_unit="HOURLY",
            format="textORcsv",
            compression="GZIP",
            additional_schema_elements=[
                "RESOURCES",
                "SPLIT_COST_ALLOCATION_DATA",
            ],
            s3_bucket="example-bucket-name",
            s3_prefix="example-cur-report",
            s3_region="us-east-1",
            additional_artifacts=[
                "REDSHIFT",
                "QUICKSIGHT",
            ])
        ```

        ## Import

        Using `pulumi import`, import Report Definitions using the `report_name`. For example:

        ```sh
        $ pulumi import aws:cur/reportDefinition:ReportDefinition example_cur_report_definition example-cur-report-definition
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_artifacts: A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_schema_elements: A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`, `MANUAL_DISCOUNT_COMPATIBILITY`.
        :param pulumi.Input[_builtins.str] compression: Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
        :param pulumi.Input[_builtins.str] format: Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
        :param pulumi.Input[_builtins.bool] refresh_closed_reports: Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
        :param pulumi.Input[_builtins.str] report_name: Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
        :param pulumi.Input[_builtins.str] report_versioning: Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
        :param pulumi.Input[_builtins.str] s3_bucket: Name of the existing S3 bucket to hold generated reports.
        :param pulumi.Input[_builtins.str] s3_prefix: Report path prefix. Limited to 256 characters. May be empty (`""`) but the resource can then not be modified via the AWS Console.
        :param pulumi.Input[_builtins.str] s3_region: Region of the existing S3 bucket to hold generated reports.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] time_unit: The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReportDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Cost and Usage Report Definitions.

        > *NOTE:* The AWS Cost and Usage Report service is only available in `us-east-1` currently.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_cur_report_definition = aws.cur.ReportDefinition("example_cur_report_definition",
            report_name="example-cur-report-definition",
            time_unit="HOURLY",
            format="textORcsv",
            compression="GZIP",
            additional_schema_elements=[
                "RESOURCES",
                "SPLIT_COST_ALLOCATION_DATA",
            ],
            s3_bucket="example-bucket-name",
            s3_prefix="example-cur-report",
            s3_region="us-east-1",
            additional_artifacts=[
                "REDSHIFT",
                "QUICKSIGHT",
            ])
        ```

        ## Import

        Using `pulumi import`, import Report Definitions using the `report_name`. For example:

        ```sh
        $ pulumi import aws:cur/reportDefinition:ReportDefinition example_cur_report_definition example-cur-report-definition
        ```

        :param str resource_name: The name of the resource.
        :param ReportDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReportDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 additional_schema_elements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_closed_reports: Optional[pulumi.Input[_builtins.bool]] = None,
                 report_name: Optional[pulumi.Input[_builtins.str]] = None,
                 report_versioning: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReportDefinitionArgs.__new__(ReportDefinitionArgs)

            __props__.__dict__["additional_artifacts"] = additional_artifacts
            if additional_schema_elements is None and not opts.urn:
                raise TypeError("Missing required property 'additional_schema_elements'")
            __props__.__dict__["additional_schema_elements"] = additional_schema_elements
            if compression is None and not opts.urn:
                raise TypeError("Missing required property 'compression'")
            __props__.__dict__["compression"] = compression
            if format is None and not opts.urn:
                raise TypeError("Missing required property 'format'")
            __props__.__dict__["format"] = format
            __props__.__dict__["refresh_closed_reports"] = refresh_closed_reports
            if report_name is None and not opts.urn:
                raise TypeError("Missing required property 'report_name'")
            __props__.__dict__["report_name"] = report_name
            __props__.__dict__["report_versioning"] = report_versioning
            if s3_bucket is None and not opts.urn:
                raise TypeError("Missing required property 's3_bucket'")
            __props__.__dict__["s3_bucket"] = s3_bucket
            if s3_prefix is None and not opts.urn:
                raise TypeError("Missing required property 's3_prefix'")
            __props__.__dict__["s3_prefix"] = s3_prefix
            if s3_region is None and not opts.urn:
                raise TypeError("Missing required property 's3_region'")
            __props__.__dict__["s3_region"] = s3_region
            __props__.__dict__["tags"] = tags
            if time_unit is None and not opts.urn:
                raise TypeError("Missing required property 'time_unit'")
            __props__.__dict__["time_unit"] = time_unit
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(ReportDefinition, __self__).__init__(
            'aws:cur/reportDefinition:ReportDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            additional_schema_elements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            compression: Optional[pulumi.Input[_builtins.str]] = None,
            format: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_closed_reports: Optional[pulumi.Input[_builtins.bool]] = None,
            report_name: Optional[pulumi.Input[_builtins.str]] = None,
            report_versioning: Optional[pulumi.Input[_builtins.str]] = None,
            s3_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            s3_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            s3_region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_unit: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReportDefinition':
        """
        Get an existing ReportDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_artifacts: A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_schema_elements: A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`, `MANUAL_DISCOUNT_COMPATIBILITY`.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) specifying the cur report.
        :param pulumi.Input[_builtins.str] compression: Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
        :param pulumi.Input[_builtins.str] format: Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
        :param pulumi.Input[_builtins.bool] refresh_closed_reports: Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
        :param pulumi.Input[_builtins.str] report_name: Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
        :param pulumi.Input[_builtins.str] report_versioning: Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
        :param pulumi.Input[_builtins.str] s3_bucket: Name of the existing S3 bucket to hold generated reports.
        :param pulumi.Input[_builtins.str] s3_prefix: Report path prefix. Limited to 256 characters. May be empty (`""`) but the resource can then not be modified via the AWS Console.
        :param pulumi.Input[_builtins.str] s3_region: Region of the existing S3 bucket to hold generated reports.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] time_unit: The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReportDefinitionState.__new__(_ReportDefinitionState)

        __props__.__dict__["additional_artifacts"] = additional_artifacts
        __props__.__dict__["additional_schema_elements"] = additional_schema_elements
        __props__.__dict__["arn"] = arn
        __props__.__dict__["compression"] = compression
        __props__.__dict__["format"] = format
        __props__.__dict__["refresh_closed_reports"] = refresh_closed_reports
        __props__.__dict__["report_name"] = report_name
        __props__.__dict__["report_versioning"] = report_versioning
        __props__.__dict__["s3_bucket"] = s3_bucket
        __props__.__dict__["s3_prefix"] = s3_prefix
        __props__.__dict__["s3_region"] = s3_region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["time_unit"] = time_unit
        return ReportDefinition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalArtifacts")
    def additional_artifacts(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
        """
        return pulumi.get(self, "additional_artifacts")

    @_builtins.property
    @pulumi.getter(name="additionalSchemaElements")
    def additional_schema_elements(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`, `MANUAL_DISCOUNT_COMPATIBILITY`.
        """
        return pulumi.get(self, "additional_schema_elements")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) specifying the cur report.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def compression(self) -> pulumi.Output[_builtins.str]:
        """
        Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
        """
        return pulumi.get(self, "compression")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[_builtins.str]:
        """
        Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="refreshClosedReports")
    def refresh_closed_reports(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
        """
        return pulumi.get(self, "refresh_closed_reports")

    @_builtins.property
    @pulumi.getter(name="reportName")
    def report_name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
        """
        return pulumi.get(self, "report_name")

    @_builtins.property
    @pulumi.getter(name="reportVersioning")
    def report_versioning(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
        """
        return pulumi.get(self, "report_versioning")

    @_builtins.property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the existing S3 bucket to hold generated reports.
        """
        return pulumi.get(self, "s3_bucket")

    @_builtins.property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Report path prefix. Limited to 256 characters. May be empty (`""`) but the resource can then not be modified via the AWS Console.
        """
        return pulumi.get(self, "s3_prefix")

    @_builtins.property
    @pulumi.getter(name="s3Region")
    def s3_region(self) -> pulumi.Output[_builtins.str]:
        """
        Region of the existing S3 bucket to hold generated reports.
        """
        return pulumi.get(self, "s3_region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> pulumi.Output[_builtins.str]:
        """
        The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
        """
        return pulumi.get(self, "time_unit")

