# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DomainMatching',
    'DomainMatchingAutoMerging',
    'DomainMatchingAutoMergingConflictResolution',
    'DomainMatchingAutoMergingConsolidation',
    'DomainMatchingExportingConfig',
    'DomainMatchingExportingConfigS3Exporting',
    'DomainMatchingJobSchedule',
    'DomainRuleBasedMatching',
    'DomainRuleBasedMatchingAttributeTypesSelector',
    'DomainRuleBasedMatchingConflictResolution',
    'DomainRuleBasedMatchingExportingConfig',
    'DomainRuleBasedMatchingExportingConfigS3Exporting',
    'DomainRuleBasedMatchingMatchingRule',
    'ProfileAddress',
    'ProfileBillingAddress',
    'ProfileMailingAddress',
    'ProfileShippingAddress',
]

@pulumi.output_type
class DomainMatching(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoMerging":
            suggest = "auto_merging"
        elif key == "exportingConfig":
            suggest = "exporting_config"
        elif key == "jobSchedule":
            suggest = "job_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMatching. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMatching.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMatching.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 auto_merging: Optional['outputs.DomainMatchingAutoMerging'] = None,
                 exporting_config: Optional['outputs.DomainMatchingExportingConfig'] = None,
                 job_schedule: Optional['outputs.DomainMatchingJobSchedule'] = None):
        """
        :param _builtins.bool enabled: The flag that enables the matching process of duplicate profiles.
        :param 'DomainMatchingAutoMergingArgs' auto_merging: A block that specifies the configuration about the auto-merging process. Documented below.
        :param 'DomainMatchingExportingConfigArgs' exporting_config: A block that specifies the configuration for exporting Identity Resolution results. Documented below.
        :param 'DomainMatchingJobScheduleArgs' job_schedule: A block that specifies the day and time when you want to start the Identity Resolution Job every week. Documented below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if auto_merging is not None:
            pulumi.set(__self__, "auto_merging", auto_merging)
        if exporting_config is not None:
            pulumi.set(__self__, "exporting_config", exporting_config)
        if job_schedule is not None:
            pulumi.set(__self__, "job_schedule", job_schedule)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        The flag that enables the matching process of duplicate profiles.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="autoMerging")
    def auto_merging(self) -> Optional['outputs.DomainMatchingAutoMerging']:
        """
        A block that specifies the configuration about the auto-merging process. Documented below.
        """
        return pulumi.get(self, "auto_merging")

    @_builtins.property
    @pulumi.getter(name="exportingConfig")
    def exporting_config(self) -> Optional['outputs.DomainMatchingExportingConfig']:
        """
        A block that specifies the configuration for exporting Identity Resolution results. Documented below.
        """
        return pulumi.get(self, "exporting_config")

    @_builtins.property
    @pulumi.getter(name="jobSchedule")
    def job_schedule(self) -> Optional['outputs.DomainMatchingJobSchedule']:
        """
        A block that specifies the day and time when you want to start the Identity Resolution Job every week. Documented below.
        """
        return pulumi.get(self, "job_schedule")


@pulumi.output_type
class DomainMatchingAutoMerging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictResolution":
            suggest = "conflict_resolution"
        elif key == "minAllowedConfidenceScoreForMerging":
            suggest = "min_allowed_confidence_score_for_merging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMatchingAutoMerging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMatchingAutoMerging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMatchingAutoMerging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 conflict_resolution: Optional['outputs.DomainMatchingAutoMergingConflictResolution'] = None,
                 consolidation: Optional['outputs.DomainMatchingAutoMergingConsolidation'] = None,
                 min_allowed_confidence_score_for_merging: Optional[_builtins.float] = None):
        """
        :param _builtins.bool enabled: The flag that enables the auto-merging of duplicate profiles.
        :param 'DomainMatchingAutoMergingConflictResolutionArgs' conflict_resolution: A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
        :param 'DomainMatchingAutoMergingConsolidationArgs' consolidation: A block that specifies a list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged. Documented below.
               * `min_allowed_confidence_score_for_merging ` - (Optional) A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
        """
        pulumi.set(__self__, "enabled", enabled)
        if conflict_resolution is not None:
            pulumi.set(__self__, "conflict_resolution", conflict_resolution)
        if consolidation is not None:
            pulumi.set(__self__, "consolidation", consolidation)
        if min_allowed_confidence_score_for_merging is not None:
            pulumi.set(__self__, "min_allowed_confidence_score_for_merging", min_allowed_confidence_score_for_merging)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        The flag that enables the auto-merging of duplicate profiles.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="conflictResolution")
    def conflict_resolution(self) -> Optional['outputs.DomainMatchingAutoMergingConflictResolution']:
        """
        A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
        """
        return pulumi.get(self, "conflict_resolution")

    @_builtins.property
    @pulumi.getter
    def consolidation(self) -> Optional['outputs.DomainMatchingAutoMergingConsolidation']:
        """
        A block that specifies a list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged. Documented below.
        * `min_allowed_confidence_score_for_merging ` - (Optional) A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
        """
        return pulumi.get(self, "consolidation")

    @_builtins.property
    @pulumi.getter(name="minAllowedConfidenceScoreForMerging")
    def min_allowed_confidence_score_for_merging(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "min_allowed_confidence_score_for_merging")


@pulumi.output_type
class DomainMatchingAutoMergingConflictResolution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictResolvingModel":
            suggest = "conflict_resolving_model"
        elif key == "sourceName":
            suggest = "source_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMatchingAutoMergingConflictResolution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMatchingAutoMergingConflictResolution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMatchingAutoMergingConflictResolution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_resolving_model: _builtins.str,
                 source_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str conflict_resolving_model: How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
        :param _builtins.str source_name: The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
        """
        pulumi.set(__self__, "conflict_resolving_model", conflict_resolving_model)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)

    @_builtins.property
    @pulumi.getter(name="conflictResolvingModel")
    def conflict_resolving_model(self) -> _builtins.str:
        """
        How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
        """
        return pulumi.get(self, "conflict_resolving_model")

    @_builtins.property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[_builtins.str]:
        """
        The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
        """
        return pulumi.get(self, "source_name")


@pulumi.output_type
class DomainMatchingAutoMergingConsolidation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchingAttributesLists":
            suggest = "matching_attributes_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMatchingAutoMergingConsolidation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMatchingAutoMergingConsolidation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMatchingAutoMergingConsolidation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 matching_attributes_lists: Sequence[Sequence[_builtins.str]]):
        """
        :param Sequence[Sequence[_builtins.str]] matching_attributes_lists: A list of matching criteria.
        """
        pulumi.set(__self__, "matching_attributes_lists", matching_attributes_lists)

    @_builtins.property
    @pulumi.getter(name="matchingAttributesLists")
    def matching_attributes_lists(self) -> Sequence[Sequence[_builtins.str]]:
        """
        A list of matching criteria.
        """
        return pulumi.get(self, "matching_attributes_lists")


@pulumi.output_type
class DomainMatchingExportingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Exporting":
            suggest = "s3_exporting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMatchingExportingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMatchingExportingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMatchingExportingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_exporting: Optional['outputs.DomainMatchingExportingConfigS3Exporting'] = None):
        if s3_exporting is not None:
            pulumi.set(__self__, "s3_exporting", s3_exporting)

    @_builtins.property
    @pulumi.getter(name="s3Exporting")
    def s3_exporting(self) -> Optional['outputs.DomainMatchingExportingConfigS3Exporting']:
        return pulumi.get(self, "s3_exporting")


@pulumi.output_type
class DomainMatchingExportingConfigS3Exporting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyName":
            suggest = "s3_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMatchingExportingConfigS3Exporting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMatchingExportingConfigS3Exporting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMatchingExportingConfigS3Exporting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: _builtins.str,
                 s3_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str s3_bucket_name: The name of the S3 bucket where Identity Resolution Jobs write result files.
        :param _builtins.str s3_key_name: The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_name is not None:
            pulumi.set(__self__, "s3_key_name", s3_key_name)

    @_builtins.property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> _builtins.str:
        """
        The name of the S3 bucket where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_bucket_name")

    @_builtins.property
    @pulumi.getter(name="s3KeyName")
    def s3_key_name(self) -> Optional[_builtins.str]:
        """
        The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_key_name")


@pulumi.output_type
class DomainMatchingJobSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfTheWeek":
            suggest = "day_of_the_week"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMatchingJobSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMatchingJobSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMatchingJobSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_the_week: _builtins.str,
                 time: _builtins.str):
        """
        :param _builtins.str day_of_the_week: The day when the Identity Resolution Job should run every week.
        :param _builtins.str time: The time when the Identity Resolution Job should run every week.
        """
        pulumi.set(__self__, "day_of_the_week", day_of_the_week)
        pulumi.set(__self__, "time", time)

    @_builtins.property
    @pulumi.getter(name="dayOfTheWeek")
    def day_of_the_week(self) -> _builtins.str:
        """
        The day when the Identity Resolution Job should run every week.
        """
        return pulumi.get(self, "day_of_the_week")

    @_builtins.property
    @pulumi.getter
    def time(self) -> _builtins.str:
        """
        The time when the Identity Resolution Job should run every week.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class DomainRuleBasedMatching(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeTypesSelector":
            suggest = "attribute_types_selector"
        elif key == "conflictResolution":
            suggest = "conflict_resolution"
        elif key == "exportingConfig":
            suggest = "exporting_config"
        elif key == "matchingRules":
            suggest = "matching_rules"
        elif key == "maxAllowedRuleLevelForMatching":
            suggest = "max_allowed_rule_level_for_matching"
        elif key == "maxAllowedRuleLevelForMerging":
            suggest = "max_allowed_rule_level_for_merging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRuleBasedMatching. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRuleBasedMatching.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRuleBasedMatching.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 attribute_types_selector: Optional['outputs.DomainRuleBasedMatchingAttributeTypesSelector'] = None,
                 conflict_resolution: Optional['outputs.DomainRuleBasedMatchingConflictResolution'] = None,
                 exporting_config: Optional['outputs.DomainRuleBasedMatchingExportingConfig'] = None,
                 matching_rules: Optional[Sequence['outputs.DomainRuleBasedMatchingMatchingRule']] = None,
                 max_allowed_rule_level_for_matching: Optional[_builtins.int] = None,
                 max_allowed_rule_level_for_merging: Optional[_builtins.int] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: The flag that enables the rule-based matching process of duplicate profiles.
        :param 'DomainRuleBasedMatchingAttributeTypesSelectorArgs' attribute_types_selector: A block that configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles. Documented below.
        :param 'DomainRuleBasedMatchingConflictResolutionArgs' conflict_resolution: A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
        :param 'DomainRuleBasedMatchingExportingConfigArgs' exporting_config: A block that specifies the configuration for exporting Identity Resolution results. Documented below.
        :param Sequence['DomainRuleBasedMatchingMatchingRuleArgs'] matching_rules: A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
        :param _builtins.int max_allowed_rule_level_for_matching: Indicates the maximum allowed rule level for matching.
        :param _builtins.int max_allowed_rule_level_for_merging: Indicates the maximum allowed rule level for merging.
        """
        pulumi.set(__self__, "enabled", enabled)
        if attribute_types_selector is not None:
            pulumi.set(__self__, "attribute_types_selector", attribute_types_selector)
        if conflict_resolution is not None:
            pulumi.set(__self__, "conflict_resolution", conflict_resolution)
        if exporting_config is not None:
            pulumi.set(__self__, "exporting_config", exporting_config)
        if matching_rules is not None:
            pulumi.set(__self__, "matching_rules", matching_rules)
        if max_allowed_rule_level_for_matching is not None:
            pulumi.set(__self__, "max_allowed_rule_level_for_matching", max_allowed_rule_level_for_matching)
        if max_allowed_rule_level_for_merging is not None:
            pulumi.set(__self__, "max_allowed_rule_level_for_merging", max_allowed_rule_level_for_merging)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        The flag that enables the rule-based matching process of duplicate profiles.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="attributeTypesSelector")
    def attribute_types_selector(self) -> Optional['outputs.DomainRuleBasedMatchingAttributeTypesSelector']:
        """
        A block that configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles. Documented below.
        """
        return pulumi.get(self, "attribute_types_selector")

    @_builtins.property
    @pulumi.getter(name="conflictResolution")
    def conflict_resolution(self) -> Optional['outputs.DomainRuleBasedMatchingConflictResolution']:
        """
        A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
        """
        return pulumi.get(self, "conflict_resolution")

    @_builtins.property
    @pulumi.getter(name="exportingConfig")
    def exporting_config(self) -> Optional['outputs.DomainRuleBasedMatchingExportingConfig']:
        """
        A block that specifies the configuration for exporting Identity Resolution results. Documented below.
        """
        return pulumi.get(self, "exporting_config")

    @_builtins.property
    @pulumi.getter(name="matchingRules")
    def matching_rules(self) -> Optional[Sequence['outputs.DomainRuleBasedMatchingMatchingRule']]:
        """
        A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
        """
        return pulumi.get(self, "matching_rules")

    @_builtins.property
    @pulumi.getter(name="maxAllowedRuleLevelForMatching")
    def max_allowed_rule_level_for_matching(self) -> Optional[_builtins.int]:
        """
        Indicates the maximum allowed rule level for matching.
        """
        return pulumi.get(self, "max_allowed_rule_level_for_matching")

    @_builtins.property
    @pulumi.getter(name="maxAllowedRuleLevelForMerging")
    def max_allowed_rule_level_for_merging(self) -> Optional[_builtins.int]:
        """
        Indicates the maximum allowed rule level for merging.
        """
        return pulumi.get(self, "max_allowed_rule_level_for_merging")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class DomainRuleBasedMatchingAttributeTypesSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeMatchingModel":
            suggest = "attribute_matching_model"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "phoneNumbers":
            suggest = "phone_numbers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRuleBasedMatchingAttributeTypesSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRuleBasedMatchingAttributeTypesSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRuleBasedMatchingAttributeTypesSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_matching_model: _builtins.str,
                 addresses: Optional[Sequence[_builtins.str]] = None,
                 email_addresses: Optional[Sequence[_builtins.str]] = None,
                 phone_numbers: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str attribute_matching_model: Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
        :param Sequence[_builtins.str] addresses: The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
        :param Sequence[_builtins.str] email_addresses: The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
        :param Sequence[_builtins.str] phone_numbers: The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
        """
        pulumi.set(__self__, "attribute_matching_model", attribute_matching_model)
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if phone_numbers is not None:
            pulumi.set(__self__, "phone_numbers", phone_numbers)

    @_builtins.property
    @pulumi.getter(name="attributeMatchingModel")
    def attribute_matching_model(self) -> _builtins.str:
        """
        Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
        """
        return pulumi.get(self, "attribute_matching_model")

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
        """
        return pulumi.get(self, "email_addresses")

    @_builtins.property
    @pulumi.getter(name="phoneNumbers")
    def phone_numbers(self) -> Optional[Sequence[_builtins.str]]:
        """
        The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
        """
        return pulumi.get(self, "phone_numbers")


@pulumi.output_type
class DomainRuleBasedMatchingConflictResolution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictResolvingModel":
            suggest = "conflict_resolving_model"
        elif key == "sourceName":
            suggest = "source_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRuleBasedMatchingConflictResolution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRuleBasedMatchingConflictResolution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRuleBasedMatchingConflictResolution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_resolving_model: _builtins.str,
                 source_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str conflict_resolving_model: How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
        :param _builtins.str source_name: The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
        """
        pulumi.set(__self__, "conflict_resolving_model", conflict_resolving_model)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)

    @_builtins.property
    @pulumi.getter(name="conflictResolvingModel")
    def conflict_resolving_model(self) -> _builtins.str:
        """
        How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
        """
        return pulumi.get(self, "conflict_resolving_model")

    @_builtins.property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[_builtins.str]:
        """
        The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
        """
        return pulumi.get(self, "source_name")


@pulumi.output_type
class DomainRuleBasedMatchingExportingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Exporting":
            suggest = "s3_exporting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRuleBasedMatchingExportingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRuleBasedMatchingExportingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRuleBasedMatchingExportingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_exporting: Optional['outputs.DomainRuleBasedMatchingExportingConfigS3Exporting'] = None):
        if s3_exporting is not None:
            pulumi.set(__self__, "s3_exporting", s3_exporting)

    @_builtins.property
    @pulumi.getter(name="s3Exporting")
    def s3_exporting(self) -> Optional['outputs.DomainRuleBasedMatchingExportingConfigS3Exporting']:
        return pulumi.get(self, "s3_exporting")


@pulumi.output_type
class DomainRuleBasedMatchingExportingConfigS3Exporting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyName":
            suggest = "s3_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRuleBasedMatchingExportingConfigS3Exporting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRuleBasedMatchingExportingConfigS3Exporting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRuleBasedMatchingExportingConfigS3Exporting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: _builtins.str,
                 s3_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str s3_bucket_name: The name of the S3 bucket where Identity Resolution Jobs write result files.
        :param _builtins.str s3_key_name: The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_name is not None:
            pulumi.set(__self__, "s3_key_name", s3_key_name)

    @_builtins.property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> _builtins.str:
        """
        The name of the S3 bucket where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_bucket_name")

    @_builtins.property
    @pulumi.getter(name="s3KeyName")
    def s3_key_name(self) -> Optional[_builtins.str]:
        """
        The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_key_name")


@pulumi.output_type
class DomainRuleBasedMatchingMatchingRule(dict):
    def __init__(__self__, *,
                 rules: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] rules: A single rule level of the `match_rules`. Configures how the rule-based matching process should match profiles.
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence[_builtins.str]:
        """
        A single rule level of the `match_rules`. Configures how the rule-based matching process should match profiles.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ProfileAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postalCode":
            suggest = "postal_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address1: Optional[_builtins.str] = None,
                 address2: Optional[_builtins.str] = None,
                 address3: Optional[_builtins.str] = None,
                 address4: Optional[_builtins.str] = None,
                 city: Optional[_builtins.str] = None,
                 country: Optional[_builtins.str] = None,
                 county: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 province: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str address1: The first line of a customer address.
        :param _builtins.str address2: The second line of a customer address.
        :param _builtins.str address3: The third line of a customer address.
        :param _builtins.str address4: The fourth line of a customer address.
        :param _builtins.str city: The city in which a customer lives.
        :param _builtins.str country: The country in which a customer lives.
        :param _builtins.str county: The county in which a customer lives.
        :param _builtins.str postal_code: The postal code of a customer address.
        :param _builtins.str province: The province in which a customer lives.
        :param _builtins.str state: The state in which a customer lives.
        """
        if address1 is not None:
            pulumi.set(__self__, "address1", address1)
        if address2 is not None:
            pulumi.set(__self__, "address2", address2)
        if address3 is not None:
            pulumi.set(__self__, "address3", address3)
        if address4 is not None:
            pulumi.set(__self__, "address4", address4)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def address1(self) -> Optional[_builtins.str]:
        """
        The first line of a customer address.
        """
        return pulumi.get(self, "address1")

    @_builtins.property
    @pulumi.getter
    def address2(self) -> Optional[_builtins.str]:
        """
        The second line of a customer address.
        """
        return pulumi.get(self, "address2")

    @_builtins.property
    @pulumi.getter
    def address3(self) -> Optional[_builtins.str]:
        """
        The third line of a customer address.
        """
        return pulumi.get(self, "address3")

    @_builtins.property
    @pulumi.getter
    def address4(self) -> Optional[_builtins.str]:
        """
        The fourth line of a customer address.
        """
        return pulumi.get(self, "address4")

    @_builtins.property
    @pulumi.getter
    def city(self) -> Optional[_builtins.str]:
        """
        The city in which a customer lives.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[_builtins.str]:
        """
        The country in which a customer lives.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def county(self) -> Optional[_builtins.str]:
        """
        The county in which a customer lives.
        """
        return pulumi.get(self, "county")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        The postal code of a customer address.
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[_builtins.str]:
        """
        The province in which a customer lives.
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state in which a customer lives.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ProfileBillingAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postalCode":
            suggest = "postal_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileBillingAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileBillingAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileBillingAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address1: Optional[_builtins.str] = None,
                 address2: Optional[_builtins.str] = None,
                 address3: Optional[_builtins.str] = None,
                 address4: Optional[_builtins.str] = None,
                 city: Optional[_builtins.str] = None,
                 country: Optional[_builtins.str] = None,
                 county: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 province: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str address1: The first line of a customer address.
        :param _builtins.str address2: The second line of a customer address.
        :param _builtins.str address3: The third line of a customer address.
        :param _builtins.str address4: The fourth line of a customer address.
        :param _builtins.str city: The city in which a customer lives.
        :param _builtins.str country: The country in which a customer lives.
        :param _builtins.str county: The county in which a customer lives.
        :param _builtins.str postal_code: The postal code of a customer address.
        :param _builtins.str province: The province in which a customer lives.
        :param _builtins.str state: The state in which a customer lives.
        """
        if address1 is not None:
            pulumi.set(__self__, "address1", address1)
        if address2 is not None:
            pulumi.set(__self__, "address2", address2)
        if address3 is not None:
            pulumi.set(__self__, "address3", address3)
        if address4 is not None:
            pulumi.set(__self__, "address4", address4)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def address1(self) -> Optional[_builtins.str]:
        """
        The first line of a customer address.
        """
        return pulumi.get(self, "address1")

    @_builtins.property
    @pulumi.getter
    def address2(self) -> Optional[_builtins.str]:
        """
        The second line of a customer address.
        """
        return pulumi.get(self, "address2")

    @_builtins.property
    @pulumi.getter
    def address3(self) -> Optional[_builtins.str]:
        """
        The third line of a customer address.
        """
        return pulumi.get(self, "address3")

    @_builtins.property
    @pulumi.getter
    def address4(self) -> Optional[_builtins.str]:
        """
        The fourth line of a customer address.
        """
        return pulumi.get(self, "address4")

    @_builtins.property
    @pulumi.getter
    def city(self) -> Optional[_builtins.str]:
        """
        The city in which a customer lives.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[_builtins.str]:
        """
        The country in which a customer lives.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def county(self) -> Optional[_builtins.str]:
        """
        The county in which a customer lives.
        """
        return pulumi.get(self, "county")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        The postal code of a customer address.
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[_builtins.str]:
        """
        The province in which a customer lives.
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state in which a customer lives.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ProfileMailingAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postalCode":
            suggest = "postal_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileMailingAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileMailingAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileMailingAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address1: Optional[_builtins.str] = None,
                 address2: Optional[_builtins.str] = None,
                 address3: Optional[_builtins.str] = None,
                 address4: Optional[_builtins.str] = None,
                 city: Optional[_builtins.str] = None,
                 country: Optional[_builtins.str] = None,
                 county: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 province: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str address1: The first line of a customer address.
        :param _builtins.str address2: The second line of a customer address.
        :param _builtins.str address3: The third line of a customer address.
        :param _builtins.str address4: The fourth line of a customer address.
        :param _builtins.str city: The city in which a customer lives.
        :param _builtins.str country: The country in which a customer lives.
        :param _builtins.str county: The county in which a customer lives.
        :param _builtins.str postal_code: The postal code of a customer address.
        :param _builtins.str province: The province in which a customer lives.
        :param _builtins.str state: The state in which a customer lives.
        """
        if address1 is not None:
            pulumi.set(__self__, "address1", address1)
        if address2 is not None:
            pulumi.set(__self__, "address2", address2)
        if address3 is not None:
            pulumi.set(__self__, "address3", address3)
        if address4 is not None:
            pulumi.set(__self__, "address4", address4)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def address1(self) -> Optional[_builtins.str]:
        """
        The first line of a customer address.
        """
        return pulumi.get(self, "address1")

    @_builtins.property
    @pulumi.getter
    def address2(self) -> Optional[_builtins.str]:
        """
        The second line of a customer address.
        """
        return pulumi.get(self, "address2")

    @_builtins.property
    @pulumi.getter
    def address3(self) -> Optional[_builtins.str]:
        """
        The third line of a customer address.
        """
        return pulumi.get(self, "address3")

    @_builtins.property
    @pulumi.getter
    def address4(self) -> Optional[_builtins.str]:
        """
        The fourth line of a customer address.
        """
        return pulumi.get(self, "address4")

    @_builtins.property
    @pulumi.getter
    def city(self) -> Optional[_builtins.str]:
        """
        The city in which a customer lives.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[_builtins.str]:
        """
        The country in which a customer lives.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def county(self) -> Optional[_builtins.str]:
        """
        The county in which a customer lives.
        """
        return pulumi.get(self, "county")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        The postal code of a customer address.
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[_builtins.str]:
        """
        The province in which a customer lives.
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state in which a customer lives.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ProfileShippingAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postalCode":
            suggest = "postal_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileShippingAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileShippingAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileShippingAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address1: Optional[_builtins.str] = None,
                 address2: Optional[_builtins.str] = None,
                 address3: Optional[_builtins.str] = None,
                 address4: Optional[_builtins.str] = None,
                 city: Optional[_builtins.str] = None,
                 country: Optional[_builtins.str] = None,
                 county: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 province: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str address1: The first line of a customer address.
        :param _builtins.str address2: The second line of a customer address.
        :param _builtins.str address3: The third line of a customer address.
        :param _builtins.str address4: The fourth line of a customer address.
        :param _builtins.str city: The city in which a customer lives.
        :param _builtins.str country: The country in which a customer lives.
        :param _builtins.str county: The county in which a customer lives.
        :param _builtins.str postal_code: The postal code of a customer address.
        :param _builtins.str province: The province in which a customer lives.
        :param _builtins.str state: The state in which a customer lives.
        """
        if address1 is not None:
            pulumi.set(__self__, "address1", address1)
        if address2 is not None:
            pulumi.set(__self__, "address2", address2)
        if address3 is not None:
            pulumi.set(__self__, "address3", address3)
        if address4 is not None:
            pulumi.set(__self__, "address4", address4)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def address1(self) -> Optional[_builtins.str]:
        """
        The first line of a customer address.
        """
        return pulumi.get(self, "address1")

    @_builtins.property
    @pulumi.getter
    def address2(self) -> Optional[_builtins.str]:
        """
        The second line of a customer address.
        """
        return pulumi.get(self, "address2")

    @_builtins.property
    @pulumi.getter
    def address3(self) -> Optional[_builtins.str]:
        """
        The third line of a customer address.
        """
        return pulumi.get(self, "address3")

    @_builtins.property
    @pulumi.getter
    def address4(self) -> Optional[_builtins.str]:
        """
        The fourth line of a customer address.
        """
        return pulumi.get(self, "address4")

    @_builtins.property
    @pulumi.getter
    def city(self) -> Optional[_builtins.str]:
        """
        The city in which a customer lives.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[_builtins.str]:
        """
        The country in which a customer lives.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def county(self) -> Optional[_builtins.str]:
        """
        The county in which a customer lives.
        """
        return pulumi.get(self, "county")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        The postal code of a customer address.
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[_builtins.str]:
        """
        The province in which a customer lives.
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state in which a customer lives.
        """
        return pulumi.get(self, "state")


