# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProfileArgs', 'Profile']

@pulumi.input_type
class ProfileArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[_builtins.str],
                 account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_information: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input['ProfileAddressArgs']] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 billing_address: Optional[pulumi.Input['ProfileBillingAddressArgs']] = None,
                 birth_date: Optional[pulumi.Input[_builtins.str]] = None,
                 business_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 business_name: Optional[pulumi.Input[_builtins.str]] = None,
                 business_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gender_string: Optional[pulumi.Input[_builtins.str]] = None,
                 home_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mailing_address: Optional[pulumi.Input['ProfileMailingAddressArgs']] = None,
                 middle_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 party_type_string: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shipping_address: Optional[pulumi.Input['ProfileShippingAddressArgs']] = None):
        """
        The set of arguments for constructing a Profile resource.
        :param pulumi.Input[_builtins.str] domain_name: The name of your Customer Profile domain. It must be unique for your AWS account.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] account_number: A unique account number that you have given to the customer.
        :param pulumi.Input[_builtins.str] additional_information: Any additional information relevant to the customer’s profile.
        :param pulumi.Input['ProfileAddressArgs'] address: A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attributes: A key value pair of attributes of a customer profile.
        :param pulumi.Input['ProfileBillingAddressArgs'] billing_address: A block that specifies the customer’s billing address. Documented below.
        :param pulumi.Input[_builtins.str] birth_date: The customer’s birth date.
        :param pulumi.Input[_builtins.str] business_email_address: The customer’s business email address.
        :param pulumi.Input[_builtins.str] business_name: The name of the customer’s business.
        :param pulumi.Input[_builtins.str] business_phone_number: The customer’s business phone number.
        :param pulumi.Input[_builtins.str] email_address: The customer’s email address, which has not been specified as a personal or business address.
        :param pulumi.Input[_builtins.str] first_name: The customer’s first name.
        :param pulumi.Input[_builtins.str] gender_string: The gender with which the customer identifies.
        :param pulumi.Input[_builtins.str] home_phone_number: The customer’s home phone number.
        :param pulumi.Input[_builtins.str] last_name: The customer’s last name.
        :param pulumi.Input['ProfileMailingAddressArgs'] mailing_address: A block that specifies the customer’s mailing address. Documented below.
        :param pulumi.Input[_builtins.str] middle_name: The customer’s middle name.
        :param pulumi.Input[_builtins.str] mobile_phone_number: The customer’s mobile phone number.
        :param pulumi.Input[_builtins.str] party_type_string: The type of profile used to describe the customer.
        :param pulumi.Input[_builtins.str] personal_email_address: The customer’s personal email address.
        :param pulumi.Input[_builtins.str] phone_number: The customer’s phone number, which has not been specified as a mobile, home, or business number.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ProfileShippingAddressArgs'] shipping_address: A block that specifies the customer’s shipping address. Documented below.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if additional_information is not None:
            pulumi.set(__self__, "additional_information", additional_information)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if billing_address is not None:
            pulumi.set(__self__, "billing_address", billing_address)
        if birth_date is not None:
            pulumi.set(__self__, "birth_date", birth_date)
        if business_email_address is not None:
            pulumi.set(__self__, "business_email_address", business_email_address)
        if business_name is not None:
            pulumi.set(__self__, "business_name", business_name)
        if business_phone_number is not None:
            pulumi.set(__self__, "business_phone_number", business_phone_number)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if gender_string is not None:
            pulumi.set(__self__, "gender_string", gender_string)
        if home_phone_number is not None:
            pulumi.set(__self__, "home_phone_number", home_phone_number)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if mailing_address is not None:
            pulumi.set(__self__, "mailing_address", mailing_address)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if mobile_phone_number is not None:
            pulumi.set(__self__, "mobile_phone_number", mobile_phone_number)
        if party_type_string is not None:
            pulumi.set(__self__, "party_type_string", party_type_string)
        if personal_email_address is not None:
            pulumi.set(__self__, "personal_email_address", personal_email_address)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shipping_address is not None:
            pulumi.set(__self__, "shipping_address", shipping_address)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of your Customer Profile domain. It must be unique for your AWS account.

        The following arguments are optional:
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique account number that you have given to the customer.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_number", value)

    @_builtins.property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any additional information relevant to the customer’s profile.
        """
        return pulumi.get(self, "additional_information")

    @additional_information.setter
    def additional_information(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "additional_information", value)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input['ProfileAddressArgs']]:
        """
        A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input['ProfileAddressArgs']]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A key value pair of attributes of a customer profile.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="billingAddress")
    def billing_address(self) -> Optional[pulumi.Input['ProfileBillingAddressArgs']]:
        """
        A block that specifies the customer’s billing address. Documented below.
        """
        return pulumi.get(self, "billing_address")

    @billing_address.setter
    def billing_address(self, value: Optional[pulumi.Input['ProfileBillingAddressArgs']]):
        pulumi.set(self, "billing_address", value)

    @_builtins.property
    @pulumi.getter(name="birthDate")
    def birth_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s birth date.
        """
        return pulumi.get(self, "birth_date")

    @birth_date.setter
    def birth_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "birth_date", value)

    @_builtins.property
    @pulumi.getter(name="businessEmailAddress")
    def business_email_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s business email address.
        """
        return pulumi.get(self, "business_email_address")

    @business_email_address.setter
    def business_email_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_email_address", value)

    @_builtins.property
    @pulumi.getter(name="businessName")
    def business_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the customer’s business.
        """
        return pulumi.get(self, "business_name")

    @business_name.setter
    def business_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_name", value)

    @_builtins.property
    @pulumi.getter(name="businessPhoneNumber")
    def business_phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s business phone number.
        """
        return pulumi.get(self, "business_phone_number")

    @business_phone_number.setter
    def business_phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_phone_number", value)

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s email address, which has not been specified as a personal or business address.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_address", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s first name.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="genderString")
    def gender_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The gender with which the customer identifies.
        """
        return pulumi.get(self, "gender_string")

    @gender_string.setter
    def gender_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gender_string", value)

    @_builtins.property
    @pulumi.getter(name="homePhoneNumber")
    def home_phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s home phone number.
        """
        return pulumi.get(self, "home_phone_number")

    @home_phone_number.setter
    def home_phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_phone_number", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s last name.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter(name="mailingAddress")
    def mailing_address(self) -> Optional[pulumi.Input['ProfileMailingAddressArgs']]:
        """
        A block that specifies the customer’s mailing address. Documented below.
        """
        return pulumi.get(self, "mailing_address")

    @mailing_address.setter
    def mailing_address(self, value: Optional[pulumi.Input['ProfileMailingAddressArgs']]):
        pulumi.set(self, "mailing_address", value)

    @_builtins.property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s middle name.
        """
        return pulumi.get(self, "middle_name")

    @middle_name.setter
    def middle_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "middle_name", value)

    @_builtins.property
    @pulumi.getter(name="mobilePhoneNumber")
    def mobile_phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s mobile phone number.
        """
        return pulumi.get(self, "mobile_phone_number")

    @mobile_phone_number.setter
    def mobile_phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile_phone_number", value)

    @_builtins.property
    @pulumi.getter(name="partyTypeString")
    def party_type_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of profile used to describe the customer.
        """
        return pulumi.get(self, "party_type_string")

    @party_type_string.setter
    def party_type_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "party_type_string", value)

    @_builtins.property
    @pulumi.getter(name="personalEmailAddress")
    def personal_email_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s personal email address.
        """
        return pulumi.get(self, "personal_email_address")

    @personal_email_address.setter
    def personal_email_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "personal_email_address", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s phone number, which has not been specified as a mobile, home, or business number.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> Optional[pulumi.Input['ProfileShippingAddressArgs']]:
        """
        A block that specifies the customer’s shipping address. Documented below.
        """
        return pulumi.get(self, "shipping_address")

    @shipping_address.setter
    def shipping_address(self, value: Optional[pulumi.Input['ProfileShippingAddressArgs']]):
        pulumi.set(self, "shipping_address", value)


@pulumi.input_type
class _ProfileState:
    def __init__(__self__, *,
                 account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_information: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input['ProfileAddressArgs']] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 billing_address: Optional[pulumi.Input['ProfileBillingAddressArgs']] = None,
                 birth_date: Optional[pulumi.Input[_builtins.str]] = None,
                 business_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 business_name: Optional[pulumi.Input[_builtins.str]] = None,
                 business_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gender_string: Optional[pulumi.Input[_builtins.str]] = None,
                 home_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mailing_address: Optional[pulumi.Input['ProfileMailingAddressArgs']] = None,
                 middle_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 party_type_string: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shipping_address: Optional[pulumi.Input['ProfileShippingAddressArgs']] = None):
        """
        Input properties used for looking up and filtering Profile resources.
        :param pulumi.Input[_builtins.str] account_number: A unique account number that you have given to the customer.
        :param pulumi.Input[_builtins.str] additional_information: Any additional information relevant to the customer’s profile.
        :param pulumi.Input['ProfileAddressArgs'] address: A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attributes: A key value pair of attributes of a customer profile.
        :param pulumi.Input['ProfileBillingAddressArgs'] billing_address: A block that specifies the customer’s billing address. Documented below.
        :param pulumi.Input[_builtins.str] birth_date: The customer’s birth date.
        :param pulumi.Input[_builtins.str] business_email_address: The customer’s business email address.
        :param pulumi.Input[_builtins.str] business_name: The name of the customer’s business.
        :param pulumi.Input[_builtins.str] business_phone_number: The customer’s business phone number.
        :param pulumi.Input[_builtins.str] domain_name: The name of your Customer Profile domain. It must be unique for your AWS account.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] email_address: The customer’s email address, which has not been specified as a personal or business address.
        :param pulumi.Input[_builtins.str] first_name: The customer’s first name.
        :param pulumi.Input[_builtins.str] gender_string: The gender with which the customer identifies.
        :param pulumi.Input[_builtins.str] home_phone_number: The customer’s home phone number.
        :param pulumi.Input[_builtins.str] last_name: The customer’s last name.
        :param pulumi.Input['ProfileMailingAddressArgs'] mailing_address: A block that specifies the customer’s mailing address. Documented below.
        :param pulumi.Input[_builtins.str] middle_name: The customer’s middle name.
        :param pulumi.Input[_builtins.str] mobile_phone_number: The customer’s mobile phone number.
        :param pulumi.Input[_builtins.str] party_type_string: The type of profile used to describe the customer.
        :param pulumi.Input[_builtins.str] personal_email_address: The customer’s personal email address.
        :param pulumi.Input[_builtins.str] phone_number: The customer’s phone number, which has not been specified as a mobile, home, or business number.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ProfileShippingAddressArgs'] shipping_address: A block that specifies the customer’s shipping address. Documented below.
        """
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if additional_information is not None:
            pulumi.set(__self__, "additional_information", additional_information)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if billing_address is not None:
            pulumi.set(__self__, "billing_address", billing_address)
        if birth_date is not None:
            pulumi.set(__self__, "birth_date", birth_date)
        if business_email_address is not None:
            pulumi.set(__self__, "business_email_address", business_email_address)
        if business_name is not None:
            pulumi.set(__self__, "business_name", business_name)
        if business_phone_number is not None:
            pulumi.set(__self__, "business_phone_number", business_phone_number)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if gender_string is not None:
            pulumi.set(__self__, "gender_string", gender_string)
        if home_phone_number is not None:
            pulumi.set(__self__, "home_phone_number", home_phone_number)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if mailing_address is not None:
            pulumi.set(__self__, "mailing_address", mailing_address)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if mobile_phone_number is not None:
            pulumi.set(__self__, "mobile_phone_number", mobile_phone_number)
        if party_type_string is not None:
            pulumi.set(__self__, "party_type_string", party_type_string)
        if personal_email_address is not None:
            pulumi.set(__self__, "personal_email_address", personal_email_address)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shipping_address is not None:
            pulumi.set(__self__, "shipping_address", shipping_address)

    @_builtins.property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique account number that you have given to the customer.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_number", value)

    @_builtins.property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any additional information relevant to the customer’s profile.
        """
        return pulumi.get(self, "additional_information")

    @additional_information.setter
    def additional_information(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "additional_information", value)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input['ProfileAddressArgs']]:
        """
        A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input['ProfileAddressArgs']]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A key value pair of attributes of a customer profile.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="billingAddress")
    def billing_address(self) -> Optional[pulumi.Input['ProfileBillingAddressArgs']]:
        """
        A block that specifies the customer’s billing address. Documented below.
        """
        return pulumi.get(self, "billing_address")

    @billing_address.setter
    def billing_address(self, value: Optional[pulumi.Input['ProfileBillingAddressArgs']]):
        pulumi.set(self, "billing_address", value)

    @_builtins.property
    @pulumi.getter(name="birthDate")
    def birth_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s birth date.
        """
        return pulumi.get(self, "birth_date")

    @birth_date.setter
    def birth_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "birth_date", value)

    @_builtins.property
    @pulumi.getter(name="businessEmailAddress")
    def business_email_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s business email address.
        """
        return pulumi.get(self, "business_email_address")

    @business_email_address.setter
    def business_email_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_email_address", value)

    @_builtins.property
    @pulumi.getter(name="businessName")
    def business_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the customer’s business.
        """
        return pulumi.get(self, "business_name")

    @business_name.setter
    def business_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_name", value)

    @_builtins.property
    @pulumi.getter(name="businessPhoneNumber")
    def business_phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s business phone number.
        """
        return pulumi.get(self, "business_phone_number")

    @business_phone_number.setter
    def business_phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_phone_number", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of your Customer Profile domain. It must be unique for your AWS account.

        The following arguments are optional:
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s email address, which has not been specified as a personal or business address.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_address", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s first name.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="genderString")
    def gender_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The gender with which the customer identifies.
        """
        return pulumi.get(self, "gender_string")

    @gender_string.setter
    def gender_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gender_string", value)

    @_builtins.property
    @pulumi.getter(name="homePhoneNumber")
    def home_phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s home phone number.
        """
        return pulumi.get(self, "home_phone_number")

    @home_phone_number.setter
    def home_phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_phone_number", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s last name.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter(name="mailingAddress")
    def mailing_address(self) -> Optional[pulumi.Input['ProfileMailingAddressArgs']]:
        """
        A block that specifies the customer’s mailing address. Documented below.
        """
        return pulumi.get(self, "mailing_address")

    @mailing_address.setter
    def mailing_address(self, value: Optional[pulumi.Input['ProfileMailingAddressArgs']]):
        pulumi.set(self, "mailing_address", value)

    @_builtins.property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s middle name.
        """
        return pulumi.get(self, "middle_name")

    @middle_name.setter
    def middle_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "middle_name", value)

    @_builtins.property
    @pulumi.getter(name="mobilePhoneNumber")
    def mobile_phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s mobile phone number.
        """
        return pulumi.get(self, "mobile_phone_number")

    @mobile_phone_number.setter
    def mobile_phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile_phone_number", value)

    @_builtins.property
    @pulumi.getter(name="partyTypeString")
    def party_type_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of profile used to describe the customer.
        """
        return pulumi.get(self, "party_type_string")

    @party_type_string.setter
    def party_type_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "party_type_string", value)

    @_builtins.property
    @pulumi.getter(name="personalEmailAddress")
    def personal_email_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s personal email address.
        """
        return pulumi.get(self, "personal_email_address")

    @personal_email_address.setter
    def personal_email_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "personal_email_address", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer’s phone number, which has not been specified as a mobile, home, or business number.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> Optional[pulumi.Input['ProfileShippingAddressArgs']]:
        """
        A block that specifies the customer’s shipping address. Documented below.
        """
        return pulumi.get(self, "shipping_address")

    @shipping_address.setter
    def shipping_address(self, value: Optional[pulumi.Input['ProfileShippingAddressArgs']]):
        pulumi.set(self, "shipping_address", value)


@pulumi.type_token("aws:customerprofiles/profile:Profile")
class Profile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_information: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input[Union['ProfileAddressArgs', 'ProfileAddressArgsDict']]] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 billing_address: Optional[pulumi.Input[Union['ProfileBillingAddressArgs', 'ProfileBillingAddressArgsDict']]] = None,
                 birth_date: Optional[pulumi.Input[_builtins.str]] = None,
                 business_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 business_name: Optional[pulumi.Input[_builtins.str]] = None,
                 business_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gender_string: Optional[pulumi.Input[_builtins.str]] = None,
                 home_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mailing_address: Optional[pulumi.Input[Union['ProfileMailingAddressArgs', 'ProfileMailingAddressArgsDict']]] = None,
                 middle_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 party_type_string: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shipping_address: Optional[pulumi.Input[Union['ProfileShippingAddressArgs', 'ProfileShippingAddressArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon Customer Profiles Profile.
        See the [Create Profile](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateProfile.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.customerprofiles.Domain("example", domain_name="example")
        example_profile = aws.customerprofiles.Profile("example", domain_name=example.domain_name)
        ```

        ## Import

        Using `pulumi import`, import Amazon Customer Profiles Profile using the resource `id`. For example:

        ```sh
        $ pulumi import aws:customerprofiles/profile:Profile example domain-name/5f2f473dfbe841eb8d05cfc2a4c926df
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_number: A unique account number that you have given to the customer.
        :param pulumi.Input[_builtins.str] additional_information: Any additional information relevant to the customer’s profile.
        :param pulumi.Input[Union['ProfileAddressArgs', 'ProfileAddressArgsDict']] address: A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attributes: A key value pair of attributes of a customer profile.
        :param pulumi.Input[Union['ProfileBillingAddressArgs', 'ProfileBillingAddressArgsDict']] billing_address: A block that specifies the customer’s billing address. Documented below.
        :param pulumi.Input[_builtins.str] birth_date: The customer’s birth date.
        :param pulumi.Input[_builtins.str] business_email_address: The customer’s business email address.
        :param pulumi.Input[_builtins.str] business_name: The name of the customer’s business.
        :param pulumi.Input[_builtins.str] business_phone_number: The customer’s business phone number.
        :param pulumi.Input[_builtins.str] domain_name: The name of your Customer Profile domain. It must be unique for your AWS account.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] email_address: The customer’s email address, which has not been specified as a personal or business address.
        :param pulumi.Input[_builtins.str] first_name: The customer’s first name.
        :param pulumi.Input[_builtins.str] gender_string: The gender with which the customer identifies.
        :param pulumi.Input[_builtins.str] home_phone_number: The customer’s home phone number.
        :param pulumi.Input[_builtins.str] last_name: The customer’s last name.
        :param pulumi.Input[Union['ProfileMailingAddressArgs', 'ProfileMailingAddressArgsDict']] mailing_address: A block that specifies the customer’s mailing address. Documented below.
        :param pulumi.Input[_builtins.str] middle_name: The customer’s middle name.
        :param pulumi.Input[_builtins.str] mobile_phone_number: The customer’s mobile phone number.
        :param pulumi.Input[_builtins.str] party_type_string: The type of profile used to describe the customer.
        :param pulumi.Input[_builtins.str] personal_email_address: The customer’s personal email address.
        :param pulumi.Input[_builtins.str] phone_number: The customer’s phone number, which has not been specified as a mobile, home, or business number.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ProfileShippingAddressArgs', 'ProfileShippingAddressArgsDict']] shipping_address: A block that specifies the customer’s shipping address. Documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon Customer Profiles Profile.
        See the [Create Profile](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateProfile.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.customerprofiles.Domain("example", domain_name="example")
        example_profile = aws.customerprofiles.Profile("example", domain_name=example.domain_name)
        ```

        ## Import

        Using `pulumi import`, import Amazon Customer Profiles Profile using the resource `id`. For example:

        ```sh
        $ pulumi import aws:customerprofiles/profile:Profile example domain-name/5f2f473dfbe841eb8d05cfc2a4c926df
        ```

        :param str resource_name: The name of the resource.
        :param ProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_information: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input[Union['ProfileAddressArgs', 'ProfileAddressArgsDict']]] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 billing_address: Optional[pulumi.Input[Union['ProfileBillingAddressArgs', 'ProfileBillingAddressArgsDict']]] = None,
                 birth_date: Optional[pulumi.Input[_builtins.str]] = None,
                 business_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 business_name: Optional[pulumi.Input[_builtins.str]] = None,
                 business_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gender_string: Optional[pulumi.Input[_builtins.str]] = None,
                 home_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mailing_address: Optional[pulumi.Input[Union['ProfileMailingAddressArgs', 'ProfileMailingAddressArgsDict']]] = None,
                 middle_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 party_type_string: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shipping_address: Optional[pulumi.Input[Union['ProfileShippingAddressArgs', 'ProfileShippingAddressArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileArgs.__new__(ProfileArgs)

            __props__.__dict__["account_number"] = account_number
            __props__.__dict__["additional_information"] = additional_information
            __props__.__dict__["address"] = address
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["billing_address"] = billing_address
            __props__.__dict__["birth_date"] = birth_date
            __props__.__dict__["business_email_address"] = business_email_address
            __props__.__dict__["business_name"] = business_name
            __props__.__dict__["business_phone_number"] = business_phone_number
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["email_address"] = email_address
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["gender_string"] = gender_string
            __props__.__dict__["home_phone_number"] = home_phone_number
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["mailing_address"] = mailing_address
            __props__.__dict__["middle_name"] = middle_name
            __props__.__dict__["mobile_phone_number"] = mobile_phone_number
            __props__.__dict__["party_type_string"] = party_type_string
            __props__.__dict__["personal_email_address"] = personal_email_address
            __props__.__dict__["phone_number"] = phone_number
            __props__.__dict__["region"] = region
            __props__.__dict__["shipping_address"] = shipping_address
        super(Profile, __self__).__init__(
            'aws:customerprofiles/profile:Profile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_number: Optional[pulumi.Input[_builtins.str]] = None,
            additional_information: Optional[pulumi.Input[_builtins.str]] = None,
            address: Optional[pulumi.Input[Union['ProfileAddressArgs', 'ProfileAddressArgsDict']]] = None,
            attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            billing_address: Optional[pulumi.Input[Union['ProfileBillingAddressArgs', 'ProfileBillingAddressArgsDict']]] = None,
            birth_date: Optional[pulumi.Input[_builtins.str]] = None,
            business_email_address: Optional[pulumi.Input[_builtins.str]] = None,
            business_name: Optional[pulumi.Input[_builtins.str]] = None,
            business_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            email_address: Optional[pulumi.Input[_builtins.str]] = None,
            first_name: Optional[pulumi.Input[_builtins.str]] = None,
            gender_string: Optional[pulumi.Input[_builtins.str]] = None,
            home_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
            last_name: Optional[pulumi.Input[_builtins.str]] = None,
            mailing_address: Optional[pulumi.Input[Union['ProfileMailingAddressArgs', 'ProfileMailingAddressArgsDict']]] = None,
            middle_name: Optional[pulumi.Input[_builtins.str]] = None,
            mobile_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
            party_type_string: Optional[pulumi.Input[_builtins.str]] = None,
            personal_email_address: Optional[pulumi.Input[_builtins.str]] = None,
            phone_number: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            shipping_address: Optional[pulumi.Input[Union['ProfileShippingAddressArgs', 'ProfileShippingAddressArgsDict']]] = None) -> 'Profile':
        """
        Get an existing Profile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_number: A unique account number that you have given to the customer.
        :param pulumi.Input[_builtins.str] additional_information: Any additional information relevant to the customer’s profile.
        :param pulumi.Input[Union['ProfileAddressArgs', 'ProfileAddressArgsDict']] address: A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attributes: A key value pair of attributes of a customer profile.
        :param pulumi.Input[Union['ProfileBillingAddressArgs', 'ProfileBillingAddressArgsDict']] billing_address: A block that specifies the customer’s billing address. Documented below.
        :param pulumi.Input[_builtins.str] birth_date: The customer’s birth date.
        :param pulumi.Input[_builtins.str] business_email_address: The customer’s business email address.
        :param pulumi.Input[_builtins.str] business_name: The name of the customer’s business.
        :param pulumi.Input[_builtins.str] business_phone_number: The customer’s business phone number.
        :param pulumi.Input[_builtins.str] domain_name: The name of your Customer Profile domain. It must be unique for your AWS account.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] email_address: The customer’s email address, which has not been specified as a personal or business address.
        :param pulumi.Input[_builtins.str] first_name: The customer’s first name.
        :param pulumi.Input[_builtins.str] gender_string: The gender with which the customer identifies.
        :param pulumi.Input[_builtins.str] home_phone_number: The customer’s home phone number.
        :param pulumi.Input[_builtins.str] last_name: The customer’s last name.
        :param pulumi.Input[Union['ProfileMailingAddressArgs', 'ProfileMailingAddressArgsDict']] mailing_address: A block that specifies the customer’s mailing address. Documented below.
        :param pulumi.Input[_builtins.str] middle_name: The customer’s middle name.
        :param pulumi.Input[_builtins.str] mobile_phone_number: The customer’s mobile phone number.
        :param pulumi.Input[_builtins.str] party_type_string: The type of profile used to describe the customer.
        :param pulumi.Input[_builtins.str] personal_email_address: The customer’s personal email address.
        :param pulumi.Input[_builtins.str] phone_number: The customer’s phone number, which has not been specified as a mobile, home, or business number.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ProfileShippingAddressArgs', 'ProfileShippingAddressArgsDict']] shipping_address: A block that specifies the customer’s shipping address. Documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileState.__new__(_ProfileState)

        __props__.__dict__["account_number"] = account_number
        __props__.__dict__["additional_information"] = additional_information
        __props__.__dict__["address"] = address
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["billing_address"] = billing_address
        __props__.__dict__["birth_date"] = birth_date
        __props__.__dict__["business_email_address"] = business_email_address
        __props__.__dict__["business_name"] = business_name
        __props__.__dict__["business_phone_number"] = business_phone_number
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["email_address"] = email_address
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["gender_string"] = gender_string
        __props__.__dict__["home_phone_number"] = home_phone_number
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["mailing_address"] = mailing_address
        __props__.__dict__["middle_name"] = middle_name
        __props__.__dict__["mobile_phone_number"] = mobile_phone_number
        __props__.__dict__["party_type_string"] = party_type_string
        __props__.__dict__["personal_email_address"] = personal_email_address
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["region"] = region
        __props__.__dict__["shipping_address"] = shipping_address
        return Profile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A unique account number that you have given to the customer.
        """
        return pulumi.get(self, "account_number")

    @_builtins.property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Any additional information relevant to the customer’s profile.
        """
        return pulumi.get(self, "additional_information")

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[Optional['outputs.ProfileAddress']]:
        """
        A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A key value pair of attributes of a customer profile.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="billingAddress")
    def billing_address(self) -> pulumi.Output[Optional['outputs.ProfileBillingAddress']]:
        """
        A block that specifies the customer’s billing address. Documented below.
        """
        return pulumi.get(self, "billing_address")

    @_builtins.property
    @pulumi.getter(name="birthDate")
    def birth_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s birth date.
        """
        return pulumi.get(self, "birth_date")

    @_builtins.property
    @pulumi.getter(name="businessEmailAddress")
    def business_email_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s business email address.
        """
        return pulumi.get(self, "business_email_address")

    @_builtins.property
    @pulumi.getter(name="businessName")
    def business_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the customer’s business.
        """
        return pulumi.get(self, "business_name")

    @_builtins.property
    @pulumi.getter(name="businessPhoneNumber")
    def business_phone_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s business phone number.
        """
        return pulumi.get(self, "business_phone_number")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of your Customer Profile domain. It must be unique for your AWS account.

        The following arguments are optional:
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s email address, which has not been specified as a personal or business address.
        """
        return pulumi.get(self, "email_address")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s first name.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="genderString")
    def gender_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The gender with which the customer identifies.
        """
        return pulumi.get(self, "gender_string")

    @_builtins.property
    @pulumi.getter(name="homePhoneNumber")
    def home_phone_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s home phone number.
        """
        return pulumi.get(self, "home_phone_number")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s last name.
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter(name="mailingAddress")
    def mailing_address(self) -> pulumi.Output[Optional['outputs.ProfileMailingAddress']]:
        """
        A block that specifies the customer’s mailing address. Documented below.
        """
        return pulumi.get(self, "mailing_address")

    @_builtins.property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s middle name.
        """
        return pulumi.get(self, "middle_name")

    @_builtins.property
    @pulumi.getter(name="mobilePhoneNumber")
    def mobile_phone_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s mobile phone number.
        """
        return pulumi.get(self, "mobile_phone_number")

    @_builtins.property
    @pulumi.getter(name="partyTypeString")
    def party_type_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of profile used to describe the customer.
        """
        return pulumi.get(self, "party_type_string")

    @_builtins.property
    @pulumi.getter(name="personalEmailAddress")
    def personal_email_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s personal email address.
        """
        return pulumi.get(self, "personal_email_address")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The customer’s phone number, which has not been specified as a mobile, home, or business number.
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> pulumi.Output[Optional['outputs.ProfileShippingAddress']]:
        """
        A block that specifies the customer’s shipping address. Documented below.
        """
        return pulumi.get(self, "shipping_address")

