# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineDefinitionArgs', 'PipelineDefinition']

@pulumi.input_type
class PipelineDefinitionArgs:
    def __init__(__self__, *,
                 pipeline_id: pulumi.Input[_builtins.str],
                 pipeline_objects: pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionPipelineObjectArgs']]],
                 parameter_objects: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterObjectArgs']]]] = None,
                 parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterValueArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PipelineDefinition resource.
        :param pulumi.Input[_builtins.str] pipeline_id: ID of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionPipelineObjectArgs']]] pipeline_objects: Configuration block for the objects that define the pipeline. See below
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterObjectArgs']]] parameter_objects: Configuration block for the parameter objects used in the pipeline definition. See below
        :param pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterValueArgs']]] parameter_values: Configuration block for the parameter values used in the pipeline definition. See below
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        pulumi.set(__self__, "pipeline_objects", pipeline_objects)
        if parameter_objects is not None:
            pulumi.set(__self__, "parameter_objects", parameter_objects)
        if parameter_values is not None:
            pulumi.set(__self__, "parameter_values", parameter_values)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="pipelineObjects")
    def pipeline_objects(self) -> pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionPipelineObjectArgs']]]:
        """
        Configuration block for the objects that define the pipeline. See below

        The following arguments are optional:
        """
        return pulumi.get(self, "pipeline_objects")

    @pipeline_objects.setter
    def pipeline_objects(self, value: pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionPipelineObjectArgs']]]):
        pulumi.set(self, "pipeline_objects", value)

    @_builtins.property
    @pulumi.getter(name="parameterObjects")
    def parameter_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterObjectArgs']]]]:
        """
        Configuration block for the parameter objects used in the pipeline definition. See below
        """
        return pulumi.get(self, "parameter_objects")

    @parameter_objects.setter
    def parameter_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterObjectArgs']]]]):
        pulumi.set(self, "parameter_objects", value)

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterValueArgs']]]]:
        """
        Configuration block for the parameter values used in the pipeline definition. See below
        """
        return pulumi.get(self, "parameter_values")

    @parameter_values.setter
    def parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterValueArgs']]]]):
        pulumi.set(self, "parameter_values", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PipelineDefinitionState:
    def __init__(__self__, *,
                 parameter_objects: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterObjectArgs']]]] = None,
                 parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterValueArgs']]]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_objects: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionPipelineObjectArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PipelineDefinition resources.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterObjectArgs']]] parameter_objects: Configuration block for the parameter objects used in the pipeline definition. See below
        :param pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterValueArgs']]] parameter_values: Configuration block for the parameter values used in the pipeline definition. See below
        :param pulumi.Input[_builtins.str] pipeline_id: ID of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionPipelineObjectArgs']]] pipeline_objects: Configuration block for the objects that define the pipeline. See below
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if parameter_objects is not None:
            pulumi.set(__self__, "parameter_objects", parameter_objects)
        if parameter_values is not None:
            pulumi.set(__self__, "parameter_values", parameter_values)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if pipeline_objects is not None:
            pulumi.set(__self__, "pipeline_objects", pipeline_objects)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="parameterObjects")
    def parameter_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterObjectArgs']]]]:
        """
        Configuration block for the parameter objects used in the pipeline definition. See below
        """
        return pulumi.get(self, "parameter_objects")

    @parameter_objects.setter
    def parameter_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterObjectArgs']]]]):
        pulumi.set(self, "parameter_objects", value)

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterValueArgs']]]]:
        """
        Configuration block for the parameter values used in the pipeline definition. See below
        """
        return pulumi.get(self, "parameter_values")

    @parameter_values.setter
    def parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionParameterValueArgs']]]]):
        pulumi.set(self, "parameter_values", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="pipelineObjects")
    def pipeline_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionPipelineObjectArgs']]]]:
        """
        Configuration block for the objects that define the pipeline. See below

        The following arguments are optional:
        """
        return pulumi.get(self, "pipeline_objects")

    @pipeline_objects.setter
    def pipeline_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDefinitionPipelineObjectArgs']]]]):
        pulumi.set(self, "pipeline_objects", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:datapipeline/pipelineDefinition:PipelineDefinition")
class PipelineDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parameter_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterObjectArgs', 'PipelineDefinitionParameterObjectArgsDict']]]]] = None,
                 parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterValueArgs', 'PipelineDefinitionParameterValueArgsDict']]]]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionPipelineObjectArgs', 'PipelineDefinitionPipelineObjectArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DataPipeline Pipeline Definition resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.datapipeline.Pipeline("default", name="tf-pipeline-default")
        example = aws.datapipeline.PipelineDefinition("example",
            pipeline_id=default.id,
            pipeline_objects=[
                {
                    "id": "Default",
                    "name": "Default",
                    "fields": [{
                        "key": "workerGroup",
                        "string_value": "workerGroup",
                    }],
                },
                {
                    "id": "Schedule",
                    "name": "Schedule",
                    "fields": [
                        {
                            "key": "startDateTime",
                            "string_value": "2012-12-12T00:00:00",
                        },
                        {
                            "key": "type",
                            "string_value": "Schedule",
                        },
                        {
                            "key": "period",
                            "string_value": "1 hour",
                        },
                        {
                            "key": "endDateTime",
                            "string_value": "2012-12-21T18:00:00",
                        },
                    ],
                },
                {
                    "id": "SayHello",
                    "name": "SayHello",
                    "fields": [
                        {
                            "key": "type",
                            "string_value": "ShellCommandActivity",
                        },
                        {
                            "key": "command",
                            "string_value": "echo hello",
                        },
                        {
                            "key": "parent",
                            "string_value": "Default",
                        },
                        {
                            "key": "schedule",
                            "string_value": "Schedule",
                        },
                    ],
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import `aws_datapipeline_pipeline_definition` using the id. For example:

        ```sh
        $ pulumi import aws:datapipeline/pipelineDefinition:PipelineDefinition example df-1234567890
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterObjectArgs', 'PipelineDefinitionParameterObjectArgsDict']]]] parameter_objects: Configuration block for the parameter objects used in the pipeline definition. See below
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterValueArgs', 'PipelineDefinitionParameterValueArgsDict']]]] parameter_values: Configuration block for the parameter values used in the pipeline definition. See below
        :param pulumi.Input[_builtins.str] pipeline_id: ID of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionPipelineObjectArgs', 'PipelineDefinitionPipelineObjectArgsDict']]]] pipeline_objects: Configuration block for the objects that define the pipeline. See below
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DataPipeline Pipeline Definition resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.datapipeline.Pipeline("default", name="tf-pipeline-default")
        example = aws.datapipeline.PipelineDefinition("example",
            pipeline_id=default.id,
            pipeline_objects=[
                {
                    "id": "Default",
                    "name": "Default",
                    "fields": [{
                        "key": "workerGroup",
                        "string_value": "workerGroup",
                    }],
                },
                {
                    "id": "Schedule",
                    "name": "Schedule",
                    "fields": [
                        {
                            "key": "startDateTime",
                            "string_value": "2012-12-12T00:00:00",
                        },
                        {
                            "key": "type",
                            "string_value": "Schedule",
                        },
                        {
                            "key": "period",
                            "string_value": "1 hour",
                        },
                        {
                            "key": "endDateTime",
                            "string_value": "2012-12-21T18:00:00",
                        },
                    ],
                },
                {
                    "id": "SayHello",
                    "name": "SayHello",
                    "fields": [
                        {
                            "key": "type",
                            "string_value": "ShellCommandActivity",
                        },
                        {
                            "key": "command",
                            "string_value": "echo hello",
                        },
                        {
                            "key": "parent",
                            "string_value": "Default",
                        },
                        {
                            "key": "schedule",
                            "string_value": "Schedule",
                        },
                    ],
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import `aws_datapipeline_pipeline_definition` using the id. For example:

        ```sh
        $ pulumi import aws:datapipeline/pipelineDefinition:PipelineDefinition example df-1234567890
        ```

        :param str resource_name: The name of the resource.
        :param PipelineDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parameter_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterObjectArgs', 'PipelineDefinitionParameterObjectArgsDict']]]]] = None,
                 parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterValueArgs', 'PipelineDefinitionParameterValueArgsDict']]]]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionPipelineObjectArgs', 'PipelineDefinitionPipelineObjectArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineDefinitionArgs.__new__(PipelineDefinitionArgs)

            __props__.__dict__["parameter_objects"] = parameter_objects
            __props__.__dict__["parameter_values"] = parameter_values
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
            if pipeline_objects is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_objects'")
            __props__.__dict__["pipeline_objects"] = pipeline_objects
            __props__.__dict__["region"] = region
        super(PipelineDefinition, __self__).__init__(
            'aws:datapipeline/pipelineDefinition:PipelineDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            parameter_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterObjectArgs', 'PipelineDefinitionParameterObjectArgsDict']]]]] = None,
            parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterValueArgs', 'PipelineDefinitionParameterValueArgsDict']]]]] = None,
            pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
            pipeline_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionPipelineObjectArgs', 'PipelineDefinitionPipelineObjectArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'PipelineDefinition':
        """
        Get an existing PipelineDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterObjectArgs', 'PipelineDefinitionParameterObjectArgsDict']]]] parameter_objects: Configuration block for the parameter objects used in the pipeline definition. See below
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionParameterValueArgs', 'PipelineDefinitionParameterValueArgsDict']]]] parameter_values: Configuration block for the parameter values used in the pipeline definition. See below
        :param pulumi.Input[_builtins.str] pipeline_id: ID of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineDefinitionPipelineObjectArgs', 'PipelineDefinitionPipelineObjectArgsDict']]]] pipeline_objects: Configuration block for the objects that define the pipeline. See below
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineDefinitionState.__new__(_PipelineDefinitionState)

        __props__.__dict__["parameter_objects"] = parameter_objects
        __props__.__dict__["parameter_values"] = parameter_values
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["pipeline_objects"] = pipeline_objects
        __props__.__dict__["region"] = region
        return PipelineDefinition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="parameterObjects")
    def parameter_objects(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineDefinitionParameterObject']]]:
        """
        Configuration block for the parameter objects used in the pipeline definition. See below
        """
        return pulumi.get(self, "parameter_objects")

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineDefinitionParameterValue']]]:
        """
        Configuration block for the parameter values used in the pipeline definition. See below
        """
        return pulumi.get(self, "parameter_values")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @_builtins.property
    @pulumi.getter(name="pipelineObjects")
    def pipeline_objects(self) -> pulumi.Output[Sequence['outputs.PipelineDefinitionPipelineObject']]:
        """
        Configuration block for the objects that define the pipeline. See below

        The following arguments are optional:
        """
        return pulumi.get(self, "pipeline_objects")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

