# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceProfileArgs', 'InstanceProfile']

@pulumi.input_type
class InstanceProfileArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_app_packages_from_cleanups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_cleanup: Optional[pulumi.Input[_builtins.bool]] = None,
                 reboot_after_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a InstanceProfile resource.
        :param pulumi.Input[_builtins.str] description: The description of the instance profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_app_packages_from_cleanups: An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
        :param pulumi.Input[_builtins.str] name: The name for the instance profile.
        :param pulumi.Input[_builtins.bool] package_cleanup: When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
        :param pulumi.Input[_builtins.bool] reboot_after_use: When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_app_packages_from_cleanups is not None:
            pulumi.set(__self__, "exclude_app_packages_from_cleanups", exclude_app_packages_from_cleanups)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_cleanup is not None:
            pulumi.set(__self__, "package_cleanup", package_cleanup)
        if reboot_after_use is not None:
            pulumi.set(__self__, "reboot_after_use", reboot_after_use)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the instance profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludeAppPackagesFromCleanups")
    def exclude_app_packages_from_cleanups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
        """
        return pulumi.get(self, "exclude_app_packages_from_cleanups")

    @exclude_app_packages_from_cleanups.setter
    def exclude_app_packages_from_cleanups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_app_packages_from_cleanups", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the instance profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="packageCleanup")
    def package_cleanup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
        """
        return pulumi.get(self, "package_cleanup")

    @package_cleanup.setter
    def package_cleanup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "package_cleanup", value)

    @_builtins.property
    @pulumi.getter(name="rebootAfterUse")
    def reboot_after_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
        """
        return pulumi.get(self, "reboot_after_use")

    @reboot_after_use.setter
    def reboot_after_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reboot_after_use", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceProfileState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_app_packages_from_cleanups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_cleanup: Optional[pulumi.Input[_builtins.bool]] = None,
                 reboot_after_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering InstanceProfile resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name of this instance profile.
        :param pulumi.Input[_builtins.str] description: The description of the instance profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_app_packages_from_cleanups: An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
        :param pulumi.Input[_builtins.str] name: The name for the instance profile.
        :param pulumi.Input[_builtins.bool] package_cleanup: When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
        :param pulumi.Input[_builtins.bool] reboot_after_use: When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_app_packages_from_cleanups is not None:
            pulumi.set(__self__, "exclude_app_packages_from_cleanups", exclude_app_packages_from_cleanups)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_cleanup is not None:
            pulumi.set(__self__, "package_cleanup", package_cleanup)
        if reboot_after_use is not None:
            pulumi.set(__self__, "reboot_after_use", reboot_after_use)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name of this instance profile.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the instance profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludeAppPackagesFromCleanups")
    def exclude_app_packages_from_cleanups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
        """
        return pulumi.get(self, "exclude_app_packages_from_cleanups")

    @exclude_app_packages_from_cleanups.setter
    def exclude_app_packages_from_cleanups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_app_packages_from_cleanups", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the instance profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="packageCleanup")
    def package_cleanup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
        """
        return pulumi.get(self, "package_cleanup")

    @package_cleanup.setter
    def package_cleanup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "package_cleanup", value)

    @_builtins.property
    @pulumi.getter(name="rebootAfterUse")
    def reboot_after_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
        """
        return pulumi.get(self, "reboot_after_use")

    @reboot_after_use.setter
    def reboot_after_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reboot_after_use", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:devicefarm/instanceProfile:InstanceProfile")
class InstanceProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_app_packages_from_cleanups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_cleanup: Optional[pulumi.Input[_builtins.bool]] = None,
                 reboot_after_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage AWS Device Farm Instance Profiles.
        ∂
        > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devicefarm.InstanceProfile("example", name="example")
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the Device Farm instance profile.

        Using `pulumi import`, import DeviceFarm Instance Profiles using their ARN. For example:

        console

        % pulumi import aws_devicefarm_instance_profile.example arn:aws:devicefarm:us-west-2:123456789012:instanceprofile:4fa784c7-ccb4-4dbf-ba4f-02198320daa1

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the instance profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_app_packages_from_cleanups: An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
        :param pulumi.Input[_builtins.str] name: The name for the instance profile.
        :param pulumi.Input[_builtins.bool] package_cleanup: When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
        :param pulumi.Input[_builtins.bool] reboot_after_use: When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage AWS Device Farm Instance Profiles.
        ∂
        > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devicefarm.InstanceProfile("example", name="example")
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the Device Farm instance profile.

        Using `pulumi import`, import DeviceFarm Instance Profiles using their ARN. For example:

        console

        % pulumi import aws_devicefarm_instance_profile.example arn:aws:devicefarm:us-west-2:123456789012:instanceprofile:4fa784c7-ccb4-4dbf-ba4f-02198320daa1

        :param str resource_name: The name of the resource.
        :param InstanceProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_app_packages_from_cleanups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_cleanup: Optional[pulumi.Input[_builtins.bool]] = None,
                 reboot_after_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceProfileArgs.__new__(InstanceProfileArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_app_packages_from_cleanups"] = exclude_app_packages_from_cleanups
            __props__.__dict__["name"] = name
            __props__.__dict__["package_cleanup"] = package_cleanup
            __props__.__dict__["reboot_after_use"] = reboot_after_use
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(InstanceProfile, __self__).__init__(
            'aws:devicefarm/instanceProfile:InstanceProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_app_packages_from_cleanups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            package_cleanup: Optional[pulumi.Input[_builtins.bool]] = None,
            reboot_after_use: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'InstanceProfile':
        """
        Get an existing InstanceProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name of this instance profile.
        :param pulumi.Input[_builtins.str] description: The description of the instance profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_app_packages_from_cleanups: An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
        :param pulumi.Input[_builtins.str] name: The name for the instance profile.
        :param pulumi.Input[_builtins.bool] package_cleanup: When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
        :param pulumi.Input[_builtins.bool] reboot_after_use: When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceProfileState.__new__(_InstanceProfileState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["exclude_app_packages_from_cleanups"] = exclude_app_packages_from_cleanups
        __props__.__dict__["name"] = name
        __props__.__dict__["package_cleanup"] = package_cleanup
        __props__.__dict__["reboot_after_use"] = reboot_after_use
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return InstanceProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name of this instance profile.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the instance profile.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="excludeAppPackagesFromCleanups")
    def exclude_app_packages_from_cleanups(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
        """
        return pulumi.get(self, "exclude_app_packages_from_cleanups")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the instance profile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageCleanup")
    def package_cleanup(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
        """
        return pulumi.get(self, "package_cleanup")

    @_builtins.property
    @pulumi.getter(name="rebootAfterUse")
    def reboot_after_use(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
        """
        return pulumi.get(self, "reboot_after_use")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

