# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 allow_major_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 master_password: Optional[pulumi.Input[_builtins.str]] = None,
                 master_username: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_point_in_time: Optional[pulumi.Input['ClusterRestoreToPointInTimeArgs']] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input['ClusterServerlessV2ScalingConfigurationArgs']] = None,
                 skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.bool] allow_major_version_upgrade: A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any cluster modifications
               are applied immediately, or during the next maintenance window. Default is
               `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: A list of EC2 Availability Zones that instances in the DB cluster can be created in.
               DocumentDB automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next pulumi up.
               We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary.
        :param pulumi.Input[_builtins.int] backup_retention_period: The days to retain backups for. Default `1`
        :param pulumi.Input[_builtins.str] cluster_identifier: The cluster identifier. If omitted, the provider will assign a random, unique identifier.
        :param pulumi.Input[_builtins.str] cluster_identifier_prefix: Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_members: List of DocumentDB Instances that are a part of this cluster
        :param pulumi.Input[_builtins.str] db_cluster_parameter_group_name: A cluster parameter group to associate with the cluster.
        :param pulumi.Input[_builtins.str] db_subnet_group_name: A DB subnet group to associate with this DB instance.
        :param pulumi.Input[_builtins.bool] deletion_protection: A boolean value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cloudwatch_logs_exports: List of log types to export to cloudwatch. If omitted, no logs will be exported.
               The following log types are supported: `audit`, `profiler`.
        :param pulumi.Input[_builtins.str] engine: The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
        :param pulumi.Input[_builtins.str] engine_version: The database engine version. Updating this argument results in an outage.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: The name of your final DB snapshot
               when this DB cluster is deleted. If omitted, no final snapshot will be
               made.
        :param pulumi.Input[_builtins.str] global_cluster_identifier: The global cluster identifier specified on `docdb.GlobalCluster`.
        :param pulumi.Input[_builtins.str] kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        :param pulumi.Input[_builtins.bool] manage_master_user_password: Set to `true` to allow Amazon DocumentDB to manage the master user password in AWS Secrets Manager. Cannot be set if `master_password` or `master_password_wo` is provided.
        :param pulumi.Input[_builtins.str] master_password: Password for the master DB user. Note that this may
               show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints. Conflicts with `master_password_wo` and `manage_master_user_password`.
        :param pulumi.Input[_builtins.str] master_username: Username for the master DB user.
        :param pulumi.Input[_builtins.int] port: The port on which the DB accepts connections
        :param pulumi.Input[_builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
               Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
        :param pulumi.Input[_builtins.str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ClusterRestoreToPointInTimeArgs'] restore_to_point_in_time: A configuration block for restoring a DB instance to an arbitrary point in time. Requires the `identifier` argument to be set with the name of the new DB instance to be created. See Restore To Point In Time below for details.
        :param pulumi.Input['ClusterServerlessV2ScalingConfigurationArgs'] serverless_v2_scaling_configuration: Scaling configuration of an Amazon DocumentDB Serverless cluster. See Serverless V2 Scaling Configuration below for details.
        :param pulumi.Input[_builtins.bool] skip_final_snapshot: Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
        :param pulumi.Input[_builtins.str] snapshot_identifier: Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
        :param pulumi.Input[_builtins.bool] storage_encrypted: Specifies whether the DB cluster is encrypted. The default is `false`.
        :param pulumi.Input[_builtins.str] storage_type: The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: List of VPC security groups to associate
               with the Cluster
               
               For more detailed documentation about each argument, refer to
               the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/docdb/create-db-cluster.html).
        """
        if allow_major_version_upgrade is not None:
            pulumi.set(__self__, "allow_major_version_upgrade", allow_major_version_upgrade)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if cluster_identifier_prefix is not None:
            pulumi.set(__self__, "cluster_identifier_prefix", cluster_identifier_prefix)
        if cluster_members is not None:
            pulumi.set(__self__, "cluster_members", cluster_members)
        if db_cluster_parameter_group_name is not None:
            pulumi.set(__self__, "db_cluster_parameter_group_name", db_cluster_parameter_group_name)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enabled_cloudwatch_logs_exports is not None:
            pulumi.set(__self__, "enabled_cloudwatch_logs_exports", enabled_cloudwatch_logs_exports)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if global_cluster_identifier is not None:
            pulumi.set(__self__, "global_cluster_identifier", global_cluster_identifier)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if manage_master_user_password is not None:
            pulumi.set(__self__, "manage_master_user_password", manage_master_user_password)
        if master_password is not None:
            pulumi.set(__self__, "master_password", master_password)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restore_to_point_in_time is not None:
            pulumi.set(__self__, "restore_to_point_in_time", restore_to_point_in_time)
        if serverless_v2_scaling_configuration is not None:
            pulumi.set(__self__, "serverless_v2_scaling_configuration", serverless_v2_scaling_configuration)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @_builtins.property
    @pulumi.getter(name="allowMajorVersionUpgrade")
    def allow_major_version_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
        """
        return pulumi.get(self, "allow_major_version_upgrade")

    @allow_major_version_upgrade.setter
    def allow_major_version_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_major_version_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether any cluster modifications
        are applied immediately, or during the next maintenance window. Default is
        `false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of EC2 Availability Zones that instances in the DB cluster can be created in.
        DocumentDB automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next pulumi up.
        We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The days to retain backups for. Default `1`
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster identifier. If omitted, the provider will assign a random, unique identifier.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_identifier", value)

    @_builtins.property
    @pulumi.getter(name="clusterIdentifierPrefix")
    def cluster_identifier_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
        """
        return pulumi.get(self, "cluster_identifier_prefix")

    @cluster_identifier_prefix.setter
    def cluster_identifier_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_identifier_prefix", value)

    @_builtins.property
    @pulumi.getter(name="clusterMembers")
    def cluster_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DocumentDB Instances that are a part of this cluster
        """
        return pulumi.get(self, "cluster_members")

    @cluster_members.setter
    def cluster_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cluster_members", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterParameterGroupName")
    def db_cluster_parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A cluster parameter group to associate with the cluster.
        """
        return pulumi.get(self, "db_cluster_parameter_group_name")

    @db_cluster_parameter_group_name.setter
    def db_cluster_parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_parameter_group_name", value)

    @_builtins.property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A DB subnet group to associate with this DB instance.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enabledCloudwatchLogsExports")
    def enabled_cloudwatch_logs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of log types to export to cloudwatch. If omitted, no logs will be exported.
        The following log types are supported: `audit`, `profiler`.
        """
        return pulumi.get(self, "enabled_cloudwatch_logs_exports")

    @enabled_cloudwatch_logs_exports.setter
    def enabled_cloudwatch_logs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_cloudwatch_logs_exports", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database engine version. Updating this argument results in an outage.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of your final DB snapshot
        when this DB cluster is deleted. If omitted, no final snapshot will be
        made.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The global cluster identifier specified on `docdb.GlobalCluster`.
        """
        return pulumi.get(self, "global_cluster_identifier")

    @global_cluster_identifier.setter
    def global_cluster_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_cluster_identifier", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to allow Amazon DocumentDB to manage the master user password in AWS Secrets Manager. Cannot be set if `master_password` or `master_password_wo` is provided.
        """
        return pulumi.get(self, "manage_master_user_password")

    @manage_master_user_password.setter
    def manage_master_user_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage_master_user_password", value)

    @_builtins.property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the master DB user. Note that this may
        show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints. Conflicts with `master_password_wo` and `manage_master_user_password`.
        """
        return pulumi.get(self, "master_password")

    @master_password.setter
    def master_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_password", value)

    @_builtins.property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for the master DB user.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_username", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which the DB accepts connections
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
        Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @_builtins.property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="restoreToPointInTime")
    def restore_to_point_in_time(self) -> Optional[pulumi.Input['ClusterRestoreToPointInTimeArgs']]:
        """
        A configuration block for restoring a DB instance to an arbitrary point in time. Requires the `identifier` argument to be set with the name of the new DB instance to be created. See Restore To Point In Time below for details.
        """
        return pulumi.get(self, "restore_to_point_in_time")

    @restore_to_point_in_time.setter
    def restore_to_point_in_time(self, value: Optional[pulumi.Input['ClusterRestoreToPointInTimeArgs']]):
        pulumi.set(self, "restore_to_point_in_time", value)

    @_builtins.property
    @pulumi.getter(name="serverlessV2ScalingConfiguration")
    def serverless_v2_scaling_configuration(self) -> Optional[pulumi.Input['ClusterServerlessV2ScalingConfigurationArgs']]:
        """
        Scaling configuration of an Amazon DocumentDB Serverless cluster. See Serverless V2 Scaling Configuration below for details.
        """
        return pulumi.get(self, "serverless_v2_scaling_configuration")

    @serverless_v2_scaling_configuration.setter
    def serverless_v2_scaling_configuration(self, value: Optional[pulumi.Input['ClusterServerlessV2ScalingConfigurationArgs']]):
        pulumi.set(self, "serverless_v2_scaling_configuration", value)

    @_builtins.property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the DB cluster is encrypted. The default is `false`.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of VPC security groups to associate
        with the Cluster

        For more detailed documentation about each argument, refer to
        the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/docdb/create-db-cluster.html).
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 allow_major_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 hosted_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 master_password: Optional[pulumi.Input[_builtins.str]] = None,
                 master_user_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterUserSecretArgs']]]] = None,
                 master_username: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 reader_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_point_in_time: Optional[pulumi.Input['ClusterRestoreToPointInTimeArgs']] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input['ClusterServerlessV2ScalingConfigurationArgs']] = None,
                 skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.bool] allow_major_version_upgrade: A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any cluster modifications
               are applied immediately, or during the next maintenance window. Default is
               `false`.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of cluster
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: A list of EC2 Availability Zones that instances in the DB cluster can be created in.
               DocumentDB automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next pulumi up.
               We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary.
        :param pulumi.Input[_builtins.int] backup_retention_period: The days to retain backups for. Default `1`
        :param pulumi.Input[_builtins.str] cluster_identifier: The cluster identifier. If omitted, the provider will assign a random, unique identifier.
        :param pulumi.Input[_builtins.str] cluster_identifier_prefix: Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_members: List of DocumentDB Instances that are a part of this cluster
        :param pulumi.Input[_builtins.str] cluster_resource_id: The DocumentDB Cluster Resource ID
        :param pulumi.Input[_builtins.str] db_cluster_parameter_group_name: A cluster parameter group to associate with the cluster.
        :param pulumi.Input[_builtins.str] db_subnet_group_name: A DB subnet group to associate with this DB instance.
        :param pulumi.Input[_builtins.bool] deletion_protection: A boolean value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cloudwatch_logs_exports: List of log types to export to cloudwatch. If omitted, no logs will be exported.
               The following log types are supported: `audit`, `profiler`.
        :param pulumi.Input[_builtins.str] endpoint: The DNS address of the DocumentDB instance
        :param pulumi.Input[_builtins.str] engine: The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
        :param pulumi.Input[_builtins.str] engine_version: The database engine version. Updating this argument results in an outage.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: The name of your final DB snapshot
               when this DB cluster is deleted. If omitted, no final snapshot will be
               made.
        :param pulumi.Input[_builtins.str] global_cluster_identifier: The global cluster identifier specified on `docdb.GlobalCluster`.
        :param pulumi.Input[_builtins.str] hosted_zone_id: The Route53 Hosted Zone ID of the endpoint
        :param pulumi.Input[_builtins.str] kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        :param pulumi.Input[_builtins.bool] manage_master_user_password: Set to `true` to allow Amazon DocumentDB to manage the master user password in AWS Secrets Manager. Cannot be set if `master_password` or `master_password_wo` is provided.
        :param pulumi.Input[_builtins.str] master_password: Password for the master DB user. Note that this may
               show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints. Conflicts with `master_password_wo` and `manage_master_user_password`.
        :param pulumi.Input[_builtins.str] master_username: Username for the master DB user.
        :param pulumi.Input[_builtins.int] port: The port on which the DB accepts connections
        :param pulumi.Input[_builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
               Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
        :param pulumi.Input[_builtins.str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
        :param pulumi.Input[_builtins.str] reader_endpoint: A read-only endpoint for the DocumentDB cluster, automatically load-balanced across replicas
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ClusterRestoreToPointInTimeArgs'] restore_to_point_in_time: A configuration block for restoring a DB instance to an arbitrary point in time. Requires the `identifier` argument to be set with the name of the new DB instance to be created. See Restore To Point In Time below for details.
        :param pulumi.Input['ClusterServerlessV2ScalingConfigurationArgs'] serverless_v2_scaling_configuration: Scaling configuration of an Amazon DocumentDB Serverless cluster. See Serverless V2 Scaling Configuration below for details.
        :param pulumi.Input[_builtins.bool] skip_final_snapshot: Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
        :param pulumi.Input[_builtins.str] snapshot_identifier: Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
        :param pulumi.Input[_builtins.bool] storage_encrypted: Specifies whether the DB cluster is encrypted. The default is `false`.
        :param pulumi.Input[_builtins.str] storage_type: The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: List of VPC security groups to associate
               with the Cluster
               
               For more detailed documentation about each argument, refer to
               the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/docdb/create-db-cluster.html).
        """
        if allow_major_version_upgrade is not None:
            pulumi.set(__self__, "allow_major_version_upgrade", allow_major_version_upgrade)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if cluster_identifier_prefix is not None:
            pulumi.set(__self__, "cluster_identifier_prefix", cluster_identifier_prefix)
        if cluster_members is not None:
            pulumi.set(__self__, "cluster_members", cluster_members)
        if cluster_resource_id is not None:
            pulumi.set(__self__, "cluster_resource_id", cluster_resource_id)
        if db_cluster_parameter_group_name is not None:
            pulumi.set(__self__, "db_cluster_parameter_group_name", db_cluster_parameter_group_name)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enabled_cloudwatch_logs_exports is not None:
            pulumi.set(__self__, "enabled_cloudwatch_logs_exports", enabled_cloudwatch_logs_exports)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if global_cluster_identifier is not None:
            pulumi.set(__self__, "global_cluster_identifier", global_cluster_identifier)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if manage_master_user_password is not None:
            pulumi.set(__self__, "manage_master_user_password", manage_master_user_password)
        if master_password is not None:
            pulumi.set(__self__, "master_password", master_password)
        if master_user_secrets is not None:
            pulumi.set(__self__, "master_user_secrets", master_user_secrets)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if reader_endpoint is not None:
            pulumi.set(__self__, "reader_endpoint", reader_endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restore_to_point_in_time is not None:
            pulumi.set(__self__, "restore_to_point_in_time", restore_to_point_in_time)
        if serverless_v2_scaling_configuration is not None:
            pulumi.set(__self__, "serverless_v2_scaling_configuration", serverless_v2_scaling_configuration)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @_builtins.property
    @pulumi.getter(name="allowMajorVersionUpgrade")
    def allow_major_version_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
        """
        return pulumi.get(self, "allow_major_version_upgrade")

    @allow_major_version_upgrade.setter
    def allow_major_version_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_major_version_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether any cluster modifications
        are applied immediately, or during the next maintenance window. Default is
        `false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of cluster
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of EC2 Availability Zones that instances in the DB cluster can be created in.
        DocumentDB automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next pulumi up.
        We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The days to retain backups for. Default `1`
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster identifier. If omitted, the provider will assign a random, unique identifier.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_identifier", value)

    @_builtins.property
    @pulumi.getter(name="clusterIdentifierPrefix")
    def cluster_identifier_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
        """
        return pulumi.get(self, "cluster_identifier_prefix")

    @cluster_identifier_prefix.setter
    def cluster_identifier_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_identifier_prefix", value)

    @_builtins.property
    @pulumi.getter(name="clusterMembers")
    def cluster_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DocumentDB Instances that are a part of this cluster
        """
        return pulumi.get(self, "cluster_members")

    @cluster_members.setter
    def cluster_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cluster_members", value)

    @_builtins.property
    @pulumi.getter(name="clusterResourceId")
    def cluster_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DocumentDB Cluster Resource ID
        """
        return pulumi.get(self, "cluster_resource_id")

    @cluster_resource_id.setter
    def cluster_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterParameterGroupName")
    def db_cluster_parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A cluster parameter group to associate with the cluster.
        """
        return pulumi.get(self, "db_cluster_parameter_group_name")

    @db_cluster_parameter_group_name.setter
    def db_cluster_parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_parameter_group_name", value)

    @_builtins.property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A DB subnet group to associate with this DB instance.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enabledCloudwatchLogsExports")
    def enabled_cloudwatch_logs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of log types to export to cloudwatch. If omitted, no logs will be exported.
        The following log types are supported: `audit`, `profiler`.
        """
        return pulumi.get(self, "enabled_cloudwatch_logs_exports")

    @enabled_cloudwatch_logs_exports.setter
    def enabled_cloudwatch_logs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_cloudwatch_logs_exports", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS address of the DocumentDB instance
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database engine version. Updating this argument results in an outage.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of your final DB snapshot
        when this DB cluster is deleted. If omitted, no final snapshot will be
        made.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The global cluster identifier specified on `docdb.GlobalCluster`.
        """
        return pulumi.get(self, "global_cluster_identifier")

    @global_cluster_identifier.setter
    def global_cluster_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_cluster_identifier", value)

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Route53 Hosted Zone ID of the endpoint
        """
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hosted_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to allow Amazon DocumentDB to manage the master user password in AWS Secrets Manager. Cannot be set if `master_password` or `master_password_wo` is provided.
        """
        return pulumi.get(self, "manage_master_user_password")

    @manage_master_user_password.setter
    def manage_master_user_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage_master_user_password", value)

    @_builtins.property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the master DB user. Note that this may
        show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints. Conflicts with `master_password_wo` and `manage_master_user_password`.
        """
        return pulumi.get(self, "master_password")

    @master_password.setter
    def master_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_password", value)

    @_builtins.property
    @pulumi.getter(name="masterUserSecrets")
    def master_user_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterUserSecretArgs']]]]:
        return pulumi.get(self, "master_user_secrets")

    @master_user_secrets.setter
    def master_user_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterUserSecretArgs']]]]):
        pulumi.set(self, "master_user_secrets", value)

    @_builtins.property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for the master DB user.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_username", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which the DB accepts connections
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
        Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @_builtins.property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="readerEndpoint")
    def reader_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A read-only endpoint for the DocumentDB cluster, automatically load-balanced across replicas
        """
        return pulumi.get(self, "reader_endpoint")

    @reader_endpoint.setter
    def reader_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reader_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="restoreToPointInTime")
    def restore_to_point_in_time(self) -> Optional[pulumi.Input['ClusterRestoreToPointInTimeArgs']]:
        """
        A configuration block for restoring a DB instance to an arbitrary point in time. Requires the `identifier` argument to be set with the name of the new DB instance to be created. See Restore To Point In Time below for details.
        """
        return pulumi.get(self, "restore_to_point_in_time")

    @restore_to_point_in_time.setter
    def restore_to_point_in_time(self, value: Optional[pulumi.Input['ClusterRestoreToPointInTimeArgs']]):
        pulumi.set(self, "restore_to_point_in_time", value)

    @_builtins.property
    @pulumi.getter(name="serverlessV2ScalingConfiguration")
    def serverless_v2_scaling_configuration(self) -> Optional[pulumi.Input['ClusterServerlessV2ScalingConfigurationArgs']]:
        """
        Scaling configuration of an Amazon DocumentDB Serverless cluster. See Serverless V2 Scaling Configuration below for details.
        """
        return pulumi.get(self, "serverless_v2_scaling_configuration")

    @serverless_v2_scaling_configuration.setter
    def serverless_v2_scaling_configuration(self, value: Optional[pulumi.Input['ClusterServerlessV2ScalingConfigurationArgs']]):
        pulumi.set(self, "serverless_v2_scaling_configuration", value)

    @_builtins.property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the DB cluster is encrypted. The default is `false`.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of VPC security groups to associate
        with the Cluster

        For more detailed documentation about each argument, refer to
        the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/docdb/create-db-cluster.html).
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.type_token("aws:docdb/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_major_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 master_password: Optional[pulumi.Input[_builtins.str]] = None,
                 master_username: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_point_in_time: Optional[pulumi.Input[Union['ClusterRestoreToPointInTimeArgs', 'ClusterRestoreToPointInTimeArgsDict']]] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input[Union['ClusterServerlessV2ScalingConfigurationArgs', 'ClusterServerlessV2ScalingConfigurationArgsDict']]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a DocumentDB Cluster.

        Changes to a DocumentDB Cluster can occur when you manually change a
        parameter, such as `port`, and are reflected in the next maintenance
        window. Because of this, this provider may report a difference in its planning
        phase because a modification has not yet taken place. You can use the
        `apply_immediately` flag to instruct the service to apply the change immediately
        (see documentation below).

        > **Note:** using `apply_immediately` can result in a brief downtime as the server reboots.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        docdb = aws.docdb.Cluster("docdb",
            cluster_identifier="my-docdb-cluster",
            engine="docdb",
            master_username="foo",
            master_password="mustbeeightchars",
            backup_retention_period=5,
            preferred_backup_window="07:00-09:00",
            skip_final_snapshot=True)
        ```

        ## Import

        Using `pulumi import`, import DocumentDB Clusters using the `cluster_identifier`. For example:

        ```sh
        $ pulumi import aws:docdb/cluster:Cluster docdb_cluster docdb-prod-cluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_major_version_upgrade: A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any cluster modifications
               are applied immediately, or during the next maintenance window. Default is
               `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: A list of EC2 Availability Zones that instances in the DB cluster can be created in.
               DocumentDB automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next pulumi up.
               We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary.
        :param pulumi.Input[_builtins.int] backup_retention_period: The days to retain backups for. Default `1`
        :param pulumi.Input[_builtins.str] cluster_identifier: The cluster identifier. If omitted, the provider will assign a random, unique identifier.
        :param pulumi.Input[_builtins.str] cluster_identifier_prefix: Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_members: List of DocumentDB Instances that are a part of this cluster
        :param pulumi.Input[_builtins.str] db_cluster_parameter_group_name: A cluster parameter group to associate with the cluster.
        :param pulumi.Input[_builtins.str] db_subnet_group_name: A DB subnet group to associate with this DB instance.
        :param pulumi.Input[_builtins.bool] deletion_protection: A boolean value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cloudwatch_logs_exports: List of log types to export to cloudwatch. If omitted, no logs will be exported.
               The following log types are supported: `audit`, `profiler`.
        :param pulumi.Input[_builtins.str] engine: The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
        :param pulumi.Input[_builtins.str] engine_version: The database engine version. Updating this argument results in an outage.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: The name of your final DB snapshot
               when this DB cluster is deleted. If omitted, no final snapshot will be
               made.
        :param pulumi.Input[_builtins.str] global_cluster_identifier: The global cluster identifier specified on `docdb.GlobalCluster`.
        :param pulumi.Input[_builtins.str] kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        :param pulumi.Input[_builtins.bool] manage_master_user_password: Set to `true` to allow Amazon DocumentDB to manage the master user password in AWS Secrets Manager. Cannot be set if `master_password` or `master_password_wo` is provided.
        :param pulumi.Input[_builtins.str] master_password: Password for the master DB user. Note that this may
               show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints. Conflicts with `master_password_wo` and `manage_master_user_password`.
        :param pulumi.Input[_builtins.str] master_username: Username for the master DB user.
        :param pulumi.Input[_builtins.int] port: The port on which the DB accepts connections
        :param pulumi.Input[_builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
               Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
        :param pulumi.Input[_builtins.str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClusterRestoreToPointInTimeArgs', 'ClusterRestoreToPointInTimeArgsDict']] restore_to_point_in_time: A configuration block for restoring a DB instance to an arbitrary point in time. Requires the `identifier` argument to be set with the name of the new DB instance to be created. See Restore To Point In Time below for details.
        :param pulumi.Input[Union['ClusterServerlessV2ScalingConfigurationArgs', 'ClusterServerlessV2ScalingConfigurationArgsDict']] serverless_v2_scaling_configuration: Scaling configuration of an Amazon DocumentDB Serverless cluster. See Serverless V2 Scaling Configuration below for details.
        :param pulumi.Input[_builtins.bool] skip_final_snapshot: Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
        :param pulumi.Input[_builtins.str] snapshot_identifier: Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
        :param pulumi.Input[_builtins.bool] storage_encrypted: Specifies whether the DB cluster is encrypted. The default is `false`.
        :param pulumi.Input[_builtins.str] storage_type: The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: List of VPC security groups to associate
               with the Cluster
               
               For more detailed documentation about each argument, refer to
               the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/docdb/create-db-cluster.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DocumentDB Cluster.

        Changes to a DocumentDB Cluster can occur when you manually change a
        parameter, such as `port`, and are reflected in the next maintenance
        window. Because of this, this provider may report a difference in its planning
        phase because a modification has not yet taken place. You can use the
        `apply_immediately` flag to instruct the service to apply the change immediately
        (see documentation below).

        > **Note:** using `apply_immediately` can result in a brief downtime as the server reboots.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        docdb = aws.docdb.Cluster("docdb",
            cluster_identifier="my-docdb-cluster",
            engine="docdb",
            master_username="foo",
            master_password="mustbeeightchars",
            backup_retention_period=5,
            preferred_backup_window="07:00-09:00",
            skip_final_snapshot=True)
        ```

        ## Import

        Using `pulumi import`, import DocumentDB Clusters using the `cluster_identifier`. For example:

        ```sh
        $ pulumi import aws:docdb/cluster:Cluster docdb_cluster docdb-prod-cluster
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_major_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 master_password: Optional[pulumi.Input[_builtins.str]] = None,
                 master_username: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_point_in_time: Optional[pulumi.Input[Union['ClusterRestoreToPointInTimeArgs', 'ClusterRestoreToPointInTimeArgsDict']]] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input[Union['ClusterServerlessV2ScalingConfigurationArgs', 'ClusterServerlessV2ScalingConfigurationArgsDict']]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["allow_major_version_upgrade"] = allow_major_version_upgrade
            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            __props__.__dict__["cluster_identifier_prefix"] = cluster_identifier_prefix
            __props__.__dict__["cluster_members"] = cluster_members
            __props__.__dict__["db_cluster_parameter_group_name"] = db_cluster_parameter_group_name
            __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enabled_cloudwatch_logs_exports"] = enabled_cloudwatch_logs_exports
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
            __props__.__dict__["global_cluster_identifier"] = global_cluster_identifier
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["manage_master_user_password"] = manage_master_user_password
            __props__.__dict__["master_password"] = None if master_password is None else pulumi.Output.secret(master_password)
            __props__.__dict__["master_username"] = master_username
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_backup_window"] = preferred_backup_window
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["region"] = region
            __props__.__dict__["restore_to_point_in_time"] = restore_to_point_in_time
            __props__.__dict__["serverless_v2_scaling_configuration"] = serverless_v2_scaling_configuration
            __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
            __props__.__dict__["snapshot_identifier"] = snapshot_identifier
            __props__.__dict__["storage_encrypted"] = storage_encrypted
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["arn"] = None
            __props__.__dict__["cluster_resource_id"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["hosted_zone_id"] = None
            __props__.__dict__["master_user_secrets"] = None
            __props__.__dict__["reader_endpoint"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["masterPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'aws:docdb/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_major_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
            apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            db_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            global_cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            hosted_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            manage_master_user_password: Optional[pulumi.Input[_builtins.bool]] = None,
            master_password: Optional[pulumi.Input[_builtins.str]] = None,
            master_user_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterMasterUserSecretArgs', 'ClusterMasterUserSecretArgsDict']]]]] = None,
            master_username: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
            preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
            reader_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            restore_to_point_in_time: Optional[pulumi.Input[Union['ClusterRestoreToPointInTimeArgs', 'ClusterRestoreToPointInTimeArgsDict']]] = None,
            serverless_v2_scaling_configuration: Optional[pulumi.Input[Union['ClusterServerlessV2ScalingConfigurationArgs', 'ClusterServerlessV2ScalingConfigurationArgsDict']]] = None,
            skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            storage_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_major_version_upgrade: A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any cluster modifications
               are applied immediately, or during the next maintenance window. Default is
               `false`.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of cluster
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: A list of EC2 Availability Zones that instances in the DB cluster can be created in.
               DocumentDB automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next pulumi up.
               We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary.
        :param pulumi.Input[_builtins.int] backup_retention_period: The days to retain backups for. Default `1`
        :param pulumi.Input[_builtins.str] cluster_identifier: The cluster identifier. If omitted, the provider will assign a random, unique identifier.
        :param pulumi.Input[_builtins.str] cluster_identifier_prefix: Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_members: List of DocumentDB Instances that are a part of this cluster
        :param pulumi.Input[_builtins.str] cluster_resource_id: The DocumentDB Cluster Resource ID
        :param pulumi.Input[_builtins.str] db_cluster_parameter_group_name: A cluster parameter group to associate with the cluster.
        :param pulumi.Input[_builtins.str] db_subnet_group_name: A DB subnet group to associate with this DB instance.
        :param pulumi.Input[_builtins.bool] deletion_protection: A boolean value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cloudwatch_logs_exports: List of log types to export to cloudwatch. If omitted, no logs will be exported.
               The following log types are supported: `audit`, `profiler`.
        :param pulumi.Input[_builtins.str] endpoint: The DNS address of the DocumentDB instance
        :param pulumi.Input[_builtins.str] engine: The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
        :param pulumi.Input[_builtins.str] engine_version: The database engine version. Updating this argument results in an outage.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: The name of your final DB snapshot
               when this DB cluster is deleted. If omitted, no final snapshot will be
               made.
        :param pulumi.Input[_builtins.str] global_cluster_identifier: The global cluster identifier specified on `docdb.GlobalCluster`.
        :param pulumi.Input[_builtins.str] hosted_zone_id: The Route53 Hosted Zone ID of the endpoint
        :param pulumi.Input[_builtins.str] kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        :param pulumi.Input[_builtins.bool] manage_master_user_password: Set to `true` to allow Amazon DocumentDB to manage the master user password in AWS Secrets Manager. Cannot be set if `master_password` or `master_password_wo` is provided.
        :param pulumi.Input[_builtins.str] master_password: Password for the master DB user. Note that this may
               show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints. Conflicts with `master_password_wo` and `manage_master_user_password`.
        :param pulumi.Input[_builtins.str] master_username: Username for the master DB user.
        :param pulumi.Input[_builtins.int] port: The port on which the DB accepts connections
        :param pulumi.Input[_builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
               Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
        :param pulumi.Input[_builtins.str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
        :param pulumi.Input[_builtins.str] reader_endpoint: A read-only endpoint for the DocumentDB cluster, automatically load-balanced across replicas
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClusterRestoreToPointInTimeArgs', 'ClusterRestoreToPointInTimeArgsDict']] restore_to_point_in_time: A configuration block for restoring a DB instance to an arbitrary point in time. Requires the `identifier` argument to be set with the name of the new DB instance to be created. See Restore To Point In Time below for details.
        :param pulumi.Input[Union['ClusterServerlessV2ScalingConfigurationArgs', 'ClusterServerlessV2ScalingConfigurationArgsDict']] serverless_v2_scaling_configuration: Scaling configuration of an Amazon DocumentDB Serverless cluster. See Serverless V2 Scaling Configuration below for details.
        :param pulumi.Input[_builtins.bool] skip_final_snapshot: Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
        :param pulumi.Input[_builtins.str] snapshot_identifier: Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
        :param pulumi.Input[_builtins.bool] storage_encrypted: Specifies whether the DB cluster is encrypted. The default is `false`.
        :param pulumi.Input[_builtins.str] storage_type: The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: List of VPC security groups to associate
               with the Cluster
               
               For more detailed documentation about each argument, refer to
               the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/docdb/create-db-cluster.html).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["allow_major_version_upgrade"] = allow_major_version_upgrade
        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["backup_retention_period"] = backup_retention_period
        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["cluster_identifier_prefix"] = cluster_identifier_prefix
        __props__.__dict__["cluster_members"] = cluster_members
        __props__.__dict__["cluster_resource_id"] = cluster_resource_id
        __props__.__dict__["db_cluster_parameter_group_name"] = db_cluster_parameter_group_name
        __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["enabled_cloudwatch_logs_exports"] = enabled_cloudwatch_logs_exports
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
        __props__.__dict__["global_cluster_identifier"] = global_cluster_identifier
        __props__.__dict__["hosted_zone_id"] = hosted_zone_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["manage_master_user_password"] = manage_master_user_password
        __props__.__dict__["master_password"] = master_password
        __props__.__dict__["master_user_secrets"] = master_user_secrets
        __props__.__dict__["master_username"] = master_username
        __props__.__dict__["port"] = port
        __props__.__dict__["preferred_backup_window"] = preferred_backup_window
        __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
        __props__.__dict__["reader_endpoint"] = reader_endpoint
        __props__.__dict__["region"] = region
        __props__.__dict__["restore_to_point_in_time"] = restore_to_point_in_time
        __props__.__dict__["serverless_v2_scaling_configuration"] = serverless_v2_scaling_configuration
        __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
        __props__.__dict__["snapshot_identifier"] = snapshot_identifier
        __props__.__dict__["storage_encrypted"] = storage_encrypted
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowMajorVersionUpgrade")
    def allow_major_version_upgrade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
        """
        return pulumi.get(self, "allow_major_version_upgrade")

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether any cluster modifications
        are applied immediately, or during the next maintenance window. Default is
        `false`.
        """
        return pulumi.get(self, "apply_immediately")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of cluster
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of EC2 Availability Zones that instances in the DB cluster can be created in.
        DocumentDB automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next pulumi up.
        We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The days to retain backups for. Default `1`
        """
        return pulumi.get(self, "backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster identifier. If omitted, the provider will assign a random, unique identifier.
        """
        return pulumi.get(self, "cluster_identifier")

    @_builtins.property
    @pulumi.getter(name="clusterIdentifierPrefix")
    def cluster_identifier_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
        """
        return pulumi.get(self, "cluster_identifier_prefix")

    @_builtins.property
    @pulumi.getter(name="clusterMembers")
    def cluster_members(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of DocumentDB Instances that are a part of this cluster
        """
        return pulumi.get(self, "cluster_members")

    @_builtins.property
    @pulumi.getter(name="clusterResourceId")
    def cluster_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The DocumentDB Cluster Resource ID
        """
        return pulumi.get(self, "cluster_resource_id")

    @_builtins.property
    @pulumi.getter(name="dbClusterParameterGroupName")
    def db_cluster_parameter_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        A cluster parameter group to associate with the cluster.
        """
        return pulumi.get(self, "db_cluster_parameter_group_name")

    @_builtins.property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        A DB subnet group to associate with this DB instance.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="enabledCloudwatchLogsExports")
    def enabled_cloudwatch_logs_exports(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of log types to export to cloudwatch. If omitted, no logs will be exported.
        The following log types are supported: `audit`, `profiler`.
        """
        return pulumi.get(self, "enabled_cloudwatch_logs_exports")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The DNS address of the DocumentDB instance
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        The database engine version. Updating this argument results in an outage.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of your final DB snapshot
        when this DB cluster is deleted. If omitted, no final snapshot will be
        made.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @_builtins.property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The global cluster identifier specified on `docdb.GlobalCluster`.
        """
        return pulumi.get(self, "global_cluster_identifier")

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Route53 Hosted Zone ID of the endpoint
        """
        return pulumi.get(self, "hosted_zone_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to `true` to allow Amazon DocumentDB to manage the master user password in AWS Secrets Manager. Cannot be set if `master_password` or `master_password_wo` is provided.
        """
        return pulumi.get(self, "manage_master_user_password")

    @_builtins.property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password for the master DB user. Note that this may
        show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints. Conflicts with `master_password_wo` and `manage_master_user_password`.
        """
        return pulumi.get(self, "master_password")

    @_builtins.property
    @pulumi.getter(name="masterUserSecrets")
    def master_user_secrets(self) -> pulumi.Output[Sequence['outputs.ClusterMasterUserSecret']]:
        return pulumi.get(self, "master_user_secrets")

    @_builtins.property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Output[_builtins.str]:
        """
        Username for the master DB user.
        """
        return pulumi.get(self, "master_username")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The port on which the DB accepts connections
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[_builtins.str]:
        """
        The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
        Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
        """
        return pulumi.get(self, "preferred_backup_window")

    @_builtins.property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[_builtins.str]:
        """
        The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @_builtins.property
    @pulumi.getter(name="readerEndpoint")
    def reader_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        A read-only endpoint for the DocumentDB cluster, automatically load-balanced across replicas
        """
        return pulumi.get(self, "reader_endpoint")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="restoreToPointInTime")
    def restore_to_point_in_time(self) -> pulumi.Output[Optional['outputs.ClusterRestoreToPointInTime']]:
        """
        A configuration block for restoring a DB instance to an arbitrary point in time. Requires the `identifier` argument to be set with the name of the new DB instance to be created. See Restore To Point In Time below for details.
        """
        return pulumi.get(self, "restore_to_point_in_time")

    @_builtins.property
    @pulumi.getter(name="serverlessV2ScalingConfiguration")
    def serverless_v2_scaling_configuration(self) -> pulumi.Output[Optional['outputs.ClusterServerlessV2ScalingConfiguration']]:
        """
        Scaling configuration of an Amazon DocumentDB Serverless cluster. See Serverless V2 Scaling Configuration below for details.
        """
        return pulumi.get(self, "serverless_v2_scaling_configuration")

    @_builtins.property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @_builtins.property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
        """
        return pulumi.get(self, "snapshot_identifier")

    @_builtins.property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the DB cluster is encrypted. The default is `false`.
        """
        return pulumi.get(self, "storage_encrypted")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of VPC security groups to associate
        with the Cluster

        For more detailed documentation about each argument, refer to
        the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/docdb/create-db-cluster.html).
        """
        return pulumi.get(self, "vpc_security_group_ids")

