# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_properties: Optional[pulumi.Input['ClusterMultiRegionPropertiesArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ClusterTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled in this cluster.
               Default value is `false`.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroys cluster even if `deletion_protection_enabled` is set to `true`.
               Default value is `false`.
        :param pulumi.Input[_builtins.str] kms_encryption_key: The ARN of the AWS KMS key that encrypts data in the DSQL Cluster, or `"AWS_OWNED_KMS_KEY"`.
        :param pulumi.Input['ClusterMultiRegionPropertiesArgs'] multi_region_properties: Multi-region properties of the DSQL Cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Set of tags to be associated with the AWS DSQL Cluster resource.
        """
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if kms_encryption_key is not None:
            pulumi.set(__self__, "kms_encryption_key", kms_encryption_key)
        if multi_region_properties is not None:
            pulumi.set(__self__, "multi_region_properties", multi_region_properties)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether deletion protection is enabled in this cluster.
        Default value is `false`.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Destroys cluster even if `deletion_protection_enabled` is set to `true`.
        Default value is `false`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionKey")
    def kms_encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the AWS KMS key that encrypts data in the DSQL Cluster, or `"AWS_OWNED_KMS_KEY"`.
        """
        return pulumi.get(self, "kms_encryption_key")

    @kms_encryption_key.setter
    def kms_encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="multiRegionProperties")
    def multi_region_properties(self) -> Optional[pulumi.Input['ClusterMultiRegionPropertiesArgs']]:
        """
        Multi-region properties of the DSQL Cluster.
        """
        return pulumi.get(self, "multi_region_properties")

    @multi_region_properties.setter
    def multi_region_properties(self, value: Optional[pulumi.Input['ClusterMultiRegionPropertiesArgs']]):
        pulumi.set(self, "multi_region_properties", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of tags to be associated with the AWS DSQL Cluster resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ClusterTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ClusterTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_details: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEncryptionDetailArgs']]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_properties: Optional[pulumi.Input['ClusterMultiRegionPropertiesArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ClusterTimeoutsArgs']] = None,
                 vpc_endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled in this cluster.
               Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterEncryptionDetailArgs']]] encryption_details: Encryption configuration details for the DSQL Cluster.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroys cluster even if `deletion_protection_enabled` is set to `true`.
               Default value is `false`.
        :param pulumi.Input[_builtins.str] identifier: Cluster Identifier.
        :param pulumi.Input[_builtins.str] kms_encryption_key: The ARN of the AWS KMS key that encrypts data in the DSQL Cluster, or `"AWS_OWNED_KMS_KEY"`.
        :param pulumi.Input['ClusterMultiRegionPropertiesArgs'] multi_region_properties: Multi-region properties of the DSQL Cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Set of tags to be associated with the AWS DSQL Cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] vpc_endpoint_service_name: The DSQL Cluster's VPC endpoint service name.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if encryption_details is not None:
            pulumi.set(__self__, "encryption_details", encryption_details)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if kms_encryption_key is not None:
            pulumi.set(__self__, "kms_encryption_key", kms_encryption_key)
        if multi_region_properties is not None:
            pulumi.set(__self__, "multi_region_properties", multi_region_properties)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_endpoint_service_name is not None:
            pulumi.set(__self__, "vpc_endpoint_service_name", vpc_endpoint_service_name)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether deletion protection is enabled in this cluster.
        Default value is `false`.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionDetails")
    def encryption_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEncryptionDetailArgs']]]]:
        """
        Encryption configuration details for the DSQL Cluster.
        """
        return pulumi.get(self, "encryption_details")

    @encryption_details.setter
    def encryption_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEncryptionDetailArgs']]]]):
        pulumi.set(self, "encryption_details", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Destroys cluster even if `deletion_protection_enabled` is set to `true`.
        Default value is `false`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster Identifier.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionKey")
    def kms_encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the AWS KMS key that encrypts data in the DSQL Cluster, or `"AWS_OWNED_KMS_KEY"`.
        """
        return pulumi.get(self, "kms_encryption_key")

    @kms_encryption_key.setter
    def kms_encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="multiRegionProperties")
    def multi_region_properties(self) -> Optional[pulumi.Input['ClusterMultiRegionPropertiesArgs']]:
        """
        Multi-region properties of the DSQL Cluster.
        """
        return pulumi.get(self, "multi_region_properties")

    @multi_region_properties.setter
    def multi_region_properties(self, value: Optional[pulumi.Input['ClusterMultiRegionPropertiesArgs']]):
        pulumi.set(self, "multi_region_properties", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of tags to be associated with the AWS DSQL Cluster resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ClusterTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ClusterTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointServiceName")
    def vpc_endpoint_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DSQL Cluster's VPC endpoint service name.
        """
        return pulumi.get(self, "vpc_endpoint_service_name")

    @vpc_endpoint_service_name.setter
    def vpc_endpoint_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_endpoint_service_name", value)


@pulumi.type_token("aws:dsql/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_properties: Optional[pulumi.Input[Union['ClusterMultiRegionPropertiesArgs', 'ClusterMultiRegionPropertiesArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ClusterTimeoutsArgs', 'ClusterTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon Aurora DSQL Cluster.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dsql.Cluster("example",
            deletion_protection_enabled=True,
            tags={
                "Name": "TestCluster",
            })
        ```

        ## Import

        Using `pulumi import`, import DSQL Cluster using the `identifier`. For example:

        ```sh
        $ pulumi import aws:dsql/cluster:Cluster example abcde1f234ghijklmnop5qr6st
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled in this cluster.
               Default value is `false`.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroys cluster even if `deletion_protection_enabled` is set to `true`.
               Default value is `false`.
        :param pulumi.Input[_builtins.str] kms_encryption_key: The ARN of the AWS KMS key that encrypts data in the DSQL Cluster, or `"AWS_OWNED_KMS_KEY"`.
        :param pulumi.Input[Union['ClusterMultiRegionPropertiesArgs', 'ClusterMultiRegionPropertiesArgsDict']] multi_region_properties: Multi-region properties of the DSQL Cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Set of tags to be associated with the AWS DSQL Cluster resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon Aurora DSQL Cluster.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dsql.Cluster("example",
            deletion_protection_enabled=True,
            tags={
                "Name": "TestCluster",
            })
        ```

        ## Import

        Using `pulumi import`, import DSQL Cluster using the `identifier`. For example:

        ```sh
        $ pulumi import aws:dsql/cluster:Cluster example abcde1f234ghijklmnop5qr6st
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_properties: Optional[pulumi.Input[Union['ClusterMultiRegionPropertiesArgs', 'ClusterMultiRegionPropertiesArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ClusterTimeoutsArgs', 'ClusterTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["kms_encryption_key"] = kms_encryption_key
            __props__.__dict__["multi_region_properties"] = multi_region_properties
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["encryption_details"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_endpoint_service_name"] = None
        super(Cluster, __self__).__init__(
            'aws:dsql/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterEncryptionDetailArgs', 'ClusterEncryptionDetailArgsDict']]]]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
            multi_region_properties: Optional[pulumi.Input[Union['ClusterMultiRegionPropertiesArgs', 'ClusterMultiRegionPropertiesArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ClusterTimeoutsArgs', 'ClusterTimeoutsArgsDict']]] = None,
            vpc_endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled in this cluster.
               Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterEncryptionDetailArgs', 'ClusterEncryptionDetailArgsDict']]]] encryption_details: Encryption configuration details for the DSQL Cluster.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroys cluster even if `deletion_protection_enabled` is set to `true`.
               Default value is `false`.
        :param pulumi.Input[_builtins.str] identifier: Cluster Identifier.
        :param pulumi.Input[_builtins.str] kms_encryption_key: The ARN of the AWS KMS key that encrypts data in the DSQL Cluster, or `"AWS_OWNED_KMS_KEY"`.
        :param pulumi.Input[Union['ClusterMultiRegionPropertiesArgs', 'ClusterMultiRegionPropertiesArgsDict']] multi_region_properties: Multi-region properties of the DSQL Cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Set of tags to be associated with the AWS DSQL Cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] vpc_endpoint_service_name: The DSQL Cluster's VPC endpoint service name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["encryption_details"] = encryption_details
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["kms_encryption_key"] = kms_encryption_key
        __props__.__dict__["multi_region_properties"] = multi_region_properties
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["vpc_endpoint_service_name"] = vpc_endpoint_service_name
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether deletion protection is enabled in this cluster.
        Default value is `false`.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionDetails")
    def encryption_details(self) -> pulumi.Output[Sequence['outputs.ClusterEncryptionDetail']]:
        """
        Encryption configuration details for the DSQL Cluster.
        """
        return pulumi.get(self, "encryption_details")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[_builtins.bool]:
        """
        Destroys cluster even if `deletion_protection_enabled` is set to `true`.
        Default value is `false`.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster Identifier.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionKey")
    def kms_encryption_key(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the AWS KMS key that encrypts data in the DSQL Cluster, or `"AWS_OWNED_KMS_KEY"`.
        """
        return pulumi.get(self, "kms_encryption_key")

    @_builtins.property
    @pulumi.getter(name="multiRegionProperties")
    def multi_region_properties(self) -> pulumi.Output[Optional['outputs.ClusterMultiRegionProperties']]:
        """
        Multi-region properties of the DSQL Cluster.
        """
        return pulumi.get(self, "multi_region_properties")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of tags to be associated with the AWS DSQL Cluster resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ClusterTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointServiceName")
    def vpc_endpoint_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The DSQL Cluster's VPC endpoint service name.
        """
        return pulumi.get(self, "vpc_endpoint_service_name")

