# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCoipPoolResult',
    'AwaitableGetCoipPoolResult',
    'get_coip_pool',
    'get_coip_pool_output',
]

@pulumi.output_type
class GetCoipPoolResult:
    """
    A collection of values returned by getCoipPool.
    """
    def __init__(__self__, arn=None, filters=None, id=None, local_gateway_route_table_id=None, pool_cidrs=None, pool_id=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_gateway_route_table_id and not isinstance(local_gateway_route_table_id, str):
            raise TypeError("Expected argument 'local_gateway_route_table_id' to be a str")
        pulumi.set(__self__, "local_gateway_route_table_id", local_gateway_route_table_id)
        if pool_cidrs and not isinstance(pool_cidrs, list):
            raise TypeError("Expected argument 'pool_cidrs' to be a list")
        pulumi.set(__self__, "pool_cidrs", pool_cidrs)
        if pool_id and not isinstance(pool_id, str):
            raise TypeError("Expected argument 'pool_id' to be a str")
        pulumi.set(__self__, "pool_id", pool_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the COIP pool
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCoipPoolFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localGatewayRouteTableId")
    def local_gateway_route_table_id(self) -> _builtins.str:
        return pulumi.get(self, "local_gateway_route_table_id")

    @_builtins.property
    @pulumi.getter(name="poolCidrs")
    def pool_cidrs(self) -> Sequence[_builtins.str]:
        """
        Set of CIDR blocks in pool
        """
        return pulumi.get(self, "pool_cidrs")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> _builtins.str:
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetCoipPoolResult(GetCoipPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCoipPoolResult(
            arn=self.arn,
            filters=self.filters,
            id=self.id,
            local_gateway_route_table_id=self.local_gateway_route_table_id,
            pool_cidrs=self.pool_cidrs,
            pool_id=self.pool_id,
            region=self.region,
            tags=self.tags)


def get_coip_pool(filters: Optional[Sequence[Union['GetCoipPoolFilterArgs', 'GetCoipPoolFilterArgsDict']]] = None,
                  local_gateway_route_table_id: Optional[_builtins.str] = None,
                  pool_id: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  tags: Optional[Mapping[str, _builtins.str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCoipPoolResult:
    """
    Provides details about a specific EC2 Customer-Owned IP Pool.

    This data source can prove useful when a module accepts a coip pool id as
    an input variable and needs to, for example, determine the CIDR block of that
    COIP Pool.

    ## Example Usage

    The following example returns a specific coip pool ID


    :param _builtins.str local_gateway_route_table_id: Local Gateway Route Table Id assigned to desired COIP Pool
    :param _builtins.str pool_id: ID of the specific COIP Pool to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Mapping of tags, each pair of which must exactly match
           a pair on the desired COIP Pool.
           
           More complex filters can be expressed using one or more `filter` sub-blocks,
           which take the following arguments:
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['localGatewayRouteTableId'] = local_gateway_route_table_id
    __args__['poolId'] = pool_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getCoipPool:getCoipPool', __args__, opts=opts, typ=GetCoipPoolResult).value

    return AwaitableGetCoipPoolResult(
        arn=pulumi.get(__ret__, 'arn'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        local_gateway_route_table_id=pulumi.get(__ret__, 'local_gateway_route_table_id'),
        pool_cidrs=pulumi.get(__ret__, 'pool_cidrs'),
        pool_id=pulumi.get(__ret__, 'pool_id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_coip_pool_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCoipPoolFilterArgs', 'GetCoipPoolFilterArgsDict']]]]] = None,
                         local_gateway_route_table_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         pool_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCoipPoolResult]:
    """
    Provides details about a specific EC2 Customer-Owned IP Pool.

    This data source can prove useful when a module accepts a coip pool id as
    an input variable and needs to, for example, determine the CIDR block of that
    COIP Pool.

    ## Example Usage

    The following example returns a specific coip pool ID


    :param _builtins.str local_gateway_route_table_id: Local Gateway Route Table Id assigned to desired COIP Pool
    :param _builtins.str pool_id: ID of the specific COIP Pool to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Mapping of tags, each pair of which must exactly match
           a pair on the desired COIP Pool.
           
           More complex filters can be expressed using one or more `filter` sub-blocks,
           which take the following arguments:
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['localGatewayRouteTableId'] = local_gateway_route_table_id
    __args__['poolId'] = pool_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getCoipPool:getCoipPool', __args__, opts=opts, typ=GetCoipPoolResult)
    return __ret__.apply(lambda __response__: GetCoipPoolResult(
        arn=pulumi.get(__response__, 'arn'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        local_gateway_route_table_id=pulumi.get(__response__, 'local_gateway_route_table_id'),
        pool_cidrs=pulumi.get(__response__, 'pool_cidrs'),
        pool_id=pulumi.get(__response__, 'pool_id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
