# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstanceTypeOfferingResult',
    'AwaitableGetInstanceTypeOfferingResult',
    'get_instance_type_offering',
    'get_instance_type_offering_output',
]

@pulumi.output_type
class GetInstanceTypeOfferingResult:
    """
    A collection of values returned by getInstanceTypeOffering.
    """
    def __init__(__self__, filters=None, id=None, instance_type=None, location=None, location_type=None, preferred_instance_types=None, region=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if location_type and not isinstance(location_type, str):
            raise TypeError("Expected argument 'location_type' to be a str")
        pulumi.set(__self__, "location_type", location_type)
        if preferred_instance_types and not isinstance(preferred_instance_types, list):
            raise TypeError("Expected argument 'preferred_instance_types' to be a list")
        pulumi.set(__self__, "preferred_instance_types", preferred_instance_types)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstanceTypeOfferingFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        EC2 Instance Type.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Identifier for the location.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="locationType")
    def location_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "location_type")

    @_builtins.property
    @pulumi.getter(name="preferredInstanceTypes")
    def preferred_instance_types(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "preferred_instance_types")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetInstanceTypeOfferingResult(GetInstanceTypeOfferingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceTypeOfferingResult(
            filters=self.filters,
            id=self.id,
            instance_type=self.instance_type,
            location=self.location,
            location_type=self.location_type,
            preferred_instance_types=self.preferred_instance_types,
            region=self.region)


def get_instance_type_offering(filters: Optional[Sequence[Union['GetInstanceTypeOfferingFilterArgs', 'GetInstanceTypeOfferingFilterArgsDict']]] = None,
                               location_type: Optional[_builtins.str] = None,
                               preferred_instance_types: Optional[Sequence[_builtins.str]] = None,
                               region: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceTypeOfferingResult:
    """
    Information about single EC2 Instance Type Offering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_instance_type_offering(filters=[{
            "name": "instance-type",
            "values": [
                "t2.micro",
                "t3.micro",
            ],
        }],
        preferred_instance_types=[
            "t3.micro",
            "t2.micro",
        ])
    ```


    :param Sequence[Union['GetInstanceTypeOfferingFilterArgs', 'GetInstanceTypeOfferingFilterArgsDict']] filters: One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
    :param _builtins.str location_type: Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
    :param Sequence[_builtins.str] preferred_instance_types: Ordered list of preferred EC2 Instance Types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['locationType'] = location_type
    __args__['preferredInstanceTypes'] = preferred_instance_types
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getInstanceTypeOffering:getInstanceTypeOffering', __args__, opts=opts, typ=GetInstanceTypeOfferingResult).value

    return AwaitableGetInstanceTypeOfferingResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        location=pulumi.get(__ret__, 'location'),
        location_type=pulumi.get(__ret__, 'location_type'),
        preferred_instance_types=pulumi.get(__ret__, 'preferred_instance_types'),
        region=pulumi.get(__ret__, 'region'))
def get_instance_type_offering_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstanceTypeOfferingFilterArgs', 'GetInstanceTypeOfferingFilterArgsDict']]]]] = None,
                                      location_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      preferred_instance_types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceTypeOfferingResult]:
    """
    Information about single EC2 Instance Type Offering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_instance_type_offering(filters=[{
            "name": "instance-type",
            "values": [
                "t2.micro",
                "t3.micro",
            ],
        }],
        preferred_instance_types=[
            "t3.micro",
            "t2.micro",
        ])
    ```


    :param Sequence[Union['GetInstanceTypeOfferingFilterArgs', 'GetInstanceTypeOfferingFilterArgsDict']] filters: One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
    :param _builtins.str location_type: Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
    :param Sequence[_builtins.str] preferred_instance_types: Ordered list of preferred EC2 Instance Types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['locationType'] = location_type
    __args__['preferredInstanceTypes'] = preferred_instance_types
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getInstanceTypeOffering:getInstanceTypeOffering', __args__, opts=opts, typ=GetInstanceTypeOfferingResult)
    return __ret__.apply(lambda __response__: GetInstanceTypeOfferingResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instance_type=pulumi.get(__response__, 'instance_type'),
        location=pulumi.get(__response__, 'location'),
        location_type=pulumi.get(__response__, 'location_type'),
        preferred_instance_types=pulumi.get(__response__, 'preferred_instance_types'),
        region=pulumi.get(__response__, 'region')))
