# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLocalGatewayResult',
    'AwaitableGetLocalGatewayResult',
    'get_local_gateway',
    'get_local_gateway_output',
]

@pulumi.output_type
class GetLocalGatewayResult:
    """
    A collection of values returned by getLocalGateway.
    """
    def __init__(__self__, filters=None, id=None, outpost_arn=None, owner_id=None, region=None, state=None, tags=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if outpost_arn and not isinstance(outpost_arn, str):
            raise TypeError("Expected argument 'outpost_arn' to be a str")
        pulumi.set(__self__, "outpost_arn", outpost_arn)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLocalGatewayFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> _builtins.str:
        """
        ARN of Outpost
        """
        return pulumi.get(self, "outpost_arn")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        AWS account identifier that owns the Local Gateway.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the local gateway.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetLocalGatewayResult(GetLocalGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocalGatewayResult(
            filters=self.filters,
            id=self.id,
            outpost_arn=self.outpost_arn,
            owner_id=self.owner_id,
            region=self.region,
            state=self.state,
            tags=self.tags)


def get_local_gateway(filters: Optional[Sequence[Union['GetLocalGatewayFilterArgs', 'GetLocalGatewayFilterArgsDict']]] = None,
                      id: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      state: Optional[_builtins.str] = None,
                      tags: Optional[Mapping[str, _builtins.str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocalGatewayResult:
    """
    Provides details about an EC2 Local Gateway.

    ## Example Usage

    The following example shows how one might accept a local gateway id as a variable.

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    local_gateway_id = config.require_object("localGatewayId")
    selected = aws.ec2.get_local_gateway(id=local_gateway_id)
    ```


    :param Sequence[Union['GetLocalGatewayFilterArgs', 'GetLocalGatewayFilterArgsDict']] filters: Custom filter block as described below.
    :param _builtins.str id: Id of the specific Local Gateway to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str state: Current state of the desired Local Gateway.
           Can be either `"pending"` or `"available"`.
    :param Mapping[str, _builtins.str] tags: Mapping of tags, each pair of which must exactly match
           a pair on the desired Local Gateway.
           
           The arguments of this data source act as filters for querying the available
           Local Gateways in the current region. The given filters must match exactly one
           Local Gateway whose data will be exported as attributes.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['region'] = region
    __args__['state'] = state
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getLocalGateway:getLocalGateway', __args__, opts=opts, typ=GetLocalGatewayResult).value

    return AwaitableGetLocalGatewayResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        outpost_arn=pulumi.get(__ret__, 'outpost_arn'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        region=pulumi.get(__ret__, 'region'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_local_gateway_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLocalGatewayFilterArgs', 'GetLocalGatewayFilterArgsDict']]]]] = None,
                             id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocalGatewayResult]:
    """
    Provides details about an EC2 Local Gateway.

    ## Example Usage

    The following example shows how one might accept a local gateway id as a variable.

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    local_gateway_id = config.require_object("localGatewayId")
    selected = aws.ec2.get_local_gateway(id=local_gateway_id)
    ```


    :param Sequence[Union['GetLocalGatewayFilterArgs', 'GetLocalGatewayFilterArgsDict']] filters: Custom filter block as described below.
    :param _builtins.str id: Id of the specific Local Gateway to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str state: Current state of the desired Local Gateway.
           Can be either `"pending"` or `"available"`.
    :param Mapping[str, _builtins.str] tags: Mapping of tags, each pair of which must exactly match
           a pair on the desired Local Gateway.
           
           The arguments of this data source act as filters for querying the available
           Local Gateways in the current region. The given filters must match exactly one
           Local Gateway whose data will be exported as attributes.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['region'] = region
    __args__['state'] = state
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getLocalGateway:getLocalGateway', __args__, opts=opts, typ=GetLocalGatewayResult)
    return __ret__.apply(lambda __response__: GetLocalGatewayResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        outpost_arn=pulumi.get(__response__, 'outpost_arn'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        region=pulumi.get(__response__, 'region'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
