# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNatGatewayResult',
    'AwaitableGetNatGatewayResult',
    'get_nat_gateway',
    'get_nat_gateway_output',
]

@pulumi.output_type
class GetNatGatewayResult:
    """
    A collection of values returned by getNatGateway.
    """
    def __init__(__self__, allocation_id=None, association_id=None, connectivity_type=None, filters=None, id=None, network_interface_id=None, private_ip=None, public_ip=None, region=None, secondary_allocation_ids=None, secondary_private_ip_address_count=None, secondary_private_ip_addresses=None, state=None, subnet_id=None, tags=None, vpc_id=None):
        if allocation_id and not isinstance(allocation_id, str):
            raise TypeError("Expected argument 'allocation_id' to be a str")
        pulumi.set(__self__, "allocation_id", allocation_id)
        if association_id and not isinstance(association_id, str):
            raise TypeError("Expected argument 'association_id' to be a str")
        pulumi.set(__self__, "association_id", association_id)
        if connectivity_type and not isinstance(connectivity_type, str):
            raise TypeError("Expected argument 'connectivity_type' to be a str")
        pulumi.set(__self__, "connectivity_type", connectivity_type)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_interface_id and not isinstance(network_interface_id, str):
            raise TypeError("Expected argument 'network_interface_id' to be a str")
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secondary_allocation_ids and not isinstance(secondary_allocation_ids, list):
            raise TypeError("Expected argument 'secondary_allocation_ids' to be a list")
        pulumi.set(__self__, "secondary_allocation_ids", secondary_allocation_ids)
        if secondary_private_ip_address_count and not isinstance(secondary_private_ip_address_count, int):
            raise TypeError("Expected argument 'secondary_private_ip_address_count' to be a int")
        pulumi.set(__self__, "secondary_private_ip_address_count", secondary_private_ip_address_count)
        if secondary_private_ip_addresses and not isinstance(secondary_private_ip_addresses, list):
            raise TypeError("Expected argument 'secondary_private_ip_addresses' to be a list")
        pulumi.set(__self__, "secondary_private_ip_addresses", secondary_private_ip_addresses)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> _builtins.str:
        """
        ID of the EIP allocated to the selected NAT Gateway.
        """
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter(name="associationId")
    def association_id(self) -> _builtins.str:
        """
        The association ID of the Elastic IP address that's associated with the NAT Gateway. Only available when `connectivity_type` is `public`.
        """
        return pulumi.get(self, "association_id")

    @_builtins.property
    @pulumi.getter(name="connectivityType")
    def connectivity_type(self) -> _builtins.str:
        """
        Connectivity type of the NAT Gateway.
        """
        return pulumi.get(self, "connectivity_type")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNatGatewayFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> _builtins.str:
        """
        The ID of the ENI allocated to the selected NAT Gateway.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        Private IP address of the selected NAT Gateway.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        Public IP (EIP) address of the selected NAT Gateway.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secondaryAllocationIds")
    def secondary_allocation_ids(self) -> Sequence[_builtins.str]:
        """
        Secondary allocation EIP IDs for the selected NAT Gateway.
        """
        return pulumi.get(self, "secondary_allocation_ids")

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> _builtins.int:
        """
        The number of secondary private IPv4 addresses assigned to the selected NAT Gateway.
        """
        return pulumi.get(self, "secondary_private_ip_address_count")

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIpAddresses")
    def secondary_private_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        Secondary private IPv4 addresses assigned to the selected NAT Gateway.
        """
        return pulumi.get(self, "secondary_private_ip_addresses")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetNatGatewayResult(GetNatGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNatGatewayResult(
            allocation_id=self.allocation_id,
            association_id=self.association_id,
            connectivity_type=self.connectivity_type,
            filters=self.filters,
            id=self.id,
            network_interface_id=self.network_interface_id,
            private_ip=self.private_ip,
            public_ip=self.public_ip,
            region=self.region,
            secondary_allocation_ids=self.secondary_allocation_ids,
            secondary_private_ip_address_count=self.secondary_private_ip_address_count,
            secondary_private_ip_addresses=self.secondary_private_ip_addresses,
            state=self.state,
            subnet_id=self.subnet_id,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_nat_gateway(filters: Optional[Sequence[Union['GetNatGatewayFilterArgs', 'GetNatGatewayFilterArgsDict']]] = None,
                    id: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    state: Optional[_builtins.str] = None,
                    subnet_id: Optional[_builtins.str] = None,
                    tags: Optional[Mapping[str, _builtins.str]] = None,
                    vpc_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNatGatewayResult:
    """
    Provides details about a specific VPC NAT Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.ec2.get_nat_gateway(subnet_id=public["id"])
    ```

    ### With tags

    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.ec2.get_nat_gateway(subnet_id=public["id"],
        tags={
            "Name": "gw NAT",
        })
    ```


    :param Sequence[Union['GetNatGatewayFilterArgs', 'GetNatGatewayFilterArgsDict']] filters: Custom filter block as described below.
           
           The arguments of this data source act as filters for querying the available
           NAT Gateways in the current Region. The given filters must match exactly one
           NAT Gateway whose data will be exported as attributes.
    :param _builtins.str id: ID of the specific NAT Gateway to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str state: State of the NAT Gateway (pending | failed | available | deleting | deleted ).
    :param _builtins.str subnet_id: ID of subnet that the NAT Gateway resides in.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired NAT Gateway.
    :param _builtins.str vpc_id: ID of the VPC that the NAT Gateway resides in.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['region'] = region
    __args__['state'] = state
    __args__['subnetId'] = subnet_id
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getNatGateway:getNatGateway', __args__, opts=opts, typ=GetNatGatewayResult).value

    return AwaitableGetNatGatewayResult(
        allocation_id=pulumi.get(__ret__, 'allocation_id'),
        association_id=pulumi.get(__ret__, 'association_id'),
        connectivity_type=pulumi.get(__ret__, 'connectivity_type'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        network_interface_id=pulumi.get(__ret__, 'network_interface_id'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        public_ip=pulumi.get(__ret__, 'public_ip'),
        region=pulumi.get(__ret__, 'region'),
        secondary_allocation_ids=pulumi.get(__ret__, 'secondary_allocation_ids'),
        secondary_private_ip_address_count=pulumi.get(__ret__, 'secondary_private_ip_address_count'),
        secondary_private_ip_addresses=pulumi.get(__ret__, 'secondary_private_ip_addresses'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_nat_gateway_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNatGatewayFilterArgs', 'GetNatGatewayFilterArgsDict']]]]] = None,
                           id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                           vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNatGatewayResult]:
    """
    Provides details about a specific VPC NAT Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.ec2.get_nat_gateway(subnet_id=public["id"])
    ```

    ### With tags

    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.ec2.get_nat_gateway(subnet_id=public["id"],
        tags={
            "Name": "gw NAT",
        })
    ```


    :param Sequence[Union['GetNatGatewayFilterArgs', 'GetNatGatewayFilterArgsDict']] filters: Custom filter block as described below.
           
           The arguments of this data source act as filters for querying the available
           NAT Gateways in the current Region. The given filters must match exactly one
           NAT Gateway whose data will be exported as attributes.
    :param _builtins.str id: ID of the specific NAT Gateway to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str state: State of the NAT Gateway (pending | failed | available | deleting | deleted ).
    :param _builtins.str subnet_id: ID of subnet that the NAT Gateway resides in.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired NAT Gateway.
    :param _builtins.str vpc_id: ID of the VPC that the NAT Gateway resides in.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['region'] = region
    __args__['state'] = state
    __args__['subnetId'] = subnet_id
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getNatGateway:getNatGateway', __args__, opts=opts, typ=GetNatGatewayResult)
    return __ret__.apply(lambda __response__: GetNatGatewayResult(
        allocation_id=pulumi.get(__response__, 'allocation_id'),
        association_id=pulumi.get(__response__, 'association_id'),
        connectivity_type=pulumi.get(__response__, 'connectivity_type'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        network_interface_id=pulumi.get(__response__, 'network_interface_id'),
        private_ip=pulumi.get(__response__, 'private_ip'),
        public_ip=pulumi.get(__response__, 'public_ip'),
        region=pulumi.get(__response__, 'region'),
        secondary_allocation_ids=pulumi.get(__response__, 'secondary_allocation_ids'),
        secondary_private_ip_address_count=pulumi.get(__response__, 'secondary_private_ip_address_count'),
        secondary_private_ip_addresses=pulumi.get(__response__, 'secondary_private_ip_addresses'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
