# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPrefixListResult',
    'AwaitableGetPrefixListResult',
    'get_prefix_list',
    'get_prefix_list_output',
]

@pulumi.output_type
class GetPrefixListResult:
    """
    A collection of values returned by getPrefixList.
    """
    def __init__(__self__, cidr_blocks=None, filters=None, id=None, name=None, prefix_list_id=None, region=None):
        if cidr_blocks and not isinstance(cidr_blocks, list):
            raise TypeError("Expected argument 'cidr_blocks' to be a list")
        pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if prefix_list_id and not isinstance(prefix_list_id, str):
            raise TypeError("Expected argument 'prefix_list_id' to be a str")
        pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Sequence[_builtins.str]:
        """
        List of CIDR blocks for the AWS service associated with the prefix list.
        """
        return pulumi.get(self, "cidr_blocks")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPrefixListFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the selected prefix list.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "prefix_list_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetPrefixListResult(GetPrefixListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrefixListResult(
            cidr_blocks=self.cidr_blocks,
            filters=self.filters,
            id=self.id,
            name=self.name,
            prefix_list_id=self.prefix_list_id,
            region=self.region)


def get_prefix_list(filters: Optional[Sequence[Union['GetPrefixListFilterArgs', 'GetPrefixListFilterArgsDict']]] = None,
                    name: Optional[_builtins.str] = None,
                    prefix_list_id: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrefixListResult:
    """
    `ec2_get_prefix_list` provides details about a specific AWS prefix list (PL)
    in the current region.

    This can be used both to validate a prefix list given in a variable
    and to obtain the CIDR blocks (IP address ranges) for the associated
    AWS service. The latter may be useful e.g., for adding network ACL
    rules.

    The ec2.ManagedPrefixList data source is normally more appropriate to use given it can return customer-managed prefix list info, as well as additional attributes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    private_s3_vpc_endpoint = aws.ec2.VpcEndpoint("private_s3",
        vpc_id=foo["id"],
        service_name="com.amazonaws.us-west-2.s3")
    private_s3 = aws.ec2.get_prefix_list_output(prefix_list_id=private_s3_vpc_endpoint.prefix_list_id)
    bar = aws.ec2.NetworkAcl("bar", vpc_id=foo["id"])
    private_s3_network_acl_rule = aws.ec2.NetworkAclRule("private_s3",
        network_acl_id=bar.id,
        rule_number=200,
        egress=False,
        protocol="tcp",
        rule_action="allow",
        cidr_block=private_s3.cidr_blocks[0],
        from_port=443,
        to_port=443)
    ```

    ### Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2.get_prefix_list(filters=[{
        "name": "prefix-list-id",
        "values": ["pl-68a54001"],
    }])
    ```


    :param Sequence[Union['GetPrefixListFilterArgs', 'GetPrefixListFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
           
           The arguments of this data source act as filters for querying the available
           prefix lists. The given filters must match exactly one prefix list
           whose data will be exported as attributes.
    :param _builtins.str name: Name of the prefix list to select.
    :param _builtins.str prefix_list_id: ID of the prefix list to select.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['prefixListId'] = prefix_list_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getPrefixList:getPrefixList', __args__, opts=opts, typ=GetPrefixListResult).value

    return AwaitableGetPrefixListResult(
        cidr_blocks=pulumi.get(__ret__, 'cidr_blocks'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        prefix_list_id=pulumi.get(__ret__, 'prefix_list_id'),
        region=pulumi.get(__ret__, 'region'))
def get_prefix_list_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPrefixListFilterArgs', 'GetPrefixListFilterArgsDict']]]]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           prefix_list_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrefixListResult]:
    """
    `ec2_get_prefix_list` provides details about a specific AWS prefix list (PL)
    in the current region.

    This can be used both to validate a prefix list given in a variable
    and to obtain the CIDR blocks (IP address ranges) for the associated
    AWS service. The latter may be useful e.g., for adding network ACL
    rules.

    The ec2.ManagedPrefixList data source is normally more appropriate to use given it can return customer-managed prefix list info, as well as additional attributes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    private_s3_vpc_endpoint = aws.ec2.VpcEndpoint("private_s3",
        vpc_id=foo["id"],
        service_name="com.amazonaws.us-west-2.s3")
    private_s3 = aws.ec2.get_prefix_list_output(prefix_list_id=private_s3_vpc_endpoint.prefix_list_id)
    bar = aws.ec2.NetworkAcl("bar", vpc_id=foo["id"])
    private_s3_network_acl_rule = aws.ec2.NetworkAclRule("private_s3",
        network_acl_id=bar.id,
        rule_number=200,
        egress=False,
        protocol="tcp",
        rule_action="allow",
        cidr_block=private_s3.cidr_blocks[0],
        from_port=443,
        to_port=443)
    ```

    ### Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2.get_prefix_list(filters=[{
        "name": "prefix-list-id",
        "values": ["pl-68a54001"],
    }])
    ```


    :param Sequence[Union['GetPrefixListFilterArgs', 'GetPrefixListFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
           
           The arguments of this data source act as filters for querying the available
           prefix lists. The given filters must match exactly one prefix list
           whose data will be exported as attributes.
    :param _builtins.str name: Name of the prefix list to select.
    :param _builtins.str prefix_list_id: ID of the prefix list to select.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['prefixListId'] = prefix_list_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getPrefixList:getPrefixList', __args__, opts=opts, typ=GetPrefixListResult)
    return __ret__.apply(lambda __response__: GetPrefixListResult(
        cidr_blocks=pulumi.get(__response__, 'cidr_blocks'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        prefix_list_id=pulumi.get(__response__, 'prefix_list_id'),
        region=pulumi.get(__response__, 'region')))
