# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LaunchTemplateArgs', 'LaunchTemplate']

@pulumi.input_type
class LaunchTemplateArgs:
    def __init__(__self__, *,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateBlockDeviceMappingArgs']]]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input['LaunchTemplateCapacityReservationSpecificationArgs']] = None,
                 cpu_options: Optional[pulumi.Input['LaunchTemplateCpuOptionsArgs']] = None,
                 credit_specification: Optional[pulumi.Input['LaunchTemplateCreditSpecificationArgs']] = None,
                 default_version: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 enclave_options: Optional[pulumi.Input['LaunchTemplateEnclaveOptionsArgs']] = None,
                 hibernation_options: Optional[pulumi.Input['LaunchTemplateHibernationOptionsArgs']] = None,
                 iam_instance_profile: Optional[pulumi.Input['LaunchTemplateIamInstanceProfileArgs']] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_market_options: Optional[pulumi.Input['LaunchTemplateInstanceMarketOptionsArgs']] = None,
                 instance_requirements: Optional[pulumi.Input['LaunchTemplateInstanceRequirementsArgs']] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateLicenseSpecificationArgs']]]] = None,
                 maintenance_options: Optional[pulumi.Input['LaunchTemplateMaintenanceOptionsArgs']] = None,
                 metadata_options: Optional[pulumi.Input['LaunchTemplateMetadataOptionsArgs']] = None,
                 monitoring: Optional[pulumi.Input['LaunchTemplateMonitoringArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]] = None,
                 placement: Optional[pulumi.Input['LaunchTemplatePlacementArgs']] = None,
                 private_dns_name_options: Optional[pulumi.Input['LaunchTemplatePrivateDnsNameOptionsArgs']] = None,
                 ram_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateTagSpecificationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_default_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LaunchTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateBlockDeviceMappingArgs']]] block_device_mappings: Specify volumes to attach to the instance besides the volumes specified by the AMI.
               See Block Devices below for details.
        :param pulumi.Input['LaunchTemplateCapacityReservationSpecificationArgs'] capacity_reservation_specification: Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
        :param pulumi.Input['LaunchTemplateCpuOptionsArgs'] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input['LaunchTemplateCreditSpecificationArgs'] credit_specification: Customize the credit specification of the instance. See Credit
               Specification below for more details.
        :param pulumi.Input[_builtins.int] default_version: Default Version of the launch template.
        :param pulumi.Input[_builtins.str] description: Description of the launch template.
        :param pulumi.Input[_builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
        :param pulumi.Input[_builtins.bool] disable_api_termination: If `true`, enables [EC2 Instance
               Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
        :param pulumi.Input[_builtins.str] ebs_optimized: If `true`, the launched EC2 instance will be EBS-optimized.
        :param pulumi.Input['LaunchTemplateEnclaveOptionsArgs'] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input['LaunchTemplateHibernationOptionsArgs'] hibernation_options: The hibernation options for the instance. See Hibernation Options below for more details.
        :param pulumi.Input['LaunchTemplateIamInstanceProfileArgs'] iam_instance_profile: The IAM Instance Profile to launch the instance with. See Instance Profile
               below for more details.
        :param pulumi.Input[_builtins.str] image_id: The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
        :param pulumi.Input[_builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Can be `stop` or `terminate`.
               (Default: `stop`).
        :param pulumi.Input['LaunchTemplateInstanceMarketOptionsArgs'] instance_market_options: The market (purchasing) option for the instance. See Market Options
               below for details.
        :param pulumi.Input['LaunchTemplateInstanceRequirementsArgs'] instance_requirements: The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. If present then `instance_requirements` cannot be present.
        :param pulumi.Input[_builtins.str] kernel_id: The kernel ID.
        :param pulumi.Input[_builtins.str] key_name: The key name to use for the instance.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateLicenseSpecificationArgs']]] license_specifications: A list of license specifications to associate with. See License Specification below for more details.
        :param pulumi.Input['LaunchTemplateMaintenanceOptionsArgs'] maintenance_options: The maintenance options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input['LaunchTemplateMetadataOptionsArgs'] metadata_options: Customize the metadata options for the instance. See Metadata Options below for more details.
        :param pulumi.Input['LaunchTemplateMonitoringArgs'] monitoring: The monitoring option for the instance. See Monitoring below for more details.
        :param pulumi.Input[_builtins.str] name: The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network
               Interfaces below for more details.
        :param pulumi.Input['LaunchTemplatePlacementArgs'] placement: The placement of the instance. See Placement below for more details.
        :param pulumi.Input['LaunchTemplatePrivateDnsNameOptionsArgs'] private_dns_name_options: The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[_builtins.str] ram_disk_id: The ID of the RAM disk.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_names: A list of security group names to associate with. If you are creating Instances in a VPC, use
               `vpc_security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateTagSpecificationArgs']]] tag_specifications: The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] update_default_version: Whether to update Default Version each update. Conflicts with `default_version`.
        :param pulumi.Input[_builtins.str] user_data: The base64-encoded user data to provide when launching the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
        """
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if capacity_reservation_specification is not None:
            pulumi.set(__self__, "capacity_reservation_specification", capacity_reservation_specification)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if default_version is not None:
            pulumi.set(__self__, "default_version", default_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_api_stop is not None:
            pulumi.set(__self__, "disable_api_stop", disable_api_stop)
        if disable_api_termination is not None:
            pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if enclave_options is not None:
            pulumi.set(__self__, "enclave_options", enclave_options)
        if hibernation_options is not None:
            pulumi.set(__self__, "hibernation_options", hibernation_options)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_initiated_shutdown_behavior is not None:
            pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_market_options is not None:
            pulumi.set(__self__, "instance_market_options", instance_market_options)
        if instance_requirements is not None:
            pulumi.set(__self__, "instance_requirements", instance_requirements)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if kernel_id is not None:
            pulumi.set(__self__, "kernel_id", kernel_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if license_specifications is not None:
            pulumi.set(__self__, "license_specifications", license_specifications)
        if maintenance_options is not None:
            pulumi.set(__self__, "maintenance_options", maintenance_options)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if private_dns_name_options is not None:
            pulumi.set(__self__, "private_dns_name_options", private_dns_name_options)
        if ram_disk_id is not None:
            pulumi.set(__self__, "ram_disk_id", ram_disk_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_names is not None:
            pulumi.set(__self__, "security_group_names", security_group_names)
        if tag_specifications is not None:
            pulumi.set(__self__, "tag_specifications", tag_specifications)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_default_version is not None:
            pulumi.set(__self__, "update_default_version", update_default_version)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @_builtins.property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateBlockDeviceMappingArgs']]]]:
        """
        Specify volumes to attach to the instance besides the volumes specified by the AMI.
        See Block Devices below for details.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> Optional[pulumi.Input['LaunchTemplateCapacityReservationSpecificationArgs']]:
        """
        Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @capacity_reservation_specification.setter
    def capacity_reservation_specification(self, value: Optional[pulumi.Input['LaunchTemplateCapacityReservationSpecificationArgs']]):
        pulumi.set(self, "capacity_reservation_specification", value)

    @_builtins.property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['LaunchTemplateCpuOptionsArgs']]:
        """
        The CPU options for the instance. See CPU Options below for more details.
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['LaunchTemplateCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input['LaunchTemplateCreditSpecificationArgs']]:
        """
        Customize the credit specification of the instance. See Credit
        Specification below for more details.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input['LaunchTemplateCreditSpecificationArgs']]):
        pulumi.set(self, "credit_specification", value)

    @_builtins.property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default Version of the launch template.
        """
        return pulumi.get(self, "default_version")

    @default_version.setter
    def default_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the launch template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableApiStop")
    def disable_api_stop(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
        """
        return pulumi.get(self, "disable_api_stop")

    @disable_api_stop.setter
    def disable_api_stop(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_api_stop", value)

    @_builtins.property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, enables [EC2 Instance
        Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
        """
        return pulumi.get(self, "disable_api_termination")

    @disable_api_termination.setter
    def disable_api_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_api_termination", value)

    @_builtins.property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `true`, the launched EC2 instance will be EBS-optimized.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ebs_optimized", value)

    @_builtins.property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> Optional[pulumi.Input['LaunchTemplateEnclaveOptionsArgs']]:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @enclave_options.setter
    def enclave_options(self, value: Optional[pulumi.Input['LaunchTemplateEnclaveOptionsArgs']]):
        pulumi.set(self, "enclave_options", value)

    @_builtins.property
    @pulumi.getter(name="hibernationOptions")
    def hibernation_options(self) -> Optional[pulumi.Input['LaunchTemplateHibernationOptionsArgs']]:
        """
        The hibernation options for the instance. See Hibernation Options below for more details.
        """
        return pulumi.get(self, "hibernation_options")

    @hibernation_options.setter
    def hibernation_options(self, value: Optional[pulumi.Input['LaunchTemplateHibernationOptionsArgs']]):
        pulumi.set(self, "hibernation_options", value)

    @_builtins.property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input['LaunchTemplateIamInstanceProfileArgs']]:
        """
        The IAM Instance Profile to launch the instance with. See Instance Profile
        below for more details.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input['LaunchTemplateIamInstanceProfileArgs']]):
        pulumi.set(self, "iam_instance_profile", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shutdown behavior for the instance. Can be `stop` or `terminate`.
        (Default: `stop`).
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @instance_initiated_shutdown_behavior.setter
    def instance_initiated_shutdown_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_initiated_shutdown_behavior", value)

    @_builtins.property
    @pulumi.getter(name="instanceMarketOptions")
    def instance_market_options(self) -> Optional[pulumi.Input['LaunchTemplateInstanceMarketOptionsArgs']]:
        """
        The market (purchasing) option for the instance. See Market Options
        below for details.
        """
        return pulumi.get(self, "instance_market_options")

    @instance_market_options.setter
    def instance_market_options(self, value: Optional[pulumi.Input['LaunchTemplateInstanceMarketOptionsArgs']]):
        pulumi.set(self, "instance_market_options", value)

    @_builtins.property
    @pulumi.getter(name="instanceRequirements")
    def instance_requirements(self) -> Optional[pulumi.Input['LaunchTemplateInstanceRequirementsArgs']]:
        """
        The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
        """
        return pulumi.get(self, "instance_requirements")

    @instance_requirements.setter
    def instance_requirements(self, value: Optional[pulumi.Input['LaunchTemplateInstanceRequirementsArgs']]):
        pulumi.set(self, "instance_requirements", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance. If present then `instance_requirements` cannot be present.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kernel ID.
        """
        return pulumi.get(self, "kernel_id")

    @kernel_id.setter
    def kernel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kernel_id", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key name to use for the instance.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="licenseSpecifications")
    def license_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateLicenseSpecificationArgs']]]]:
        """
        A list of license specifications to associate with. See License Specification below for more details.
        """
        return pulumi.get(self, "license_specifications")

    @license_specifications.setter
    def license_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateLicenseSpecificationArgs']]]]):
        pulumi.set(self, "license_specifications", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceOptions")
    def maintenance_options(self) -> Optional[pulumi.Input['LaunchTemplateMaintenanceOptionsArgs']]:
        """
        The maintenance options for the instance. See Maintenance Options below for more details.
        """
        return pulumi.get(self, "maintenance_options")

    @maintenance_options.setter
    def maintenance_options(self, value: Optional[pulumi.Input['LaunchTemplateMaintenanceOptionsArgs']]):
        pulumi.set(self, "maintenance_options", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['LaunchTemplateMetadataOptionsArgs']]:
        """
        Customize the metadata options for the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['LaunchTemplateMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input['LaunchTemplateMonitoringArgs']]:
        """
        The monitoring option for the instance. See Monitoring below for more details.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input['LaunchTemplateMonitoringArgs']]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]]:
        """
        Customize network interfaces to be attached at instance boot time. See Network
        Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['LaunchTemplatePlacementArgs']]:
        """
        The placement of the instance. See Placement below for more details.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['LaunchTemplatePlacementArgs']]):
        pulumi.set(self, "placement", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> Optional[pulumi.Input['LaunchTemplatePrivateDnsNameOptionsArgs']]:
        """
        The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        """
        return pulumi.get(self, "private_dns_name_options")

    @private_dns_name_options.setter
    def private_dns_name_options(self, value: Optional[pulumi.Input['LaunchTemplatePrivateDnsNameOptionsArgs']]):
        pulumi.set(self, "private_dns_name_options", value)

    @_builtins.property
    @pulumi.getter(name="ramDiskId")
    def ram_disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the RAM disk.
        """
        return pulumi.get(self, "ram_disk_id")

    @ram_disk_id.setter
    def ram_disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_disk_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupNames")
    def security_group_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security group names to associate with. If you are creating Instances in a VPC, use
        `vpc_security_group_ids` instead.
        """
        return pulumi.get(self, "security_group_names")

    @security_group_names.setter
    def security_group_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_names", value)

    @_builtins.property
    @pulumi.getter(name="tagSpecifications")
    def tag_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateTagSpecificationArgs']]]]:
        """
        The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
        """
        return pulumi.get(self, "tag_specifications")

    @tag_specifications.setter
    def tag_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateTagSpecificationArgs']]]]):
        pulumi.set(self, "tag_specifications", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updateDefaultVersion")
    def update_default_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to update Default Version each update. Conflicts with `default_version`.
        """
        return pulumi.get(self, "update_default_version")

    @update_default_version.setter
    def update_default_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_default_version", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded user data to provide when launching the instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.input_type
class _LaunchTemplateState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateBlockDeviceMappingArgs']]]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input['LaunchTemplateCapacityReservationSpecificationArgs']] = None,
                 cpu_options: Optional[pulumi.Input['LaunchTemplateCpuOptionsArgs']] = None,
                 credit_specification: Optional[pulumi.Input['LaunchTemplateCreditSpecificationArgs']] = None,
                 default_version: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 enclave_options: Optional[pulumi.Input['LaunchTemplateEnclaveOptionsArgs']] = None,
                 hibernation_options: Optional[pulumi.Input['LaunchTemplateHibernationOptionsArgs']] = None,
                 iam_instance_profile: Optional[pulumi.Input['LaunchTemplateIamInstanceProfileArgs']] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_market_options: Optional[pulumi.Input['LaunchTemplateInstanceMarketOptionsArgs']] = None,
                 instance_requirements: Optional[pulumi.Input['LaunchTemplateInstanceRequirementsArgs']] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_version: Optional[pulumi.Input[_builtins.int]] = None,
                 license_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateLicenseSpecificationArgs']]]] = None,
                 maintenance_options: Optional[pulumi.Input['LaunchTemplateMaintenanceOptionsArgs']] = None,
                 metadata_options: Optional[pulumi.Input['LaunchTemplateMetadataOptionsArgs']] = None,
                 monitoring: Optional[pulumi.Input['LaunchTemplateMonitoringArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]] = None,
                 placement: Optional[pulumi.Input['LaunchTemplatePlacementArgs']] = None,
                 private_dns_name_options: Optional[pulumi.Input['LaunchTemplatePrivateDnsNameOptionsArgs']] = None,
                 ram_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateTagSpecificationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_default_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LaunchTemplate resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateBlockDeviceMappingArgs']]] block_device_mappings: Specify volumes to attach to the instance besides the volumes specified by the AMI.
               See Block Devices below for details.
        :param pulumi.Input['LaunchTemplateCapacityReservationSpecificationArgs'] capacity_reservation_specification: Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
        :param pulumi.Input['LaunchTemplateCpuOptionsArgs'] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input['LaunchTemplateCreditSpecificationArgs'] credit_specification: Customize the credit specification of the instance. See Credit
               Specification below for more details.
        :param pulumi.Input[_builtins.int] default_version: Default Version of the launch template.
        :param pulumi.Input[_builtins.str] description: Description of the launch template.
        :param pulumi.Input[_builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
        :param pulumi.Input[_builtins.bool] disable_api_termination: If `true`, enables [EC2 Instance
               Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
        :param pulumi.Input[_builtins.str] ebs_optimized: If `true`, the launched EC2 instance will be EBS-optimized.
        :param pulumi.Input['LaunchTemplateEnclaveOptionsArgs'] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input['LaunchTemplateHibernationOptionsArgs'] hibernation_options: The hibernation options for the instance. See Hibernation Options below for more details.
        :param pulumi.Input['LaunchTemplateIamInstanceProfileArgs'] iam_instance_profile: The IAM Instance Profile to launch the instance with. See Instance Profile
               below for more details.
        :param pulumi.Input[_builtins.str] image_id: The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
        :param pulumi.Input[_builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Can be `stop` or `terminate`.
               (Default: `stop`).
        :param pulumi.Input['LaunchTemplateInstanceMarketOptionsArgs'] instance_market_options: The market (purchasing) option for the instance. See Market Options
               below for details.
        :param pulumi.Input['LaunchTemplateInstanceRequirementsArgs'] instance_requirements: The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. If present then `instance_requirements` cannot be present.
        :param pulumi.Input[_builtins.str] kernel_id: The kernel ID.
        :param pulumi.Input[_builtins.str] key_name: The key name to use for the instance.
        :param pulumi.Input[_builtins.int] latest_version: The latest version of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateLicenseSpecificationArgs']]] license_specifications: A list of license specifications to associate with. See License Specification below for more details.
        :param pulumi.Input['LaunchTemplateMaintenanceOptionsArgs'] maintenance_options: The maintenance options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input['LaunchTemplateMetadataOptionsArgs'] metadata_options: Customize the metadata options for the instance. See Metadata Options below for more details.
        :param pulumi.Input['LaunchTemplateMonitoringArgs'] monitoring: The monitoring option for the instance. See Monitoring below for more details.
        :param pulumi.Input[_builtins.str] name: The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network
               Interfaces below for more details.
        :param pulumi.Input['LaunchTemplatePlacementArgs'] placement: The placement of the instance. See Placement below for more details.
        :param pulumi.Input['LaunchTemplatePrivateDnsNameOptionsArgs'] private_dns_name_options: The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[_builtins.str] ram_disk_id: The ID of the RAM disk.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_names: A list of security group names to associate with. If you are creating Instances in a VPC, use
               `vpc_security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateTagSpecificationArgs']]] tag_specifications: The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] update_default_version: Whether to update Default Version each update. Conflicts with `default_version`.
        :param pulumi.Input[_builtins.str] user_data: The base64-encoded user data to provide when launching the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if capacity_reservation_specification is not None:
            pulumi.set(__self__, "capacity_reservation_specification", capacity_reservation_specification)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if default_version is not None:
            pulumi.set(__self__, "default_version", default_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_api_stop is not None:
            pulumi.set(__self__, "disable_api_stop", disable_api_stop)
        if disable_api_termination is not None:
            pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if enclave_options is not None:
            pulumi.set(__self__, "enclave_options", enclave_options)
        if hibernation_options is not None:
            pulumi.set(__self__, "hibernation_options", hibernation_options)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_initiated_shutdown_behavior is not None:
            pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_market_options is not None:
            pulumi.set(__self__, "instance_market_options", instance_market_options)
        if instance_requirements is not None:
            pulumi.set(__self__, "instance_requirements", instance_requirements)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if kernel_id is not None:
            pulumi.set(__self__, "kernel_id", kernel_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if license_specifications is not None:
            pulumi.set(__self__, "license_specifications", license_specifications)
        if maintenance_options is not None:
            pulumi.set(__self__, "maintenance_options", maintenance_options)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if private_dns_name_options is not None:
            pulumi.set(__self__, "private_dns_name_options", private_dns_name_options)
        if ram_disk_id is not None:
            pulumi.set(__self__, "ram_disk_id", ram_disk_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_names is not None:
            pulumi.set(__self__, "security_group_names", security_group_names)
        if tag_specifications is not None:
            pulumi.set(__self__, "tag_specifications", tag_specifications)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if update_default_version is not None:
            pulumi.set(__self__, "update_default_version", update_default_version)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the launch template.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateBlockDeviceMappingArgs']]]]:
        """
        Specify volumes to attach to the instance besides the volumes specified by the AMI.
        See Block Devices below for details.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> Optional[pulumi.Input['LaunchTemplateCapacityReservationSpecificationArgs']]:
        """
        Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @capacity_reservation_specification.setter
    def capacity_reservation_specification(self, value: Optional[pulumi.Input['LaunchTemplateCapacityReservationSpecificationArgs']]):
        pulumi.set(self, "capacity_reservation_specification", value)

    @_builtins.property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['LaunchTemplateCpuOptionsArgs']]:
        """
        The CPU options for the instance. See CPU Options below for more details.
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['LaunchTemplateCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input['LaunchTemplateCreditSpecificationArgs']]:
        """
        Customize the credit specification of the instance. See Credit
        Specification below for more details.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input['LaunchTemplateCreditSpecificationArgs']]):
        pulumi.set(self, "credit_specification", value)

    @_builtins.property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default Version of the launch template.
        """
        return pulumi.get(self, "default_version")

    @default_version.setter
    def default_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the launch template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableApiStop")
    def disable_api_stop(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
        """
        return pulumi.get(self, "disable_api_stop")

    @disable_api_stop.setter
    def disable_api_stop(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_api_stop", value)

    @_builtins.property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, enables [EC2 Instance
        Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
        """
        return pulumi.get(self, "disable_api_termination")

    @disable_api_termination.setter
    def disable_api_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_api_termination", value)

    @_builtins.property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `true`, the launched EC2 instance will be EBS-optimized.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ebs_optimized", value)

    @_builtins.property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> Optional[pulumi.Input['LaunchTemplateEnclaveOptionsArgs']]:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @enclave_options.setter
    def enclave_options(self, value: Optional[pulumi.Input['LaunchTemplateEnclaveOptionsArgs']]):
        pulumi.set(self, "enclave_options", value)

    @_builtins.property
    @pulumi.getter(name="hibernationOptions")
    def hibernation_options(self) -> Optional[pulumi.Input['LaunchTemplateHibernationOptionsArgs']]:
        """
        The hibernation options for the instance. See Hibernation Options below for more details.
        """
        return pulumi.get(self, "hibernation_options")

    @hibernation_options.setter
    def hibernation_options(self, value: Optional[pulumi.Input['LaunchTemplateHibernationOptionsArgs']]):
        pulumi.set(self, "hibernation_options", value)

    @_builtins.property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input['LaunchTemplateIamInstanceProfileArgs']]:
        """
        The IAM Instance Profile to launch the instance with. See Instance Profile
        below for more details.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input['LaunchTemplateIamInstanceProfileArgs']]):
        pulumi.set(self, "iam_instance_profile", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shutdown behavior for the instance. Can be `stop` or `terminate`.
        (Default: `stop`).
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @instance_initiated_shutdown_behavior.setter
    def instance_initiated_shutdown_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_initiated_shutdown_behavior", value)

    @_builtins.property
    @pulumi.getter(name="instanceMarketOptions")
    def instance_market_options(self) -> Optional[pulumi.Input['LaunchTemplateInstanceMarketOptionsArgs']]:
        """
        The market (purchasing) option for the instance. See Market Options
        below for details.
        """
        return pulumi.get(self, "instance_market_options")

    @instance_market_options.setter
    def instance_market_options(self, value: Optional[pulumi.Input['LaunchTemplateInstanceMarketOptionsArgs']]):
        pulumi.set(self, "instance_market_options", value)

    @_builtins.property
    @pulumi.getter(name="instanceRequirements")
    def instance_requirements(self) -> Optional[pulumi.Input['LaunchTemplateInstanceRequirementsArgs']]:
        """
        The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
        """
        return pulumi.get(self, "instance_requirements")

    @instance_requirements.setter
    def instance_requirements(self, value: Optional[pulumi.Input['LaunchTemplateInstanceRequirementsArgs']]):
        pulumi.set(self, "instance_requirements", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance. If present then `instance_requirements` cannot be present.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kernel ID.
        """
        return pulumi.get(self, "kernel_id")

    @kernel_id.setter
    def kernel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kernel_id", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key name to use for the instance.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The latest version of the launch template.
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "latest_version", value)

    @_builtins.property
    @pulumi.getter(name="licenseSpecifications")
    def license_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateLicenseSpecificationArgs']]]]:
        """
        A list of license specifications to associate with. See License Specification below for more details.
        """
        return pulumi.get(self, "license_specifications")

    @license_specifications.setter
    def license_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateLicenseSpecificationArgs']]]]):
        pulumi.set(self, "license_specifications", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceOptions")
    def maintenance_options(self) -> Optional[pulumi.Input['LaunchTemplateMaintenanceOptionsArgs']]:
        """
        The maintenance options for the instance. See Maintenance Options below for more details.
        """
        return pulumi.get(self, "maintenance_options")

    @maintenance_options.setter
    def maintenance_options(self, value: Optional[pulumi.Input['LaunchTemplateMaintenanceOptionsArgs']]):
        pulumi.set(self, "maintenance_options", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['LaunchTemplateMetadataOptionsArgs']]:
        """
        Customize the metadata options for the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['LaunchTemplateMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input['LaunchTemplateMonitoringArgs']]:
        """
        The monitoring option for the instance. See Monitoring below for more details.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input['LaunchTemplateMonitoringArgs']]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]]:
        """
        Customize network interfaces to be attached at instance boot time. See Network
        Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['LaunchTemplatePlacementArgs']]:
        """
        The placement of the instance. See Placement below for more details.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['LaunchTemplatePlacementArgs']]):
        pulumi.set(self, "placement", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> Optional[pulumi.Input['LaunchTemplatePrivateDnsNameOptionsArgs']]:
        """
        The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        """
        return pulumi.get(self, "private_dns_name_options")

    @private_dns_name_options.setter
    def private_dns_name_options(self, value: Optional[pulumi.Input['LaunchTemplatePrivateDnsNameOptionsArgs']]):
        pulumi.set(self, "private_dns_name_options", value)

    @_builtins.property
    @pulumi.getter(name="ramDiskId")
    def ram_disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the RAM disk.
        """
        return pulumi.get(self, "ram_disk_id")

    @ram_disk_id.setter
    def ram_disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_disk_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupNames")
    def security_group_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security group names to associate with. If you are creating Instances in a VPC, use
        `vpc_security_group_ids` instead.
        """
        return pulumi.get(self, "security_group_names")

    @security_group_names.setter
    def security_group_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_names", value)

    @_builtins.property
    @pulumi.getter(name="tagSpecifications")
    def tag_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateTagSpecificationArgs']]]]:
        """
        The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
        """
        return pulumi.get(self, "tag_specifications")

    @tag_specifications.setter
    def tag_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateTagSpecificationArgs']]]]):
        pulumi.set(self, "tag_specifications", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="updateDefaultVersion")
    def update_default_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to update Default Version each update. Conflicts with `default_version`.
        """
        return pulumi.get(self, "update_default_version")

    @update_default_version.setter
    def update_default_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_default_version", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded user data to provide when launching the instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.type_token("aws:ec2/launchTemplate:LaunchTemplate")
class LaunchTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateBlockDeviceMappingArgs', 'LaunchTemplateBlockDeviceMappingArgsDict']]]]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input[Union['LaunchTemplateCapacityReservationSpecificationArgs', 'LaunchTemplateCapacityReservationSpecificationArgsDict']]] = None,
                 cpu_options: Optional[pulumi.Input[Union['LaunchTemplateCpuOptionsArgs', 'LaunchTemplateCpuOptionsArgsDict']]] = None,
                 credit_specification: Optional[pulumi.Input[Union['LaunchTemplateCreditSpecificationArgs', 'LaunchTemplateCreditSpecificationArgsDict']]] = None,
                 default_version: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 enclave_options: Optional[pulumi.Input[Union['LaunchTemplateEnclaveOptionsArgs', 'LaunchTemplateEnclaveOptionsArgsDict']]] = None,
                 hibernation_options: Optional[pulumi.Input[Union['LaunchTemplateHibernationOptionsArgs', 'LaunchTemplateHibernationOptionsArgsDict']]] = None,
                 iam_instance_profile: Optional[pulumi.Input[Union['LaunchTemplateIamInstanceProfileArgs', 'LaunchTemplateIamInstanceProfileArgsDict']]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_market_options: Optional[pulumi.Input[Union['LaunchTemplateInstanceMarketOptionsArgs', 'LaunchTemplateInstanceMarketOptionsArgsDict']]] = None,
                 instance_requirements: Optional[pulumi.Input[Union['LaunchTemplateInstanceRequirementsArgs', 'LaunchTemplateInstanceRequirementsArgsDict']]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateLicenseSpecificationArgs', 'LaunchTemplateLicenseSpecificationArgsDict']]]]] = None,
                 maintenance_options: Optional[pulumi.Input[Union['LaunchTemplateMaintenanceOptionsArgs', 'LaunchTemplateMaintenanceOptionsArgsDict']]] = None,
                 metadata_options: Optional[pulumi.Input[Union['LaunchTemplateMetadataOptionsArgs', 'LaunchTemplateMetadataOptionsArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[Union['LaunchTemplateMonitoringArgs', 'LaunchTemplateMonitoringArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateNetworkInterfaceArgs', 'LaunchTemplateNetworkInterfaceArgsDict']]]]] = None,
                 placement: Optional[pulumi.Input[Union['LaunchTemplatePlacementArgs', 'LaunchTemplatePlacementArgsDict']]] = None,
                 private_dns_name_options: Optional[pulumi.Input[Union['LaunchTemplatePrivateDnsNameOptionsArgs', 'LaunchTemplatePrivateDnsNameOptionsArgsDict']]] = None,
                 ram_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateTagSpecificationArgs', 'LaunchTemplateTagSpecificationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_default_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an EC2 launch template resource. Can be used to create instances or auto scaling groups.

        ## Import

        Using `pulumi import`, import Launch Templates using the `id`. For example:

        ```sh
        $ pulumi import aws:ec2/launchTemplate:LaunchTemplate web lt-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateBlockDeviceMappingArgs', 'LaunchTemplateBlockDeviceMappingArgsDict']]]] block_device_mappings: Specify volumes to attach to the instance besides the volumes specified by the AMI.
               See Block Devices below for details.
        :param pulumi.Input[Union['LaunchTemplateCapacityReservationSpecificationArgs', 'LaunchTemplateCapacityReservationSpecificationArgsDict']] capacity_reservation_specification: Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[Union['LaunchTemplateCpuOptionsArgs', 'LaunchTemplateCpuOptionsArgsDict']] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateCreditSpecificationArgs', 'LaunchTemplateCreditSpecificationArgsDict']] credit_specification: Customize the credit specification of the instance. See Credit
               Specification below for more details.
        :param pulumi.Input[_builtins.int] default_version: Default Version of the launch template.
        :param pulumi.Input[_builtins.str] description: Description of the launch template.
        :param pulumi.Input[_builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
        :param pulumi.Input[_builtins.bool] disable_api_termination: If `true`, enables [EC2 Instance
               Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
        :param pulumi.Input[_builtins.str] ebs_optimized: If `true`, the launched EC2 instance will be EBS-optimized.
        :param pulumi.Input[Union['LaunchTemplateEnclaveOptionsArgs', 'LaunchTemplateEnclaveOptionsArgsDict']] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateHibernationOptionsArgs', 'LaunchTemplateHibernationOptionsArgsDict']] hibernation_options: The hibernation options for the instance. See Hibernation Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateIamInstanceProfileArgs', 'LaunchTemplateIamInstanceProfileArgsDict']] iam_instance_profile: The IAM Instance Profile to launch the instance with. See Instance Profile
               below for more details.
        :param pulumi.Input[_builtins.str] image_id: The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
        :param pulumi.Input[_builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Can be `stop` or `terminate`.
               (Default: `stop`).
        :param pulumi.Input[Union['LaunchTemplateInstanceMarketOptionsArgs', 'LaunchTemplateInstanceMarketOptionsArgsDict']] instance_market_options: The market (purchasing) option for the instance. See Market Options
               below for details.
        :param pulumi.Input[Union['LaunchTemplateInstanceRequirementsArgs', 'LaunchTemplateInstanceRequirementsArgsDict']] instance_requirements: The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. If present then `instance_requirements` cannot be present.
        :param pulumi.Input[_builtins.str] kernel_id: The kernel ID.
        :param pulumi.Input[_builtins.str] key_name: The key name to use for the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateLicenseSpecificationArgs', 'LaunchTemplateLicenseSpecificationArgsDict']]]] license_specifications: A list of license specifications to associate with. See License Specification below for more details.
        :param pulumi.Input[Union['LaunchTemplateMaintenanceOptionsArgs', 'LaunchTemplateMaintenanceOptionsArgsDict']] maintenance_options: The maintenance options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateMetadataOptionsArgs', 'LaunchTemplateMetadataOptionsArgsDict']] metadata_options: Customize the metadata options for the instance. See Metadata Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateMonitoringArgs', 'LaunchTemplateMonitoringArgsDict']] monitoring: The monitoring option for the instance. See Monitoring below for more details.
        :param pulumi.Input[_builtins.str] name: The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateNetworkInterfaceArgs', 'LaunchTemplateNetworkInterfaceArgsDict']]]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network
               Interfaces below for more details.
        :param pulumi.Input[Union['LaunchTemplatePlacementArgs', 'LaunchTemplatePlacementArgsDict']] placement: The placement of the instance. See Placement below for more details.
        :param pulumi.Input[Union['LaunchTemplatePrivateDnsNameOptionsArgs', 'LaunchTemplatePrivateDnsNameOptionsArgsDict']] private_dns_name_options: The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[_builtins.str] ram_disk_id: The ID of the RAM disk.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_names: A list of security group names to associate with. If you are creating Instances in a VPC, use
               `vpc_security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateTagSpecificationArgs', 'LaunchTemplateTagSpecificationArgsDict']]]] tag_specifications: The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] update_default_version: Whether to update Default Version each update. Conflicts with `default_version`.
        :param pulumi.Input[_builtins.str] user_data: The base64-encoded user data to provide when launching the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LaunchTemplateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EC2 launch template resource. Can be used to create instances or auto scaling groups.

        ## Import

        Using `pulumi import`, import Launch Templates using the `id`. For example:

        ```sh
        $ pulumi import aws:ec2/launchTemplate:LaunchTemplate web lt-12345678
        ```

        :param str resource_name: The name of the resource.
        :param LaunchTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LaunchTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateBlockDeviceMappingArgs', 'LaunchTemplateBlockDeviceMappingArgsDict']]]]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input[Union['LaunchTemplateCapacityReservationSpecificationArgs', 'LaunchTemplateCapacityReservationSpecificationArgsDict']]] = None,
                 cpu_options: Optional[pulumi.Input[Union['LaunchTemplateCpuOptionsArgs', 'LaunchTemplateCpuOptionsArgsDict']]] = None,
                 credit_specification: Optional[pulumi.Input[Union['LaunchTemplateCreditSpecificationArgs', 'LaunchTemplateCreditSpecificationArgsDict']]] = None,
                 default_version: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 enclave_options: Optional[pulumi.Input[Union['LaunchTemplateEnclaveOptionsArgs', 'LaunchTemplateEnclaveOptionsArgsDict']]] = None,
                 hibernation_options: Optional[pulumi.Input[Union['LaunchTemplateHibernationOptionsArgs', 'LaunchTemplateHibernationOptionsArgsDict']]] = None,
                 iam_instance_profile: Optional[pulumi.Input[Union['LaunchTemplateIamInstanceProfileArgs', 'LaunchTemplateIamInstanceProfileArgsDict']]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_market_options: Optional[pulumi.Input[Union['LaunchTemplateInstanceMarketOptionsArgs', 'LaunchTemplateInstanceMarketOptionsArgsDict']]] = None,
                 instance_requirements: Optional[pulumi.Input[Union['LaunchTemplateInstanceRequirementsArgs', 'LaunchTemplateInstanceRequirementsArgsDict']]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateLicenseSpecificationArgs', 'LaunchTemplateLicenseSpecificationArgsDict']]]]] = None,
                 maintenance_options: Optional[pulumi.Input[Union['LaunchTemplateMaintenanceOptionsArgs', 'LaunchTemplateMaintenanceOptionsArgsDict']]] = None,
                 metadata_options: Optional[pulumi.Input[Union['LaunchTemplateMetadataOptionsArgs', 'LaunchTemplateMetadataOptionsArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[Union['LaunchTemplateMonitoringArgs', 'LaunchTemplateMonitoringArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateNetworkInterfaceArgs', 'LaunchTemplateNetworkInterfaceArgsDict']]]]] = None,
                 placement: Optional[pulumi.Input[Union['LaunchTemplatePlacementArgs', 'LaunchTemplatePlacementArgsDict']]] = None,
                 private_dns_name_options: Optional[pulumi.Input[Union['LaunchTemplatePrivateDnsNameOptionsArgs', 'LaunchTemplatePrivateDnsNameOptionsArgsDict']]] = None,
                 ram_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateTagSpecificationArgs', 'LaunchTemplateTagSpecificationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_default_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LaunchTemplateArgs.__new__(LaunchTemplateArgs)

            __props__.__dict__["block_device_mappings"] = block_device_mappings
            __props__.__dict__["capacity_reservation_specification"] = capacity_reservation_specification
            __props__.__dict__["cpu_options"] = cpu_options
            __props__.__dict__["credit_specification"] = credit_specification
            __props__.__dict__["default_version"] = default_version
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_api_stop"] = disable_api_stop
            __props__.__dict__["disable_api_termination"] = disable_api_termination
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["enclave_options"] = enclave_options
            __props__.__dict__["hibernation_options"] = hibernation_options
            __props__.__dict__["iam_instance_profile"] = iam_instance_profile
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
            __props__.__dict__["instance_market_options"] = instance_market_options
            __props__.__dict__["instance_requirements"] = instance_requirements
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["kernel_id"] = kernel_id
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["license_specifications"] = license_specifications
            __props__.__dict__["maintenance_options"] = maintenance_options
            __props__.__dict__["metadata_options"] = metadata_options
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["placement"] = placement
            __props__.__dict__["private_dns_name_options"] = private_dns_name_options
            __props__.__dict__["ram_disk_id"] = ram_disk_id
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_names"] = security_group_names
            __props__.__dict__["tag_specifications"] = tag_specifications
            __props__.__dict__["tags"] = tags
            __props__.__dict__["update_default_version"] = update_default_version
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["arn"] = None
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["tags_all"] = None
        super(LaunchTemplate, __self__).__init__(
            'aws:ec2/launchTemplate:LaunchTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateBlockDeviceMappingArgs', 'LaunchTemplateBlockDeviceMappingArgsDict']]]]] = None,
            capacity_reservation_specification: Optional[pulumi.Input[Union['LaunchTemplateCapacityReservationSpecificationArgs', 'LaunchTemplateCapacityReservationSpecificationArgsDict']]] = None,
            cpu_options: Optional[pulumi.Input[Union['LaunchTemplateCpuOptionsArgs', 'LaunchTemplateCpuOptionsArgsDict']]] = None,
            credit_specification: Optional[pulumi.Input[Union['LaunchTemplateCreditSpecificationArgs', 'LaunchTemplateCreditSpecificationArgsDict']]] = None,
            default_version: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
            ebs_optimized: Optional[pulumi.Input[_builtins.str]] = None,
            enclave_options: Optional[pulumi.Input[Union['LaunchTemplateEnclaveOptionsArgs', 'LaunchTemplateEnclaveOptionsArgsDict']]] = None,
            hibernation_options: Optional[pulumi.Input[Union['LaunchTemplateHibernationOptionsArgs', 'LaunchTemplateHibernationOptionsArgsDict']]] = None,
            iam_instance_profile: Optional[pulumi.Input[Union['LaunchTemplateIamInstanceProfileArgs', 'LaunchTemplateIamInstanceProfileArgsDict']]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            instance_market_options: Optional[pulumi.Input[Union['LaunchTemplateInstanceMarketOptionsArgs', 'LaunchTemplateInstanceMarketOptionsArgsDict']]] = None,
            instance_requirements: Optional[pulumi.Input[Union['LaunchTemplateInstanceRequirementsArgs', 'LaunchTemplateInstanceRequirementsArgsDict']]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            kernel_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            latest_version: Optional[pulumi.Input[_builtins.int]] = None,
            license_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateLicenseSpecificationArgs', 'LaunchTemplateLicenseSpecificationArgsDict']]]]] = None,
            maintenance_options: Optional[pulumi.Input[Union['LaunchTemplateMaintenanceOptionsArgs', 'LaunchTemplateMaintenanceOptionsArgsDict']]] = None,
            metadata_options: Optional[pulumi.Input[Union['LaunchTemplateMetadataOptionsArgs', 'LaunchTemplateMetadataOptionsArgsDict']]] = None,
            monitoring: Optional[pulumi.Input[Union['LaunchTemplateMonitoringArgs', 'LaunchTemplateMonitoringArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateNetworkInterfaceArgs', 'LaunchTemplateNetworkInterfaceArgsDict']]]]] = None,
            placement: Optional[pulumi.Input[Union['LaunchTemplatePlacementArgs', 'LaunchTemplatePlacementArgsDict']]] = None,
            private_dns_name_options: Optional[pulumi.Input[Union['LaunchTemplatePrivateDnsNameOptionsArgs', 'LaunchTemplatePrivateDnsNameOptionsArgsDict']]] = None,
            ram_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateTagSpecificationArgs', 'LaunchTemplateTagSpecificationArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            update_default_version: Optional[pulumi.Input[_builtins.bool]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'LaunchTemplate':
        """
        Get an existing LaunchTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateBlockDeviceMappingArgs', 'LaunchTemplateBlockDeviceMappingArgsDict']]]] block_device_mappings: Specify volumes to attach to the instance besides the volumes specified by the AMI.
               See Block Devices below for details.
        :param pulumi.Input[Union['LaunchTemplateCapacityReservationSpecificationArgs', 'LaunchTemplateCapacityReservationSpecificationArgsDict']] capacity_reservation_specification: Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[Union['LaunchTemplateCpuOptionsArgs', 'LaunchTemplateCpuOptionsArgsDict']] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateCreditSpecificationArgs', 'LaunchTemplateCreditSpecificationArgsDict']] credit_specification: Customize the credit specification of the instance. See Credit
               Specification below for more details.
        :param pulumi.Input[_builtins.int] default_version: Default Version of the launch template.
        :param pulumi.Input[_builtins.str] description: Description of the launch template.
        :param pulumi.Input[_builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
        :param pulumi.Input[_builtins.bool] disable_api_termination: If `true`, enables [EC2 Instance
               Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
        :param pulumi.Input[_builtins.str] ebs_optimized: If `true`, the launched EC2 instance will be EBS-optimized.
        :param pulumi.Input[Union['LaunchTemplateEnclaveOptionsArgs', 'LaunchTemplateEnclaveOptionsArgsDict']] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateHibernationOptionsArgs', 'LaunchTemplateHibernationOptionsArgsDict']] hibernation_options: The hibernation options for the instance. See Hibernation Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateIamInstanceProfileArgs', 'LaunchTemplateIamInstanceProfileArgsDict']] iam_instance_profile: The IAM Instance Profile to launch the instance with. See Instance Profile
               below for more details.
        :param pulumi.Input[_builtins.str] image_id: The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
        :param pulumi.Input[_builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Can be `stop` or `terminate`.
               (Default: `stop`).
        :param pulumi.Input[Union['LaunchTemplateInstanceMarketOptionsArgs', 'LaunchTemplateInstanceMarketOptionsArgsDict']] instance_market_options: The market (purchasing) option for the instance. See Market Options
               below for details.
        :param pulumi.Input[Union['LaunchTemplateInstanceRequirementsArgs', 'LaunchTemplateInstanceRequirementsArgsDict']] instance_requirements: The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. If present then `instance_requirements` cannot be present.
        :param pulumi.Input[_builtins.str] kernel_id: The kernel ID.
        :param pulumi.Input[_builtins.str] key_name: The key name to use for the instance.
        :param pulumi.Input[_builtins.int] latest_version: The latest version of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateLicenseSpecificationArgs', 'LaunchTemplateLicenseSpecificationArgsDict']]]] license_specifications: A list of license specifications to associate with. See License Specification below for more details.
        :param pulumi.Input[Union['LaunchTemplateMaintenanceOptionsArgs', 'LaunchTemplateMaintenanceOptionsArgsDict']] maintenance_options: The maintenance options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateMetadataOptionsArgs', 'LaunchTemplateMetadataOptionsArgsDict']] metadata_options: Customize the metadata options for the instance. See Metadata Options below for more details.
        :param pulumi.Input[Union['LaunchTemplateMonitoringArgs', 'LaunchTemplateMonitoringArgsDict']] monitoring: The monitoring option for the instance. See Monitoring below for more details.
        :param pulumi.Input[_builtins.str] name: The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateNetworkInterfaceArgs', 'LaunchTemplateNetworkInterfaceArgsDict']]]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network
               Interfaces below for more details.
        :param pulumi.Input[Union['LaunchTemplatePlacementArgs', 'LaunchTemplatePlacementArgsDict']] placement: The placement of the instance. See Placement below for more details.
        :param pulumi.Input[Union['LaunchTemplatePrivateDnsNameOptionsArgs', 'LaunchTemplatePrivateDnsNameOptionsArgsDict']] private_dns_name_options: The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[_builtins.str] ram_disk_id: The ID of the RAM disk.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_names: A list of security group names to associate with. If you are creating Instances in a VPC, use
               `vpc_security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateTagSpecificationArgs', 'LaunchTemplateTagSpecificationArgsDict']]]] tag_specifications: The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] update_default_version: Whether to update Default Version each update. Conflicts with `default_version`.
        :param pulumi.Input[_builtins.str] user_data: The base64-encoded user data to provide when launching the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LaunchTemplateState.__new__(_LaunchTemplateState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["block_device_mappings"] = block_device_mappings
        __props__.__dict__["capacity_reservation_specification"] = capacity_reservation_specification
        __props__.__dict__["cpu_options"] = cpu_options
        __props__.__dict__["credit_specification"] = credit_specification
        __props__.__dict__["default_version"] = default_version
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_api_stop"] = disable_api_stop
        __props__.__dict__["disable_api_termination"] = disable_api_termination
        __props__.__dict__["ebs_optimized"] = ebs_optimized
        __props__.__dict__["enclave_options"] = enclave_options
        __props__.__dict__["hibernation_options"] = hibernation_options
        __props__.__dict__["iam_instance_profile"] = iam_instance_profile
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
        __props__.__dict__["instance_market_options"] = instance_market_options
        __props__.__dict__["instance_requirements"] = instance_requirements
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["kernel_id"] = kernel_id
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["license_specifications"] = license_specifications
        __props__.__dict__["maintenance_options"] = maintenance_options
        __props__.__dict__["metadata_options"] = metadata_options
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["placement"] = placement
        __props__.__dict__["private_dns_name_options"] = private_dns_name_options
        __props__.__dict__["ram_disk_id"] = ram_disk_id
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_names"] = security_group_names
        __props__.__dict__["tag_specifications"] = tag_specifications
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["update_default_version"] = update_default_version
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
        return LaunchTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the launch template.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.LaunchTemplateBlockDeviceMapping']]]:
        """
        Specify volumes to attach to the instance besides the volumes specified by the AMI.
        See Block Devices below for details.
        """
        return pulumi.get(self, "block_device_mappings")

    @_builtins.property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> pulumi.Output[Optional['outputs.LaunchTemplateCapacityReservationSpecification']]:
        """
        Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @_builtins.property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> pulumi.Output[Optional['outputs.LaunchTemplateCpuOptions']]:
        """
        The CPU options for the instance. See CPU Options below for more details.
        """
        return pulumi.get(self, "cpu_options")

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> pulumi.Output[Optional['outputs.LaunchTemplateCreditSpecification']]:
        """
        Customize the credit specification of the instance. See Credit
        Specification below for more details.
        """
        return pulumi.get(self, "credit_specification")

    @_builtins.property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> pulumi.Output[_builtins.int]:
        """
        Default Version of the launch template.
        """
        return pulumi.get(self, "default_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the launch template.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableApiStop")
    def disable_api_stop(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
        """
        return pulumi.get(self, "disable_api_stop")

    @_builtins.property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, enables [EC2 Instance
        Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
        """
        return pulumi.get(self, "disable_api_termination")

    @_builtins.property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If `true`, the launched EC2 instance will be EBS-optimized.
        """
        return pulumi.get(self, "ebs_optimized")

    @_builtins.property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> pulumi.Output[Optional['outputs.LaunchTemplateEnclaveOptions']]:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @_builtins.property
    @pulumi.getter(name="hibernationOptions")
    def hibernation_options(self) -> pulumi.Output[Optional['outputs.LaunchTemplateHibernationOptions']]:
        """
        The hibernation options for the instance. See Hibernation Options below for more details.
        """
        return pulumi.get(self, "hibernation_options")

    @_builtins.property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> pulumi.Output[Optional['outputs.LaunchTemplateIamInstanceProfile']]:
        """
        The IAM Instance Profile to launch the instance with. See Instance Profile
        below for more details.
        """
        return pulumi.get(self, "iam_instance_profile")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Shutdown behavior for the instance. Can be `stop` or `terminate`.
        (Default: `stop`).
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @_builtins.property
    @pulumi.getter(name="instanceMarketOptions")
    def instance_market_options(self) -> pulumi.Output[Optional['outputs.LaunchTemplateInstanceMarketOptions']]:
        """
        The market (purchasing) option for the instance. See Market Options
        below for details.
        """
        return pulumi.get(self, "instance_market_options")

    @_builtins.property
    @pulumi.getter(name="instanceRequirements")
    def instance_requirements(self) -> pulumi.Output[Optional['outputs.LaunchTemplateInstanceRequirements']]:
        """
        The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
        """
        return pulumi.get(self, "instance_requirements")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the instance. If present then `instance_requirements` cannot be present.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The kernel ID.
        """
        return pulumi.get(self, "kernel_id")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key name to use for the instance.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[_builtins.int]:
        """
        The latest version of the launch template.
        """
        return pulumi.get(self, "latest_version")

    @_builtins.property
    @pulumi.getter(name="licenseSpecifications")
    def license_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.LaunchTemplateLicenseSpecification']]]:
        """
        A list of license specifications to associate with. See License Specification below for more details.
        """
        return pulumi.get(self, "license_specifications")

    @_builtins.property
    @pulumi.getter(name="maintenanceOptions")
    def maintenance_options(self) -> pulumi.Output[Optional['outputs.LaunchTemplateMaintenanceOptions']]:
        """
        The maintenance options for the instance. See Maintenance Options below for more details.
        """
        return pulumi.get(self, "maintenance_options")

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> pulumi.Output['outputs.LaunchTemplateMetadataOptions']:
        """
        Customize the metadata options for the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[Optional['outputs.LaunchTemplateMonitoring']]:
        """
        The monitoring option for the instance. See Monitoring below for more details.
        """
        return pulumi.get(self, "monitoring")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.LaunchTemplateNetworkInterface']]]:
        """
        Customize network interfaces to be attached at instance boot time. See Network
        Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> pulumi.Output[Optional['outputs.LaunchTemplatePlacement']]:
        """
        The placement of the instance. See Placement below for more details.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> pulumi.Output[Optional['outputs.LaunchTemplatePrivateDnsNameOptions']]:
        """
        The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        """
        return pulumi.get(self, "private_dns_name_options")

    @_builtins.property
    @pulumi.getter(name="ramDiskId")
    def ram_disk_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the RAM disk.
        """
        return pulumi.get(self, "ram_disk_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupNames")
    def security_group_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of security group names to associate with. If you are creating Instances in a VPC, use
        `vpc_security_group_ids` instead.
        """
        return pulumi.get(self, "security_group_names")

    @_builtins.property
    @pulumi.getter(name="tagSpecifications")
    def tag_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.LaunchTemplateTagSpecification']]]:
        """
        The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
        """
        return pulumi.get(self, "tag_specifications")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="updateDefaultVersion")
    def update_default_version(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to update Default Version each update. Conflicts with `default_version`.
        """
        return pulumi.get(self, "update_default_version")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base64-encoded user data to provide when launching the instance.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
        """
        return pulumi.get(self, "vpc_security_group_ids")

