# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEndpointResult',
    'AwaitableGetEndpointResult',
    'get_endpoint',
    'get_endpoint_output',
]

@pulumi.output_type
class GetEndpointResult:
    """
    A collection of values returned by getEndpoint.
    """
    def __init__(__self__, arn=None, authentication_options=None, client_cidr_block=None, client_connect_options=None, client_login_banner_options=None, client_route_enforcement_options=None, client_vpn_endpoint_id=None, connection_log_options=None, description=None, dns_name=None, dns_servers=None, endpoint_ip_address_type=None, filters=None, id=None, region=None, security_group_ids=None, self_service_portal=None, self_service_portal_url=None, server_certificate_arn=None, session_timeout_hours=None, split_tunnel=None, tags=None, traffic_ip_address_type=None, transport_protocol=None, vpc_id=None, vpn_port=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if authentication_options and not isinstance(authentication_options, list):
            raise TypeError("Expected argument 'authentication_options' to be a list")
        pulumi.set(__self__, "authentication_options", authentication_options)
        if client_cidr_block and not isinstance(client_cidr_block, str):
            raise TypeError("Expected argument 'client_cidr_block' to be a str")
        pulumi.set(__self__, "client_cidr_block", client_cidr_block)
        if client_connect_options and not isinstance(client_connect_options, list):
            raise TypeError("Expected argument 'client_connect_options' to be a list")
        pulumi.set(__self__, "client_connect_options", client_connect_options)
        if client_login_banner_options and not isinstance(client_login_banner_options, list):
            raise TypeError("Expected argument 'client_login_banner_options' to be a list")
        pulumi.set(__self__, "client_login_banner_options", client_login_banner_options)
        if client_route_enforcement_options and not isinstance(client_route_enforcement_options, list):
            raise TypeError("Expected argument 'client_route_enforcement_options' to be a list")
        pulumi.set(__self__, "client_route_enforcement_options", client_route_enforcement_options)
        if client_vpn_endpoint_id and not isinstance(client_vpn_endpoint_id, str):
            raise TypeError("Expected argument 'client_vpn_endpoint_id' to be a str")
        pulumi.set(__self__, "client_vpn_endpoint_id", client_vpn_endpoint_id)
        if connection_log_options and not isinstance(connection_log_options, list):
            raise TypeError("Expected argument 'connection_log_options' to be a list")
        pulumi.set(__self__, "connection_log_options", connection_log_options)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_name and not isinstance(dns_name, str):
            raise TypeError("Expected argument 'dns_name' to be a str")
        pulumi.set(__self__, "dns_name", dns_name)
        if dns_servers and not isinstance(dns_servers, list):
            raise TypeError("Expected argument 'dns_servers' to be a list")
        pulumi.set(__self__, "dns_servers", dns_servers)
        if endpoint_ip_address_type and not isinstance(endpoint_ip_address_type, str):
            raise TypeError("Expected argument 'endpoint_ip_address_type' to be a str")
        pulumi.set(__self__, "endpoint_ip_address_type", endpoint_ip_address_type)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if self_service_portal and not isinstance(self_service_portal, str):
            raise TypeError("Expected argument 'self_service_portal' to be a str")
        pulumi.set(__self__, "self_service_portal", self_service_portal)
        if self_service_portal_url and not isinstance(self_service_portal_url, str):
            raise TypeError("Expected argument 'self_service_portal_url' to be a str")
        pulumi.set(__self__, "self_service_portal_url", self_service_portal_url)
        if server_certificate_arn and not isinstance(server_certificate_arn, str):
            raise TypeError("Expected argument 'server_certificate_arn' to be a str")
        pulumi.set(__self__, "server_certificate_arn", server_certificate_arn)
        if session_timeout_hours and not isinstance(session_timeout_hours, int):
            raise TypeError("Expected argument 'session_timeout_hours' to be a int")
        pulumi.set(__self__, "session_timeout_hours", session_timeout_hours)
        if split_tunnel and not isinstance(split_tunnel, bool):
            raise TypeError("Expected argument 'split_tunnel' to be a bool")
        pulumi.set(__self__, "split_tunnel", split_tunnel)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if traffic_ip_address_type and not isinstance(traffic_ip_address_type, str):
            raise TypeError("Expected argument 'traffic_ip_address_type' to be a str")
        pulumi.set(__self__, "traffic_ip_address_type", traffic_ip_address_type)
        if transport_protocol and not isinstance(transport_protocol, str):
            raise TypeError("Expected argument 'transport_protocol' to be a str")
        pulumi.set(__self__, "transport_protocol", transport_protocol)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpn_port and not isinstance(vpn_port, int):
            raise TypeError("Expected argument 'vpn_port' to be a int")
        pulumi.set(__self__, "vpn_port", vpn_port)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The ARN of the Client VPN endpoint.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authenticationOptions")
    def authentication_options(self) -> Sequence['outputs.GetEndpointAuthenticationOptionResult']:
        """
        Information about the authentication method used by the Client VPN endpoint.
        """
        return pulumi.get(self, "authentication_options")

    @_builtins.property
    @pulumi.getter(name="clientCidrBlock")
    def client_cidr_block(self) -> _builtins.str:
        """
        IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
        """
        return pulumi.get(self, "client_cidr_block")

    @_builtins.property
    @pulumi.getter(name="clientConnectOptions")
    def client_connect_options(self) -> Sequence['outputs.GetEndpointClientConnectOptionResult']:
        """
        The options for managing connection authorization for new client connections.
        """
        return pulumi.get(self, "client_connect_options")

    @_builtins.property
    @pulumi.getter(name="clientLoginBannerOptions")
    def client_login_banner_options(self) -> Sequence['outputs.GetEndpointClientLoginBannerOptionResult']:
        """
        Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
        """
        return pulumi.get(self, "client_login_banner_options")

    @_builtins.property
    @pulumi.getter(name="clientRouteEnforcementOptions")
    def client_route_enforcement_options(self) -> Sequence['outputs.GetEndpointClientRouteEnforcementOptionResult']:
        """
        Options for enforce administrator defined routes on devices connected through the VPN.
        """
        return pulumi.get(self, "client_route_enforcement_options")

    @_builtins.property
    @pulumi.getter(name="clientVpnEndpointId")
    def client_vpn_endpoint_id(self) -> _builtins.str:
        return pulumi.get(self, "client_vpn_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="connectionLogOptions")
    def connection_log_options(self) -> Sequence['outputs.GetEndpointConnectionLogOptionResult']:
        """
        Information about the client connection logging options for the Client VPN endpoint.
        """
        return pulumi.get(self, "connection_log_options")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Brief description of the endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> _builtins.str:
        """
        DNS name to be used by clients when connecting to the Client VPN endpoint.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[_builtins.str]:
        """
        Information about the DNS servers to be used for DNS resolution.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="endpointIpAddressType")
    def endpoint_ip_address_type(self) -> _builtins.str:
        """
        IP address type for the Client VPN endpoint.
        """
        return pulumi.get(self, "endpoint_ip_address_type")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEndpointFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        IDs of the security groups for the target network associated with the Client VPN endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="selfServicePortal")
    def self_service_portal(self) -> _builtins.str:
        """
        Whether the self-service portal for the Client VPN endpoint is enabled.
        """
        return pulumi.get(self, "self_service_portal")

    @_builtins.property
    @pulumi.getter(name="selfServicePortalUrl")
    def self_service_portal_url(self) -> _builtins.str:
        """
        The URL of the self-service portal.
        """
        return pulumi.get(self, "self_service_portal_url")

    @_builtins.property
    @pulumi.getter(name="serverCertificateArn")
    def server_certificate_arn(self) -> _builtins.str:
        """
        The ARN of the server certificate.
        """
        return pulumi.get(self, "server_certificate_arn")

    @_builtins.property
    @pulumi.getter(name="sessionTimeoutHours")
    def session_timeout_hours(self) -> _builtins.int:
        """
        The maximum VPN session duration time in hours.
        """
        return pulumi.get(self, "session_timeout_hours")

    @_builtins.property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> _builtins.bool:
        """
        Whether split-tunnel is enabled in the AWS Client VPN endpoint.
        """
        return pulumi.get(self, "split_tunnel")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="trafficIpAddressType")
    def traffic_ip_address_type(self) -> _builtins.str:
        """
        IP address type for traffic within the Client VPN tunnel.
        """
        return pulumi.get(self, "traffic_ip_address_type")

    @_builtins.property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> _builtins.str:
        """
        Transport protocol used by the Client VPN endpoint.
        """
        return pulumi.get(self, "transport_protocol")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC associated with the Client VPN endpoint.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpnPort")
    def vpn_port(self) -> _builtins.int:
        """
        Port number for the Client VPN endpoint.
        """
        return pulumi.get(self, "vpn_port")


class AwaitableGetEndpointResult(GetEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointResult(
            arn=self.arn,
            authentication_options=self.authentication_options,
            client_cidr_block=self.client_cidr_block,
            client_connect_options=self.client_connect_options,
            client_login_banner_options=self.client_login_banner_options,
            client_route_enforcement_options=self.client_route_enforcement_options,
            client_vpn_endpoint_id=self.client_vpn_endpoint_id,
            connection_log_options=self.connection_log_options,
            description=self.description,
            dns_name=self.dns_name,
            dns_servers=self.dns_servers,
            endpoint_ip_address_type=self.endpoint_ip_address_type,
            filters=self.filters,
            id=self.id,
            region=self.region,
            security_group_ids=self.security_group_ids,
            self_service_portal=self.self_service_portal,
            self_service_portal_url=self.self_service_portal_url,
            server_certificate_arn=self.server_certificate_arn,
            session_timeout_hours=self.session_timeout_hours,
            split_tunnel=self.split_tunnel,
            tags=self.tags,
            traffic_ip_address_type=self.traffic_ip_address_type,
            transport_protocol=self.transport_protocol,
            vpc_id=self.vpc_id,
            vpn_port=self.vpn_port)


def get_endpoint(client_vpn_endpoint_id: Optional[_builtins.str] = None,
                 filters: Optional[Sequence[Union['GetEndpointFilterArgs', 'GetEndpointFilterArgsDict']]] = None,
                 region: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointResult:
    """
    Get information on an EC2 Client VPN endpoint.

    ## Example Usage

    ### By Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2clientvpn.get_endpoint(filters=[{
        "name": "tag:Name",
        "values": ["ExampleVpn"],
    }])
    ```

    ### By Identifier

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2clientvpn.get_endpoint(client_vpn_endpoint_id="cvpn-endpoint-083cf50d6eb314f21")
    ```


    :param _builtins.str client_vpn_endpoint_id: ID of the Client VPN endpoint.
    :param Sequence[Union['GetEndpointFilterArgs', 'GetEndpointFilterArgsDict']] filters: One or more configuration blocks containing name-values filters. Detailed below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match a pair on the desired endpoint.
    """
    __args__ = dict()
    __args__['clientVpnEndpointId'] = client_vpn_endpoint_id
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2clientvpn/getEndpoint:getEndpoint', __args__, opts=opts, typ=GetEndpointResult).value

    return AwaitableGetEndpointResult(
        arn=pulumi.get(__ret__, 'arn'),
        authentication_options=pulumi.get(__ret__, 'authentication_options'),
        client_cidr_block=pulumi.get(__ret__, 'client_cidr_block'),
        client_connect_options=pulumi.get(__ret__, 'client_connect_options'),
        client_login_banner_options=pulumi.get(__ret__, 'client_login_banner_options'),
        client_route_enforcement_options=pulumi.get(__ret__, 'client_route_enforcement_options'),
        client_vpn_endpoint_id=pulumi.get(__ret__, 'client_vpn_endpoint_id'),
        connection_log_options=pulumi.get(__ret__, 'connection_log_options'),
        description=pulumi.get(__ret__, 'description'),
        dns_name=pulumi.get(__ret__, 'dns_name'),
        dns_servers=pulumi.get(__ret__, 'dns_servers'),
        endpoint_ip_address_type=pulumi.get(__ret__, 'endpoint_ip_address_type'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        self_service_portal=pulumi.get(__ret__, 'self_service_portal'),
        self_service_portal_url=pulumi.get(__ret__, 'self_service_portal_url'),
        server_certificate_arn=pulumi.get(__ret__, 'server_certificate_arn'),
        session_timeout_hours=pulumi.get(__ret__, 'session_timeout_hours'),
        split_tunnel=pulumi.get(__ret__, 'split_tunnel'),
        tags=pulumi.get(__ret__, 'tags'),
        traffic_ip_address_type=pulumi.get(__ret__, 'traffic_ip_address_type'),
        transport_protocol=pulumi.get(__ret__, 'transport_protocol'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vpn_port=pulumi.get(__ret__, 'vpn_port'))
def get_endpoint_output(client_vpn_endpoint_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetEndpointFilterArgs', 'GetEndpointFilterArgsDict']]]]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEndpointResult]:
    """
    Get information on an EC2 Client VPN endpoint.

    ## Example Usage

    ### By Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2clientvpn.get_endpoint(filters=[{
        "name": "tag:Name",
        "values": ["ExampleVpn"],
    }])
    ```

    ### By Identifier

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2clientvpn.get_endpoint(client_vpn_endpoint_id="cvpn-endpoint-083cf50d6eb314f21")
    ```


    :param _builtins.str client_vpn_endpoint_id: ID of the Client VPN endpoint.
    :param Sequence[Union['GetEndpointFilterArgs', 'GetEndpointFilterArgsDict']] filters: One or more configuration blocks containing name-values filters. Detailed below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match a pair on the desired endpoint.
    """
    __args__ = dict()
    __args__['clientVpnEndpointId'] = client_vpn_endpoint_id
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2clientvpn/getEndpoint:getEndpoint', __args__, opts=opts, typ=GetEndpointResult)
    return __ret__.apply(lambda __response__: GetEndpointResult(
        arn=pulumi.get(__response__, 'arn'),
        authentication_options=pulumi.get(__response__, 'authentication_options'),
        client_cidr_block=pulumi.get(__response__, 'client_cidr_block'),
        client_connect_options=pulumi.get(__response__, 'client_connect_options'),
        client_login_banner_options=pulumi.get(__response__, 'client_login_banner_options'),
        client_route_enforcement_options=pulumi.get(__response__, 'client_route_enforcement_options'),
        client_vpn_endpoint_id=pulumi.get(__response__, 'client_vpn_endpoint_id'),
        connection_log_options=pulumi.get(__response__, 'connection_log_options'),
        description=pulumi.get(__response__, 'description'),
        dns_name=pulumi.get(__response__, 'dns_name'),
        dns_servers=pulumi.get(__response__, 'dns_servers'),
        endpoint_ip_address_type=pulumi.get(__response__, 'endpoint_ip_address_type'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        self_service_portal=pulumi.get(__response__, 'self_service_portal'),
        self_service_portal_url=pulumi.get(__response__, 'self_service_portal_url'),
        server_certificate_arn=pulumi.get(__response__, 'server_certificate_arn'),
        session_timeout_hours=pulumi.get(__response__, 'session_timeout_hours'),
        split_tunnel=pulumi.get(__response__, 'split_tunnel'),
        tags=pulumi.get(__response__, 'tags'),
        traffic_ip_address_type=pulumi.get(__response__, 'traffic_ip_address_type'),
        transport_protocol=pulumi.get(__response__, 'transport_protocol'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        vpn_port=pulumi.get(__response__, 'vpn_port')))
