# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMountTargetResult',
    'AwaitableGetMountTargetResult',
    'get_mount_target',
    'get_mount_target_output',
]

@pulumi.output_type
class GetMountTargetResult:
    """
    A collection of values returned by getMountTarget.
    """
    def __init__(__self__, access_point_id=None, availability_zone_id=None, availability_zone_name=None, dns_name=None, file_system_arn=None, file_system_id=None, id=None, ip_address=None, ip_address_type=None, ipv6_address=None, mount_target_dns_name=None, mount_target_id=None, network_interface_id=None, owner_id=None, region=None, security_groups=None, subnet_id=None):
        if access_point_id and not isinstance(access_point_id, str):
            raise TypeError("Expected argument 'access_point_id' to be a str")
        pulumi.set(__self__, "access_point_id", access_point_id)
        if availability_zone_id and not isinstance(availability_zone_id, str):
            raise TypeError("Expected argument 'availability_zone_id' to be a str")
        pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if availability_zone_name and not isinstance(availability_zone_name, str):
            raise TypeError("Expected argument 'availability_zone_name' to be a str")
        pulumi.set(__self__, "availability_zone_name", availability_zone_name)
        if dns_name and not isinstance(dns_name, str):
            raise TypeError("Expected argument 'dns_name' to be a str")
        pulumi.set(__self__, "dns_name", dns_name)
        if file_system_arn and not isinstance(file_system_arn, str):
            raise TypeError("Expected argument 'file_system_arn' to be a str")
        pulumi.set(__self__, "file_system_arn", file_system_arn)
        if file_system_id and not isinstance(file_system_id, str):
            raise TypeError("Expected argument 'file_system_id' to be a str")
        pulumi.set(__self__, "file_system_id", file_system_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_type and not isinstance(ip_address_type, str):
            raise TypeError("Expected argument 'ip_address_type' to be a str")
        pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ipv6_address and not isinstance(ipv6_address, str):
            raise TypeError("Expected argument 'ipv6_address' to be a str")
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        if mount_target_dns_name and not isinstance(mount_target_dns_name, str):
            raise TypeError("Expected argument 'mount_target_dns_name' to be a str")
        pulumi.set(__self__, "mount_target_dns_name", mount_target_dns_name)
        if mount_target_id and not isinstance(mount_target_id, str):
            raise TypeError("Expected argument 'mount_target_id' to be a str")
        pulumi.set(__self__, "mount_target_id", mount_target_id)
        if network_interface_id and not isinstance(network_interface_id, str):
            raise TypeError("Expected argument 'network_interface_id' to be a str")
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_point_id")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> _builtins.str:
        """
        The unique and consistent identifier of the Availability Zone (AZ) that the mount target resides in.
        """
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneName")
    def availability_zone_name(self) -> _builtins.str:
        """
        The name of the Availability Zone (AZ) that the mount target resides in.
        """
        return pulumi.get(self, "availability_zone_name")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> _builtins.str:
        """
        DNS name for the EFS file system.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="fileSystemArn")
    def file_system_arn(self) -> _builtins.str:
        """
        Amazon Resource Name of the file system for which the mount target is intended.
        """
        return pulumi.get(self, "file_system_arn")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> _builtins.str:
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        Address at which the file system may be mounted via the mount target.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> _builtins.str:
        """
        IP address type for the mount target.
        """
        return pulumi.get(self, "ip_address_type")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> _builtins.str:
        """
        IPv6 address at which the file system may be mounted via the mount target.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="mountTargetDnsName")
    def mount_target_dns_name(self) -> _builtins.str:
        """
        The DNS name for the given subnet/AZ per [documented convention](http://docs.aws.amazon.com/efs/latest/ug/mounting-fs-mount-cmd-dns-name.html).
        """
        return pulumi.get(self, "mount_target_dns_name")

    @_builtins.property
    @pulumi.getter(name="mountTargetId")
    def mount_target_id(self) -> _builtins.str:
        return pulumi.get(self, "mount_target_id")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> _builtins.str:
        """
        The ID of the network interface that Amazon EFS created when it created the mount target.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        AWS account ID that owns the resource.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[_builtins.str]:
        """
        List of VPC security group IDs attached to the mount target.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        ID of the mount target's subnet.
        """
        return pulumi.get(self, "subnet_id")


class AwaitableGetMountTargetResult(GetMountTargetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMountTargetResult(
            access_point_id=self.access_point_id,
            availability_zone_id=self.availability_zone_id,
            availability_zone_name=self.availability_zone_name,
            dns_name=self.dns_name,
            file_system_arn=self.file_system_arn,
            file_system_id=self.file_system_id,
            id=self.id,
            ip_address=self.ip_address,
            ip_address_type=self.ip_address_type,
            ipv6_address=self.ipv6_address,
            mount_target_dns_name=self.mount_target_dns_name,
            mount_target_id=self.mount_target_id,
            network_interface_id=self.network_interface_id,
            owner_id=self.owner_id,
            region=self.region,
            security_groups=self.security_groups,
            subnet_id=self.subnet_id)


def get_mount_target(access_point_id: Optional[_builtins.str] = None,
                     file_system_id: Optional[_builtins.str] = None,
                     mount_target_id: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMountTargetResult:
    """
    Provides information about an Elastic File System Mount Target (EFS).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    mount_target_id = config.get("mountTargetId")
    if mount_target_id is None:
        mount_target_id = ""
    by_id = aws.efs.get_mount_target(mount_target_id=mount_target_id)
    ```


    :param _builtins.str access_point_id: ID or ARN of the access point whose mount target that you want to find. It must be included if a `file_system_id` and `mount_target_id` are not included.
    :param _builtins.str file_system_id: ID or ARN of the file system whose mount target that you want to find. It must be included if an `access_point_id` and `mount_target_id` are not included.
    :param _builtins.str mount_target_id: ID or ARN of the mount target that you want to find. It must be included in your request if an `access_point_id` and `file_system_id` are not included.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['accessPointId'] = access_point_id
    __args__['fileSystemId'] = file_system_id
    __args__['mountTargetId'] = mount_target_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:efs/getMountTarget:getMountTarget', __args__, opts=opts, typ=GetMountTargetResult).value

    return AwaitableGetMountTargetResult(
        access_point_id=pulumi.get(__ret__, 'access_point_id'),
        availability_zone_id=pulumi.get(__ret__, 'availability_zone_id'),
        availability_zone_name=pulumi.get(__ret__, 'availability_zone_name'),
        dns_name=pulumi.get(__ret__, 'dns_name'),
        file_system_arn=pulumi.get(__ret__, 'file_system_arn'),
        file_system_id=pulumi.get(__ret__, 'file_system_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        ip_address_type=pulumi.get(__ret__, 'ip_address_type'),
        ipv6_address=pulumi.get(__ret__, 'ipv6_address'),
        mount_target_dns_name=pulumi.get(__ret__, 'mount_target_dns_name'),
        mount_target_id=pulumi.get(__ret__, 'mount_target_id'),
        network_interface_id=pulumi.get(__ret__, 'network_interface_id'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        region=pulumi.get(__ret__, 'region'),
        security_groups=pulumi.get(__ret__, 'security_groups'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'))
def get_mount_target_output(access_point_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            file_system_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            mount_target_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMountTargetResult]:
    """
    Provides information about an Elastic File System Mount Target (EFS).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    mount_target_id = config.get("mountTargetId")
    if mount_target_id is None:
        mount_target_id = ""
    by_id = aws.efs.get_mount_target(mount_target_id=mount_target_id)
    ```


    :param _builtins.str access_point_id: ID or ARN of the access point whose mount target that you want to find. It must be included if a `file_system_id` and `mount_target_id` are not included.
    :param _builtins.str file_system_id: ID or ARN of the file system whose mount target that you want to find. It must be included if an `access_point_id` and `mount_target_id` are not included.
    :param _builtins.str mount_target_id: ID or ARN of the mount target that you want to find. It must be included in your request if an `access_point_id` and `file_system_id` are not included.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['accessPointId'] = access_point_id
    __args__['fileSystemId'] = file_system_id
    __args__['mountTargetId'] = mount_target_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:efs/getMountTarget:getMountTarget', __args__, opts=opts, typ=GetMountTargetResult)
    return __ret__.apply(lambda __response__: GetMountTargetResult(
        access_point_id=pulumi.get(__response__, 'access_point_id'),
        availability_zone_id=pulumi.get(__response__, 'availability_zone_id'),
        availability_zone_name=pulumi.get(__response__, 'availability_zone_name'),
        dns_name=pulumi.get(__response__, 'dns_name'),
        file_system_arn=pulumi.get(__response__, 'file_system_arn'),
        file_system_id=pulumi.get(__response__, 'file_system_id'),
        id=pulumi.get(__response__, 'id'),
        ip_address=pulumi.get(__response__, 'ip_address'),
        ip_address_type=pulumi.get(__response__, 'ip_address_type'),
        ipv6_address=pulumi.get(__response__, 'ipv6_address'),
        mount_target_dns_name=pulumi.get(__response__, 'mount_target_dns_name'),
        mount_target_id=pulumi.get(__response__, 'mount_target_id'),
        network_interface_id=pulumi.get(__response__, 'network_interface_id'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        region=pulumi.get(__response__, 'region'),
        security_groups=pulumi.get(__response__, 'security_groups'),
        subnet_id=pulumi.get(__response__, 'subnet_id')))
