# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessPolicyAssociationArgs', 'AccessPolicyAssociation']

@pulumi.input_type
class AccessPolicyAssociationArgs:
    def __init__(__self__, *,
                 access_scope: pulumi.Input['AccessPolicyAssociationAccessScopeArgs'],
                 cluster_name: pulumi.Input[_builtins.str],
                 policy_arn: pulumi.Input[_builtins.str],
                 principal_arn: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccessPolicyAssociation resource.
        :param pulumi.Input['AccessPolicyAssociationAccessScopeArgs'] access_scope: The configuration block to determine the scope of the access. See `access_scope` Block below.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[_builtins.str] policy_arn: The ARN of the access policy that you're associating.
        :param pulumi.Input[_builtins.str] principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "access_scope", access_scope)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "policy_arn", policy_arn)
        pulumi.set(__self__, "principal_arn", principal_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accessScope")
    def access_scope(self) -> pulumi.Input['AccessPolicyAssociationAccessScopeArgs']:
        """
        The configuration block to determine the scope of the access. See `access_scope` Block below.
        """
        return pulumi.get(self, "access_scope")

    @access_scope.setter
    def access_scope(self, value: pulumi.Input['AccessPolicyAssociationAccessScopeArgs']):
        pulumi.set(self, "access_scope", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the access policy that you're associating.
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_arn", value)

    @_builtins.property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The IAM Principal ARN which requires Authentication access to the EKS cluster.
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AccessPolicyAssociationState:
    def __init__(__self__, *,
                 access_scope: Optional[pulumi.Input['AccessPolicyAssociationAccessScopeArgs']] = None,
                 associated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_at: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessPolicyAssociation resources.
        :param pulumi.Input['AccessPolicyAssociationAccessScopeArgs'] access_scope: The configuration block to determine the scope of the access. See `access_scope` Block below.
        :param pulumi.Input[_builtins.str] associated_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was associated.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[_builtins.str] modified_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was updated.
        :param pulumi.Input[_builtins.str] policy_arn: The ARN of the access policy that you're associating.
        :param pulumi.Input[_builtins.str] principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if access_scope is not None:
            pulumi.set(__self__, "access_scope", access_scope)
        if associated_at is not None:
            pulumi.set(__self__, "associated_at", associated_at)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if policy_arn is not None:
            pulumi.set(__self__, "policy_arn", policy_arn)
        if principal_arn is not None:
            pulumi.set(__self__, "principal_arn", principal_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accessScope")
    def access_scope(self) -> Optional[pulumi.Input['AccessPolicyAssociationAccessScopeArgs']]:
        """
        The configuration block to determine the scope of the access. See `access_scope` Block below.
        """
        return pulumi.get(self, "access_scope")

    @access_scope.setter
    def access_scope(self, value: Optional[pulumi.Input['AccessPolicyAssociationAccessScopeArgs']]):
        pulumi.set(self, "access_scope", value)

    @_builtins.property
    @pulumi.getter(name="associatedAt")
    def associated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was associated.
        """
        return pulumi.get(self, "associated_at")

    @associated_at.setter
    def associated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_at", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was updated.
        """
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_at", value)

    @_builtins.property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the access policy that you're associating.
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_arn", value)

    @_builtins.property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM Principal ARN which requires Authentication access to the EKS cluster.
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:eks/accessPolicyAssociation:AccessPolicyAssociation")
class AccessPolicyAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_scope: Optional[pulumi.Input[Union['AccessPolicyAssociationAccessScopeArgs', 'AccessPolicyAssociationAccessScopeArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Access Entry Policy Association for an EKS Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.AccessPolicyAssociation("example",
            cluster_name=example_aws_eks_cluster["name"],
            policy_arn="arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy",
            principal_arn=example_aws_iam_user["arn"],
            access_scope={
                "type": "namespace",
                "namespaces": ["example-namespace"],
            })
        ```

        ## Import

        Using `pulumi import`, import EKS access entry using the `cluster_name` `principal_arn` and `policy_arn` separated by an octothorp (`#`). For example:

        ```sh
        $ pulumi import aws:eks/accessPolicyAssociation:AccessPolicyAssociation my_eks_access_entry my_cluster_name#my_principal_arn#my_policy_arn
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AccessPolicyAssociationAccessScopeArgs', 'AccessPolicyAssociationAccessScopeArgsDict']] access_scope: The configuration block to determine the scope of the access. See `access_scope` Block below.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[_builtins.str] policy_arn: The ARN of the access policy that you're associating.
        :param pulumi.Input[_builtins.str] principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessPolicyAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Access Entry Policy Association for an EKS Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.AccessPolicyAssociation("example",
            cluster_name=example_aws_eks_cluster["name"],
            policy_arn="arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy",
            principal_arn=example_aws_iam_user["arn"],
            access_scope={
                "type": "namespace",
                "namespaces": ["example-namespace"],
            })
        ```

        ## Import

        Using `pulumi import`, import EKS access entry using the `cluster_name` `principal_arn` and `policy_arn` separated by an octothorp (`#`). For example:

        ```sh
        $ pulumi import aws:eks/accessPolicyAssociation:AccessPolicyAssociation my_eks_access_entry my_cluster_name#my_principal_arn#my_policy_arn
        ```

        :param str resource_name: The name of the resource.
        :param AccessPolicyAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessPolicyAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_scope: Optional[pulumi.Input[Union['AccessPolicyAssociationAccessScopeArgs', 'AccessPolicyAssociationAccessScopeArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessPolicyAssociationArgs.__new__(AccessPolicyAssociationArgs)

            if access_scope is None and not opts.urn:
                raise TypeError("Missing required property 'access_scope'")
            __props__.__dict__["access_scope"] = access_scope
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            if policy_arn is None and not opts.urn:
                raise TypeError("Missing required property 'policy_arn'")
            __props__.__dict__["policy_arn"] = policy_arn
            if principal_arn is None and not opts.urn:
                raise TypeError("Missing required property 'principal_arn'")
            __props__.__dict__["principal_arn"] = principal_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["associated_at"] = None
            __props__.__dict__["modified_at"] = None
        super(AccessPolicyAssociation, __self__).__init__(
            'aws:eks/accessPolicyAssociation:AccessPolicyAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_scope: Optional[pulumi.Input[Union['AccessPolicyAssociationAccessScopeArgs', 'AccessPolicyAssociationAccessScopeArgsDict']]] = None,
            associated_at: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            modified_at: Optional[pulumi.Input[_builtins.str]] = None,
            policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
            principal_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccessPolicyAssociation':
        """
        Get an existing AccessPolicyAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AccessPolicyAssociationAccessScopeArgs', 'AccessPolicyAssociationAccessScopeArgsDict']] access_scope: The configuration block to determine the scope of the access. See `access_scope` Block below.
        :param pulumi.Input[_builtins.str] associated_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was associated.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[_builtins.str] modified_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was updated.
        :param pulumi.Input[_builtins.str] policy_arn: The ARN of the access policy that you're associating.
        :param pulumi.Input[_builtins.str] principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessPolicyAssociationState.__new__(_AccessPolicyAssociationState)

        __props__.__dict__["access_scope"] = access_scope
        __props__.__dict__["associated_at"] = associated_at
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["modified_at"] = modified_at
        __props__.__dict__["policy_arn"] = policy_arn
        __props__.__dict__["principal_arn"] = principal_arn
        __props__.__dict__["region"] = region
        return AccessPolicyAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessScope")
    def access_scope(self) -> pulumi.Output['outputs.AccessPolicyAssociationAccessScope']:
        """
        The configuration block to determine the scope of the access. See `access_scope` Block below.
        """
        return pulumi.get(self, "access_scope")

    @_builtins.property
    @pulumi.getter(name="associatedAt")
    def associated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was associated.
        """
        return pulumi.get(self, "associated_at")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was updated.
        """
        return pulumi.get(self, "modified_at")

    @_builtins.property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the access policy that you're associating.
        """
        return pulumi.get(self, "policy_arn")

    @_builtins.property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The IAM Principal ARN which requires Authentication access to the EKS cluster.
        """
        return pulumi.get(self, "principal_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

