# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, access_configs=None, arn=None, certificate_authorities=None, cluster_id=None, compute_configs=None, created_at=None, deletion_protection=None, enabled_cluster_log_types=None, endpoint=None, id=None, identities=None, kubernetes_network_configs=None, name=None, outpost_configs=None, platform_version=None, region=None, remote_network_configs=None, role_arn=None, status=None, storage_configs=None, tags=None, upgrade_policies=None, version=None, vpc_config=None, zonal_shift_configs=None):
        if access_configs and not isinstance(access_configs, list):
            raise TypeError("Expected argument 'access_configs' to be a list")
        pulumi.set(__self__, "access_configs", access_configs)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if certificate_authorities and not isinstance(certificate_authorities, list):
            raise TypeError("Expected argument 'certificate_authorities' to be a list")
        pulumi.set(__self__, "certificate_authorities", certificate_authorities)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compute_configs and not isinstance(compute_configs, list):
            raise TypeError("Expected argument 'compute_configs' to be a list")
        pulumi.set(__self__, "compute_configs", compute_configs)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enabled_cluster_log_types and not isinstance(enabled_cluster_log_types, list):
            raise TypeError("Expected argument 'enabled_cluster_log_types' to be a list")
        pulumi.set(__self__, "enabled_cluster_log_types", enabled_cluster_log_types)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if kubernetes_network_configs and not isinstance(kubernetes_network_configs, list):
            raise TypeError("Expected argument 'kubernetes_network_configs' to be a list")
        pulumi.set(__self__, "kubernetes_network_configs", kubernetes_network_configs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outpost_configs and not isinstance(outpost_configs, list):
            raise TypeError("Expected argument 'outpost_configs' to be a list")
        pulumi.set(__self__, "outpost_configs", outpost_configs)
        if platform_version and not isinstance(platform_version, str):
            raise TypeError("Expected argument 'platform_version' to be a str")
        pulumi.set(__self__, "platform_version", platform_version)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if remote_network_configs and not isinstance(remote_network_configs, list):
            raise TypeError("Expected argument 'remote_network_configs' to be a list")
        pulumi.set(__self__, "remote_network_configs", remote_network_configs)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if storage_configs and not isinstance(storage_configs, list):
            raise TypeError("Expected argument 'storage_configs' to be a list")
        pulumi.set(__self__, "storage_configs", storage_configs)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if upgrade_policies and not isinstance(upgrade_policies, list):
            raise TypeError("Expected argument 'upgrade_policies' to be a list")
        pulumi.set(__self__, "upgrade_policies", upgrade_policies)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if vpc_config and not isinstance(vpc_config, dict):
            raise TypeError("Expected argument 'vpc_config' to be a dict")
        pulumi.set(__self__, "vpc_config", vpc_config)
        if zonal_shift_configs and not isinstance(zonal_shift_configs, list):
            raise TypeError("Expected argument 'zonal_shift_configs' to be a list")
        pulumi.set(__self__, "zonal_shift_configs", zonal_shift_configs)

    @_builtins.property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Sequence['outputs.GetClusterAccessConfigResult']:
        """
        Configuration block for access config.
        """
        return pulumi.get(self, "access_configs")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="certificateAuthorities")
    def certificate_authorities(self) -> Sequence['outputs.GetClusterCertificateAuthorityResult']:
        """
        Nested attribute containing `certificate-authority-data` for your cluster.
        """
        return pulumi.get(self, "certificate_authorities")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of your local Amazon EKS cluster on the AWS Outpost. This attribute isn't available for an AWS EKS cluster on AWS cloud.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="computeConfigs")
    def compute_configs(self) -> Sequence['outputs.GetClusterComputeConfigResult']:
        """
        Nested attribute containing compute capability configuration for EKS Auto Mode enabled cluster.
        """
        return pulumi.get(self, "compute_configs")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Unix epoch time stamp in seconds for when the cluster was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        Whether deletion protection for the cluster is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="enabledClusterLogTypes")
    def enabled_cluster_log_types(self) -> Sequence[_builtins.str]:
        """
        The enabled control plane logs.
        """
        return pulumi.get(self, "enabled_cluster_log_types")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        Endpoint for your Kubernetes API server.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetClusterIdentityResult']:
        """
        Nested attribute containing identity provider information for your cluster. Only available on Kubernetes version 1.13 and 1.14 clusters created or upgraded on or after September 3, 2019. For an example using this information to enable IAM Roles for Service Accounts, see the `eks.Cluster` resource documentation.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="kubernetesNetworkConfigs")
    def kubernetes_network_configs(self) -> Sequence['outputs.GetClusterKubernetesNetworkConfigResult']:
        """
        Nested list containing Kubernetes Network Configuration.
        """
        return pulumi.get(self, "kubernetes_network_configs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outpostConfigs")
    def outpost_configs(self) -> Sequence['outputs.GetClusterOutpostConfigResult']:
        """
        Contains Outpost Configuration.
        """
        return pulumi.get(self, "outpost_configs")

    @_builtins.property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> _builtins.str:
        """
        Platform version for the cluster.
        """
        return pulumi.get(self, "platform_version")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="remoteNetworkConfigs")
    def remote_network_configs(self) -> Sequence['outputs.GetClusterRemoteNetworkConfigResult']:
        """
        Contains remote network configuration for EKS Hybrid Nodes.
        """
        return pulumi.get(self, "remote_network_configs")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the EKS cluster. One of `CREATING`, `ACTIVE`, `DELETING`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageConfigs")
    def storage_configs(self) -> Sequence['outputs.GetClusterStorageConfigResult']:
        """
        Contains storage configuration for EKS Auto Mode enabled cluster.
        """
        return pulumi.get(self, "storage_configs")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="upgradePolicies")
    def upgrade_policies(self) -> Sequence['outputs.GetClusterUpgradePolicyResult']:
        """
        Configuration block for the support policy to use for the cluster.
        """
        return pulumi.get(self, "upgrade_policies")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Kubernetes server version for the cluster.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> 'outputs.GetClusterVpcConfigResult':
        """
        Nested list containing VPC configuration for the cluster.
        """
        return pulumi.get(self, "vpc_config")

    @_builtins.property
    @pulumi.getter(name="zonalShiftConfigs")
    def zonal_shift_configs(self) -> Sequence['outputs.GetClusterZonalShiftConfigResult']:
        """
        Contains Zonal Shift Configuration.
        """
        return pulumi.get(self, "zonal_shift_configs")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            access_configs=self.access_configs,
            arn=self.arn,
            certificate_authorities=self.certificate_authorities,
            cluster_id=self.cluster_id,
            compute_configs=self.compute_configs,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            enabled_cluster_log_types=self.enabled_cluster_log_types,
            endpoint=self.endpoint,
            id=self.id,
            identities=self.identities,
            kubernetes_network_configs=self.kubernetes_network_configs,
            name=self.name,
            outpost_configs=self.outpost_configs,
            platform_version=self.platform_version,
            region=self.region,
            remote_network_configs=self.remote_network_configs,
            role_arn=self.role_arn,
            status=self.status,
            storage_configs=self.storage_configs,
            tags=self.tags,
            upgrade_policies=self.upgrade_policies,
            version=self.version,
            vpc_config=self.vpc_config,
            zonal_shift_configs=self.zonal_shift_configs)


def get_cluster(name: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                tags: Optional[Mapping[str, _builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Retrieve information about an EKS Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_cluster(name="example")
    pulumi.export("endpoint", example.endpoint)
    pulumi.export("kubeconfig-certificate-authority-data", example.certificate_authorities[0].data)
    ```


    :param _builtins.str name: Name of the cluster.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:eks/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        access_configs=pulumi.get(__ret__, 'access_configs'),
        arn=pulumi.get(__ret__, 'arn'),
        certificate_authorities=pulumi.get(__ret__, 'certificate_authorities'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compute_configs=pulumi.get(__ret__, 'compute_configs'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        enabled_cluster_log_types=pulumi.get(__ret__, 'enabled_cluster_log_types'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        kubernetes_network_configs=pulumi.get(__ret__, 'kubernetes_network_configs'),
        name=pulumi.get(__ret__, 'name'),
        outpost_configs=pulumi.get(__ret__, 'outpost_configs'),
        platform_version=pulumi.get(__ret__, 'platform_version'),
        region=pulumi.get(__ret__, 'region'),
        remote_network_configs=pulumi.get(__ret__, 'remote_network_configs'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        status=pulumi.get(__ret__, 'status'),
        storage_configs=pulumi.get(__ret__, 'storage_configs'),
        tags=pulumi.get(__ret__, 'tags'),
        upgrade_policies=pulumi.get(__ret__, 'upgrade_policies'),
        version=pulumi.get(__ret__, 'version'),
        vpc_config=pulumi.get(__ret__, 'vpc_config'),
        zonal_shift_configs=pulumi.get(__ret__, 'zonal_shift_configs'))
def get_cluster_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Retrieve information about an EKS Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_cluster(name="example")
    pulumi.export("endpoint", example.endpoint)
    pulumi.export("kubeconfig-certificate-authority-data", example.certificate_authorities[0].data)
    ```


    :param _builtins.str name: Name of the cluster.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:eks/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        access_configs=pulumi.get(__response__, 'access_configs'),
        arn=pulumi.get(__response__, 'arn'),
        certificate_authorities=pulumi.get(__response__, 'certificate_authorities'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        compute_configs=pulumi.get(__response__, 'compute_configs'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        enabled_cluster_log_types=pulumi.get(__response__, 'enabled_cluster_log_types'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        kubernetes_network_configs=pulumi.get(__response__, 'kubernetes_network_configs'),
        name=pulumi.get(__response__, 'name'),
        outpost_configs=pulumi.get(__response__, 'outpost_configs'),
        platform_version=pulumi.get(__response__, 'platform_version'),
        region=pulumi.get(__response__, 'region'),
        remote_network_configs=pulumi.get(__response__, 'remote_network_configs'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        status=pulumi.get(__response__, 'status'),
        storage_configs=pulumi.get(__response__, 'storage_configs'),
        tags=pulumi.get(__response__, 'tags'),
        upgrade_policies=pulumi.get(__response__, 'upgrade_policies'),
        version=pulumi.get(__response__, 'version'),
        vpc_config=pulumi.get(__response__, 'vpc_config'),
        zonal_shift_configs=pulumi.get(__response__, 'zonal_shift_configs')))
