# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterVersionsResult',
    'AwaitableGetClusterVersionsResult',
    'get_cluster_versions',
    'get_cluster_versions_output',
]

@pulumi.output_type
class GetClusterVersionsResult:
    """
    A collection of values returned by getClusterVersions.
    """
    def __init__(__self__, cluster_type=None, cluster_versions=None, cluster_versions_onlies=None, default_only=None, id=None, include_all=None, region=None, version_status=None):
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_versions and not isinstance(cluster_versions, list):
            raise TypeError("Expected argument 'cluster_versions' to be a list")
        pulumi.set(__self__, "cluster_versions", cluster_versions)
        if cluster_versions_onlies and not isinstance(cluster_versions_onlies, list):
            raise TypeError("Expected argument 'cluster_versions_onlies' to be a list")
        pulumi.set(__self__, "cluster_versions_onlies", cluster_versions_onlies)
        if default_only and not isinstance(default_only, bool):
            raise TypeError("Expected argument 'default_only' to be a bool")
        pulumi.set(__self__, "default_only", default_only)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_all and not isinstance(include_all, bool):
            raise TypeError("Expected argument 'include_all' to be a bool")
        pulumi.set(__self__, "include_all", include_all)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if version_status and not isinstance(version_status, str):
            raise TypeError("Expected argument 'version_status' to be a str")
        pulumi.set(__self__, "version_status", version_status)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[_builtins.str]:
        """
        Type of cluster that the version belongs to.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="clusterVersions")
    def cluster_versions(self) -> Sequence['outputs.GetClusterVersionsClusterVersionResult']:
        """
        A list of Kubernetes version information.
        """
        return pulumi.get(self, "cluster_versions")

    @_builtins.property
    @pulumi.getter(name="clusterVersionsOnlies")
    def cluster_versions_onlies(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "cluster_versions_onlies")

    @_builtins.property
    @pulumi.getter(name="defaultOnly")
    def default_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "default_only")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includeAll")
    def include_all(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_all")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="versionStatus")
    def version_status(self) -> Optional[_builtins.str]:
        """
        Status of the EKS cluster version.
        """
        return pulumi.get(self, "version_status")


class AwaitableGetClusterVersionsResult(GetClusterVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterVersionsResult(
            cluster_type=self.cluster_type,
            cluster_versions=self.cluster_versions,
            cluster_versions_onlies=self.cluster_versions_onlies,
            default_only=self.default_only,
            id=self.id,
            include_all=self.include_all,
            region=self.region,
            version_status=self.version_status)


def get_cluster_versions(cluster_type: Optional[_builtins.str] = None,
                         cluster_versions_onlies: Optional[Sequence[_builtins.str]] = None,
                         default_only: Optional[_builtins.bool] = None,
                         include_all: Optional[_builtins.bool] = None,
                         region: Optional[_builtins.str] = None,
                         version_status: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterVersionsResult:
    """
    Data source for managing AWS EKS (Elastic Kubernetes) Cluster Versions.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_cluster_versions()
    pulumi.export("eksClusterVersions", example.cluster_versions)
    pulumi.export("eksClusterVersionFiltered", [version for version in example.cluster_versions if version.cluster_version == "1.33"])
    pulumi.export("eksClusterVersionList", [version.cluster_version for version in example.cluster_versions])
    ```

    ### Filter by Cluster Type

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_cluster_versions(cluster_type="eks")
    ```

    ### Filter by Version Status

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_cluster_versions(version_status="STANDARD_SUPPORT")
    ```


    :param _builtins.str cluster_type: Type of clusters to filter by.
           Currently, the only valid value is `eks`.
    :param _builtins.bool default_only: Whether to show only the default versions of Kubernetes supported by EKS.
    :param _builtins.bool include_all: Whether to include all kubernetes versions in the response.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str version_status: Status of the EKS cluster versions to list.
           Valid values are `STANDARD_SUPPORT` or `UNSUPPORTED` or `EXTENDED_SUPPORT`.
    """
    __args__ = dict()
    __args__['clusterType'] = cluster_type
    __args__['clusterVersionsOnlies'] = cluster_versions_onlies
    __args__['defaultOnly'] = default_only
    __args__['includeAll'] = include_all
    __args__['region'] = region
    __args__['versionStatus'] = version_status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:eks/getClusterVersions:getClusterVersions', __args__, opts=opts, typ=GetClusterVersionsResult).value

    return AwaitableGetClusterVersionsResult(
        cluster_type=pulumi.get(__ret__, 'cluster_type'),
        cluster_versions=pulumi.get(__ret__, 'cluster_versions'),
        cluster_versions_onlies=pulumi.get(__ret__, 'cluster_versions_onlies'),
        default_only=pulumi.get(__ret__, 'default_only'),
        id=pulumi.get(__ret__, 'id'),
        include_all=pulumi.get(__ret__, 'include_all'),
        region=pulumi.get(__ret__, 'region'),
        version_status=pulumi.get(__ret__, 'version_status'))
def get_cluster_versions_output(cluster_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                cluster_versions_onlies: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                default_only: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                include_all: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                version_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterVersionsResult]:
    """
    Data source for managing AWS EKS (Elastic Kubernetes) Cluster Versions.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_cluster_versions()
    pulumi.export("eksClusterVersions", example.cluster_versions)
    pulumi.export("eksClusterVersionFiltered", [version for version in example.cluster_versions if version.cluster_version == "1.33"])
    pulumi.export("eksClusterVersionList", [version.cluster_version for version in example.cluster_versions])
    ```

    ### Filter by Cluster Type

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_cluster_versions(cluster_type="eks")
    ```

    ### Filter by Version Status

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_cluster_versions(version_status="STANDARD_SUPPORT")
    ```


    :param _builtins.str cluster_type: Type of clusters to filter by.
           Currently, the only valid value is `eks`.
    :param _builtins.bool default_only: Whether to show only the default versions of Kubernetes supported by EKS.
    :param _builtins.bool include_all: Whether to include all kubernetes versions in the response.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str version_status: Status of the EKS cluster versions to list.
           Valid values are `STANDARD_SUPPORT` or `UNSUPPORTED` or `EXTENDED_SUPPORT`.
    """
    __args__ = dict()
    __args__['clusterType'] = cluster_type
    __args__['clusterVersionsOnlies'] = cluster_versions_onlies
    __args__['defaultOnly'] = default_only
    __args__['includeAll'] = include_all
    __args__['region'] = region
    __args__['versionStatus'] = version_status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:eks/getClusterVersions:getClusterVersions', __args__, opts=opts, typ=GetClusterVersionsResult)
    return __ret__.apply(lambda __response__: GetClusterVersionsResult(
        cluster_type=pulumi.get(__response__, 'cluster_type'),
        cluster_versions=pulumi.get(__response__, 'cluster_versions'),
        cluster_versions_onlies=pulumi.get(__response__, 'cluster_versions_onlies'),
        default_only=pulumi.get(__response__, 'default_only'),
        id=pulumi.get(__response__, 'id'),
        include_all=pulumi.get(__response__, 'include_all'),
        region=pulumi.get(__response__, 'region'),
        version_status=pulumi.get(__response__, 'version_status')))
