# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 az_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLogDeliveryConfigurationArgs']]]] = None,
                 maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 num_cache_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 outpost_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_outpost_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.bool] apply_immediately: Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
        :param pulumi.Input[_builtins.str] auto_minor_version_upgrade: Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
               Only supported for engine type `"redis"` and if the engine version is 6 or higher.
               Defaults to `true`.
        :param pulumi.Input[_builtins.str] availability_zone: Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] az_mode: Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
        :param pulumi.Input[_builtins.str] cluster_id: Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] engine: Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` and `valkey`.
        :param pulumi.Input[_builtins.str] engine_version: Version number of the cache engine to be used.
               If not set, defaults to the latest version.
               See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
               When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
               When the version is 6, the major and minor version can be set, e.g., `6.2`,
               or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
               Otherwise, specify the full version desired, e.g., `5.0.6`.
               The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: Name of your final cluster snapshot. If omitted, no final snapshot will be made.
        :param pulumi.Input[_builtins.str] ip_discovery: The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterLogDeliveryConfigurationArgs']]] log_delivery_configurations: Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html). See Log Delivery Configuration below for more details.
        :param pulumi.Input[_builtins.str] maintenance_window: Specifies the weekly time range for when maintenance
               on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
               The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
        :param pulumi.Input[_builtins.str] network_type: The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        :param pulumi.Input[_builtins.str] node_type: The instance class used.
               See AWS documentation for information on [supported node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen) and [guidance on selecting node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.redis).
               See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen-Memcached) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.Mem).
               For Memcached, changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] notification_topic_arn: ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
        :param pulumi.Input[_builtins.int] num_cache_nodes: The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
        :param pulumi.Input[_builtins.str] outpost_mode: Specify the outpost mode that will apply to the cache cluster creation. Valid values are `"single-outpost"` and `"cross-outpost"`, however AWS currently only supports `"single-outpost"` mode.
        :param pulumi.Input[_builtins.str] parameter_group_name: The name of the parameter group to associate with this cache cluster.
        :param pulumi.Input[_builtins.int] port: The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_availability_zones: List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
        :param pulumi.Input[_builtins.str] preferred_outpost_arn: The outpost ARN in which the cache cluster will be created.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_group_id: ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: One or more VPC security groups associated with the cache cluster. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[_builtins.str] snapshot_arns: Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
        :param pulumi.Input[_builtins.str] snapshot_name: Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
        :param pulumi.Input[_builtins.int] snapshot_retention_limit: Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        :param pulumi.Input[_builtins.str] snapshot_window: Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
        :param pulumi.Input[_builtins.str] subnet_group_name: Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Enable encryption in-transit. Supported with Memcached versions `1.6.12` and later, Valkey `7.2` and later, Redis OSS versions `3.2.6`, `4.0.10` and later, running in a VPC. See the [ElastiCache in-transit encryption documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/in-transit-encryption.html#in-transit-encryption-constraints) for more details.
        """
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if az_mode is not None:
            pulumi.set(__self__, "az_mode", az_mode)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if ip_discovery is not None:
            pulumi.set(__self__, "ip_discovery", ip_discovery)
        if log_delivery_configurations is not None:
            pulumi.set(__self__, "log_delivery_configurations", log_delivery_configurations)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if notification_topic_arn is not None:
            pulumi.set(__self__, "notification_topic_arn", notification_topic_arn)
        if num_cache_nodes is not None:
            pulumi.set(__self__, "num_cache_nodes", num_cache_nodes)
        if outpost_mode is not None:
            pulumi.set(__self__, "outpost_mode", outpost_mode)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_availability_zones is not None:
            pulumi.set(__self__, "preferred_availability_zones", preferred_availability_zones)
        if preferred_outpost_arn is not None:
            pulumi.set(__self__, "preferred_outpost_arn", preferred_outpost_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_group_id is not None:
            pulumi.set(__self__, "replication_group_id", replication_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if snapshot_arns is not None:
            pulumi.set(__self__, "snapshot_arns", snapshot_arns)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if subnet_group_name is not None:
            pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_encryption_enabled is not None:
            pulumi.set(__self__, "transit_encryption_enabled", transit_encryption_enabled)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
        Only supported for engine type `"redis"` and if the engine version is 6 or higher.
        Defaults to `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="azMode")
    def az_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
        """
        return pulumi.get(self, "az_mode")

    @az_mode.setter
    def az_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "az_mode", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` and `valkey`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of the cache engine to be used.
        If not set, defaults to the latest version.
        See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
        When the version is 6, the major and minor version can be set, e.g., `6.2`,
        or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
        Otherwise, specify the full version desired, e.g., `5.0.6`.
        The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. Cannot be provided with `replication_group_id.`
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of your final cluster snapshot. If omitted, no final snapshot will be made.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter(name="ipDiscovery")
    def ip_discovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_discovery")

    @ip_discovery.setter
    def ip_discovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_discovery", value)

    @_builtins.property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLogDeliveryConfigurationArgs']]]]:
        """
        Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html). See Log Delivery Configuration below for more details.
        """
        return pulumi.get(self, "log_delivery_configurations")

    @log_delivery_configurations.setter
    def log_delivery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLogDeliveryConfigurationArgs']]]]):
        pulumi.set(self, "log_delivery_configurations", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the weekly time range for when maintenance
        on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
        The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance class used.
        See AWS documentation for information on [supported node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen) and [guidance on selecting node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.redis).
        See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen-Memcached) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.Mem).
        For Memcached, changing this value will re-create the resource.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="notificationTopicArn")
    def notification_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
        """
        return pulumi.get(self, "notification_topic_arn")

    @notification_topic_arn.setter
    def notification_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="numCacheNodes")
    def num_cache_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
        """
        return pulumi.get(self, "num_cache_nodes")

    @num_cache_nodes.setter
    def num_cache_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cache_nodes", value)

    @_builtins.property
    @pulumi.getter(name="outpostMode")
    def outpost_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the outpost mode that will apply to the cache cluster creation. Valid values are `"single-outpost"` and `"cross-outpost"`, however AWS currently only supports `"single-outpost"` mode.
        """
        return pulumi.get(self, "outpost_mode")

    @outpost_mode.setter
    def outpost_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "outpost_mode", value)

    @_builtins.property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the parameter group to associate with this cache cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter_group_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
        """
        return pulumi.get(self, "preferred_availability_zones")

    @preferred_availability_zones.setter
    def preferred_availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="preferredOutpostArn")
    def preferred_outpost_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The outpost ARN in which the cache cluster will be created.
        """
        return pulumi.get(self, "preferred_outpost_arn")

    @preferred_outpost_arn.setter
    def preferred_outpost_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_outpost_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationGroupId")
    def replication_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
        """
        return pulumi.get(self, "replication_group_id")

    @replication_group_id.setter
    def replication_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more VPC security groups associated with the cache cluster. Cannot be provided with `replication_group_id.`
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
        """
        return pulumi.get(self, "snapshot_arns")

    @snapshot_arns.setter
    def snapshot_arns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_arns", value)

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @_builtins.property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
        """
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_window", value)

    @_builtins.property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource. Cannot be provided with `replication_group_id.`
        """
        return pulumi.get(self, "subnet_group_name")

    @subnet_group_name.setter
    def subnet_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable encryption in-transit. Supported with Memcached versions `1.6.12` and later, Valkey `7.2` and later, Redis OSS versions `3.2.6`, `4.0.10` and later, running in a VPC. See the [ElastiCache in-transit encryption documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/in-transit-encryption.html#in-transit-encryption-constraints) for more details.
        """
        return pulumi.get(self, "transit_encryption_enabled")

    @transit_encryption_enabled.setter
    def transit_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transit_encryption_enabled", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 az_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCacheNodeArgs']]]] = None,
                 cluster_address: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version_actual: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLogDeliveryConfigurationArgs']]]] = None,
                 maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 num_cache_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 outpost_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_outpost_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.bool] apply_immediately: Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
        :param pulumi.Input[_builtins.str] arn: The ARN of the created ElastiCache Cluster.
        :param pulumi.Input[_builtins.str] auto_minor_version_upgrade: Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
               Only supported for engine type `"redis"` and if the engine version is 6 or higher.
               Defaults to `true`.
        :param pulumi.Input[_builtins.str] availability_zone: Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] az_mode: Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCacheNodeArgs']]] cache_nodes: List of node objects including `id`, `address`, `port` and `availability_zone`.
        :param pulumi.Input[_builtins.str] cluster_address: (Memcached only) DNS name of the cache cluster without the port appended.
        :param pulumi.Input[_builtins.str] cluster_id: Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] configuration_endpoint: (Memcached only) Configuration endpoint to allow host discovery.
        :param pulumi.Input[_builtins.str] engine: Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` and `valkey`.
        :param pulumi.Input[_builtins.str] engine_version: Version number of the cache engine to be used.
               If not set, defaults to the latest version.
               See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
               When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
               When the version is 6, the major and minor version can be set, e.g., `6.2`,
               or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
               Otherwise, specify the full version desired, e.g., `5.0.6`.
               The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[_builtins.str] engine_version_actual: Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: Name of your final cluster snapshot. If omitted, no final snapshot will be made.
        :param pulumi.Input[_builtins.str] ip_discovery: The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterLogDeliveryConfigurationArgs']]] log_delivery_configurations: Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html). See Log Delivery Configuration below for more details.
        :param pulumi.Input[_builtins.str] maintenance_window: Specifies the weekly time range for when maintenance
               on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
               The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
        :param pulumi.Input[_builtins.str] network_type: The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        :param pulumi.Input[_builtins.str] node_type: The instance class used.
               See AWS documentation for information on [supported node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen) and [guidance on selecting node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.redis).
               See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen-Memcached) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.Mem).
               For Memcached, changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] notification_topic_arn: ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
        :param pulumi.Input[_builtins.int] num_cache_nodes: The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
        :param pulumi.Input[_builtins.str] outpost_mode: Specify the outpost mode that will apply to the cache cluster creation. Valid values are `"single-outpost"` and `"cross-outpost"`, however AWS currently only supports `"single-outpost"` mode.
        :param pulumi.Input[_builtins.str] parameter_group_name: The name of the parameter group to associate with this cache cluster.
        :param pulumi.Input[_builtins.int] port: The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_availability_zones: List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
        :param pulumi.Input[_builtins.str] preferred_outpost_arn: The outpost ARN in which the cache cluster will be created.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_group_id: ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: One or more VPC security groups associated with the cache cluster. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[_builtins.str] snapshot_arns: Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
        :param pulumi.Input[_builtins.str] snapshot_name: Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
        :param pulumi.Input[_builtins.int] snapshot_retention_limit: Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        :param pulumi.Input[_builtins.str] snapshot_window: Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
        :param pulumi.Input[_builtins.str] subnet_group_name: Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Enable encryption in-transit. Supported with Memcached versions `1.6.12` and later, Valkey `7.2` and later, Redis OSS versions `3.2.6`, `4.0.10` and later, running in a VPC. See the [ElastiCache in-transit encryption documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/in-transit-encryption.html#in-transit-encryption-constraints) for more details.
        """
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if az_mode is not None:
            pulumi.set(__self__, "az_mode", az_mode)
        if cache_nodes is not None:
            pulumi.set(__self__, "cache_nodes", cache_nodes)
        if cluster_address is not None:
            pulumi.set(__self__, "cluster_address", cluster_address)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if configuration_endpoint is not None:
            pulumi.set(__self__, "configuration_endpoint", configuration_endpoint)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if engine_version_actual is not None:
            pulumi.set(__self__, "engine_version_actual", engine_version_actual)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if ip_discovery is not None:
            pulumi.set(__self__, "ip_discovery", ip_discovery)
        if log_delivery_configurations is not None:
            pulumi.set(__self__, "log_delivery_configurations", log_delivery_configurations)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if notification_topic_arn is not None:
            pulumi.set(__self__, "notification_topic_arn", notification_topic_arn)
        if num_cache_nodes is not None:
            pulumi.set(__self__, "num_cache_nodes", num_cache_nodes)
        if outpost_mode is not None:
            pulumi.set(__self__, "outpost_mode", outpost_mode)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_availability_zones is not None:
            pulumi.set(__self__, "preferred_availability_zones", preferred_availability_zones)
        if preferred_outpost_arn is not None:
            pulumi.set(__self__, "preferred_outpost_arn", preferred_outpost_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_group_id is not None:
            pulumi.set(__self__, "replication_group_id", replication_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if snapshot_arns is not None:
            pulumi.set(__self__, "snapshot_arns", snapshot_arns)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if subnet_group_name is not None:
            pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if transit_encryption_enabled is not None:
            pulumi.set(__self__, "transit_encryption_enabled", transit_encryption_enabled)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the created ElastiCache Cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
        Only supported for engine type `"redis"` and if the engine version is 6 or higher.
        Defaults to `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="azMode")
    def az_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
        """
        return pulumi.get(self, "az_mode")

    @az_mode.setter
    def az_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "az_mode", value)

    @_builtins.property
    @pulumi.getter(name="cacheNodes")
    def cache_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCacheNodeArgs']]]]:
        """
        List of node objects including `id`, `address`, `port` and `availability_zone`.
        """
        return pulumi.get(self, "cache_nodes")

    @cache_nodes.setter
    def cache_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCacheNodeArgs']]]]):
        pulumi.set(self, "cache_nodes", value)

    @_builtins.property
    @pulumi.getter(name="clusterAddress")
    def cluster_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Memcached only) DNS name of the cache cluster without the port appended.
        """
        return pulumi.get(self, "cluster_address")

    @cluster_address.setter
    def cluster_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_address", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="configurationEndpoint")
    def configuration_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Memcached only) Configuration endpoint to allow host discovery.
        """
        return pulumi.get(self, "configuration_endpoint")

    @configuration_endpoint.setter
    def configuration_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` and `valkey`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of the cache engine to be used.
        If not set, defaults to the latest version.
        See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
        When the version is 6, the major and minor version can be set, e.g., `6.2`,
        or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
        Otherwise, specify the full version desired, e.g., `5.0.6`.
        The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. Cannot be provided with `replication_group_id.`
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
        """
        return pulumi.get(self, "engine_version_actual")

    @engine_version_actual.setter
    def engine_version_actual(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version_actual", value)

    @_builtins.property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of your final cluster snapshot. If omitted, no final snapshot will be made.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter(name="ipDiscovery")
    def ip_discovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_discovery")

    @ip_discovery.setter
    def ip_discovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_discovery", value)

    @_builtins.property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLogDeliveryConfigurationArgs']]]]:
        """
        Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html). See Log Delivery Configuration below for more details.
        """
        return pulumi.get(self, "log_delivery_configurations")

    @log_delivery_configurations.setter
    def log_delivery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLogDeliveryConfigurationArgs']]]]):
        pulumi.set(self, "log_delivery_configurations", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the weekly time range for when maintenance
        on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
        The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance class used.
        See AWS documentation for information on [supported node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen) and [guidance on selecting node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.redis).
        See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen-Memcached) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.Mem).
        For Memcached, changing this value will re-create the resource.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="notificationTopicArn")
    def notification_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
        """
        return pulumi.get(self, "notification_topic_arn")

    @notification_topic_arn.setter
    def notification_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="numCacheNodes")
    def num_cache_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
        """
        return pulumi.get(self, "num_cache_nodes")

    @num_cache_nodes.setter
    def num_cache_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cache_nodes", value)

    @_builtins.property
    @pulumi.getter(name="outpostMode")
    def outpost_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the outpost mode that will apply to the cache cluster creation. Valid values are `"single-outpost"` and `"cross-outpost"`, however AWS currently only supports `"single-outpost"` mode.
        """
        return pulumi.get(self, "outpost_mode")

    @outpost_mode.setter
    def outpost_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "outpost_mode", value)

    @_builtins.property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the parameter group to associate with this cache cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter_group_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
        """
        return pulumi.get(self, "preferred_availability_zones")

    @preferred_availability_zones.setter
    def preferred_availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="preferredOutpostArn")
    def preferred_outpost_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The outpost ARN in which the cache cluster will be created.
        """
        return pulumi.get(self, "preferred_outpost_arn")

    @preferred_outpost_arn.setter
    def preferred_outpost_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_outpost_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationGroupId")
    def replication_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
        """
        return pulumi.get(self, "replication_group_id")

    @replication_group_id.setter
    def replication_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more VPC security groups associated with the cache cluster. Cannot be provided with `replication_group_id.`
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
        """
        return pulumi.get(self, "snapshot_arns")

    @snapshot_arns.setter
    def snapshot_arns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_arns", value)

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @_builtins.property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
        """
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_window", value)

    @_builtins.property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource. Cannot be provided with `replication_group_id.`
        """
        return pulumi.get(self, "subnet_group_name")

    @subnet_group_name.setter
    def subnet_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable encryption in-transit. Supported with Memcached versions `1.6.12` and later, Valkey `7.2` and later, Redis OSS versions `3.2.6`, `4.0.10` and later, running in a VPC. See the [ElastiCache in-transit encryption documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/in-transit-encryption.html#in-transit-encryption-constraints) for more details.
        """
        return pulumi.get(self, "transit_encryption_enabled")

    @transit_encryption_enabled.setter
    def transit_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transit_encryption_enabled", value)


@pulumi.type_token("aws:elasticache/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 az_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterLogDeliveryConfigurationArgs', 'ClusterLogDeliveryConfigurationArgsDict']]]]] = None,
                 maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 num_cache_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 outpost_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_outpost_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides an ElastiCache Cluster resource, which manages a Memcached cluster, a single-node Redis instance,
        or a read replica in a Redis (Cluster Mode Enabled) replication group. For more information, refer to
        the AWS document [What is Amazon ElastiCache?](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/WhatIs.html).

        For working with Redis (Cluster Mode Enabled) replication groups, see the
        `elasticache.ReplicationGroup` resource.

        > **Note:** When you change an attribute, such as `num_cache_nodes`, by default
        it is applied in the next maintenance window. Because of this, this provider may report
        a difference in its planning phase because the actual modification has not yet taken
        place. You can use the `apply_immediately` flag to instruct the service to apply the
        change immediately. Using `apply_immediately` can result in a brief downtime as the server reboots.
        See the "Changes take effect" section of the "Details" column in the AWS Documentation on Engine specific parameters for
        [ElastiCache for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/ParameterGroups.Engine.html#ParameterGroups.Memcached) or
        [ElastiCache for Valkey and Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/ParameterGroups.Engine.html#ParameterGroups.Redis)
        for more information.

        > **Note:** Any attribute changes that re-create the resource will be applied immediately, regardless of the value of `apply_immediately`.

        ## Example Usage

        ### Memcached Cluster

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.Cluster("example",
            cluster_id="cluster-example",
            engine="memcached",
            node_type="cache.m4.large",
            num_cache_nodes=2,
            parameter_group_name="default.memcached1.4",
            port=11211)
        ```

        ### Redis Instance

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.Cluster("example",
            cluster_id="cluster-example",
            engine="redis",
            node_type="cache.m4.large",
            num_cache_nodes=1,
            parameter_group_name="default.redis3.2",
            engine_version="3.2.10",
            port=6379)
        ```

        ### Redis Cluster Mode Disabled Read Replica Instance

        These inherit their settings from the replication group.

        ```python
        import pulumi
        import pulumi_aws as aws

        replica = aws.elasticache.Cluster("replica",
            cluster_id="cluster-example",
            replication_group_id=example["id"])
        ```

        ### Redis Log Delivery configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.elasticache.Cluster("test",
            cluster_id="mycluster",
            engine="redis",
            node_type="cache.t3.micro",
            num_cache_nodes=1,
            port=6379,
            apply_immediately=True,
            log_delivery_configurations=[
                {
                    "destination": example["name"],
                    "destination_type": "cloudwatch-logs",
                    "log_format": "text",
                    "log_type": "slow-log",
                },
                {
                    "destination": example_aws_kinesis_firehose_delivery_stream["name"],
                    "destination_type": "kinesis-firehose",
                    "log_format": "json",
                    "log_type": "engine-log",
                },
            ])
        ```

        ### Elasticache Cluster in Outpost

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.outposts.get_outposts()
        example_get_outpost = aws.outposts.get_outpost(id=example.ids[0])
        example_vpc = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
        example_subnet = aws.ec2.Subnet("example",
            vpc_id=example_vpc.id,
            cidr_block="10.0.1.0/24",
            tags={
                "Name": "my-subnet",
            })
        example_subnet_group = aws.elasticache.SubnetGroup("example",
            name="my-cache-subnet",
            subnet_ids=[example_subnet.id])
        example_cluster = aws.elasticache.Cluster("example",
            cluster_id="cluster-example",
            outpost_mode="single-outpost",
            preferred_outpost_arn=example_get_outpost.arn,
            engine="memcached",
            node_type="cache.r5.large",
            num_cache_nodes=2,
            parameter_group_name="default.memcached1.4",
            port=11211,
            subnet_group_name=example_subnet_group.name)
        ```

        ## Import

        Using `pulumi import`, import ElastiCache Clusters using the `cluster_id`. For example:

        ```sh
        $ pulumi import aws:elasticache/cluster:Cluster my_cluster my_cluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] apply_immediately: Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
        :param pulumi.Input[_builtins.str] auto_minor_version_upgrade: Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
               Only supported for engine type `"redis"` and if the engine version is 6 or higher.
               Defaults to `true`.
        :param pulumi.Input[_builtins.str] availability_zone: Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] az_mode: Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
        :param pulumi.Input[_builtins.str] cluster_id: Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] engine: Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` and `valkey`.
        :param pulumi.Input[_builtins.str] engine_version: Version number of the cache engine to be used.
               If not set, defaults to the latest version.
               See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
               When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
               When the version is 6, the major and minor version can be set, e.g., `6.2`,
               or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
               Otherwise, specify the full version desired, e.g., `5.0.6`.
               The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: Name of your final cluster snapshot. If omitted, no final snapshot will be made.
        :param pulumi.Input[_builtins.str] ip_discovery: The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterLogDeliveryConfigurationArgs', 'ClusterLogDeliveryConfigurationArgsDict']]]] log_delivery_configurations: Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html). See Log Delivery Configuration below for more details.
        :param pulumi.Input[_builtins.str] maintenance_window: Specifies the weekly time range for when maintenance
               on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
               The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
        :param pulumi.Input[_builtins.str] network_type: The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        :param pulumi.Input[_builtins.str] node_type: The instance class used.
               See AWS documentation for information on [supported node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen) and [guidance on selecting node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.redis).
               See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen-Memcached) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.Mem).
               For Memcached, changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] notification_topic_arn: ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
        :param pulumi.Input[_builtins.int] num_cache_nodes: The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
        :param pulumi.Input[_builtins.str] outpost_mode: Specify the outpost mode that will apply to the cache cluster creation. Valid values are `"single-outpost"` and `"cross-outpost"`, however AWS currently only supports `"single-outpost"` mode.
        :param pulumi.Input[_builtins.str] parameter_group_name: The name of the parameter group to associate with this cache cluster.
        :param pulumi.Input[_builtins.int] port: The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_availability_zones: List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
        :param pulumi.Input[_builtins.str] preferred_outpost_arn: The outpost ARN in which the cache cluster will be created.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_group_id: ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: One or more VPC security groups associated with the cache cluster. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[_builtins.str] snapshot_arns: Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
        :param pulumi.Input[_builtins.str] snapshot_name: Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
        :param pulumi.Input[_builtins.int] snapshot_retention_limit: Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        :param pulumi.Input[_builtins.str] snapshot_window: Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
        :param pulumi.Input[_builtins.str] subnet_group_name: Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Enable encryption in-transit. Supported with Memcached versions `1.6.12` and later, Valkey `7.2` and later, Redis OSS versions `3.2.6`, `4.0.10` and later, running in a VPC. See the [ElastiCache in-transit encryption documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/in-transit-encryption.html#in-transit-encryption-constraints) for more details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an ElastiCache Cluster resource, which manages a Memcached cluster, a single-node Redis instance,
        or a read replica in a Redis (Cluster Mode Enabled) replication group. For more information, refer to
        the AWS document [What is Amazon ElastiCache?](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/WhatIs.html).

        For working with Redis (Cluster Mode Enabled) replication groups, see the
        `elasticache.ReplicationGroup` resource.

        > **Note:** When you change an attribute, such as `num_cache_nodes`, by default
        it is applied in the next maintenance window. Because of this, this provider may report
        a difference in its planning phase because the actual modification has not yet taken
        place. You can use the `apply_immediately` flag to instruct the service to apply the
        change immediately. Using `apply_immediately` can result in a brief downtime as the server reboots.
        See the "Changes take effect" section of the "Details" column in the AWS Documentation on Engine specific parameters for
        [ElastiCache for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/ParameterGroups.Engine.html#ParameterGroups.Memcached) or
        [ElastiCache for Valkey and Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/ParameterGroups.Engine.html#ParameterGroups.Redis)
        for more information.

        > **Note:** Any attribute changes that re-create the resource will be applied immediately, regardless of the value of `apply_immediately`.

        ## Example Usage

        ### Memcached Cluster

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.Cluster("example",
            cluster_id="cluster-example",
            engine="memcached",
            node_type="cache.m4.large",
            num_cache_nodes=2,
            parameter_group_name="default.memcached1.4",
            port=11211)
        ```

        ### Redis Instance

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.Cluster("example",
            cluster_id="cluster-example",
            engine="redis",
            node_type="cache.m4.large",
            num_cache_nodes=1,
            parameter_group_name="default.redis3.2",
            engine_version="3.2.10",
            port=6379)
        ```

        ### Redis Cluster Mode Disabled Read Replica Instance

        These inherit their settings from the replication group.

        ```python
        import pulumi
        import pulumi_aws as aws

        replica = aws.elasticache.Cluster("replica",
            cluster_id="cluster-example",
            replication_group_id=example["id"])
        ```

        ### Redis Log Delivery configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.elasticache.Cluster("test",
            cluster_id="mycluster",
            engine="redis",
            node_type="cache.t3.micro",
            num_cache_nodes=1,
            port=6379,
            apply_immediately=True,
            log_delivery_configurations=[
                {
                    "destination": example["name"],
                    "destination_type": "cloudwatch-logs",
                    "log_format": "text",
                    "log_type": "slow-log",
                },
                {
                    "destination": example_aws_kinesis_firehose_delivery_stream["name"],
                    "destination_type": "kinesis-firehose",
                    "log_format": "json",
                    "log_type": "engine-log",
                },
            ])
        ```

        ### Elasticache Cluster in Outpost

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.outposts.get_outposts()
        example_get_outpost = aws.outposts.get_outpost(id=example.ids[0])
        example_vpc = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
        example_subnet = aws.ec2.Subnet("example",
            vpc_id=example_vpc.id,
            cidr_block="10.0.1.0/24",
            tags={
                "Name": "my-subnet",
            })
        example_subnet_group = aws.elasticache.SubnetGroup("example",
            name="my-cache-subnet",
            subnet_ids=[example_subnet.id])
        example_cluster = aws.elasticache.Cluster("example",
            cluster_id="cluster-example",
            outpost_mode="single-outpost",
            preferred_outpost_arn=example_get_outpost.arn,
            engine="memcached",
            node_type="cache.r5.large",
            num_cache_nodes=2,
            parameter_group_name="default.memcached1.4",
            port=11211,
            subnet_group_name=example_subnet_group.name)
        ```

        ## Import

        Using `pulumi import`, import ElastiCache Clusters using the `cluster_id`. For example:

        ```sh
        $ pulumi import aws:elasticache/cluster:Cluster my_cluster my_cluster
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 az_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterLogDeliveryConfigurationArgs', 'ClusterLogDeliveryConfigurationArgsDict']]]]] = None,
                 maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 num_cache_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 outpost_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_outpost_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["az_mode"] = az_mode
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
            __props__.__dict__["ip_discovery"] = ip_discovery
            __props__.__dict__["log_delivery_configurations"] = log_delivery_configurations
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["notification_topic_arn"] = notification_topic_arn
            __props__.__dict__["num_cache_nodes"] = num_cache_nodes
            __props__.__dict__["outpost_mode"] = outpost_mode
            __props__.__dict__["parameter_group_name"] = parameter_group_name
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_availability_zones"] = preferred_availability_zones
            __props__.__dict__["preferred_outpost_arn"] = preferred_outpost_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["replication_group_id"] = replication_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["snapshot_arns"] = snapshot_arns
            __props__.__dict__["snapshot_name"] = snapshot_name
            __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
            __props__.__dict__["snapshot_window"] = snapshot_window
            __props__.__dict__["subnet_group_name"] = subnet_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_encryption_enabled"] = transit_encryption_enabled
            __props__.__dict__["arn"] = None
            __props__.__dict__["cache_nodes"] = None
            __props__.__dict__["cluster_address"] = None
            __props__.__dict__["configuration_endpoint"] = None
            __props__.__dict__["engine_version_actual"] = None
            __props__.__dict__["tags_all"] = None
        super(Cluster, __self__).__init__(
            'aws:elasticache/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            az_mode: Optional[pulumi.Input[_builtins.str]] = None,
            cache_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterCacheNodeArgs', 'ClusterCacheNodeArgsDict']]]]] = None,
            cluster_address: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version_actual: Optional[pulumi.Input[_builtins.str]] = None,
            final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
            log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterLogDeliveryConfigurationArgs', 'ClusterLogDeliveryConfigurationArgsDict']]]]] = None,
            maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
            num_cache_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            outpost_mode: Optional[pulumi.Input[_builtins.str]] = None,
            parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            preferred_outpost_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            snapshot_arns: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] apply_immediately: Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
        :param pulumi.Input[_builtins.str] arn: The ARN of the created ElastiCache Cluster.
        :param pulumi.Input[_builtins.str] auto_minor_version_upgrade: Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
               Only supported for engine type `"redis"` and if the engine version is 6 or higher.
               Defaults to `true`.
        :param pulumi.Input[_builtins.str] availability_zone: Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] az_mode: Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterCacheNodeArgs', 'ClusterCacheNodeArgsDict']]]] cache_nodes: List of node objects including `id`, `address`, `port` and `availability_zone`.
        :param pulumi.Input[_builtins.str] cluster_address: (Memcached only) DNS name of the cache cluster without the port appended.
        :param pulumi.Input[_builtins.str] cluster_id: Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] configuration_endpoint: (Memcached only) Configuration endpoint to allow host discovery.
        :param pulumi.Input[_builtins.str] engine: Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` and `valkey`.
        :param pulumi.Input[_builtins.str] engine_version: Version number of the cache engine to be used.
               If not set, defaults to the latest version.
               See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
               When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
               When the version is 6, the major and minor version can be set, e.g., `6.2`,
               or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
               Otherwise, specify the full version desired, e.g., `5.0.6`.
               The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[_builtins.str] engine_version_actual: Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: Name of your final cluster snapshot. If omitted, no final snapshot will be made.
        :param pulumi.Input[_builtins.str] ip_discovery: The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterLogDeliveryConfigurationArgs', 'ClusterLogDeliveryConfigurationArgsDict']]]] log_delivery_configurations: Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html). See Log Delivery Configuration below for more details.
        :param pulumi.Input[_builtins.str] maintenance_window: Specifies the weekly time range for when maintenance
               on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
               The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
        :param pulumi.Input[_builtins.str] network_type: The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        :param pulumi.Input[_builtins.str] node_type: The instance class used.
               See AWS documentation for information on [supported node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen) and [guidance on selecting node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.redis).
               See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen-Memcached) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.Mem).
               For Memcached, changing this value will re-create the resource.
        :param pulumi.Input[_builtins.str] notification_topic_arn: ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
        :param pulumi.Input[_builtins.int] num_cache_nodes: The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
        :param pulumi.Input[_builtins.str] outpost_mode: Specify the outpost mode that will apply to the cache cluster creation. Valid values are `"single-outpost"` and `"cross-outpost"`, however AWS currently only supports `"single-outpost"` mode.
        :param pulumi.Input[_builtins.str] parameter_group_name: The name of the parameter group to associate with this cache cluster.
        :param pulumi.Input[_builtins.int] port: The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_availability_zones: List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
        :param pulumi.Input[_builtins.str] preferred_outpost_arn: The outpost ARN in which the cache cluster will be created.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_group_id: ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: One or more VPC security groups associated with the cache cluster. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[_builtins.str] snapshot_arns: Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
        :param pulumi.Input[_builtins.str] snapshot_name: Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
        :param pulumi.Input[_builtins.int] snapshot_retention_limit: Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        :param pulumi.Input[_builtins.str] snapshot_window: Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
        :param pulumi.Input[_builtins.str] subnet_group_name: Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource. Cannot be provided with `replication_group_id.`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Enable encryption in-transit. Supported with Memcached versions `1.6.12` and later, Valkey `7.2` and later, Redis OSS versions `3.2.6`, `4.0.10` and later, running in a VPC. See the [ElastiCache in-transit encryption documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/in-transit-encryption.html#in-transit-encryption-constraints) for more details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["az_mode"] = az_mode
        __props__.__dict__["cache_nodes"] = cache_nodes
        __props__.__dict__["cluster_address"] = cluster_address
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["configuration_endpoint"] = configuration_endpoint
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["engine_version_actual"] = engine_version_actual
        __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
        __props__.__dict__["ip_discovery"] = ip_discovery
        __props__.__dict__["log_delivery_configurations"] = log_delivery_configurations
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["notification_topic_arn"] = notification_topic_arn
        __props__.__dict__["num_cache_nodes"] = num_cache_nodes
        __props__.__dict__["outpost_mode"] = outpost_mode
        __props__.__dict__["parameter_group_name"] = parameter_group_name
        __props__.__dict__["port"] = port
        __props__.__dict__["preferred_availability_zones"] = preferred_availability_zones
        __props__.__dict__["preferred_outpost_arn"] = preferred_outpost_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_group_id"] = replication_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["snapshot_arns"] = snapshot_arns
        __props__.__dict__["snapshot_name"] = snapshot_name
        __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
        __props__.__dict__["snapshot_window"] = snapshot_window
        __props__.__dict__["subnet_group_name"] = subnet_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["transit_encryption_enabled"] = transit_encryption_enabled
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
        """
        return pulumi.get(self, "apply_immediately")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the created ElastiCache Cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
        Only supported for engine type `"redis"` and if the engine version is 6 or higher.
        Defaults to `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="azMode")
    def az_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
        """
        return pulumi.get(self, "az_mode")

    @_builtins.property
    @pulumi.getter(name="cacheNodes")
    def cache_nodes(self) -> pulumi.Output[Sequence['outputs.ClusterCacheNode']]:
        """
        List of node objects including `id`, `address`, `port` and `availability_zone`.
        """
        return pulumi.get(self, "cache_nodes")

    @_builtins.property
    @pulumi.getter(name="clusterAddress")
    def cluster_address(self) -> pulumi.Output[_builtins.str]:
        """
        (Memcached only) DNS name of the cache cluster without the port appended.
        """
        return pulumi.get(self, "cluster_address")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="configurationEndpoint")
    def configuration_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (Memcached only) Configuration endpoint to allow host discovery.
        """
        return pulumi.get(self, "configuration_endpoint")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` and `valkey`.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version number of the cache engine to be used.
        If not set, defaults to the latest version.
        See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
        When the version is 6, the major and minor version can be set, e.g., `6.2`,
        or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
        Otherwise, specify the full version desired, e.g., `5.0.6`.
        The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. Cannot be provided with `replication_group_id.`
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> pulumi.Output[_builtins.str]:
        """
        Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
        """
        return pulumi.get(self, "engine_version_actual")

    @_builtins.property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of your final cluster snapshot. If omitted, no final snapshot will be made.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @_builtins.property
    @pulumi.getter(name="ipDiscovery")
    def ip_discovery(self) -> pulumi.Output[_builtins.str]:
        """
        The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_discovery")

    @_builtins.property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterLogDeliveryConfiguration']]]:
        """
        Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Log_Delivery.html). See Log Delivery Configuration below for more details.
        """
        return pulumi.get(self, "log_delivery_configurations")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the weekly time range for when maintenance
        on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
        The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        The instance class used.
        See AWS documentation for information on [supported node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen) and [guidance on selecting node types for Valkey or Redis OSS](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.redis).
        See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SupportedTypes.html#CacheNodes.CurrentGen-Memcached) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/CacheNodes.SelectSize.html#CacheNodes.SelectSize.Mem).
        For Memcached, changing this value will re-create the resource.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="notificationTopicArn")
    def notification_topic_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
        """
        return pulumi.get(self, "notification_topic_arn")

    @_builtins.property
    @pulumi.getter(name="numCacheNodes")
    def num_cache_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
        """
        return pulumi.get(self, "num_cache_nodes")

    @_builtins.property
    @pulumi.getter(name="outpostMode")
    def outpost_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify the outpost mode that will apply to the cache cluster creation. Valid values are `"single-outpost"` and `"cross-outpost"`, however AWS currently only supports `"single-outpost"` mode.
        """
        return pulumi.get(self, "outpost_mode")

    @_builtins.property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the parameter group to associate with this cache cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
        """
        return pulumi.get(self, "preferred_availability_zones")

    @_builtins.property
    @pulumi.getter(name="preferredOutpostArn")
    def preferred_outpost_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The outpost ARN in which the cache cluster will be created.
        """
        return pulumi.get(self, "preferred_outpost_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicationGroupId")
    def replication_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
        """
        return pulumi.get(self, "replication_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        One or more VPC security groups associated with the cache cluster. Cannot be provided with `replication_group_id.`
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
        """
        return pulumi.get(self, "snapshot_arns")

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
        """
        return pulumi.get(self, "snapshot_name")

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @_builtins.property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> pulumi.Output[_builtins.str]:
        """
        Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
        """
        return pulumi.get(self, "snapshot_window")

    @_builtins.property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource. Cannot be provided with `replication_group_id.`
        """
        return pulumi.get(self, "subnet_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable encryption in-transit. Supported with Memcached versions `1.6.12` and later, Valkey `7.2` and later, Redis OSS versions `3.2.6`, `4.0.10` and later, running in a VPC. See the [ElastiCache in-transit encryption documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/in-transit-encryption.html#in-transit-encryption-constraints) for more details.
        """
        return pulumi.get(self, "transit_encryption_enabled")

