# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicationGroupArgs', 'ReplicationGroup']

@pulumi.input_type
class ReplicationGroupArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_token_update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_tiering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 global_replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationArgs']]]] = None,
                 maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_az_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 num_cache_clusters: Optional[pulumi.Input[_builtins.int]] = None,
                 num_node_groups: Optional[pulumi.Input[_builtins.int]] = None,
                 parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_cache_cluster_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas_per_node_group: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ReplicationGroup resource.
        :param pulumi.Input[_builtins.str] description: User-created description for the replication group. Must not be empty.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
        :param pulumi.Input[_builtins.bool] at_rest_encryption_enabled: Whether to enable encryption at rest.
               When `engine` is `redis`, default is `false`.
               When `engine` is `valkey`, default is `true`.
        :param pulumi.Input[_builtins.str] auth_token: Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
        :param pulumi.Input[_builtins.str] auth_token_update_strategy: Strategy to use when updating the `auth_token`. Valid values are `SET`, `ROTATE`, and `DELETE`. Required if `auth_token` is set.
        :param pulumi.Input[_builtins.bool] auto_minor_version_upgrade: Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
               Only supported for engine types `"redis"` and `"valkey"` and if the engine version is 6 or higher.
               Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_failover_enabled: Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
        :param pulumi.Input[_builtins.str] cluster_mode: Specifies whether cluster mode is enabled or disabled. Valid values are `enabled` or `disabled` or `compatible`
        :param pulumi.Input[_builtins.bool] data_tiering_enabled: Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
        :param pulumi.Input[_builtins.str] engine: Name of the cache engine to be used for the clusters in this replication group.
               Valid values are `redis` or `valkey`.
               Default is `redis`.
        :param pulumi.Input[_builtins.str] engine_version: Version number of the cache engine to be used for the cache clusters in this replication group.
               If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
               If the version is 6, the major and minor version can be set, e.g., `6.2`,
               or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
               Otherwise, specify the full version desired, e.g., `5.0.6`.
               The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
        :param pulumi.Input[_builtins.str] global_replication_group_id: The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
        :param pulumi.Input[_builtins.str] ip_discovery: The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        :param pulumi.Input[_builtins.str] kms_key_id: The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationArgs']]] log_delivery_configurations: Specifies the destination and format of Redis OSS/Valkey [SLOWLOG](https://redis.io/commands/slowlog) or Redis OSS/Valkey [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
        :param pulumi.Input[_builtins.str] maintenance_window: Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
        :param pulumi.Input[_builtins.bool] multi_az_enabled: Specifies whether to enable Multi-AZ Support for the replication group.
               If `true`, `automatic_failover_enabled` must also be enabled.
               Defaults to `false`.
        :param pulumi.Input[_builtins.str] network_type: The IP versions for cache cluster connections. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        :param pulumi.Input[_builtins.str] node_type: Instance class to be used.
               See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
               Required unless `global_replication_group_id` is set.
               Cannot be set if `global_replication_group_id` is set.
        :param pulumi.Input[_builtins.str] notification_topic_arn: ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
        :param pulumi.Input[_builtins.int] num_cache_clusters: Number of cache clusters (primary and replicas) this replication group will have.
               If `automatic_failover_enabled` or `multi_az_enabled` are `true`, must be at least 2.
               Updates will occur before other modifications.
               Conflicts with `num_node_groups` and `replicas_per_node_group`.
               Defaults to `1`.
        :param pulumi.Input[_builtins.int] num_node_groups: Number of node groups (shards) for this Redis replication group.
               Changing this number will trigger a resizing operation before other settings modifications.
               Conflicts with `num_cache_clusters`.
        :param pulumi.Input[_builtins.str] parameter_group_name: Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable "cluster mode", i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
        :param pulumi.Input[_builtins.int] port: Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_cache_cluster_azs: List of EC2 availability zones in which the replication group's cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] replicas_per_node_group: Number of replica nodes in each node group.
               Changing this number will trigger a resizing operation before other settings modifications.
               Valid values are 0 to 5.
               Conflicts with `num_cache_clusters`.
               Can only be set if `num_node_groups` is set.
        :param pulumi.Input[_builtins.str] replication_group_id: Replication group identifier. This parameter is stored as a lowercase string.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: IDs of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_names: Names of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snapshot_arns: List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
        :param pulumi.Input[_builtins.str] snapshot_name: Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
        :param pulumi.Input[_builtins.int] snapshot_retention_limit: Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        :param pulumi.Input[_builtins.str] snapshot_window: Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
        :param pulumi.Input[_builtins.str] subnet_group_name: Name of the cache subnet group to be used for the replication group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Whether to enable encryption in transit.
               Changing this argument with an `engine_version` < `7.0.5` will force a replacement.
               Engine versions prior to `7.0.5` only allow this transit encryption to be configured during creation of the replication group.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: A setting that enables clients to migrate to in-transit encryption with no downtime.
               Valid values are `preferred` and `required`.
               When enabling encryption on an existing replication group, this must first be set to `preferred` before setting it to `required` in a subsequent apply.
               See the `TransitEncryptionMode` field in the [`CreateReplicationGroup` API documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateReplicationGroup.html) for additional details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_group_ids: User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
        """
        pulumi.set(__self__, "description", description)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if at_rest_encryption_enabled is not None:
            pulumi.set(__self__, "at_rest_encryption_enabled", at_rest_encryption_enabled)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if auth_token_update_strategy is not None:
            pulumi.set(__self__, "auth_token_update_strategy", auth_token_update_strategy)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if automatic_failover_enabled is not None:
            pulumi.set(__self__, "automatic_failover_enabled", automatic_failover_enabled)
        if cluster_mode is not None:
            pulumi.set(__self__, "cluster_mode", cluster_mode)
        if data_tiering_enabled is not None:
            pulumi.set(__self__, "data_tiering_enabled", data_tiering_enabled)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if global_replication_group_id is not None:
            pulumi.set(__self__, "global_replication_group_id", global_replication_group_id)
        if ip_discovery is not None:
            pulumi.set(__self__, "ip_discovery", ip_discovery)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_delivery_configurations is not None:
            pulumi.set(__self__, "log_delivery_configurations", log_delivery_configurations)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if multi_az_enabled is not None:
            pulumi.set(__self__, "multi_az_enabled", multi_az_enabled)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if notification_topic_arn is not None:
            pulumi.set(__self__, "notification_topic_arn", notification_topic_arn)
        if num_cache_clusters is not None:
            pulumi.set(__self__, "num_cache_clusters", num_cache_clusters)
        if num_node_groups is not None:
            pulumi.set(__self__, "num_node_groups", num_node_groups)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_cache_cluster_azs is not None:
            pulumi.set(__self__, "preferred_cache_cluster_azs", preferred_cache_cluster_azs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas_per_node_group is not None:
            pulumi.set(__self__, "replicas_per_node_group", replicas_per_node_group)
        if replication_group_id is not None:
            pulumi.set(__self__, "replication_group_id", replication_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_group_names is not None:
            pulumi.set(__self__, "security_group_names", security_group_names)
        if snapshot_arns is not None:
            pulumi.set(__self__, "snapshot_arns", snapshot_arns)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if subnet_group_name is not None:
            pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_encryption_enabled is not None:
            pulumi.set(__self__, "transit_encryption_enabled", transit_encryption_enabled)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if user_group_ids is not None:
            pulumi.set(__self__, "user_group_ids", user_group_ids)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        User-created description for the replication group. Must not be empty.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @_builtins.property
    @pulumi.getter(name="atRestEncryptionEnabled")
    def at_rest_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable encryption at rest.
        When `engine` is `redis`, default is `false`.
        When `engine` is `valkey`, default is `true`.
        """
        return pulumi.get(self, "at_rest_encryption_enabled")

    @at_rest_encryption_enabled.setter
    def at_rest_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "at_rest_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_token", value)

    @_builtins.property
    @pulumi.getter(name="authTokenUpdateStrategy")
    def auth_token_update_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Strategy to use when updating the `auth_token`. Valid values are `SET`, `ROTATE`, and `DELETE`. Required if `auth_token` is set.
        """
        return pulumi.get(self, "auth_token_update_strategy")

    @auth_token_update_strategy.setter
    def auth_token_update_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_token_update_strategy", value)

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
        Only supported for engine types `"redis"` and `"valkey"` and if the engine version is 6 or higher.
        Defaults to `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_failover_enabled")

    @automatic_failover_enabled.setter
    def automatic_failover_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_failover_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clusterMode")
    def cluster_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether cluster mode is enabled or disabled. Valid values are `enabled` or `disabled` or `compatible`
        """
        return pulumi.get(self, "cluster_mode")

    @cluster_mode.setter
    def cluster_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataTieringEnabled")
    def data_tiering_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
        """
        return pulumi.get(self, "data_tiering_enabled")

    @data_tiering_enabled.setter
    def data_tiering_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_tiering_enabled", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cache engine to be used for the clusters in this replication group.
        Valid values are `redis` or `valkey`.
        Default is `redis`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of the cache engine to be used for the cache clusters in this replication group.
        If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
        If the version is 6, the major and minor version can be set, e.g., `6.2`,
        or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
        Otherwise, specify the full version desired, e.g., `5.0.6`.
        The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter(name="globalReplicationGroupId")
    def global_replication_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
        """
        return pulumi.get(self, "global_replication_group_id")

    @global_replication_group_id.setter
    def global_replication_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_replication_group_id", value)

    @_builtins.property
    @pulumi.getter(name="ipDiscovery")
    def ip_discovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_discovery")

    @ip_discovery.setter
    def ip_discovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_discovery", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationArgs']]]]:
        """
        Specifies the destination and format of Redis OSS/Valkey [SLOWLOG](https://redis.io/commands/slowlog) or Redis OSS/Valkey [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
        """
        return pulumi.get(self, "log_delivery_configurations")

    @log_delivery_configurations.setter
    def log_delivery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationArgs']]]]):
        pulumi.set(self, "log_delivery_configurations", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="multiAzEnabled")
    def multi_az_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable Multi-AZ Support for the replication group.
        If `true`, `automatic_failover_enabled` must also be enabled.
        Defaults to `false`.
        """
        return pulumi.get(self, "multi_az_enabled")

    @multi_az_enabled.setter
    def multi_az_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_az_enabled", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP versions for cache cluster connections. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance class to be used.
        See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
        Required unless `global_replication_group_id` is set.
        Cannot be set if `global_replication_group_id` is set.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="notificationTopicArn")
    def notification_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
        """
        return pulumi.get(self, "notification_topic_arn")

    @notification_topic_arn.setter
    def notification_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="numCacheClusters")
    def num_cache_clusters(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of cache clusters (primary and replicas) this replication group will have.
        If `automatic_failover_enabled` or `multi_az_enabled` are `true`, must be at least 2.
        Updates will occur before other modifications.
        Conflicts with `num_node_groups` and `replicas_per_node_group`.
        Defaults to `1`.
        """
        return pulumi.get(self, "num_cache_clusters")

    @num_cache_clusters.setter
    def num_cache_clusters(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cache_clusters", value)

    @_builtins.property
    @pulumi.getter(name="numNodeGroups")
    def num_node_groups(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of node groups (shards) for this Redis replication group.
        Changing this number will trigger a resizing operation before other settings modifications.
        Conflicts with `num_cache_clusters`.
        """
        return pulumi.get(self, "num_node_groups")

    @num_node_groups.setter
    def num_node_groups(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_node_groups", value)

    @_builtins.property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable "cluster mode", i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter_group_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="preferredCacheClusterAzs")
    def preferred_cache_cluster_azs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of EC2 availability zones in which the replication group's cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
        """
        return pulumi.get(self, "preferred_cache_cluster_azs")

    @preferred_cache_cluster_azs.setter
    def preferred_cache_cluster_azs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_cache_cluster_azs", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicasPerNodeGroup")
    def replicas_per_node_group(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of replica nodes in each node group.
        Changing this number will trigger a resizing operation before other settings modifications.
        Valid values are 0 to 5.
        Conflicts with `num_cache_clusters`.
        Can only be set if `num_node_groups` is set.
        """
        return pulumi.get(self, "replicas_per_node_group")

    @replicas_per_node_group.setter
    def replicas_per_node_group(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas_per_node_group", value)

    @_builtins.property
    @pulumi.getter(name="replicationGroupId")
    def replication_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Replication group identifier. This parameter is stored as a lowercase string.

        The following arguments are optional:
        """
        return pulumi.get(self, "replication_group_id")

    @replication_group_id.setter
    def replication_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IDs of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupNames")
    def security_group_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Names of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        """
        return pulumi.get(self, "security_group_names")

    @security_group_names.setter
    def security_group_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_names", value)

    @_builtins.property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
        """
        return pulumi.get(self, "snapshot_arns")

    @snapshot_arns.setter
    def snapshot_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "snapshot_arns", value)

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @_builtins.property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
        """
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_window", value)

    @_builtins.property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cache subnet group to be used for the replication group.
        """
        return pulumi.get(self, "subnet_group_name")

    @subnet_group_name.setter
    def subnet_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable encryption in transit.
        Changing this argument with an `engine_version` < `7.0.5` will force a replacement.
        Engine versions prior to `7.0.5` only allow this transit encryption to be configured during creation of the replication group.
        """
        return pulumi.get(self, "transit_encryption_enabled")

    @transit_encryption_enabled.setter
    def transit_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transit_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A setting that enables clients to migrate to in-transit encryption with no downtime.
        Valid values are `preferred` and `required`.
        When enabling encryption on an existing replication group, this must first be set to `preferred` before setting it to `required` in a subsequent apply.
        See the `TransitEncryptionMode` field in the [`CreateReplicationGroup` API documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateReplicationGroup.html) for additional details.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
        """
        return pulumi.get(self, "user_group_ids")

    @user_group_ids.setter
    def user_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_group_ids", value)


@pulumi.input_type
class _ReplicationGroupState:
    def __init__(__self__, *,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_token_update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_endpoint_address: Optional[pulumi.Input[_builtins.str]] = None,
                 data_tiering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version_actual: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 global_replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationArgs']]]] = None,
                 maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 member_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 multi_az_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 num_cache_clusters: Optional[pulumi.Input[_builtins.int]] = None,
                 num_node_groups: Optional[pulumi.Input[_builtins.int]] = None,
                 parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_cache_cluster_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 primary_endpoint_address: Optional[pulumi.Input[_builtins.str]] = None,
                 reader_endpoint_address: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas_per_node_group: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ReplicationGroup resources.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
        :param pulumi.Input[_builtins.str] arn: ARN of the created ElastiCache Replication Group.
        :param pulumi.Input[_builtins.bool] at_rest_encryption_enabled: Whether to enable encryption at rest.
               When `engine` is `redis`, default is `false`.
               When `engine` is `valkey`, default is `true`.
        :param pulumi.Input[_builtins.str] auth_token: Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
        :param pulumi.Input[_builtins.str] auth_token_update_strategy: Strategy to use when updating the `auth_token`. Valid values are `SET`, `ROTATE`, and `DELETE`. Required if `auth_token` is set.
        :param pulumi.Input[_builtins.bool] auto_minor_version_upgrade: Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
               Only supported for engine types `"redis"` and `"valkey"` and if the engine version is 6 or higher.
               Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_failover_enabled: Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] cluster_enabled: Indicates if cluster mode is enabled.
        :param pulumi.Input[_builtins.str] cluster_mode: Specifies whether cluster mode is enabled or disabled. Valid values are `enabled` or `disabled` or `compatible`
        :param pulumi.Input[_builtins.str] configuration_endpoint_address: Address of the replication group configuration endpoint when cluster mode is enabled.
        :param pulumi.Input[_builtins.bool] data_tiering_enabled: Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
        :param pulumi.Input[_builtins.str] description: User-created description for the replication group. Must not be empty.
        :param pulumi.Input[_builtins.str] engine: Name of the cache engine to be used for the clusters in this replication group.
               Valid values are `redis` or `valkey`.
               Default is `redis`.
        :param pulumi.Input[_builtins.str] engine_version: Version number of the cache engine to be used for the cache clusters in this replication group.
               If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
               If the version is 6, the major and minor version can be set, e.g., `6.2`,
               or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
               Otherwise, specify the full version desired, e.g., `5.0.6`.
               The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
        :param pulumi.Input[_builtins.str] engine_version_actual: Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
        :param pulumi.Input[_builtins.str] global_replication_group_id: The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
        :param pulumi.Input[_builtins.str] ip_discovery: The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        :param pulumi.Input[_builtins.str] kms_key_id: The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationArgs']]] log_delivery_configurations: Specifies the destination and format of Redis OSS/Valkey [SLOWLOG](https://redis.io/commands/slowlog) or Redis OSS/Valkey [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
        :param pulumi.Input[_builtins.str] maintenance_window: Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] member_clusters: Identifiers of all the nodes that are part of this replication group.
        :param pulumi.Input[_builtins.bool] multi_az_enabled: Specifies whether to enable Multi-AZ Support for the replication group.
               If `true`, `automatic_failover_enabled` must also be enabled.
               Defaults to `false`.
        :param pulumi.Input[_builtins.str] network_type: The IP versions for cache cluster connections. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        :param pulumi.Input[_builtins.str] node_type: Instance class to be used.
               See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
               Required unless `global_replication_group_id` is set.
               Cannot be set if `global_replication_group_id` is set.
        :param pulumi.Input[_builtins.str] notification_topic_arn: ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
        :param pulumi.Input[_builtins.int] num_cache_clusters: Number of cache clusters (primary and replicas) this replication group will have.
               If `automatic_failover_enabled` or `multi_az_enabled` are `true`, must be at least 2.
               Updates will occur before other modifications.
               Conflicts with `num_node_groups` and `replicas_per_node_group`.
               Defaults to `1`.
        :param pulumi.Input[_builtins.int] num_node_groups: Number of node groups (shards) for this Redis replication group.
               Changing this number will trigger a resizing operation before other settings modifications.
               Conflicts with `num_cache_clusters`.
        :param pulumi.Input[_builtins.str] parameter_group_name: Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable "cluster mode", i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
        :param pulumi.Input[_builtins.int] port: Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_cache_cluster_azs: List of EC2 availability zones in which the replication group's cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
        :param pulumi.Input[_builtins.str] primary_endpoint_address: (Redis only) Address of the endpoint for the primary node in the replication group, if the cluster mode is disabled.
        :param pulumi.Input[_builtins.str] reader_endpoint_address: (Redis only) Address of the endpoint for the reader node in the replication group, if the cluster mode is disabled.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] replicas_per_node_group: Number of replica nodes in each node group.
               Changing this number will trigger a resizing operation before other settings modifications.
               Valid values are 0 to 5.
               Conflicts with `num_cache_clusters`.
               Can only be set if `num_node_groups` is set.
        :param pulumi.Input[_builtins.str] replication_group_id: Replication group identifier. This parameter is stored as a lowercase string.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: IDs of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_names: Names of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snapshot_arns: List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
        :param pulumi.Input[_builtins.str] snapshot_name: Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
        :param pulumi.Input[_builtins.int] snapshot_retention_limit: Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        :param pulumi.Input[_builtins.str] snapshot_window: Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
        :param pulumi.Input[_builtins.str] subnet_group_name: Name of the cache subnet group to be used for the replication group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Whether to enable encryption in transit.
               Changing this argument with an `engine_version` < `7.0.5` will force a replacement.
               Engine versions prior to `7.0.5` only allow this transit encryption to be configured during creation of the replication group.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: A setting that enables clients to migrate to in-transit encryption with no downtime.
               Valid values are `preferred` and `required`.
               When enabling encryption on an existing replication group, this must first be set to `preferred` before setting it to `required` in a subsequent apply.
               See the `TransitEncryptionMode` field in the [`CreateReplicationGroup` API documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateReplicationGroup.html) for additional details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_group_ids: User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
        """
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if at_rest_encryption_enabled is not None:
            pulumi.set(__self__, "at_rest_encryption_enabled", at_rest_encryption_enabled)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if auth_token_update_strategy is not None:
            pulumi.set(__self__, "auth_token_update_strategy", auth_token_update_strategy)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if automatic_failover_enabled is not None:
            pulumi.set(__self__, "automatic_failover_enabled", automatic_failover_enabled)
        if cluster_enabled is not None:
            pulumi.set(__self__, "cluster_enabled", cluster_enabled)
        if cluster_mode is not None:
            pulumi.set(__self__, "cluster_mode", cluster_mode)
        if configuration_endpoint_address is not None:
            pulumi.set(__self__, "configuration_endpoint_address", configuration_endpoint_address)
        if data_tiering_enabled is not None:
            pulumi.set(__self__, "data_tiering_enabled", data_tiering_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if engine_version_actual is not None:
            pulumi.set(__self__, "engine_version_actual", engine_version_actual)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if global_replication_group_id is not None:
            pulumi.set(__self__, "global_replication_group_id", global_replication_group_id)
        if ip_discovery is not None:
            pulumi.set(__self__, "ip_discovery", ip_discovery)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_delivery_configurations is not None:
            pulumi.set(__self__, "log_delivery_configurations", log_delivery_configurations)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if member_clusters is not None:
            pulumi.set(__self__, "member_clusters", member_clusters)
        if multi_az_enabled is not None:
            pulumi.set(__self__, "multi_az_enabled", multi_az_enabled)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if notification_topic_arn is not None:
            pulumi.set(__self__, "notification_topic_arn", notification_topic_arn)
        if num_cache_clusters is not None:
            pulumi.set(__self__, "num_cache_clusters", num_cache_clusters)
        if num_node_groups is not None:
            pulumi.set(__self__, "num_node_groups", num_node_groups)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_cache_cluster_azs is not None:
            pulumi.set(__self__, "preferred_cache_cluster_azs", preferred_cache_cluster_azs)
        if primary_endpoint_address is not None:
            pulumi.set(__self__, "primary_endpoint_address", primary_endpoint_address)
        if reader_endpoint_address is not None:
            pulumi.set(__self__, "reader_endpoint_address", reader_endpoint_address)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas_per_node_group is not None:
            pulumi.set(__self__, "replicas_per_node_group", replicas_per_node_group)
        if replication_group_id is not None:
            pulumi.set(__self__, "replication_group_id", replication_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_group_names is not None:
            pulumi.set(__self__, "security_group_names", security_group_names)
        if snapshot_arns is not None:
            pulumi.set(__self__, "snapshot_arns", snapshot_arns)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if subnet_group_name is not None:
            pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if transit_encryption_enabled is not None:
            pulumi.set(__self__, "transit_encryption_enabled", transit_encryption_enabled)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if user_group_ids is not None:
            pulumi.set(__self__, "user_group_ids", user_group_ids)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the created ElastiCache Replication Group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="atRestEncryptionEnabled")
    def at_rest_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable encryption at rest.
        When `engine` is `redis`, default is `false`.
        When `engine` is `valkey`, default is `true`.
        """
        return pulumi.get(self, "at_rest_encryption_enabled")

    @at_rest_encryption_enabled.setter
    def at_rest_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "at_rest_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_token", value)

    @_builtins.property
    @pulumi.getter(name="authTokenUpdateStrategy")
    def auth_token_update_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Strategy to use when updating the `auth_token`. Valid values are `SET`, `ROTATE`, and `DELETE`. Required if `auth_token` is set.
        """
        return pulumi.get(self, "auth_token_update_strategy")

    @auth_token_update_strategy.setter
    def auth_token_update_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_token_update_strategy", value)

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
        Only supported for engine types `"redis"` and `"valkey"` and if the engine version is 6 or higher.
        Defaults to `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_failover_enabled")

    @automatic_failover_enabled.setter
    def automatic_failover_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_failover_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clusterEnabled")
    def cluster_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if cluster mode is enabled.
        """
        return pulumi.get(self, "cluster_enabled")

    @cluster_enabled.setter
    def cluster_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cluster_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clusterMode")
    def cluster_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether cluster mode is enabled or disabled. Valid values are `enabled` or `disabled` or `compatible`
        """
        return pulumi.get(self, "cluster_mode")

    @cluster_mode.setter
    def cluster_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_mode", value)

    @_builtins.property
    @pulumi.getter(name="configurationEndpointAddress")
    def configuration_endpoint_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Address of the replication group configuration endpoint when cluster mode is enabled.
        """
        return pulumi.get(self, "configuration_endpoint_address")

    @configuration_endpoint_address.setter
    def configuration_endpoint_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_endpoint_address", value)

    @_builtins.property
    @pulumi.getter(name="dataTieringEnabled")
    def data_tiering_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
        """
        return pulumi.get(self, "data_tiering_enabled")

    @data_tiering_enabled.setter
    def data_tiering_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_tiering_enabled", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-created description for the replication group. Must not be empty.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cache engine to be used for the clusters in this replication group.
        Valid values are `redis` or `valkey`.
        Default is `redis`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of the cache engine to be used for the cache clusters in this replication group.
        If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
        If the version is 6, the major and minor version can be set, e.g., `6.2`,
        or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
        Otherwise, specify the full version desired, e.g., `5.0.6`.
        The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
        """
        return pulumi.get(self, "engine_version_actual")

    @engine_version_actual.setter
    def engine_version_actual(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version_actual", value)

    @_builtins.property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter(name="globalReplicationGroupId")
    def global_replication_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
        """
        return pulumi.get(self, "global_replication_group_id")

    @global_replication_group_id.setter
    def global_replication_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_replication_group_id", value)

    @_builtins.property
    @pulumi.getter(name="ipDiscovery")
    def ip_discovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_discovery")

    @ip_discovery.setter
    def ip_discovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_discovery", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationArgs']]]]:
        """
        Specifies the destination and format of Redis OSS/Valkey [SLOWLOG](https://redis.io/commands/slowlog) or Redis OSS/Valkey [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
        """
        return pulumi.get(self, "log_delivery_configurations")

    @log_delivery_configurations.setter
    def log_delivery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationArgs']]]]):
        pulumi.set(self, "log_delivery_configurations", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="memberClusters")
    def member_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Identifiers of all the nodes that are part of this replication group.
        """
        return pulumi.get(self, "member_clusters")

    @member_clusters.setter
    def member_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "member_clusters", value)

    @_builtins.property
    @pulumi.getter(name="multiAzEnabled")
    def multi_az_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable Multi-AZ Support for the replication group.
        If `true`, `automatic_failover_enabled` must also be enabled.
        Defaults to `false`.
        """
        return pulumi.get(self, "multi_az_enabled")

    @multi_az_enabled.setter
    def multi_az_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_az_enabled", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP versions for cache cluster connections. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance class to be used.
        See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
        Required unless `global_replication_group_id` is set.
        Cannot be set if `global_replication_group_id` is set.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="notificationTopicArn")
    def notification_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
        """
        return pulumi.get(self, "notification_topic_arn")

    @notification_topic_arn.setter
    def notification_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="numCacheClusters")
    def num_cache_clusters(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of cache clusters (primary and replicas) this replication group will have.
        If `automatic_failover_enabled` or `multi_az_enabled` are `true`, must be at least 2.
        Updates will occur before other modifications.
        Conflicts with `num_node_groups` and `replicas_per_node_group`.
        Defaults to `1`.
        """
        return pulumi.get(self, "num_cache_clusters")

    @num_cache_clusters.setter
    def num_cache_clusters(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cache_clusters", value)

    @_builtins.property
    @pulumi.getter(name="numNodeGroups")
    def num_node_groups(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of node groups (shards) for this Redis replication group.
        Changing this number will trigger a resizing operation before other settings modifications.
        Conflicts with `num_cache_clusters`.
        """
        return pulumi.get(self, "num_node_groups")

    @num_node_groups.setter
    def num_node_groups(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_node_groups", value)

    @_builtins.property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable "cluster mode", i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter_group_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="preferredCacheClusterAzs")
    def preferred_cache_cluster_azs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of EC2 availability zones in which the replication group's cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
        """
        return pulumi.get(self, "preferred_cache_cluster_azs")

    @preferred_cache_cluster_azs.setter
    def preferred_cache_cluster_azs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_cache_cluster_azs", value)

    @_builtins.property
    @pulumi.getter(name="primaryEndpointAddress")
    def primary_endpoint_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Redis only) Address of the endpoint for the primary node in the replication group, if the cluster mode is disabled.
        """
        return pulumi.get(self, "primary_endpoint_address")

    @primary_endpoint_address.setter
    def primary_endpoint_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_endpoint_address", value)

    @_builtins.property
    @pulumi.getter(name="readerEndpointAddress")
    def reader_endpoint_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Redis only) Address of the endpoint for the reader node in the replication group, if the cluster mode is disabled.
        """
        return pulumi.get(self, "reader_endpoint_address")

    @reader_endpoint_address.setter
    def reader_endpoint_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reader_endpoint_address", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicasPerNodeGroup")
    def replicas_per_node_group(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of replica nodes in each node group.
        Changing this number will trigger a resizing operation before other settings modifications.
        Valid values are 0 to 5.
        Conflicts with `num_cache_clusters`.
        Can only be set if `num_node_groups` is set.
        """
        return pulumi.get(self, "replicas_per_node_group")

    @replicas_per_node_group.setter
    def replicas_per_node_group(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas_per_node_group", value)

    @_builtins.property
    @pulumi.getter(name="replicationGroupId")
    def replication_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Replication group identifier. This parameter is stored as a lowercase string.

        The following arguments are optional:
        """
        return pulumi.get(self, "replication_group_id")

    @replication_group_id.setter
    def replication_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IDs of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupNames")
    def security_group_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Names of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        """
        return pulumi.get(self, "security_group_names")

    @security_group_names.setter
    def security_group_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_names", value)

    @_builtins.property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
        """
        return pulumi.get(self, "snapshot_arns")

    @snapshot_arns.setter
    def snapshot_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "snapshot_arns", value)

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @_builtins.property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
        """
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_window", value)

    @_builtins.property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cache subnet group to be used for the replication group.
        """
        return pulumi.get(self, "subnet_group_name")

    @subnet_group_name.setter
    def subnet_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable encryption in transit.
        Changing this argument with an `engine_version` < `7.0.5` will force a replacement.
        Engine versions prior to `7.0.5` only allow this transit encryption to be configured during creation of the replication group.
        """
        return pulumi.get(self, "transit_encryption_enabled")

    @transit_encryption_enabled.setter
    def transit_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transit_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A setting that enables clients to migrate to in-transit encryption with no downtime.
        Valid values are `preferred` and `required`.
        When enabling encryption on an existing replication group, this must first be set to `preferred` before setting it to `required` in a subsequent apply.
        See the `TransitEncryptionMode` field in the [`CreateReplicationGroup` API documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateReplicationGroup.html) for additional details.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
        """
        return pulumi.get(self, "user_group_ids")

    @user_group_ids.setter
    def user_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_group_ids", value)


@pulumi.type_token("aws:elasticache/replicationGroup:ReplicationGroup")
class ReplicationGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_token_update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_tiering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 global_replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationGroupLogDeliveryConfigurationArgs', 'ReplicationGroupLogDeliveryConfigurationArgsDict']]]]] = None,
                 maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_az_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 num_cache_clusters: Optional[pulumi.Input[_builtins.int]] = None,
                 num_node_groups: Optional[pulumi.Input[_builtins.int]] = None,
                 parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_cache_cluster_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas_per_node_group: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an ElastiCache Replication Group resource.

        For working with a [Memcached cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/WhatIs.html) or a
        [single-node Redis instance (Cluster Mode Disabled)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/WhatIs.html),
        see the `elasticache.Cluster` resource.

        > **Note:** When you change an attribute, such as `engine_version`, by
        default the ElastiCache API applies it in the next maintenance window. Because
        of this, this provider may report a difference in its planning phase because the
        actual modification has not yet taken place. You can use the
        `apply_immediately` flag to instruct the service to apply the change
        immediately. Using `apply_immediately` can result in a brief downtime as
        servers reboots.
        See the AWS Documentation on
        [Modifying an ElastiCache Cache Cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Modify.html)
        for more information.

        > **Note:** Any attribute changes that re-create the resource will be applied immediately, regardless of the value of `apply_immediately`.

        > **Note:** Be aware of the terminology collision around "cluster" for `elasticache.ReplicationGroup`. For example, it is possible to create a ["Cluster Mode Disabled [Redis] Cluster"](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Create.CON.Redis.html). With "Cluster Mode Enabled", the data will be stored in shards (called "node groups"). See [Redis Cluster Configuration](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/cluster-create-determine-requirements.html#redis-cluster-configuration) for a diagram of the differences. To enable cluster mode, use a parameter group that has cluster mode enabled. The default parameter groups provided by AWS end with ".cluster.on", for example `default.redis6.x.cluster.on`.

        ## Example Usage

        ### Redis OSS/Valkey Cluster Mode Disabled

        To create a single shard primary with single read replica:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ReplicationGroup("example",
            automatic_failover_enabled=True,
            preferred_cache_cluster_azs=[
                "us-west-2a",
                "us-west-2b",
            ],
            replication_group_id="tf-rep-group-1",
            description="example description",
            node_type="cache.m4.large",
            num_cache_clusters=2,
            parameter_group_name="default.redis3.2",
            port=6379)
        ```

        You have two options for adjusting the number of replicas:

        * Adjusting `num_cache_clusters` directly. This will attempt to automatically add or remove replicas, but provides no granular control (e.g., preferred availability zone, cache cluster ID) for the added or removed replicas. This also currently expects cache cluster IDs in the form of `replication_group_id-00#`.
        * Otherwise for fine grained control of the underlying cache clusters, they can be added or removed with the `elasticache.Cluster` resource and its `replication_group_id` attribute. In this situation, you will need to utilize [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to prevent perpetual differences with the `number_cache_cluster` attribute.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ReplicationGroup("example",
            automatic_failover_enabled=True,
            preferred_cache_cluster_azs=[
                "us-west-2a",
                "us-west-2b",
            ],
            replication_group_id="tf-rep-group-1",
            description="example description",
            node_type="cache.m4.large",
            num_cache_clusters=2,
            parameter_group_name="default.redis3.2",
            port=6379)
        replica = []
        for range in [{"value": i} for i in range(0, 1)]:
            replica.append(aws.elasticache.Cluster(f"replica-{range['value']}",
                cluster_id=f"tf-rep-group-1-{range['value']}",
                replication_group_id=example.id))
        ```

        ### Redis OSS/Valkey Cluster Mode Enabled

        To create two shards with a primary and a single read replica each:

        ```python
        import pulumi
        import pulumi_aws as aws

        baz = aws.elasticache.ReplicationGroup("baz",
            replication_group_id="tf-redis-cluster",
            description="example description",
            node_type="cache.t2.small",
            port=6379,
            parameter_group_name="default.redis3.2.cluster.on",
            automatic_failover_enabled=True,
            num_node_groups=2,
            replicas_per_node_group=1)
        ```

        ### Redis Log Delivery configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.elasticache.ReplicationGroup("test",
            replication_group_id="myreplicaciongroup",
            description="test description",
            node_type="cache.t3.small",
            port=6379,
            apply_immediately=True,
            auto_minor_version_upgrade=False,
            maintenance_window="tue:06:30-tue:07:30",
            snapshot_window="01:00-02:00",
            log_delivery_configurations=[
                {
                    "destination": example["name"],
                    "destination_type": "cloudwatch-logs",
                    "log_format": "text",
                    "log_type": "slow-log",
                },
                {
                    "destination": example_aws_kinesis_firehose_delivery_stream["name"],
                    "destination_type": "kinesis-firehose",
                    "log_format": "json",
                    "log_type": "engine-log",
                },
            ])
        ```

        > **Note:** We currently do not support passing a `primary_cluster_id` in order to create the Replication Group.

        > **Note:** Automatic Failover is unavailable for Redis versions earlier than 2.8.6,
        and unavailable on T1 node types. For T2 node types, it is only available on Redis version 3.2.4 or later with cluster mode enabled. See the [High Availability Using Replication Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Replication.html) guide
        for full details on using Replication Groups.

        ### Creating a secondary replication group for a global replication group

        A Global Replication Group can have up to two secondary Replication Groups in different regions. These are added to an existing Global Replication Group.

        ```python
        import pulumi
        import pulumi_aws as aws

        primary = aws.elasticache.ReplicationGroup("primary",
            replication_group_id="example-primary",
            description="primary replication group",
            engine="redis",
            engine_version="5.0.6",
            node_type="cache.m5.large",
            num_cache_clusters=1)
        example = aws.elasticache.GlobalReplicationGroup("example",
            global_replication_group_id_suffix="example",
            primary_replication_group_id=primary.id)
        secondary = aws.elasticache.ReplicationGroup("secondary",
            replication_group_id="example-secondary",
            description="secondary replication group",
            global_replication_group_id=example.global_replication_group_id,
            num_cache_clusters=1)
        ```

        ### Redis AUTH and In-Transit Encryption Enabled

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ReplicationGroup("example",
            replication_group_id="example",
            description="example with authentication",
            node_type="cache.t2.micro",
            num_cache_clusters=1,
            port=6379,
            subnet_group_name=example_aws_elasticache_subnet_group["name"],
            security_group_ids=[example_aws_security_group["id"]],
            parameter_group_name="default.redis5.0",
            engine_version="5.0.6",
            transit_encryption_enabled=True,
            auth_token="abcdefgh1234567890",
            auth_token_update_strategy="ROTATE")
        ```

        > When adding a new `auth_token` to a previously passwordless replication group, using the `ROTATE` update strategy will result in support for **both** the new token and passwordless authentication. To immediately require authorization when adding the initial token, use the `SET` strategy instead. See the [Authenticating with the Redis AUTH command](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html) guide for additional details.

        ## Import

        Using `pulumi import`, import ElastiCache Replication Groups using the `replication_group_id`. For example:

        ```sh
        $ pulumi import aws:elasticache/replicationGroup:ReplicationGroup my_replication_group replication-group-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
        :param pulumi.Input[_builtins.bool] at_rest_encryption_enabled: Whether to enable encryption at rest.
               When `engine` is `redis`, default is `false`.
               When `engine` is `valkey`, default is `true`.
        :param pulumi.Input[_builtins.str] auth_token: Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
        :param pulumi.Input[_builtins.str] auth_token_update_strategy: Strategy to use when updating the `auth_token`. Valid values are `SET`, `ROTATE`, and `DELETE`. Required if `auth_token` is set.
        :param pulumi.Input[_builtins.bool] auto_minor_version_upgrade: Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
               Only supported for engine types `"redis"` and `"valkey"` and if the engine version is 6 or higher.
               Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_failover_enabled: Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
        :param pulumi.Input[_builtins.str] cluster_mode: Specifies whether cluster mode is enabled or disabled. Valid values are `enabled` or `disabled` or `compatible`
        :param pulumi.Input[_builtins.bool] data_tiering_enabled: Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
        :param pulumi.Input[_builtins.str] description: User-created description for the replication group. Must not be empty.
        :param pulumi.Input[_builtins.str] engine: Name of the cache engine to be used for the clusters in this replication group.
               Valid values are `redis` or `valkey`.
               Default is `redis`.
        :param pulumi.Input[_builtins.str] engine_version: Version number of the cache engine to be used for the cache clusters in this replication group.
               If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
               If the version is 6, the major and minor version can be set, e.g., `6.2`,
               or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
               Otherwise, specify the full version desired, e.g., `5.0.6`.
               The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
        :param pulumi.Input[_builtins.str] global_replication_group_id: The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
        :param pulumi.Input[_builtins.str] ip_discovery: The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        :param pulumi.Input[_builtins.str] kms_key_id: The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationGroupLogDeliveryConfigurationArgs', 'ReplicationGroupLogDeliveryConfigurationArgsDict']]]] log_delivery_configurations: Specifies the destination and format of Redis OSS/Valkey [SLOWLOG](https://redis.io/commands/slowlog) or Redis OSS/Valkey [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
        :param pulumi.Input[_builtins.str] maintenance_window: Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
        :param pulumi.Input[_builtins.bool] multi_az_enabled: Specifies whether to enable Multi-AZ Support for the replication group.
               If `true`, `automatic_failover_enabled` must also be enabled.
               Defaults to `false`.
        :param pulumi.Input[_builtins.str] network_type: The IP versions for cache cluster connections. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        :param pulumi.Input[_builtins.str] node_type: Instance class to be used.
               See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
               Required unless `global_replication_group_id` is set.
               Cannot be set if `global_replication_group_id` is set.
        :param pulumi.Input[_builtins.str] notification_topic_arn: ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
        :param pulumi.Input[_builtins.int] num_cache_clusters: Number of cache clusters (primary and replicas) this replication group will have.
               If `automatic_failover_enabled` or `multi_az_enabled` are `true`, must be at least 2.
               Updates will occur before other modifications.
               Conflicts with `num_node_groups` and `replicas_per_node_group`.
               Defaults to `1`.
        :param pulumi.Input[_builtins.int] num_node_groups: Number of node groups (shards) for this Redis replication group.
               Changing this number will trigger a resizing operation before other settings modifications.
               Conflicts with `num_cache_clusters`.
        :param pulumi.Input[_builtins.str] parameter_group_name: Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable "cluster mode", i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
        :param pulumi.Input[_builtins.int] port: Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_cache_cluster_azs: List of EC2 availability zones in which the replication group's cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] replicas_per_node_group: Number of replica nodes in each node group.
               Changing this number will trigger a resizing operation before other settings modifications.
               Valid values are 0 to 5.
               Conflicts with `num_cache_clusters`.
               Can only be set if `num_node_groups` is set.
        :param pulumi.Input[_builtins.str] replication_group_id: Replication group identifier. This parameter is stored as a lowercase string.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: IDs of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_names: Names of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snapshot_arns: List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
        :param pulumi.Input[_builtins.str] snapshot_name: Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
        :param pulumi.Input[_builtins.int] snapshot_retention_limit: Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        :param pulumi.Input[_builtins.str] snapshot_window: Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
        :param pulumi.Input[_builtins.str] subnet_group_name: Name of the cache subnet group to be used for the replication group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Whether to enable encryption in transit.
               Changing this argument with an `engine_version` < `7.0.5` will force a replacement.
               Engine versions prior to `7.0.5` only allow this transit encryption to be configured during creation of the replication group.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: A setting that enables clients to migrate to in-transit encryption with no downtime.
               Valid values are `preferred` and `required`.
               When enabling encryption on an existing replication group, this must first be set to `preferred` before setting it to `required` in a subsequent apply.
               See the `TransitEncryptionMode` field in the [`CreateReplicationGroup` API documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateReplicationGroup.html) for additional details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_group_ids: User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicationGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an ElastiCache Replication Group resource.

        For working with a [Memcached cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/WhatIs.html) or a
        [single-node Redis instance (Cluster Mode Disabled)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/WhatIs.html),
        see the `elasticache.Cluster` resource.

        > **Note:** When you change an attribute, such as `engine_version`, by
        default the ElastiCache API applies it in the next maintenance window. Because
        of this, this provider may report a difference in its planning phase because the
        actual modification has not yet taken place. You can use the
        `apply_immediately` flag to instruct the service to apply the change
        immediately. Using `apply_immediately` can result in a brief downtime as
        servers reboots.
        See the AWS Documentation on
        [Modifying an ElastiCache Cache Cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Modify.html)
        for more information.

        > **Note:** Any attribute changes that re-create the resource will be applied immediately, regardless of the value of `apply_immediately`.

        > **Note:** Be aware of the terminology collision around "cluster" for `elasticache.ReplicationGroup`. For example, it is possible to create a ["Cluster Mode Disabled [Redis] Cluster"](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Create.CON.Redis.html). With "Cluster Mode Enabled", the data will be stored in shards (called "node groups"). See [Redis Cluster Configuration](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/cluster-create-determine-requirements.html#redis-cluster-configuration) for a diagram of the differences. To enable cluster mode, use a parameter group that has cluster mode enabled. The default parameter groups provided by AWS end with ".cluster.on", for example `default.redis6.x.cluster.on`.

        ## Example Usage

        ### Redis OSS/Valkey Cluster Mode Disabled

        To create a single shard primary with single read replica:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ReplicationGroup("example",
            automatic_failover_enabled=True,
            preferred_cache_cluster_azs=[
                "us-west-2a",
                "us-west-2b",
            ],
            replication_group_id="tf-rep-group-1",
            description="example description",
            node_type="cache.m4.large",
            num_cache_clusters=2,
            parameter_group_name="default.redis3.2",
            port=6379)
        ```

        You have two options for adjusting the number of replicas:

        * Adjusting `num_cache_clusters` directly. This will attempt to automatically add or remove replicas, but provides no granular control (e.g., preferred availability zone, cache cluster ID) for the added or removed replicas. This also currently expects cache cluster IDs in the form of `replication_group_id-00#`.
        * Otherwise for fine grained control of the underlying cache clusters, they can be added or removed with the `elasticache.Cluster` resource and its `replication_group_id` attribute. In this situation, you will need to utilize [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to prevent perpetual differences with the `number_cache_cluster` attribute.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ReplicationGroup("example",
            automatic_failover_enabled=True,
            preferred_cache_cluster_azs=[
                "us-west-2a",
                "us-west-2b",
            ],
            replication_group_id="tf-rep-group-1",
            description="example description",
            node_type="cache.m4.large",
            num_cache_clusters=2,
            parameter_group_name="default.redis3.2",
            port=6379)
        replica = []
        for range in [{"value": i} for i in range(0, 1)]:
            replica.append(aws.elasticache.Cluster(f"replica-{range['value']}",
                cluster_id=f"tf-rep-group-1-{range['value']}",
                replication_group_id=example.id))
        ```

        ### Redis OSS/Valkey Cluster Mode Enabled

        To create two shards with a primary and a single read replica each:

        ```python
        import pulumi
        import pulumi_aws as aws

        baz = aws.elasticache.ReplicationGroup("baz",
            replication_group_id="tf-redis-cluster",
            description="example description",
            node_type="cache.t2.small",
            port=6379,
            parameter_group_name="default.redis3.2.cluster.on",
            automatic_failover_enabled=True,
            num_node_groups=2,
            replicas_per_node_group=1)
        ```

        ### Redis Log Delivery configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.elasticache.ReplicationGroup("test",
            replication_group_id="myreplicaciongroup",
            description="test description",
            node_type="cache.t3.small",
            port=6379,
            apply_immediately=True,
            auto_minor_version_upgrade=False,
            maintenance_window="tue:06:30-tue:07:30",
            snapshot_window="01:00-02:00",
            log_delivery_configurations=[
                {
                    "destination": example["name"],
                    "destination_type": "cloudwatch-logs",
                    "log_format": "text",
                    "log_type": "slow-log",
                },
                {
                    "destination": example_aws_kinesis_firehose_delivery_stream["name"],
                    "destination_type": "kinesis-firehose",
                    "log_format": "json",
                    "log_type": "engine-log",
                },
            ])
        ```

        > **Note:** We currently do not support passing a `primary_cluster_id` in order to create the Replication Group.

        > **Note:** Automatic Failover is unavailable for Redis versions earlier than 2.8.6,
        and unavailable on T1 node types. For T2 node types, it is only available on Redis version 3.2.4 or later with cluster mode enabled. See the [High Availability Using Replication Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Replication.html) guide
        for full details on using Replication Groups.

        ### Creating a secondary replication group for a global replication group

        A Global Replication Group can have up to two secondary Replication Groups in different regions. These are added to an existing Global Replication Group.

        ```python
        import pulumi
        import pulumi_aws as aws

        primary = aws.elasticache.ReplicationGroup("primary",
            replication_group_id="example-primary",
            description="primary replication group",
            engine="redis",
            engine_version="5.0.6",
            node_type="cache.m5.large",
            num_cache_clusters=1)
        example = aws.elasticache.GlobalReplicationGroup("example",
            global_replication_group_id_suffix="example",
            primary_replication_group_id=primary.id)
        secondary = aws.elasticache.ReplicationGroup("secondary",
            replication_group_id="example-secondary",
            description="secondary replication group",
            global_replication_group_id=example.global_replication_group_id,
            num_cache_clusters=1)
        ```

        ### Redis AUTH and In-Transit Encryption Enabled

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ReplicationGroup("example",
            replication_group_id="example",
            description="example with authentication",
            node_type="cache.t2.micro",
            num_cache_clusters=1,
            port=6379,
            subnet_group_name=example_aws_elasticache_subnet_group["name"],
            security_group_ids=[example_aws_security_group["id"]],
            parameter_group_name="default.redis5.0",
            engine_version="5.0.6",
            transit_encryption_enabled=True,
            auth_token="abcdefgh1234567890",
            auth_token_update_strategy="ROTATE")
        ```

        > When adding a new `auth_token` to a previously passwordless replication group, using the `ROTATE` update strategy will result in support for **both** the new token and passwordless authentication. To immediately require authorization when adding the initial token, use the `SET` strategy instead. See the [Authenticating with the Redis AUTH command](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html) guide for additional details.

        ## Import

        Using `pulumi import`, import ElastiCache Replication Groups using the `replication_group_id`. For example:

        ```sh
        $ pulumi import aws:elasticache/replicationGroup:ReplicationGroup my_replication_group replication-group-1
        ```

        :param str resource_name: The name of the resource.
        :param ReplicationGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_token_update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_tiering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 global_replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationGroupLogDeliveryConfigurationArgs', 'ReplicationGroupLogDeliveryConfigurationArgsDict']]]]] = None,
                 maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_az_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 num_cache_clusters: Optional[pulumi.Input[_builtins.int]] = None,
                 num_node_groups: Optional[pulumi.Input[_builtins.int]] = None,
                 parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_cache_cluster_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas_per_node_group: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationGroupArgs.__new__(ReplicationGroupArgs)

            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["at_rest_encryption_enabled"] = at_rest_encryption_enabled
            __props__.__dict__["auth_token"] = None if auth_token is None else pulumi.Output.secret(auth_token)
            __props__.__dict__["auth_token_update_strategy"] = auth_token_update_strategy
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["automatic_failover_enabled"] = automatic_failover_enabled
            __props__.__dict__["cluster_mode"] = cluster_mode
            __props__.__dict__["data_tiering_enabled"] = data_tiering_enabled
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
            __props__.__dict__["global_replication_group_id"] = global_replication_group_id
            __props__.__dict__["ip_discovery"] = ip_discovery
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["log_delivery_configurations"] = log_delivery_configurations
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["multi_az_enabled"] = multi_az_enabled
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["notification_topic_arn"] = notification_topic_arn
            __props__.__dict__["num_cache_clusters"] = num_cache_clusters
            __props__.__dict__["num_node_groups"] = num_node_groups
            __props__.__dict__["parameter_group_name"] = parameter_group_name
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_cache_cluster_azs"] = preferred_cache_cluster_azs
            __props__.__dict__["region"] = region
            __props__.__dict__["replicas_per_node_group"] = replicas_per_node_group
            __props__.__dict__["replication_group_id"] = replication_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["security_group_names"] = security_group_names
            __props__.__dict__["snapshot_arns"] = snapshot_arns
            __props__.__dict__["snapshot_name"] = snapshot_name
            __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
            __props__.__dict__["snapshot_window"] = snapshot_window
            __props__.__dict__["subnet_group_name"] = subnet_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_encryption_enabled"] = transit_encryption_enabled
            __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
            __props__.__dict__["user_group_ids"] = user_group_ids
            __props__.__dict__["arn"] = None
            __props__.__dict__["cluster_enabled"] = None
            __props__.__dict__["configuration_endpoint_address"] = None
            __props__.__dict__["engine_version_actual"] = None
            __props__.__dict__["member_clusters"] = None
            __props__.__dict__["primary_endpoint_address"] = None
            __props__.__dict__["reader_endpoint_address"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ReplicationGroup, __self__).__init__(
            'aws:elasticache/replicationGroup:ReplicationGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            auth_token: Optional[pulumi.Input[_builtins.str]] = None,
            auth_token_update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
            automatic_failover_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cluster_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cluster_mode: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_endpoint_address: Optional[pulumi.Input[_builtins.str]] = None,
            data_tiering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version_actual: Optional[pulumi.Input[_builtins.str]] = None,
            final_snapshot_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            global_replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_discovery: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationGroupLogDeliveryConfigurationArgs', 'ReplicationGroupLogDeliveryConfigurationArgsDict']]]]] = None,
            maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
            member_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            multi_az_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            notification_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
            num_cache_clusters: Optional[pulumi.Input[_builtins.int]] = None,
            num_node_groups: Optional[pulumi.Input[_builtins.int]] = None,
            parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            preferred_cache_cluster_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            primary_endpoint_address: Optional[pulumi.Input[_builtins.str]] = None,
            reader_endpoint_address: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replicas_per_node_group: Optional[pulumi.Input[_builtins.int]] = None,
            replication_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
            user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ReplicationGroup':
        """
        Get an existing ReplicationGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
        :param pulumi.Input[_builtins.str] arn: ARN of the created ElastiCache Replication Group.
        :param pulumi.Input[_builtins.bool] at_rest_encryption_enabled: Whether to enable encryption at rest.
               When `engine` is `redis`, default is `false`.
               When `engine` is `valkey`, default is `true`.
        :param pulumi.Input[_builtins.str] auth_token: Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
        :param pulumi.Input[_builtins.str] auth_token_update_strategy: Strategy to use when updating the `auth_token`. Valid values are `SET`, `ROTATE`, and `DELETE`. Required if `auth_token` is set.
        :param pulumi.Input[_builtins.bool] auto_minor_version_upgrade: Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
               Only supported for engine types `"redis"` and `"valkey"` and if the engine version is 6 or higher.
               Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_failover_enabled: Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] cluster_enabled: Indicates if cluster mode is enabled.
        :param pulumi.Input[_builtins.str] cluster_mode: Specifies whether cluster mode is enabled or disabled. Valid values are `enabled` or `disabled` or `compatible`
        :param pulumi.Input[_builtins.str] configuration_endpoint_address: Address of the replication group configuration endpoint when cluster mode is enabled.
        :param pulumi.Input[_builtins.bool] data_tiering_enabled: Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
        :param pulumi.Input[_builtins.str] description: User-created description for the replication group. Must not be empty.
        :param pulumi.Input[_builtins.str] engine: Name of the cache engine to be used for the clusters in this replication group.
               Valid values are `redis` or `valkey`.
               Default is `redis`.
        :param pulumi.Input[_builtins.str] engine_version: Version number of the cache engine to be used for the cache clusters in this replication group.
               If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
               If the version is 6, the major and minor version can be set, e.g., `6.2`,
               or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
               Otherwise, specify the full version desired, e.g., `5.0.6`.
               The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
        :param pulumi.Input[_builtins.str] engine_version_actual: Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
        :param pulumi.Input[_builtins.str] final_snapshot_identifier: The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
        :param pulumi.Input[_builtins.str] global_replication_group_id: The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
        :param pulumi.Input[_builtins.str] ip_discovery: The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        :param pulumi.Input[_builtins.str] kms_key_id: The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationGroupLogDeliveryConfigurationArgs', 'ReplicationGroupLogDeliveryConfigurationArgsDict']]]] log_delivery_configurations: Specifies the destination and format of Redis OSS/Valkey [SLOWLOG](https://redis.io/commands/slowlog) or Redis OSS/Valkey [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
        :param pulumi.Input[_builtins.str] maintenance_window: Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] member_clusters: Identifiers of all the nodes that are part of this replication group.
        :param pulumi.Input[_builtins.bool] multi_az_enabled: Specifies whether to enable Multi-AZ Support for the replication group.
               If `true`, `automatic_failover_enabled` must also be enabled.
               Defaults to `false`.
        :param pulumi.Input[_builtins.str] network_type: The IP versions for cache cluster connections. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        :param pulumi.Input[_builtins.str] node_type: Instance class to be used.
               See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
               Required unless `global_replication_group_id` is set.
               Cannot be set if `global_replication_group_id` is set.
        :param pulumi.Input[_builtins.str] notification_topic_arn: ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
        :param pulumi.Input[_builtins.int] num_cache_clusters: Number of cache clusters (primary and replicas) this replication group will have.
               If `automatic_failover_enabled` or `multi_az_enabled` are `true`, must be at least 2.
               Updates will occur before other modifications.
               Conflicts with `num_node_groups` and `replicas_per_node_group`.
               Defaults to `1`.
        :param pulumi.Input[_builtins.int] num_node_groups: Number of node groups (shards) for this Redis replication group.
               Changing this number will trigger a resizing operation before other settings modifications.
               Conflicts with `num_cache_clusters`.
        :param pulumi.Input[_builtins.str] parameter_group_name: Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable "cluster mode", i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
        :param pulumi.Input[_builtins.int] port: Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_cache_cluster_azs: List of EC2 availability zones in which the replication group's cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
        :param pulumi.Input[_builtins.str] primary_endpoint_address: (Redis only) Address of the endpoint for the primary node in the replication group, if the cluster mode is disabled.
        :param pulumi.Input[_builtins.str] reader_endpoint_address: (Redis only) Address of the endpoint for the reader node in the replication group, if the cluster mode is disabled.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] replicas_per_node_group: Number of replica nodes in each node group.
               Changing this number will trigger a resizing operation before other settings modifications.
               Valid values are 0 to 5.
               Conflicts with `num_cache_clusters`.
               Can only be set if `num_node_groups` is set.
        :param pulumi.Input[_builtins.str] replication_group_id: Replication group identifier. This parameter is stored as a lowercase string.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: IDs of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_names: Names of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snapshot_arns: List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
        :param pulumi.Input[_builtins.str] snapshot_name: Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
        :param pulumi.Input[_builtins.int] snapshot_retention_limit: Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        :param pulumi.Input[_builtins.str] snapshot_window: Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
        :param pulumi.Input[_builtins.str] subnet_group_name: Name of the cache subnet group to be used for the replication group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Whether to enable encryption in transit.
               Changing this argument with an `engine_version` < `7.0.5` will force a replacement.
               Engine versions prior to `7.0.5` only allow this transit encryption to be configured during creation of the replication group.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: A setting that enables clients to migrate to in-transit encryption with no downtime.
               Valid values are `preferred` and `required`.
               When enabling encryption on an existing replication group, this must first be set to `preferred` before setting it to `required` in a subsequent apply.
               See the `TransitEncryptionMode` field in the [`CreateReplicationGroup` API documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateReplicationGroup.html) for additional details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_group_ids: User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicationGroupState.__new__(_ReplicationGroupState)

        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["arn"] = arn
        __props__.__dict__["at_rest_encryption_enabled"] = at_rest_encryption_enabled
        __props__.__dict__["auth_token"] = auth_token
        __props__.__dict__["auth_token_update_strategy"] = auth_token_update_strategy
        __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
        __props__.__dict__["automatic_failover_enabled"] = automatic_failover_enabled
        __props__.__dict__["cluster_enabled"] = cluster_enabled
        __props__.__dict__["cluster_mode"] = cluster_mode
        __props__.__dict__["configuration_endpoint_address"] = configuration_endpoint_address
        __props__.__dict__["data_tiering_enabled"] = data_tiering_enabled
        __props__.__dict__["description"] = description
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["engine_version_actual"] = engine_version_actual
        __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
        __props__.__dict__["global_replication_group_id"] = global_replication_group_id
        __props__.__dict__["ip_discovery"] = ip_discovery
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["log_delivery_configurations"] = log_delivery_configurations
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["member_clusters"] = member_clusters
        __props__.__dict__["multi_az_enabled"] = multi_az_enabled
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["notification_topic_arn"] = notification_topic_arn
        __props__.__dict__["num_cache_clusters"] = num_cache_clusters
        __props__.__dict__["num_node_groups"] = num_node_groups
        __props__.__dict__["parameter_group_name"] = parameter_group_name
        __props__.__dict__["port"] = port
        __props__.__dict__["preferred_cache_cluster_azs"] = preferred_cache_cluster_azs
        __props__.__dict__["primary_endpoint_address"] = primary_endpoint_address
        __props__.__dict__["reader_endpoint_address"] = reader_endpoint_address
        __props__.__dict__["region"] = region
        __props__.__dict__["replicas_per_node_group"] = replicas_per_node_group
        __props__.__dict__["replication_group_id"] = replication_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["security_group_names"] = security_group_names
        __props__.__dict__["snapshot_arns"] = snapshot_arns
        __props__.__dict__["snapshot_name"] = snapshot_name
        __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
        __props__.__dict__["snapshot_window"] = snapshot_window
        __props__.__dict__["subnet_group_name"] = subnet_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["transit_encryption_enabled"] = transit_encryption_enabled
        __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
        __props__.__dict__["user_group_ids"] = user_group_ids
        return ReplicationGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
        """
        return pulumi.get(self, "apply_immediately")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the created ElastiCache Replication Group.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="atRestEncryptionEnabled")
    def at_rest_encryption_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable encryption at rest.
        When `engine` is `redis`, default is `false`.
        When `engine` is `valkey`, default is `true`.
        """
        return pulumi.get(self, "at_rest_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
        """
        return pulumi.get(self, "auth_token")

    @_builtins.property
    @pulumi.getter(name="authTokenUpdateStrategy")
    def auth_token_update_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Strategy to use when updating the `auth_token`. Valid values are `SET`, `ROTATE`, and `DELETE`. Required if `auth_token` is set.
        """
        return pulumi.get(self, "auth_token_update_strategy")

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
        Only supported for engine types `"redis"` and `"valkey"` and if the engine version is 6 or higher.
        Defaults to `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @_builtins.property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_failover_enabled")

    @_builtins.property
    @pulumi.getter(name="clusterEnabled")
    def cluster_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if cluster mode is enabled.
        """
        return pulumi.get(self, "cluster_enabled")

    @_builtins.property
    @pulumi.getter(name="clusterMode")
    def cluster_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether cluster mode is enabled or disabled. Valid values are `enabled` or `disabled` or `compatible`
        """
        return pulumi.get(self, "cluster_mode")

    @_builtins.property
    @pulumi.getter(name="configurationEndpointAddress")
    def configuration_endpoint_address(self) -> pulumi.Output[_builtins.str]:
        """
        Address of the replication group configuration endpoint when cluster mode is enabled.
        """
        return pulumi.get(self, "configuration_endpoint_address")

    @_builtins.property
    @pulumi.getter(name="dataTieringEnabled")
    def data_tiering_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
        """
        return pulumi.get(self, "data_tiering_enabled")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        User-created description for the replication group. Must not be empty.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the cache engine to be used for the clusters in this replication group.
        Valid values are `redis` or `valkey`.
        Default is `redis`.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version number of the cache engine to be used for the cache clusters in this replication group.
        If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
        If the version is 6, the major and minor version can be set, e.g., `6.2`,
        or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
        Otherwise, specify the full version desired, e.g., `5.0.6`.
        The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> pulumi.Output[_builtins.str]:
        """
        Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
        """
        return pulumi.get(self, "engine_version_actual")

    @_builtins.property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @_builtins.property
    @pulumi.getter(name="globalReplicationGroupId")
    def global_replication_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
        """
        return pulumi.get(self, "global_replication_group_id")

    @_builtins.property
    @pulumi.getter(name="ipDiscovery")
    def ip_discovery(self) -> pulumi.Output[_builtins.str]:
        """
        The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_discovery")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.ReplicationGroupLogDeliveryConfiguration']]]:
        """
        Specifies the destination and format of Redis OSS/Valkey [SLOWLOG](https://redis.io/commands/slowlog) or Redis OSS/Valkey [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
        """
        return pulumi.get(self, "log_delivery_configurations")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="memberClusters")
    def member_clusters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Identifiers of all the nodes that are part of this replication group.
        """
        return pulumi.get(self, "member_clusters")

    @_builtins.property
    @pulumi.getter(name="multiAzEnabled")
    def multi_az_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable Multi-AZ Support for the replication group.
        If `true`, `automatic_failover_enabled` must also be enabled.
        Defaults to `false`.
        """
        return pulumi.get(self, "multi_az_enabled")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The IP versions for cache cluster connections. Valid values are `ipv4`, `ipv6` or `dual_stack`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance class to be used.
        See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
        Required unless `global_replication_group_id` is set.
        Cannot be set if `global_replication_group_id` is set.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="notificationTopicArn")
    def notification_topic_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
        """
        return pulumi.get(self, "notification_topic_arn")

    @_builtins.property
    @pulumi.getter(name="numCacheClusters")
    def num_cache_clusters(self) -> pulumi.Output[_builtins.int]:
        """
        Number of cache clusters (primary and replicas) this replication group will have.
        If `automatic_failover_enabled` or `multi_az_enabled` are `true`, must be at least 2.
        Updates will occur before other modifications.
        Conflicts with `num_node_groups` and `replicas_per_node_group`.
        Defaults to `1`.
        """
        return pulumi.get(self, "num_cache_clusters")

    @_builtins.property
    @pulumi.getter(name="numNodeGroups")
    def num_node_groups(self) -> pulumi.Output[_builtins.int]:
        """
        Number of node groups (shards) for this Redis replication group.
        Changing this number will trigger a resizing operation before other settings modifications.
        Conflicts with `num_cache_clusters`.
        """
        return pulumi.get(self, "num_node_groups")

    @_builtins.property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable "cluster mode", i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
        """
        return pulumi.get(self, "parameter_group_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="preferredCacheClusterAzs")
    def preferred_cache_cluster_azs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of EC2 availability zones in which the replication group's cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
        """
        return pulumi.get(self, "preferred_cache_cluster_azs")

    @_builtins.property
    @pulumi.getter(name="primaryEndpointAddress")
    def primary_endpoint_address(self) -> pulumi.Output[_builtins.str]:
        """
        (Redis only) Address of the endpoint for the primary node in the replication group, if the cluster mode is disabled.
        """
        return pulumi.get(self, "primary_endpoint_address")

    @_builtins.property
    @pulumi.getter(name="readerEndpointAddress")
    def reader_endpoint_address(self) -> pulumi.Output[_builtins.str]:
        """
        (Redis only) Address of the endpoint for the reader node in the replication group, if the cluster mode is disabled.
        """
        return pulumi.get(self, "reader_endpoint_address")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicasPerNodeGroup")
    def replicas_per_node_group(self) -> pulumi.Output[_builtins.int]:
        """
        Number of replica nodes in each node group.
        Changing this number will trigger a resizing operation before other settings modifications.
        Valid values are 0 to 5.
        Conflicts with `num_cache_clusters`.
        Can only be set if `num_node_groups` is set.
        """
        return pulumi.get(self, "replicas_per_node_group")

    @_builtins.property
    @pulumi.getter(name="replicationGroupId")
    def replication_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Replication group identifier. This parameter is stored as a lowercase string.

        The following arguments are optional:
        """
        return pulumi.get(self, "replication_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        IDs of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="securityGroupNames")
    def security_group_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Names of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
        """
        return pulumi.get(self, "security_group_names")

    @_builtins.property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
        """
        return pulumi.get(self, "snapshot_arns")

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
        """
        return pulumi.get(self, "snapshot_name")

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @_builtins.property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> pulumi.Output[_builtins.str]:
        """
        Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
        """
        return pulumi.get(self, "snapshot_window")

    @_builtins.property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the cache subnet group to be used for the replication group.
        """
        return pulumi.get(self, "subnet_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable encryption in transit.
        Changing this argument with an `engine_version` < `7.0.5` will force a replacement.
        Engine versions prior to `7.0.5` only allow this transit encryption to be configured during creation of the replication group.
        """
        return pulumi.get(self, "transit_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> pulumi.Output[_builtins.str]:
        """
        A setting that enables clients to migrate to in-transit encryption with no downtime.
        Valid values are `preferred` and `required`.
        When enabling encryption on an existing replication group, this must first be set to `preferred` before setting it to `required` in a subsequent apply.
        See the `TransitEncryptionMode` field in the [`CreateReplicationGroup` API documentation](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateReplicationGroup.html) for additional details.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
        """
        return pulumi.get(self, "user_group_ids")

