# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ApplicationAppversionLifecycle',
    'ConfigurationTemplateSetting',
    'EnvironmentAllSetting',
    'EnvironmentSetting',
    'GetApplicationAppversionLifecycleResult',
]

@pulumi.output_type
class ApplicationAppversionLifecycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceRole":
            suggest = "service_role"
        elif key == "deleteSourceFromS3":
            suggest = "delete_source_from_s3"
        elif key == "maxAgeInDays":
            suggest = "max_age_in_days"
        elif key == "maxCount":
            suggest = "max_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAppversionLifecycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAppversionLifecycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAppversionLifecycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_role: _builtins.str,
                 delete_source_from_s3: Optional[_builtins.bool] = None,
                 max_age_in_days: Optional[_builtins.int] = None,
                 max_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str service_role: The ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
        :param _builtins.bool delete_source_from_s3: Set to `true` to delete a version's source bundle from S3 when the application version is deleted.
        :param _builtins.int max_age_in_days: The number of days to retain an application version ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
        :param _builtins.int max_count: The maximum number of application versions to retain ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
        """
        pulumi.set(__self__, "service_role", service_role)
        if delete_source_from_s3 is not None:
            pulumi.set(__self__, "delete_source_from_s3", delete_source_from_s3)
        if max_age_in_days is not None:
            pulumi.set(__self__, "max_age_in_days", max_age_in_days)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> _builtins.str:
        """
        The ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
        """
        return pulumi.get(self, "service_role")

    @_builtins.property
    @pulumi.getter(name="deleteSourceFromS3")
    def delete_source_from_s3(self) -> Optional[_builtins.bool]:
        """
        Set to `true` to delete a version's source bundle from S3 when the application version is deleted.
        """
        return pulumi.get(self, "delete_source_from_s3")

    @_builtins.property
    @pulumi.getter(name="maxAgeInDays")
    def max_age_in_days(self) -> Optional[_builtins.int]:
        """
        The number of days to retain an application version ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
        """
        return pulumi.get(self, "max_age_in_days")

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[_builtins.int]:
        """
        The maximum number of application versions to retain ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
        """
        return pulumi.get(self, "max_count")


@pulumi.output_type
class ConfigurationTemplateSetting(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 value: _builtins.str,
                 resource: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: A unique name for this Template.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for this Template.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource")


@pulumi.output_type
class EnvironmentAllSetting(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 value: _builtins.str,
                 resource: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: A unique name for this Environment. This name is used
               in the application URL
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for this Environment. This name is used
        in the application URL
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource")


@pulumi.output_type
class EnvironmentSetting(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 value: _builtins.str,
                 resource: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: A unique name for this Environment. This name is used
               in the application URL
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for this Environment. This name is used
        in the application URL
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource")


@pulumi.output_type
class GetApplicationAppversionLifecycleResult(dict):
    def __init__(__self__, *,
                 delete_source_from_s3: _builtins.bool,
                 max_age_in_days: _builtins.int,
                 max_count: _builtins.int,
                 service_role: _builtins.str):
        """
        :param _builtins.bool delete_source_from_s3: Specifies whether delete a version's source bundle from S3 when the application version is deleted.
        :param _builtins.int max_age_in_days: Number of days to retain an application version.
        :param _builtins.int max_count: Maximum number of application versions to retain.
        :param _builtins.str service_role: ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
        """
        pulumi.set(__self__, "delete_source_from_s3", delete_source_from_s3)
        pulumi.set(__self__, "max_age_in_days", max_age_in_days)
        pulumi.set(__self__, "max_count", max_count)
        pulumi.set(__self__, "service_role", service_role)

    @_builtins.property
    @pulumi.getter(name="deleteSourceFromS3")
    def delete_source_from_s3(self) -> _builtins.bool:
        """
        Specifies whether delete a version's source bundle from S3 when the application version is deleted.
        """
        return pulumi.get(self, "delete_source_from_s3")

    @_builtins.property
    @pulumi.getter(name="maxAgeInDays")
    def max_age_in_days(self) -> _builtins.int:
        """
        Number of days to retain an application version.
        """
        return pulumi.get(self, "max_age_in_days")

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> _builtins.int:
        """
        Maximum number of application versions to retain.
        """
        return pulumi.get(self, "max_count")

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> _builtins.str:
        """
        ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
        """
        return pulumi.get(self, "service_role")


