# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StudioSessionMappingArgs', 'StudioSessionMapping']

@pulumi.input_type
class StudioSessionMappingArgs:
    def __init__(__self__, *,
                 identity_type: pulumi.Input[_builtins.str],
                 session_policy_arn: pulumi.Input[_builtins.str],
                 studio_id: pulumi.Input[_builtins.str],
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StudioSessionMapping resource.
        :param pulumi.Input[_builtins.str] identity_type: Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
        :param pulumi.Input[_builtins.str] session_policy_arn: The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
        :param pulumi.Input[_builtins.str] studio_id: The ID of the Amazon EMR Studio to which the user or group will be mapped.
        :param pulumi.Input[_builtins.str] identity_id: The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
        :param pulumi.Input[_builtins.str] identity_name: The name of the user or group from the Amazon Web Services SSO Identity Store.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "identity_type", identity_type)
        pulumi.set(__self__, "session_policy_arn", session_policy_arn)
        pulumi.set(__self__, "studio_id", studio_id)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if identity_name is not None:
            pulumi.set(__self__, "identity_name", identity_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity_type", value)

    @_builtins.property
    @pulumi.getter(name="sessionPolicyArn")
    def session_policy_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
        """
        return pulumi.get(self, "session_policy_arn")

    @session_policy_arn.setter
    def session_policy_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "session_policy_arn", value)

    @_builtins.property
    @pulumi.getter(name="studioId")
    def studio_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        return pulumi.get(self, "studio_id")

    @studio_id.setter
    def studio_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "studio_id", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="identityName")
    def identity_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user or group from the Amazon Web Services SSO Identity Store.
        """
        return pulumi.get(self, "identity_name")

    @identity_name.setter
    def identity_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _StudioSessionMappingState:
    def __init__(__self__, *,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 session_policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 studio_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StudioSessionMapping resources.
        :param pulumi.Input[_builtins.str] identity_id: The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
        :param pulumi.Input[_builtins.str] identity_name: The name of the user or group from the Amazon Web Services SSO Identity Store.
        :param pulumi.Input[_builtins.str] identity_type: Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] session_policy_arn: The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
        :param pulumi.Input[_builtins.str] studio_id: The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if identity_name is not None:
            pulumi.set(__self__, "identity_name", identity_name)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if session_policy_arn is not None:
            pulumi.set(__self__, "session_policy_arn", session_policy_arn)
        if studio_id is not None:
            pulumi.set(__self__, "studio_id", studio_id)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="identityName")
    def identity_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user or group from the Amazon Web Services SSO Identity Store.
        """
        return pulumi.get(self, "identity_name")

    @identity_name.setter
    def identity_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_name", value)

    @_builtins.property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sessionPolicyArn")
    def session_policy_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
        """
        return pulumi.get(self, "session_policy_arn")

    @session_policy_arn.setter
    def session_policy_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_policy_arn", value)

    @_builtins.property
    @pulumi.getter(name="studioId")
    def studio_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        return pulumi.get(self, "studio_id")

    @studio_id.setter
    def studio_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "studio_id", value)


@pulumi.type_token("aws:emr/studioSessionMapping:StudioSessionMapping")
class StudioSessionMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 session_policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 studio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Elastic MapReduce Studio Session Mapping.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.StudioSessionMapping("example",
            studio_id=example_aws_emr_studio["id"],
            identity_type="USER",
            identity_id="example",
            session_policy_arn=example_aws_iam_policy["arn"])
        ```

        ## Import

        Using `pulumi import`, import EMR studio session mappings using `studio-id:identity-type:identity-id`. For example:

        ```sh
        $ pulumi import aws:emr/studioSessionMapping:StudioSessionMapping example es-xxxxx:USER:xxxxx-xxx-xxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity_id: The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
        :param pulumi.Input[_builtins.str] identity_name: The name of the user or group from the Amazon Web Services SSO Identity Store.
        :param pulumi.Input[_builtins.str] identity_type: Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] session_policy_arn: The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
        :param pulumi.Input[_builtins.str] studio_id: The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StudioSessionMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic MapReduce Studio Session Mapping.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.StudioSessionMapping("example",
            studio_id=example_aws_emr_studio["id"],
            identity_type="USER",
            identity_id="example",
            session_policy_arn=example_aws_iam_policy["arn"])
        ```

        ## Import

        Using `pulumi import`, import EMR studio session mappings using `studio-id:identity-type:identity-id`. For example:

        ```sh
        $ pulumi import aws:emr/studioSessionMapping:StudioSessionMapping example es-xxxxx:USER:xxxxx-xxx-xxx
        ```

        :param str resource_name: The name of the resource.
        :param StudioSessionMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StudioSessionMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 session_policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 studio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StudioSessionMappingArgs.__new__(StudioSessionMappingArgs)

            __props__.__dict__["identity_id"] = identity_id
            __props__.__dict__["identity_name"] = identity_name
            if identity_type is None and not opts.urn:
                raise TypeError("Missing required property 'identity_type'")
            __props__.__dict__["identity_type"] = identity_type
            __props__.__dict__["region"] = region
            if session_policy_arn is None and not opts.urn:
                raise TypeError("Missing required property 'session_policy_arn'")
            __props__.__dict__["session_policy_arn"] = session_policy_arn
            if studio_id is None and not opts.urn:
                raise TypeError("Missing required property 'studio_id'")
            __props__.__dict__["studio_id"] = studio_id
        super(StudioSessionMapping, __self__).__init__(
            'aws:emr/studioSessionMapping:StudioSessionMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity_name: Optional[pulumi.Input[_builtins.str]] = None,
            identity_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            session_policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
            studio_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'StudioSessionMapping':
        """
        Get an existing StudioSessionMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity_id: The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
        :param pulumi.Input[_builtins.str] identity_name: The name of the user or group from the Amazon Web Services SSO Identity Store.
        :param pulumi.Input[_builtins.str] identity_type: Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] session_policy_arn: The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
        :param pulumi.Input[_builtins.str] studio_id: The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StudioSessionMappingState.__new__(_StudioSessionMappingState)

        __props__.__dict__["identity_id"] = identity_id
        __props__.__dict__["identity_name"] = identity_name
        __props__.__dict__["identity_type"] = identity_type
        __props__.__dict__["region"] = region
        __props__.__dict__["session_policy_arn"] = session_policy_arn
        __props__.__dict__["studio_id"] = studio_id
        return StudioSessionMapping(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Output[_builtins.str]:
        """
        The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter(name="identityName")
    def identity_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the user or group from the Amazon Web Services SSO Identity Store.
        """
        return pulumi.get(self, "identity_name")

    @_builtins.property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
        """
        return pulumi.get(self, "identity_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sessionPolicyArn")
    def session_policy_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
        """
        return pulumi.get(self, "session_policy_arn")

    @_builtins.property
    @pulumi.getter(name="studioId")
    def studio_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        return pulumi.get(self, "studio_id")

