# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LaunchArgs', 'Launch']

@pulumi.input_type
class LaunchArgs:
    def __init__(__self__, *,
                 groups: pulumi.Input[Sequence[pulumi.Input['LaunchGroupArgs']]],
                 project: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_monitors: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchMetricMonitorArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 randomization_salt: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_splits_config: Optional[pulumi.Input['LaunchScheduledSplitsConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Launch resource.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchGroupArgs']]] groups: One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
        :param pulumi.Input[_builtins.str] project: The name or ARN of the project that is to contain the new launch.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the launch.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchMetricMonitorArgs']]] metric_monitors: One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
        :param pulumi.Input[_builtins.str] name: The name for the new launch. Minimum length of `1`. Maximum length of `127`.
        :param pulumi.Input[_builtins.str] randomization_salt: When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['LaunchScheduledSplitsConfigArgs'] scheduled_splits_config: A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "project", project)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metric_monitors is not None:
            pulumi.set(__self__, "metric_monitors", metric_monitors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if randomization_salt is not None:
            pulumi.set(__self__, "randomization_salt", randomization_salt)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduled_splits_config is not None:
            pulumi.set(__self__, "scheduled_splits_config", scheduled_splits_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input['LaunchGroupArgs']]]:
        """
        One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input['LaunchGroupArgs']]]):
        pulumi.set(self, "groups", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name or ARN of the project that is to contain the new launch.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the launch.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="metricMonitors")
    def metric_monitors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchMetricMonitorArgs']]]]:
        """
        One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
        """
        return pulumi.get(self, "metric_monitors")

    @metric_monitors.setter
    def metric_monitors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchMetricMonitorArgs']]]]):
        pulumi.set(self, "metric_monitors", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the new launch. Minimum length of `1`. Maximum length of `127`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="randomizationSalt")
    def randomization_salt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
        """
        return pulumi.get(self, "randomization_salt")

    @randomization_salt.setter
    def randomization_salt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "randomization_salt", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scheduledSplitsConfig")
    def scheduled_splits_config(self) -> Optional[pulumi.Input['LaunchScheduledSplitsConfigArgs']]:
        """
        A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
        """
        return pulumi.get(self, "scheduled_splits_config")

    @scheduled_splits_config.setter
    def scheduled_splits_config(self, value: Optional[pulumi.Input['LaunchScheduledSplitsConfigArgs']]):
        pulumi.set(self, "scheduled_splits_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LaunchState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 executions: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchExecutionArgs']]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchGroupArgs']]]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_monitors: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchMetricMonitorArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 randomization_salt: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_splits_config: Optional[pulumi.Input['LaunchScheduledSplitsConfigArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Launch resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the launch.
        :param pulumi.Input[_builtins.str] created_time: The date and time that the launch is created.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the launch.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchExecutionArgs']]] executions: A block that contains information about the start and end times of the launch. Detailed below
        :param pulumi.Input[Sequence[pulumi.Input['LaunchGroupArgs']]] groups: One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
        :param pulumi.Input[_builtins.str] last_updated_time: The date and time that the launch was most recently updated.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchMetricMonitorArgs']]] metric_monitors: One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
        :param pulumi.Input[_builtins.str] name: The name for the new launch. Minimum length of `1`. Maximum length of `127`.
        :param pulumi.Input[_builtins.str] project: The name or ARN of the project that is to contain the new launch.
        :param pulumi.Input[_builtins.str] randomization_salt: When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['LaunchScheduledSplitsConfigArgs'] scheduled_splits_config: A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
        :param pulumi.Input[_builtins.str] status: The current state of the launch. Valid values are `CREATED`, `UPDATING`, `RUNNING`, `COMPLETED`, and `CANCELLED`.
        :param pulumi.Input[_builtins.str] status_reason: If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: The type of launch.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if executions is not None:
            pulumi.set(__self__, "executions", executions)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if metric_monitors is not None:
            pulumi.set(__self__, "metric_monitors", metric_monitors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if randomization_salt is not None:
            pulumi.set(__self__, "randomization_salt", randomization_salt)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduled_splits_config is not None:
            pulumi.set(__self__, "scheduled_splits_config", scheduled_splits_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the launch.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the launch is created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the launch.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def executions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchExecutionArgs']]]]:
        """
        A block that contains information about the start and end times of the launch. Detailed below
        """
        return pulumi.get(self, "executions")

    @executions.setter
    def executions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchExecutionArgs']]]]):
        pulumi.set(self, "executions", value)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchGroupArgs']]]]:
        """
        One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the launch was most recently updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter(name="metricMonitors")
    def metric_monitors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchMetricMonitorArgs']]]]:
        """
        One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
        """
        return pulumi.get(self, "metric_monitors")

    @metric_monitors.setter
    def metric_monitors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchMetricMonitorArgs']]]]):
        pulumi.set(self, "metric_monitors", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the new launch. Minimum length of `1`. Maximum length of `127`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or ARN of the project that is to contain the new launch.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="randomizationSalt")
    def randomization_salt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
        """
        return pulumi.get(self, "randomization_salt")

    @randomization_salt.setter
    def randomization_salt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "randomization_salt", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scheduledSplitsConfig")
    def scheduled_splits_config(self) -> Optional[pulumi.Input['LaunchScheduledSplitsConfigArgs']]:
        """
        A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
        """
        return pulumi.get(self, "scheduled_splits_config")

    @scheduled_splits_config.setter
    def scheduled_splits_config(self, value: Optional[pulumi.Input['LaunchScheduledSplitsConfigArgs']]):
        pulumi.set(self, "scheduled_splits_config", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the launch. Valid values are `CREATED`, `UPDATING`, `RUNNING`, `COMPLETED`, and `CANCELLED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of launch.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:evidently/launch:Launch")
class Launch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchGroupArgs', 'LaunchGroupArgsDict']]]]] = None,
                 metric_monitors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchMetricMonitorArgs', 'LaunchMetricMonitorArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 randomization_salt: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_splits_config: Optional[pulumi.Input[Union['LaunchScheduledSplitsConfigArgs', 'LaunchScheduledSplitsConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a CloudWatch Evidently Launch resource.

        > **Warning:** This resource is deprecated. Use [AWS AppConfig feature flags](https://aws.amazon.com/blogs/mt/using-aws-appconfig-feature-flags/) instead.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[{
                "feature": example_aws_evidently_feature["name"],
                "name": "Variation1",
                "variation": "Variation1",
            }],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With description

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            description="example description",
            groups=[{
                "feature": example_aws_evidently_feature["name"],
                "name": "Variation1",
                "variation": "Variation1",
            }],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With multiple groups

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation1",
                    "variation": "Variation1",
                    "description": "first-group",
                },
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation2",
                    "variation": "Variation2",
                    "description": "second-group",
                },
            ],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                        "Variation2": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With metric_monitors

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[{
                "feature": example_aws_evidently_feature["name"],
                "name": "Variation1",
                "variation": "Variation1",
            }],
            metric_monitors=[
                {
                    "metric_definition": {
                        "entity_id_key": "entity_id_key1",
                        "event_pattern": "{\\"Price\\":[{\\"numeric\\":[\\">\\",11,\\"<=\\",22]}]}",
                        "name": "name1",
                        "unit_label": "unit_label1",
                        "value_key": "value_key1",
                    },
                },
                {
                    "metric_definition": {
                        "entity_id_key": "entity_id_key2",
                        "event_pattern": "{\\"Price\\":[{\\"numeric\\":[\\">\\",9,\\"<=\\",19]}]}",
                        "name": "name2",
                        "unit_label": "unit_label2",
                        "value_key": "value_key2",
                    },
                },
            ],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With randomization_salt

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            randomization_salt="example randomization salt",
            groups=[{
                "feature": example_aws_evidently_feature["name"],
                "name": "Variation1",
                "variation": "Variation1",
            }],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With multiple steps

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation1",
                    "variation": "Variation1",
                },
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation2",
                    "variation": "Variation2",
                },
            ],
            scheduled_splits_config={
                "steps": [
                    {
                        "group_weights": {
                            "Variation1": 15,
                            "Variation2": 10,
                        },
                        "start_time": "2024-01-07 01:43:59+00:00",
                    },
                    {
                        "group_weights": {
                            "Variation1": 20,
                            "Variation2": 25,
                        },
                        "start_time": "2024-01-08 01:43:59+00:00",
                    },
                ],
            })
        ```

        ### With segment overrides

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation1",
                    "variation": "Variation1",
                },
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation2",
                    "variation": "Variation2",
                },
            ],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                        "Variation2": 0,
                    },
                    "segment_overrides": [
                        {
                            "evaluation_order": 1,
                            "segment": example_aws_evidently_segment["name"],
                            "weights": {
                                "Variation2": 10000,
                            },
                        },
                        {
                            "evaluation_order": 2,
                            "segment": example_aws_evidently_segment["name"],
                            "weights": {
                                "Variation1": 40000,
                                "Variation2": 30000,
                            },
                        },
                    ],
                    "start_time": "2024-01-08 01:43:59+00:00",
                }],
            })
        ```

        ## Import

        Import using the `name` of the launch and `arn` of the project separated by a `:`:

        __Using `pulumi import` to import__ CloudWatch Evidently Launch using the `name` of the launch and `name` of the project or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:

        Import using the `name` of the launch and `name` of the project separated by a `:`:

        ```sh
        $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:exampleProjectName
        ```
        Import using the `name` of the launch and `arn` of the project separated by a `:`:

        ```sh
        $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:arn:aws:evidently:us-east-1:123456789012:project/exampleProjectName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the launch.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchGroupArgs', 'LaunchGroupArgsDict']]]] groups: One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchMetricMonitorArgs', 'LaunchMetricMonitorArgsDict']]]] metric_monitors: One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
        :param pulumi.Input[_builtins.str] name: The name for the new launch. Minimum length of `1`. Maximum length of `127`.
        :param pulumi.Input[_builtins.str] project: The name or ARN of the project that is to contain the new launch.
        :param pulumi.Input[_builtins.str] randomization_salt: When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['LaunchScheduledSplitsConfigArgs', 'LaunchScheduledSplitsConfigArgsDict']] scheduled_splits_config: A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LaunchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudWatch Evidently Launch resource.

        > **Warning:** This resource is deprecated. Use [AWS AppConfig feature flags](https://aws.amazon.com/blogs/mt/using-aws-appconfig-feature-flags/) instead.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[{
                "feature": example_aws_evidently_feature["name"],
                "name": "Variation1",
                "variation": "Variation1",
            }],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With description

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            description="example description",
            groups=[{
                "feature": example_aws_evidently_feature["name"],
                "name": "Variation1",
                "variation": "Variation1",
            }],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With multiple groups

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation1",
                    "variation": "Variation1",
                    "description": "first-group",
                },
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation2",
                    "variation": "Variation2",
                    "description": "second-group",
                },
            ],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                        "Variation2": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With metric_monitors

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[{
                "feature": example_aws_evidently_feature["name"],
                "name": "Variation1",
                "variation": "Variation1",
            }],
            metric_monitors=[
                {
                    "metric_definition": {
                        "entity_id_key": "entity_id_key1",
                        "event_pattern": "{\\"Price\\":[{\\"numeric\\":[\\">\\",11,\\"<=\\",22]}]}",
                        "name": "name1",
                        "unit_label": "unit_label1",
                        "value_key": "value_key1",
                    },
                },
                {
                    "metric_definition": {
                        "entity_id_key": "entity_id_key2",
                        "event_pattern": "{\\"Price\\":[{\\"numeric\\":[\\">\\",9,\\"<=\\",19]}]}",
                        "name": "name2",
                        "unit_label": "unit_label2",
                        "value_key": "value_key2",
                    },
                },
            ],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With randomization_salt

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            randomization_salt="example randomization salt",
            groups=[{
                "feature": example_aws_evidently_feature["name"],
                "name": "Variation1",
                "variation": "Variation1",
            }],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                    },
                    "start_time": "2024-01-07 01:43:59+00:00",
                }],
            })
        ```

        ### With multiple steps

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation1",
                    "variation": "Variation1",
                },
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation2",
                    "variation": "Variation2",
                },
            ],
            scheduled_splits_config={
                "steps": [
                    {
                        "group_weights": {
                            "Variation1": 15,
                            "Variation2": 10,
                        },
                        "start_time": "2024-01-07 01:43:59+00:00",
                    },
                    {
                        "group_weights": {
                            "Variation1": 20,
                            "Variation2": 25,
                        },
                        "start_time": "2024-01-08 01:43:59+00:00",
                    },
                ],
            })
        ```

        ### With segment overrides

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Launch("example",
            name="example",
            project=example_aws_evidently_project["name"],
            groups=[
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation1",
                    "variation": "Variation1",
                },
                {
                    "feature": example_aws_evidently_feature["name"],
                    "name": "Variation2",
                    "variation": "Variation2",
                },
            ],
            scheduled_splits_config={
                "steps": [{
                    "group_weights": {
                        "Variation1": 0,
                        "Variation2": 0,
                    },
                    "segment_overrides": [
                        {
                            "evaluation_order": 1,
                            "segment": example_aws_evidently_segment["name"],
                            "weights": {
                                "Variation2": 10000,
                            },
                        },
                        {
                            "evaluation_order": 2,
                            "segment": example_aws_evidently_segment["name"],
                            "weights": {
                                "Variation1": 40000,
                                "Variation2": 30000,
                            },
                        },
                    ],
                    "start_time": "2024-01-08 01:43:59+00:00",
                }],
            })
        ```

        ## Import

        Import using the `name` of the launch and `arn` of the project separated by a `:`:

        __Using `pulumi import` to import__ CloudWatch Evidently Launch using the `name` of the launch and `name` of the project or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:

        Import using the `name` of the launch and `name` of the project separated by a `:`:

        ```sh
        $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:exampleProjectName
        ```
        Import using the `name` of the launch and `arn` of the project separated by a `:`:

        ```sh
        $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:arn:aws:evidently:us-east-1:123456789012:project/exampleProjectName
        ```

        :param str resource_name: The name of the resource.
        :param LaunchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LaunchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchGroupArgs', 'LaunchGroupArgsDict']]]]] = None,
                 metric_monitors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchMetricMonitorArgs', 'LaunchMetricMonitorArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 randomization_salt: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_splits_config: Optional[pulumi.Input[Union['LaunchScheduledSplitsConfigArgs', 'LaunchScheduledSplitsConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LaunchArgs.__new__(LaunchArgs)

            __props__.__dict__["description"] = description
            if groups is None and not opts.urn:
                raise TypeError("Missing required property 'groups'")
            __props__.__dict__["groups"] = groups
            __props__.__dict__["metric_monitors"] = metric_monitors
            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["randomization_salt"] = randomization_salt
            __props__.__dict__["region"] = region
            __props__.__dict__["scheduled_splits_config"] = scheduled_splits_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["executions"] = None
            __props__.__dict__["last_updated_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reason"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["type"] = None
        super(Launch, __self__).__init__(
            'aws:evidently/launch:Launch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            executions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchExecutionArgs', 'LaunchExecutionArgsDict']]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchGroupArgs', 'LaunchGroupArgsDict']]]]] = None,
            last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
            metric_monitors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchMetricMonitorArgs', 'LaunchMetricMonitorArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            randomization_salt: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_splits_config: Optional[pulumi.Input[Union['LaunchScheduledSplitsConfigArgs', 'LaunchScheduledSplitsConfigArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_reason: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Launch':
        """
        Get an existing Launch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the launch.
        :param pulumi.Input[_builtins.str] created_time: The date and time that the launch is created.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the launch.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchExecutionArgs', 'LaunchExecutionArgsDict']]]] executions: A block that contains information about the start and end times of the launch. Detailed below
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchGroupArgs', 'LaunchGroupArgsDict']]]] groups: One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
        :param pulumi.Input[_builtins.str] last_updated_time: The date and time that the launch was most recently updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchMetricMonitorArgs', 'LaunchMetricMonitorArgsDict']]]] metric_monitors: One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
        :param pulumi.Input[_builtins.str] name: The name for the new launch. Minimum length of `1`. Maximum length of `127`.
        :param pulumi.Input[_builtins.str] project: The name or ARN of the project that is to contain the new launch.
        :param pulumi.Input[_builtins.str] randomization_salt: When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['LaunchScheduledSplitsConfigArgs', 'LaunchScheduledSplitsConfigArgsDict']] scheduled_splits_config: A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
        :param pulumi.Input[_builtins.str] status: The current state of the launch. Valid values are `CREATED`, `UPDATING`, `RUNNING`, `COMPLETED`, and `CANCELLED`.
        :param pulumi.Input[_builtins.str] status_reason: If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: The type of launch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LaunchState.__new__(_LaunchState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["description"] = description
        __props__.__dict__["executions"] = executions
        __props__.__dict__["groups"] = groups
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["metric_monitors"] = metric_monitors
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["randomization_salt"] = randomization_salt
        __props__.__dict__["region"] = region
        __props__.__dict__["scheduled_splits_config"] = scheduled_splits_config
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        return Launch(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the launch.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the launch is created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the launch.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def executions(self) -> pulumi.Output[Sequence['outputs.LaunchExecution']]:
        """
        A block that contains information about the start and end times of the launch. Detailed below
        """
        return pulumi.get(self, "executions")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Sequence['outputs.LaunchGroup']]:
        """
        One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the launch was most recently updated.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter(name="metricMonitors")
    def metric_monitors(self) -> pulumi.Output[Optional[Sequence['outputs.LaunchMetricMonitor']]]:
        """
        One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
        """
        return pulumi.get(self, "metric_monitors")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the new launch. Minimum length of `1`. Maximum length of `127`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name or ARN of the project that is to contain the new launch.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="randomizationSalt")
    def randomization_salt(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
        """
        return pulumi.get(self, "randomization_salt")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scheduledSplitsConfig")
    def scheduled_splits_config(self) -> pulumi.Output[Optional['outputs.LaunchScheduledSplitsConfig']]:
        """
        A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
        """
        return pulumi.get(self, "scheduled_splits_config")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the launch. Valid values are `CREATED`, `UPDATING`, `RUNNING`, `COMPLETED`, and `CANCELLED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[_builtins.str]:
        """
        If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of launch.
        """
        return pulumi.get(self, "type")

