# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 data_delivery: Optional[pulumi.Input['ProjectDataDeliveryArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input['ProjectDataDeliveryArgs'] data_delivery: A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the project.
        :param pulumi.Input[_builtins.str] name: A name for the project.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if data_delivery is not None:
            pulumi.set(__self__, "data_delivery", data_delivery)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="dataDelivery")
    def data_delivery(self) -> Optional[pulumi.Input['ProjectDataDeliveryArgs']]:
        """
        A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
        """
        return pulumi.get(self, "data_delivery")

    @data_delivery.setter
    def data_delivery(self, value: Optional[pulumi.Input['ProjectDataDeliveryArgs']]):
        pulumi.set(self, "data_delivery", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 active_experiment_count: Optional[pulumi.Input[_builtins.int]] = None,
                 active_launch_count: Optional[pulumi.Input[_builtins.int]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_delivery: Optional[pulumi.Input['ProjectDataDeliveryArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 experiment_count: Optional[pulumi.Input[_builtins.int]] = None,
                 feature_count: Optional[pulumi.Input[_builtins.int]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[_builtins.int] active_experiment_count: The number of ongoing experiments currently in the project.
        :param pulumi.Input[_builtins.int] active_launch_count: The number of ongoing launches currently in the project.
        :param pulumi.Input[_builtins.str] arn: The ARN of the project.
        :param pulumi.Input[_builtins.str] created_time: The date and time that the project is created.
        :param pulumi.Input['ProjectDataDeliveryArgs'] data_delivery: A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the project.
        :param pulumi.Input[_builtins.int] experiment_count: The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.
        :param pulumi.Input[_builtins.int] feature_count: The number of features currently in the project.
        :param pulumi.Input[_builtins.str] last_updated_time: The date and time that the project was most recently updated.
        :param pulumi.Input[_builtins.int] launch_count: The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.
        :param pulumi.Input[_builtins.str] name: A name for the project.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The current state of the project. Valid values are `AVAILABLE` and `UPDATING`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if active_experiment_count is not None:
            pulumi.set(__self__, "active_experiment_count", active_experiment_count)
        if active_launch_count is not None:
            pulumi.set(__self__, "active_launch_count", active_launch_count)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if data_delivery is not None:
            pulumi.set(__self__, "data_delivery", data_delivery)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if experiment_count is not None:
            pulumi.set(__self__, "experiment_count", experiment_count)
        if feature_count is not None:
            pulumi.set(__self__, "feature_count", feature_count)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if launch_count is not None:
            pulumi.set(__self__, "launch_count", launch_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="activeExperimentCount")
    def active_experiment_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of ongoing experiments currently in the project.
        """
        return pulumi.get(self, "active_experiment_count")

    @active_experiment_count.setter
    def active_experiment_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "active_experiment_count", value)

    @_builtins.property
    @pulumi.getter(name="activeLaunchCount")
    def active_launch_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of ongoing launches currently in the project.
        """
        return pulumi.get(self, "active_launch_count")

    @active_launch_count.setter
    def active_launch_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "active_launch_count", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the project.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the project is created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter(name="dataDelivery")
    def data_delivery(self) -> Optional[pulumi.Input['ProjectDataDeliveryArgs']]:
        """
        A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
        """
        return pulumi.get(self, "data_delivery")

    @data_delivery.setter
    def data_delivery(self, value: Optional[pulumi.Input['ProjectDataDeliveryArgs']]):
        pulumi.set(self, "data_delivery", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="experimentCount")
    def experiment_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.
        """
        return pulumi.get(self, "experiment_count")

    @experiment_count.setter
    def experiment_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "experiment_count", value)

    @_builtins.property
    @pulumi.getter(name="featureCount")
    def feature_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of features currently in the project.
        """
        return pulumi.get(self, "feature_count")

    @feature_count.setter
    def feature_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "feature_count", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the project was most recently updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter(name="launchCount")
    def launch_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.
        """
        return pulumi.get(self, "launch_count")

    @launch_count.setter
    def launch_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "launch_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the project. Valid values are `AVAILABLE` and `UPDATING`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:evidently/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_delivery: Optional[pulumi.Input[Union['ProjectDataDeliveryArgs', 'ProjectDataDeliveryArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a CloudWatch Evidently Project resource.

        > **Warning:** This resource is deprecated. Use [AWS AppConfig feature flags](https://aws.amazon.com/blogs/mt/using-aws-appconfig-feature-flags/) instead.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Project("example",
            name="Example",
            description="Example Description",
            tags={
                "Key1": "example Project",
            })
        ```

        ### Store evaluation events in a CloudWatch Log Group

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Project("example",
            name="Example",
            description="Example Description",
            data_delivery={
                "cloudwatch_logs": {
                    "log_group": "example-log-group-name",
                },
            },
            tags={
                "Key1": "example Project",
            })
        ```

        ### Store evaluation events in an S3 bucket

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Project("example",
            name="Example",
            description="Example Description",
            data_delivery={
                "s3_destination": {
                    "bucket": "example-bucket-name",
                    "prefix": "example",
                },
            },
            tags={
                "Key1": "example Project",
            })
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Evidently Project using the `arn`. For example:

        ```sh
        $ pulumi import aws:evidently/project:Project example arn:aws:evidently:us-east-1:123456789012:segment/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectDataDeliveryArgs', 'ProjectDataDeliveryArgsDict']] data_delivery: A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the project.
        :param pulumi.Input[_builtins.str] name: A name for the project.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudWatch Evidently Project resource.

        > **Warning:** This resource is deprecated. Use [AWS AppConfig feature flags](https://aws.amazon.com/blogs/mt/using-aws-appconfig-feature-flags/) instead.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Project("example",
            name="Example",
            description="Example Description",
            tags={
                "Key1": "example Project",
            })
        ```

        ### Store evaluation events in a CloudWatch Log Group

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Project("example",
            name="Example",
            description="Example Description",
            data_delivery={
                "cloudwatch_logs": {
                    "log_group": "example-log-group-name",
                },
            },
            tags={
                "Key1": "example Project",
            })
        ```

        ### Store evaluation events in an S3 bucket

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Project("example",
            name="Example",
            description="Example Description",
            data_delivery={
                "s3_destination": {
                    "bucket": "example-bucket-name",
                    "prefix": "example",
                },
            },
            tags={
                "Key1": "example Project",
            })
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Evidently Project using the `arn`. For example:

        ```sh
        $ pulumi import aws:evidently/project:Project example arn:aws:evidently:us-east-1:123456789012:segment/example
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_delivery: Optional[pulumi.Input[Union['ProjectDataDeliveryArgs', 'ProjectDataDeliveryArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["data_delivery"] = data_delivery
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["active_experiment_count"] = None
            __props__.__dict__["active_launch_count"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["experiment_count"] = None
            __props__.__dict__["feature_count"] = None
            __props__.__dict__["last_updated_time"] = None
            __props__.__dict__["launch_count"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(Project, __self__).__init__(
            'aws:evidently/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_experiment_count: Optional[pulumi.Input[_builtins.int]] = None,
            active_launch_count: Optional[pulumi.Input[_builtins.int]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_delivery: Optional[pulumi.Input[Union['ProjectDataDeliveryArgs', 'ProjectDataDeliveryArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            experiment_count: Optional[pulumi.Input[_builtins.int]] = None,
            feature_count: Optional[pulumi.Input[_builtins.int]] = None,
            last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
            launch_count: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] active_experiment_count: The number of ongoing experiments currently in the project.
        :param pulumi.Input[_builtins.int] active_launch_count: The number of ongoing launches currently in the project.
        :param pulumi.Input[_builtins.str] arn: The ARN of the project.
        :param pulumi.Input[_builtins.str] created_time: The date and time that the project is created.
        :param pulumi.Input[Union['ProjectDataDeliveryArgs', 'ProjectDataDeliveryArgsDict']] data_delivery: A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the project.
        :param pulumi.Input[_builtins.int] experiment_count: The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.
        :param pulumi.Input[_builtins.int] feature_count: The number of features currently in the project.
        :param pulumi.Input[_builtins.str] last_updated_time: The date and time that the project was most recently updated.
        :param pulumi.Input[_builtins.int] launch_count: The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.
        :param pulumi.Input[_builtins.str] name: A name for the project.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The current state of the project. Valid values are `AVAILABLE` and `UPDATING`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["active_experiment_count"] = active_experiment_count
        __props__.__dict__["active_launch_count"] = active_launch_count
        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["data_delivery"] = data_delivery
        __props__.__dict__["description"] = description
        __props__.__dict__["experiment_count"] = experiment_count
        __props__.__dict__["feature_count"] = feature_count
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["launch_count"] = launch_count
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activeExperimentCount")
    def active_experiment_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of ongoing experiments currently in the project.
        """
        return pulumi.get(self, "active_experiment_count")

    @_builtins.property
    @pulumi.getter(name="activeLaunchCount")
    def active_launch_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of ongoing launches currently in the project.
        """
        return pulumi.get(self, "active_launch_count")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the project.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the project is created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="dataDelivery")
    def data_delivery(self) -> pulumi.Output[Optional['outputs.ProjectDataDelivery']]:
        """
        A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
        """
        return pulumi.get(self, "data_delivery")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="experimentCount")
    def experiment_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.
        """
        return pulumi.get(self, "experiment_count")

    @_builtins.property
    @pulumi.getter(name="featureCount")
    def feature_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of features currently in the project.
        """
        return pulumi.get(self, "feature_count")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the project was most recently updated.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter(name="launchCount")
    def launch_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.
        """
        return pulumi.get(self, "launch_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A name for the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the project. Valid values are `AVAILABLE` and `UPDATING`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

