# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'PolicyExcludeMap',
    'PolicyIncludeMap',
    'PolicySecurityServicePolicyData',
    'PolicySecurityServicePolicyDataPolicyOption',
    'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicy',
    'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySet',
    'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntry',
    'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryIcmpTypeCode',
    'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryPortRange',
    'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntry',
    'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryIcmpTypeCode',
    'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryPortRange',
    'PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicy',
    'PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicy',
    'ResourceSetResourceSet',
    'ResourceSetTimeouts',
]

@pulumi.output_type
class PolicyExcludeMap(dict):
    def __init__(__self__, *,
                 accounts: Optional[Sequence[_builtins.str]] = None,
                 orgunits: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] accounts: A list of AWS Organization member Accounts that you want to include for this AWS FMS Policy.
        :param Sequence[_builtins.str] orgunits: A list of IDs of the AWS Organizational Units that you want to include for this AWS FMS Policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
               
               You can specify inclusions or exclusions, but not both. If you specify an `include_map`, AWS Firewall Manager applies the policy to all accounts specified by the `include_map`, and does not evaluate any `exclude_map` specifications. If you do not specify an `include_map`, then Firewall Manager applies the policy to all accounts except for those specified by the `exclude_map`.
        """
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if orgunits is not None:
            pulumi.set(__self__, "orgunits", orgunits)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of AWS Organization member Accounts that you want to include for this AWS FMS Policy.
        """
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter
    def orgunits(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IDs of the AWS Organizational Units that you want to include for this AWS FMS Policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.

        You can specify inclusions or exclusions, but not both. If you specify an `include_map`, AWS Firewall Manager applies the policy to all accounts specified by the `include_map`, and does not evaluate any `exclude_map` specifications. If you do not specify an `include_map`, then Firewall Manager applies the policy to all accounts except for those specified by the `exclude_map`.
        """
        return pulumi.get(self, "orgunits")


@pulumi.output_type
class PolicyIncludeMap(dict):
    def __init__(__self__, *,
                 accounts: Optional[Sequence[_builtins.str]] = None,
                 orgunits: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] accounts: A list of AWS Organization member Accounts that you want to include for this AWS FMS Policy.
        :param Sequence[_builtins.str] orgunits: A list of IDs of the AWS Organizational Units that you want to include for this AWS FMS Policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
               
               You can specify inclusions or exclusions, but not both. If you specify an `include_map`, AWS Firewall Manager applies the policy to all accounts specified by the `include_map`, and does not evaluate any `exclude_map` specifications. If you do not specify an `include_map`, then Firewall Manager applies the policy to all accounts except for those specified by the `exclude_map`.
        """
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if orgunits is not None:
            pulumi.set(__self__, "orgunits", orgunits)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of AWS Organization member Accounts that you want to include for this AWS FMS Policy.
        """
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter
    def orgunits(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IDs of the AWS Organizational Units that you want to include for this AWS FMS Policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.

        You can specify inclusions or exclusions, but not both. If you specify an `include_map`, AWS Firewall Manager applies the policy to all accounts specified by the `include_map`, and does not evaluate any `exclude_map` specifications. If you do not specify an `include_map`, then Firewall Manager applies the policy to all accounts except for those specified by the `exclude_map`.
        """
        return pulumi.get(self, "orgunits")


@pulumi.output_type
class PolicySecurityServicePolicyData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedServiceData":
            suggest = "managed_service_data"
        elif key == "policyOption":
            suggest = "policy_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 managed_service_data: Optional[_builtins.str] = None,
                 policy_option: Optional['outputs.PolicySecurityServicePolicyDataPolicyOption'] = None):
        """
        :param _builtins.str type: An integer value containing ICMP type.
        :param _builtins.str managed_service_data: Details about the service that are specific to the service type, in JSON format. For service type `SHIELD_ADVANCED`, this is an empty string. Examples depending on `type` can be found in the [AWS Firewall Manager SecurityServicePolicyData API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html).
        :param 'PolicySecurityServicePolicyDataPolicyOptionArgs' policy_option: Contains the Network Firewall firewall policy options to configure a centralized deployment model. See the `policy_option` block.
        """
        pulumi.set(__self__, "type", type)
        if managed_service_data is not None:
            pulumi.set(__self__, "managed_service_data", managed_service_data)
        if policy_option is not None:
            pulumi.set(__self__, "policy_option", policy_option)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        An integer value containing ICMP type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="managedServiceData")
    def managed_service_data(self) -> Optional[_builtins.str]:
        """
        Details about the service that are specific to the service type, in JSON format. For service type `SHIELD_ADVANCED`, this is an empty string. Examples depending on `type` can be found in the [AWS Firewall Manager SecurityServicePolicyData API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html).
        """
        return pulumi.get(self, "managed_service_data")

    @_builtins.property
    @pulumi.getter(name="policyOption")
    def policy_option(self) -> Optional['outputs.PolicySecurityServicePolicyDataPolicyOption']:
        """
        Contains the Network Firewall firewall policy options to configure a centralized deployment model. See the `policy_option` block.
        """
        return pulumi.get(self, "policy_option")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkAclCommonPolicy":
            suggest = "network_acl_common_policy"
        elif key == "networkFirewallPolicy":
            suggest = "network_firewall_policy"
        elif key == "thirdPartyFirewallPolicy":
            suggest = "third_party_firewall_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyDataPolicyOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyDataPolicyOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyDataPolicyOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_acl_common_policy: Optional['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicy'] = None,
                 network_firewall_policy: Optional['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicy'] = None,
                 third_party_firewall_policy: Optional['outputs.PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicy'] = None):
        """
        :param 'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyArgs' network_acl_common_policy: Defines NACL rules across accounts in their AWS Organization. See the `network_acl_common_policy` block.
        :param 'PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs' network_firewall_policy: Defines the deployment model to use for the firewall policy.  See the `network_firewall_policy` block.
        """
        if network_acl_common_policy is not None:
            pulumi.set(__self__, "network_acl_common_policy", network_acl_common_policy)
        if network_firewall_policy is not None:
            pulumi.set(__self__, "network_firewall_policy", network_firewall_policy)
        if third_party_firewall_policy is not None:
            pulumi.set(__self__, "third_party_firewall_policy", third_party_firewall_policy)

    @_builtins.property
    @pulumi.getter(name="networkAclCommonPolicy")
    def network_acl_common_policy(self) -> Optional['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicy']:
        """
        Defines NACL rules across accounts in their AWS Organization. See the `network_acl_common_policy` block.
        """
        return pulumi.get(self, "network_acl_common_policy")

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicy")
    def network_firewall_policy(self) -> Optional['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicy']:
        """
        Defines the deployment model to use for the firewall policy.  See the `network_firewall_policy` block.
        """
        return pulumi.get(self, "network_firewall_policy")

    @_builtins.property
    @pulumi.getter(name="thirdPartyFirewallPolicy")
    def third_party_firewall_policy(self) -> Optional['outputs.PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicy']:
        return pulumi.get(self, "third_party_firewall_policy")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkAclEntrySet":
            suggest = "network_acl_entry_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_acl_entry_set: Optional['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySet'] = None):
        """
        :param 'PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetArgs' network_acl_entry_set: Defines NACL entries for Network ACL policy. See the `network_acl_entry_set` block.
        """
        if network_acl_entry_set is not None:
            pulumi.set(__self__, "network_acl_entry_set", network_acl_entry_set)

    @_builtins.property
    @pulumi.getter(name="networkAclEntrySet")
    def network_acl_entry_set(self) -> Optional['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySet']:
        """
        Defines NACL entries for Network ACL policy. See the `network_acl_entry_set` block.
        """
        return pulumi.get(self, "network_acl_entry_set")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceRemediateForFirstEntries":
            suggest = "force_remediate_for_first_entries"
        elif key == "forceRemediateForLastEntries":
            suggest = "force_remediate_for_last_entries"
        elif key == "firstEntries":
            suggest = "first_entries"
        elif key == "lastEntries":
            suggest = "last_entries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 force_remediate_for_first_entries: _builtins.bool,
                 force_remediate_for_last_entries: _builtins.bool,
                 first_entries: Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntry']] = None,
                 last_entries: Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntry']] = None):
        """
        :param _builtins.bool force_remediate_for_first_entries: A boolean value, if true Firewall Manager uses this setting when it finds policy violations that involve conflicts between the custom entries and the policy entries. If false Firewall Manager marks the network ACL as noncompliant and does not try to remediate.
        :param _builtins.bool force_remediate_for_last_entries: A boolean value, if true Firewall Manager uses this setting when it finds policy violations that involve conflicts between the custom entries and the policy entries. If false Firewall Manager marks the network ACL as noncompliant and does not try to remediate.
        :param Sequence['PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryArgs'] first_entries: The rules that you want to run first in the Firewall Manager managed network ACLs. Firewall manager creates entries with ID value between 1 and 5000. See the `first_entry` block.
        :param Sequence['PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryArgs'] last_entries: The rules that you want to run last in the Firewall Manager managed network ACLs. Firewall manager creates entries with ID value between 32000 and 32766. See the `last_entry` block.
        """
        pulumi.set(__self__, "force_remediate_for_first_entries", force_remediate_for_first_entries)
        pulumi.set(__self__, "force_remediate_for_last_entries", force_remediate_for_last_entries)
        if first_entries is not None:
            pulumi.set(__self__, "first_entries", first_entries)
        if last_entries is not None:
            pulumi.set(__self__, "last_entries", last_entries)

    @_builtins.property
    @pulumi.getter(name="forceRemediateForFirstEntries")
    def force_remediate_for_first_entries(self) -> _builtins.bool:
        """
        A boolean value, if true Firewall Manager uses this setting when it finds policy violations that involve conflicts between the custom entries and the policy entries. If false Firewall Manager marks the network ACL as noncompliant and does not try to remediate.
        """
        return pulumi.get(self, "force_remediate_for_first_entries")

    @_builtins.property
    @pulumi.getter(name="forceRemediateForLastEntries")
    def force_remediate_for_last_entries(self) -> _builtins.bool:
        """
        A boolean value, if true Firewall Manager uses this setting when it finds policy violations that involve conflicts between the custom entries and the policy entries. If false Firewall Manager marks the network ACL as noncompliant and does not try to remediate.
        """
        return pulumi.get(self, "force_remediate_for_last_entries")

    @_builtins.property
    @pulumi.getter(name="firstEntries")
    def first_entries(self) -> Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntry']]:
        """
        The rules that you want to run first in the Firewall Manager managed network ACLs. Firewall manager creates entries with ID value between 1 and 5000. See the `first_entry` block.
        """
        return pulumi.get(self, "first_entries")

    @_builtins.property
    @pulumi.getter(name="lastEntries")
    def last_entries(self) -> Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntry']]:
        """
        The rules that you want to run last in the Firewall Manager managed network ACLs. Firewall manager creates entries with ID value between 32000 and 32766. See the `last_entry` block.
        """
        return pulumi.get(self, "last_entries")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleAction":
            suggest = "rule_action"
        elif key == "cidrBlock":
            suggest = "cidr_block"
        elif key == "icmpTypeCodes":
            suggest = "icmp_type_codes"
        elif key == "ipv6CidrBlock":
            suggest = "ipv6_cidr_block"
        elif key == "portRanges":
            suggest = "port_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress: _builtins.bool,
                 protocol: _builtins.str,
                 rule_action: _builtins.str,
                 cidr_block: Optional[_builtins.str] = None,
                 icmp_type_codes: Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryIcmpTypeCode']] = None,
                 ipv6_cidr_block: Optional[_builtins.str] = None,
                 port_ranges: Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryPortRange']] = None):
        """
        :param _builtins.bool egress: A boolean value, if true Firewall Manager creates egress rule. If false Firewall Manager creates ingress rule.
        :param _builtins.str protocol: The protocol number. A value of "-1" means all protocols.
        :param _builtins.str rule_action: A string value that indicates whether to allow or deny the traffic that matches the rule. Valid values: `allow`, `deny`.
        :param _builtins.str cidr_block: A string value containing the IPv4 network range to allow or deny, in CIDR notation.
        :param Sequence['PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryIcmpTypeCodeArgs'] icmp_type_codes: A configuration block for ICMP protocol: The ICMP type and code. See the `icmp_type_code` block.
        :param _builtins.str ipv6_cidr_block: A string value containing the IPv6 network range to allow or deny, in CIDR notation.
        :param Sequence['PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryPortRangeArgs'] port_ranges: A configuration block for PortRange. See the `port_range` block.
        """
        pulumi.set(__self__, "egress", egress)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "rule_action", rule_action)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if icmp_type_codes is not None:
            pulumi.set(__self__, "icmp_type_codes", icmp_type_codes)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if port_ranges is not None:
            pulumi.set(__self__, "port_ranges", port_ranges)

    @_builtins.property
    @pulumi.getter
    def egress(self) -> _builtins.bool:
        """
        A boolean value, if true Firewall Manager creates egress rule. If false Firewall Manager creates ingress rule.
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol number. A value of "-1" means all protocols.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> _builtins.str:
        """
        A string value that indicates whether to allow or deny the traffic that matches the rule. Valid values: `allow`, `deny`.
        """
        return pulumi.get(self, "rule_action")

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[_builtins.str]:
        """
        A string value containing the IPv4 network range to allow or deny, in CIDR notation.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="icmpTypeCodes")
    def icmp_type_codes(self) -> Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryIcmpTypeCode']]:
        """
        A configuration block for ICMP protocol: The ICMP type and code. See the `icmp_type_code` block.
        """
        return pulumi.get(self, "icmp_type_codes")

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[_builtins.str]:
        """
        A string value containing the IPv6 network range to allow or deny, in CIDR notation.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryPortRange']]:
        """
        A configuration block for PortRange. See the `port_range` block.
        """
        return pulumi.get(self, "port_ranges")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryIcmpTypeCode(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 type: Optional[_builtins.int] = None):
        """
        :param _builtins.int code: An integer value containing ICMP code.
        :param _builtins.int type: An integer value containing ICMP type.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        An integer value containing ICMP code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.int]:
        """
        An integer value containing ICMP type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryPortRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetFirstEntryPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: Optional[_builtins.int] = None,
                 to: Optional[_builtins.int] = None):
        """
        :param _builtins.int from_: The beginning port number of the range.
        :param _builtins.int to: The ending port number of the range.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[_builtins.int]:
        """
        The beginning port number of the range.
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter
    def to(self) -> Optional[_builtins.int]:
        """
        The ending port number of the range.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleAction":
            suggest = "rule_action"
        elif key == "cidrBlock":
            suggest = "cidr_block"
        elif key == "icmpTypeCodes":
            suggest = "icmp_type_codes"
        elif key == "ipv6CidrBlock":
            suggest = "ipv6_cidr_block"
        elif key == "portRanges":
            suggest = "port_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress: _builtins.bool,
                 protocol: _builtins.str,
                 rule_action: _builtins.str,
                 cidr_block: Optional[_builtins.str] = None,
                 icmp_type_codes: Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryIcmpTypeCode']] = None,
                 ipv6_cidr_block: Optional[_builtins.str] = None,
                 port_ranges: Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryPortRange']] = None):
        """
        :param _builtins.bool egress: A boolean value, if true Firewall Manager creates egress rule. If false Firewall Manager creates ingress rule.
        :param _builtins.str protocol: The protocol number. A value of "-1" means all protocols.
        :param _builtins.str rule_action: A string value that indicates whether to allow or deny the traffic that matches the rule. Valid values: `allow`, `deny`.
        :param _builtins.str cidr_block: A string value containing the IPv4 network range to allow or deny, in CIDR notation.
        :param Sequence['PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryIcmpTypeCodeArgs'] icmp_type_codes: A configuration block for ICMP protocol: The ICMP type and code. See the `icmp_type_code` block.
        :param _builtins.str ipv6_cidr_block: A string value containing the IPv6 network range to allow or deny, in CIDR notation.
        :param Sequence['PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryPortRangeArgs'] port_ranges: A configuration block for PortRange. See the `port_range` block.
        """
        pulumi.set(__self__, "egress", egress)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "rule_action", rule_action)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if icmp_type_codes is not None:
            pulumi.set(__self__, "icmp_type_codes", icmp_type_codes)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if port_ranges is not None:
            pulumi.set(__self__, "port_ranges", port_ranges)

    @_builtins.property
    @pulumi.getter
    def egress(self) -> _builtins.bool:
        """
        A boolean value, if true Firewall Manager creates egress rule. If false Firewall Manager creates ingress rule.
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol number. A value of "-1" means all protocols.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> _builtins.str:
        """
        A string value that indicates whether to allow or deny the traffic that matches the rule. Valid values: `allow`, `deny`.
        """
        return pulumi.get(self, "rule_action")

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[_builtins.str]:
        """
        A string value containing the IPv4 network range to allow or deny, in CIDR notation.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="icmpTypeCodes")
    def icmp_type_codes(self) -> Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryIcmpTypeCode']]:
        """
        A configuration block for ICMP protocol: The ICMP type and code. See the `icmp_type_code` block.
        """
        return pulumi.get(self, "icmp_type_codes")

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[_builtins.str]:
        """
        A string value containing the IPv6 network range to allow or deny, in CIDR notation.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[Sequence['outputs.PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryPortRange']]:
        """
        A configuration block for PortRange. See the `port_range` block.
        """
        return pulumi.get(self, "port_ranges")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryIcmpTypeCode(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 type: Optional[_builtins.int] = None):
        """
        :param _builtins.int code: An integer value containing ICMP code.
        :param _builtins.int type: An integer value containing ICMP type.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        An integer value containing ICMP code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.int]:
        """
        An integer value containing ICMP type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryPortRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkAclCommonPolicyNetworkAclEntrySetLastEntryPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: Optional[_builtins.int] = None,
                 to: Optional[_builtins.int] = None):
        """
        :param _builtins.int from_: The beginning port number of the range.
        :param _builtins.int to: The ending port number of the range.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[_builtins.int]:
        """
        The beginning port number of the range.
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter
    def to(self) -> Optional[_builtins.int]:
        """
        The ending port number of the range.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firewallDeploymentModel":
            suggest = "firewall_deployment_model"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 firewall_deployment_model: Optional[_builtins.str] = None):
        """
        :param _builtins.str firewall_deployment_model: Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
        """
        if firewall_deployment_model is not None:
            pulumi.set(__self__, "firewall_deployment_model", firewall_deployment_model)

    @_builtins.property
    @pulumi.getter(name="firewallDeploymentModel")
    def firewall_deployment_model(self) -> Optional[_builtins.str]:
        """
        Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
        """
        return pulumi.get(self, "firewall_deployment_model")


@pulumi.output_type
class PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firewallDeploymentModel":
            suggest = "firewall_deployment_model"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 firewall_deployment_model: Optional[_builtins.str] = None):
        """
        :param _builtins.str firewall_deployment_model: Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
        """
        if firewall_deployment_model is not None:
            pulumi.set(__self__, "firewall_deployment_model", firewall_deployment_model)

    @_builtins.property
    @pulumi.getter(name="firewallDeploymentModel")
    def firewall_deployment_model(self) -> Optional[_builtins.str]:
        """
        Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
        """
        return pulumi.get(self, "firewall_deployment_model")


@pulumi.output_type
class ResourceSetResourceSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdateTime":
            suggest = "last_update_time"
        elif key == "resourceSetStatus":
            suggest = "resource_set_status"
        elif key == "resourceTypeLists":
            suggest = "resource_type_lists"
        elif key == "updateToken":
            suggest = "update_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSetResourceSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSetResourceSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSetResourceSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 last_update_time: Optional[_builtins.str] = None,
                 resource_set_status: Optional[_builtins.str] = None,
                 resource_type_lists: Optional[Sequence[_builtins.str]] = None,
                 update_token: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Descriptive name of the resource set. You can't change the name of a resource set after you create it.
        :param _builtins.str description: Description of the resource set.
        :param _builtins.str id: Unique identifier for the resource set. It's returned in the responses to create and list commands. You provide it to operations like update and delete.
        :param _builtins.str last_update_time: Last time that the reosurce set was changed.
        :param _builtins.str resource_set_status: Indicates whether the resource set is in or out of the admin's Region scope. Valid values are `ACTIVE` (Admin can manage and delete the resource set) or `OUT_OF_ADMIN_SCOPE` (Admin can view the resource set, but they can't edit or delete the resource set.)
        :param Sequence[_builtins.str] resource_type_lists: Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if resource_set_status is not None:
            pulumi.set(__self__, "resource_set_status", resource_set_status)
        if resource_type_lists is not None:
            pulumi.set(__self__, "resource_type_lists", resource_type_lists)
        if update_token is not None:
            pulumi.set(__self__, "update_token", update_token)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Descriptive name of the resource set. You can't change the name of a resource set after you create it.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the resource set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier for the resource set. It's returned in the responses to create and list commands. You provide it to operations like update and delete.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[_builtins.str]:
        """
        Last time that the reosurce set was changed.
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter(name="resourceSetStatus")
    def resource_set_status(self) -> Optional[_builtins.str]:
        """
        Indicates whether the resource set is in or out of the admin's Region scope. Valid values are `ACTIVE` (Admin can manage and delete the resource set) or `OUT_OF_ADMIN_SCOPE` (Admin can view the resource set, but they can't edit or delete the resource set.)
        """
        return pulumi.get(self, "resource_set_status")

    @_builtins.property
    @pulumi.getter(name="resourceTypeLists")
    def resource_type_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
        """
        return pulumi.get(self, "resource_type_lists")

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "update_token")


@pulumi.output_type
class ResourceSetTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


