# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OntapVolumeArgs', 'OntapVolume']

@pulumi.input_type
class OntapVolumeArgs:
    def __init__(__self__, *,
                 storage_virtual_machine_id: pulumi.Input[_builtins.str],
                 aggregate_configuration: Optional[pulumi.Input['OntapVolumeAggregateConfigurationArgs']] = None,
                 bypass_snaplock_enterprise_retention: Optional[pulumi.Input[_builtins.bool]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[_builtins.bool]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 junction_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ontap_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_style: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_megabytes: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_final_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 snaplock_configuration: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationArgs']] = None,
                 snapshot_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_efficiency_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tiering_policy: Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']] = None,
                 volume_style: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OntapVolume resource.
        :param pulumi.Input[_builtins.str] storage_virtual_machine_id: Specifies the storage virtual machine in which to create the volume.
               
               The following arguments are optional:
        :param pulumi.Input['OntapVolumeAggregateConfigurationArgs'] aggregate_configuration: The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
        :param pulumi.Input[_builtins.bool] bypass_snaplock_enterprise_retention: Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] copy_tags_to_backups: A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] final_backup_tags: A map of tags to apply to the volume's final backup.
        :param pulumi.Input[_builtins.str] junction_path: Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        :param pulumi.Input[_builtins.str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input[_builtins.str] ontap_volume_type: Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] security_style: Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
        :param pulumi.Input[_builtins.str] size_in_bytes: Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        :param pulumi.Input[_builtins.int] size_in_megabytes: Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        :param pulumi.Input[_builtins.bool] skip_final_backup: When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input['OntapVolumeSnaplockConfigurationArgs'] snaplock_configuration: The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
        :param pulumi.Input[_builtins.str] snapshot_policy: Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
        :param pulumi.Input[_builtins.bool] storage_efficiency_enabled: Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['OntapVolumeTieringPolicyArgs'] tiering_policy: The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
        :param pulumi.Input[_builtins.str] volume_style: Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
        :param pulumi.Input[_builtins.str] volume_type: The type of volume, currently the only valid value is `ONTAP`.
        """
        pulumi.set(__self__, "storage_virtual_machine_id", storage_virtual_machine_id)
        if aggregate_configuration is not None:
            pulumi.set(__self__, "aggregate_configuration", aggregate_configuration)
        if bypass_snaplock_enterprise_retention is not None:
            pulumi.set(__self__, "bypass_snaplock_enterprise_retention", bypass_snaplock_enterprise_retention)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if final_backup_tags is not None:
            pulumi.set(__self__, "final_backup_tags", final_backup_tags)
        if junction_path is not None:
            pulumi.set(__self__, "junction_path", junction_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ontap_volume_type is not None:
            pulumi.set(__self__, "ontap_volume_type", ontap_volume_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if size_in_bytes is not None:
            pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if size_in_megabytes is not None:
            pulumi.set(__self__, "size_in_megabytes", size_in_megabytes)
        if skip_final_backup is not None:
            pulumi.set(__self__, "skip_final_backup", skip_final_backup)
        if snaplock_configuration is not None:
            pulumi.set(__self__, "snaplock_configuration", snaplock_configuration)
        if snapshot_policy is not None:
            pulumi.set(__self__, "snapshot_policy", snapshot_policy)
        if storage_efficiency_enabled is not None:
            pulumi.set(__self__, "storage_efficiency_enabled", storage_efficiency_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if volume_style is not None:
            pulumi.set(__self__, "volume_style", volume_style)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="storageVirtualMachineId")
    def storage_virtual_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the storage virtual machine in which to create the volume.

        The following arguments are optional:
        """
        return pulumi.get(self, "storage_virtual_machine_id")

    @storage_virtual_machine_id.setter
    def storage_virtual_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="aggregateConfiguration")
    def aggregate_configuration(self) -> Optional[pulumi.Input['OntapVolumeAggregateConfigurationArgs']]:
        """
        The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
        """
        return pulumi.get(self, "aggregate_configuration")

    @aggregate_configuration.setter
    def aggregate_configuration(self, value: Optional[pulumi.Input['OntapVolumeAggregateConfigurationArgs']]):
        pulumi.set(self, "aggregate_configuration", value)

    @_builtins.property
    @pulumi.getter(name="bypassSnaplockEnterpriseRetention")
    def bypass_snaplock_enterprise_retention(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "bypass_snaplock_enterprise_retention")

    @bypass_snaplock_enterprise_retention.setter
    def bypass_snaplock_enterprise_retention(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_snaplock_enterprise_retention", value)

    @_builtins.property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
        """
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @_builtins.property
    @pulumi.getter(name="finalBackupTags")
    def final_backup_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to apply to the volume's final backup.
        """
        return pulumi.get(self, "final_backup_tags")

    @final_backup_tags.setter
    def final_backup_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "final_backup_tags", value)

    @_builtins.property
    @pulumi.getter(name="junctionPath")
    def junction_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        """
        return pulumi.get(self, "junction_path")

    @junction_path.setter
    def junction_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "junction_path", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ontapVolumeType")
    def ontap_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        """
        return pulumi.get(self, "ontap_volume_type")

    @ontap_volume_type.setter
    def ontap_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ontap_volume_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_style", value)

    @_builtins.property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        """
        return pulumi.get(self, "size_in_bytes")

    @size_in_bytes.setter
    def size_in_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="sizeInMegabytes")
    def size_in_megabytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        """
        return pulumi.get(self, "size_in_megabytes")

    @size_in_megabytes.setter
    def size_in_megabytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_in_megabytes", value)

    @_builtins.property
    @pulumi.getter(name="skipFinalBackup")
    def skip_final_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "skip_final_backup")

    @skip_final_backup.setter
    def skip_final_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_final_backup", value)

    @_builtins.property
    @pulumi.getter(name="snaplockConfiguration")
    def snaplock_configuration(self) -> Optional[pulumi.Input['OntapVolumeSnaplockConfigurationArgs']]:
        """
        The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
        """
        return pulumi.get(self, "snaplock_configuration")

    @snaplock_configuration.setter
    def snaplock_configuration(self, value: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationArgs']]):
        pulumi.set(self, "snaplock_configuration", value)

    @_builtins.property
    @pulumi.getter(name="snapshotPolicy")
    def snapshot_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
        """
        return pulumi.get(self, "snapshot_policy")

    @snapshot_policy.setter
    def snapshot_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_policy", value)

    @_builtins.property
    @pulumi.getter(name="storageEfficiencyEnabled")
    def storage_efficiency_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        """
        return pulumi.get(self, "storage_efficiency_enabled")

    @storage_efficiency_enabled.setter
    def storage_efficiency_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_efficiency_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']]:
        """
        The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
        """
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)

    @_builtins.property
    @pulumi.getter(name="volumeStyle")
    def volume_style(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
        """
        return pulumi.get(self, "volume_style")

    @volume_style.setter
    def volume_style(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_style", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of volume, currently the only valid value is `ONTAP`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _OntapVolumeState:
    def __init__(__self__, *,
                 aggregate_configuration: Optional[pulumi.Input['OntapVolumeAggregateConfigurationArgs']] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 bypass_snaplock_enterprise_retention: Optional[pulumi.Input[_builtins.bool]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 flexcache_endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 junction_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ontap_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_style: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_megabytes: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_final_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 snaplock_configuration: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationArgs']] = None,
                 snapshot_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_efficiency_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tiering_policy: Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_style: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OntapVolume resources.
        :param pulumi.Input['OntapVolumeAggregateConfigurationArgs'] aggregate_configuration: The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name of the volune.
        :param pulumi.Input[_builtins.bool] bypass_snaplock_enterprise_retention: Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] copy_tags_to_backups: A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
        :param pulumi.Input[_builtins.str] file_system_id: Describes the file system for the volume, e.g. `fs-12345679`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] final_backup_tags: A map of tags to apply to the volume's final backup.
        :param pulumi.Input[_builtins.str] flexcache_endpoint_type: Specifies the FlexCache endpoint type of the volume, Valid values are `NONE`, `ORIGIN`, `CACHE`. Default value is `NONE`. These can be set by the ONTAP CLI or API and are use with FlexCache feature.
        :param pulumi.Input[_builtins.str] junction_path: Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        :param pulumi.Input[_builtins.str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input[_builtins.str] ontap_volume_type: Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] security_style: Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
        :param pulumi.Input[_builtins.str] size_in_bytes: Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        :param pulumi.Input[_builtins.int] size_in_megabytes: Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        :param pulumi.Input[_builtins.bool] skip_final_backup: When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input['OntapVolumeSnaplockConfigurationArgs'] snaplock_configuration: The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
        :param pulumi.Input[_builtins.str] snapshot_policy: Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
        :param pulumi.Input[_builtins.bool] storage_efficiency_enabled: Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        :param pulumi.Input[_builtins.str] storage_virtual_machine_id: Specifies the storage virtual machine in which to create the volume.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['OntapVolumeTieringPolicyArgs'] tiering_policy: The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
        :param pulumi.Input[_builtins.str] uuid: The Volume's UUID (universally unique identifier).
        :param pulumi.Input[_builtins.str] volume_style: Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
        :param pulumi.Input[_builtins.str] volume_type: The type of volume, currently the only valid value is `ONTAP`.
        """
        if aggregate_configuration is not None:
            pulumi.set(__self__, "aggregate_configuration", aggregate_configuration)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bypass_snaplock_enterprise_retention is not None:
            pulumi.set(__self__, "bypass_snaplock_enterprise_retention", bypass_snaplock_enterprise_retention)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if final_backup_tags is not None:
            pulumi.set(__self__, "final_backup_tags", final_backup_tags)
        if flexcache_endpoint_type is not None:
            pulumi.set(__self__, "flexcache_endpoint_type", flexcache_endpoint_type)
        if junction_path is not None:
            pulumi.set(__self__, "junction_path", junction_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ontap_volume_type is not None:
            pulumi.set(__self__, "ontap_volume_type", ontap_volume_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if size_in_bytes is not None:
            pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if size_in_megabytes is not None:
            pulumi.set(__self__, "size_in_megabytes", size_in_megabytes)
        if skip_final_backup is not None:
            pulumi.set(__self__, "skip_final_backup", skip_final_backup)
        if snaplock_configuration is not None:
            pulumi.set(__self__, "snaplock_configuration", snaplock_configuration)
        if snapshot_policy is not None:
            pulumi.set(__self__, "snapshot_policy", snapshot_policy)
        if storage_efficiency_enabled is not None:
            pulumi.set(__self__, "storage_efficiency_enabled", storage_efficiency_enabled)
        if storage_virtual_machine_id is not None:
            pulumi.set(__self__, "storage_virtual_machine_id", storage_virtual_machine_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if volume_style is not None:
            pulumi.set(__self__, "volume_style", volume_style)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="aggregateConfiguration")
    def aggregate_configuration(self) -> Optional[pulumi.Input['OntapVolumeAggregateConfigurationArgs']]:
        """
        The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
        """
        return pulumi.get(self, "aggregate_configuration")

    @aggregate_configuration.setter
    def aggregate_configuration(self, value: Optional[pulumi.Input['OntapVolumeAggregateConfigurationArgs']]):
        pulumi.set(self, "aggregate_configuration", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name of the volune.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="bypassSnaplockEnterpriseRetention")
    def bypass_snaplock_enterprise_retention(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "bypass_snaplock_enterprise_retention")

    @bypass_snaplock_enterprise_retention.setter
    def bypass_snaplock_enterprise_retention(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_snaplock_enterprise_retention", value)

    @_builtins.property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
        """
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the file system for the volume, e.g. `fs-12345679`
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="finalBackupTags")
    def final_backup_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to apply to the volume's final backup.
        """
        return pulumi.get(self, "final_backup_tags")

    @final_backup_tags.setter
    def final_backup_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "final_backup_tags", value)

    @_builtins.property
    @pulumi.getter(name="flexcacheEndpointType")
    def flexcache_endpoint_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the FlexCache endpoint type of the volume, Valid values are `NONE`, `ORIGIN`, `CACHE`. Default value is `NONE`. These can be set by the ONTAP CLI or API and are use with FlexCache feature.
        """
        return pulumi.get(self, "flexcache_endpoint_type")

    @flexcache_endpoint_type.setter
    def flexcache_endpoint_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flexcache_endpoint_type", value)

    @_builtins.property
    @pulumi.getter(name="junctionPath")
    def junction_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        """
        return pulumi.get(self, "junction_path")

    @junction_path.setter
    def junction_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "junction_path", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ontapVolumeType")
    def ontap_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        """
        return pulumi.get(self, "ontap_volume_type")

    @ontap_volume_type.setter
    def ontap_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ontap_volume_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_style", value)

    @_builtins.property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        """
        return pulumi.get(self, "size_in_bytes")

    @size_in_bytes.setter
    def size_in_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="sizeInMegabytes")
    def size_in_megabytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        """
        return pulumi.get(self, "size_in_megabytes")

    @size_in_megabytes.setter
    def size_in_megabytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_in_megabytes", value)

    @_builtins.property
    @pulumi.getter(name="skipFinalBackup")
    def skip_final_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "skip_final_backup")

    @skip_final_backup.setter
    def skip_final_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_final_backup", value)

    @_builtins.property
    @pulumi.getter(name="snaplockConfiguration")
    def snaplock_configuration(self) -> Optional[pulumi.Input['OntapVolumeSnaplockConfigurationArgs']]:
        """
        The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
        """
        return pulumi.get(self, "snaplock_configuration")

    @snaplock_configuration.setter
    def snaplock_configuration(self, value: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationArgs']]):
        pulumi.set(self, "snaplock_configuration", value)

    @_builtins.property
    @pulumi.getter(name="snapshotPolicy")
    def snapshot_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
        """
        return pulumi.get(self, "snapshot_policy")

    @snapshot_policy.setter
    def snapshot_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_policy", value)

    @_builtins.property
    @pulumi.getter(name="storageEfficiencyEnabled")
    def storage_efficiency_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        """
        return pulumi.get(self, "storage_efficiency_enabled")

    @storage_efficiency_enabled.setter
    def storage_efficiency_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_efficiency_enabled", value)

    @_builtins.property
    @pulumi.getter(name="storageVirtualMachineId")
    def storage_virtual_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage virtual machine in which to create the volume.

        The following arguments are optional:
        """
        return pulumi.get(self, "storage_virtual_machine_id")

    @storage_virtual_machine_id.setter
    def storage_virtual_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']]:
        """
        The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
        """
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Volume's UUID (universally unique identifier).
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)

    @_builtins.property
    @pulumi.getter(name="volumeStyle")
    def volume_style(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
        """
        return pulumi.get(self, "volume_style")

    @volume_style.setter
    def volume_style(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_style", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of volume, currently the only valid value is `ONTAP`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.type_token("aws:fsx/ontapVolume:OntapVolume")
class OntapVolume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregate_configuration: Optional[pulumi.Input[Union['OntapVolumeAggregateConfigurationArgs', 'OntapVolumeAggregateConfigurationArgsDict']]] = None,
                 bypass_snaplock_enterprise_retention: Optional[pulumi.Input[_builtins.bool]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[_builtins.bool]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 junction_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ontap_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_style: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_megabytes: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_final_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 snaplock_configuration: Optional[pulumi.Input[Union['OntapVolumeSnaplockConfigurationArgs', 'OntapVolumeSnaplockConfigurationArgsDict']]] = None,
                 snapshot_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_efficiency_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tiering_policy: Optional[pulumi.Input[Union['OntapVolumeTieringPolicyArgs', 'OntapVolumeTieringPolicyArgsDict']]] = None,
                 volume_style: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a FSx ONTAP Volume.
        See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html) for more information.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapVolume("test",
            name="test",
            junction_path="/test",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=test_aws_fsx_ontap_storage_virtual_machine["id"])
        ```

        ### Using Tiering Policy

        Additional information on tiering policy with ONTAP Volumes can be found in the [FSx ONTAP Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapVolume("test",
            name="test",
            junction_path="/test",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=test_aws_fsx_ontap_storage_virtual_machine["id"],
            tiering_policy={
                "name": "AUTO",
                "cooling_period": 31,
            })
        ```

        ## Import

        Using `pulumi import`, import FSx ONTAP volume using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/ontapVolume:OntapVolume example fsvol-12345678abcdef123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OntapVolumeAggregateConfigurationArgs', 'OntapVolumeAggregateConfigurationArgsDict']] aggregate_configuration: The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
        :param pulumi.Input[_builtins.bool] bypass_snaplock_enterprise_retention: Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] copy_tags_to_backups: A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] final_backup_tags: A map of tags to apply to the volume's final backup.
        :param pulumi.Input[_builtins.str] junction_path: Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        :param pulumi.Input[_builtins.str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input[_builtins.str] ontap_volume_type: Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] security_style: Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
        :param pulumi.Input[_builtins.str] size_in_bytes: Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        :param pulumi.Input[_builtins.int] size_in_megabytes: Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        :param pulumi.Input[_builtins.bool] skip_final_backup: When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[Union['OntapVolumeSnaplockConfigurationArgs', 'OntapVolumeSnaplockConfigurationArgsDict']] snaplock_configuration: The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
        :param pulumi.Input[_builtins.str] snapshot_policy: Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
        :param pulumi.Input[_builtins.bool] storage_efficiency_enabled: Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        :param pulumi.Input[_builtins.str] storage_virtual_machine_id: Specifies the storage virtual machine in which to create the volume.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['OntapVolumeTieringPolicyArgs', 'OntapVolumeTieringPolicyArgsDict']] tiering_policy: The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
        :param pulumi.Input[_builtins.str] volume_style: Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
        :param pulumi.Input[_builtins.str] volume_type: The type of volume, currently the only valid value is `ONTAP`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OntapVolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a FSx ONTAP Volume.
        See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html) for more information.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapVolume("test",
            name="test",
            junction_path="/test",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=test_aws_fsx_ontap_storage_virtual_machine["id"])
        ```

        ### Using Tiering Policy

        Additional information on tiering policy with ONTAP Volumes can be found in the [FSx ONTAP Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapVolume("test",
            name="test",
            junction_path="/test",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=test_aws_fsx_ontap_storage_virtual_machine["id"],
            tiering_policy={
                "name": "AUTO",
                "cooling_period": 31,
            })
        ```

        ## Import

        Using `pulumi import`, import FSx ONTAP volume using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/ontapVolume:OntapVolume example fsvol-12345678abcdef123
        ```

        :param str resource_name: The name of the resource.
        :param OntapVolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OntapVolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregate_configuration: Optional[pulumi.Input[Union['OntapVolumeAggregateConfigurationArgs', 'OntapVolumeAggregateConfigurationArgsDict']]] = None,
                 bypass_snaplock_enterprise_retention: Optional[pulumi.Input[_builtins.bool]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[_builtins.bool]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 junction_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ontap_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_style: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_megabytes: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_final_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 snaplock_configuration: Optional[pulumi.Input[Union['OntapVolumeSnaplockConfigurationArgs', 'OntapVolumeSnaplockConfigurationArgsDict']]] = None,
                 snapshot_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_efficiency_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tiering_policy: Optional[pulumi.Input[Union['OntapVolumeTieringPolicyArgs', 'OntapVolumeTieringPolicyArgsDict']]] = None,
                 volume_style: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OntapVolumeArgs.__new__(OntapVolumeArgs)

            __props__.__dict__["aggregate_configuration"] = aggregate_configuration
            __props__.__dict__["bypass_snaplock_enterprise_retention"] = bypass_snaplock_enterprise_retention
            __props__.__dict__["copy_tags_to_backups"] = copy_tags_to_backups
            __props__.__dict__["final_backup_tags"] = final_backup_tags
            __props__.__dict__["junction_path"] = junction_path
            __props__.__dict__["name"] = name
            __props__.__dict__["ontap_volume_type"] = ontap_volume_type
            __props__.__dict__["region"] = region
            __props__.__dict__["security_style"] = security_style
            __props__.__dict__["size_in_bytes"] = size_in_bytes
            __props__.__dict__["size_in_megabytes"] = size_in_megabytes
            __props__.__dict__["skip_final_backup"] = skip_final_backup
            __props__.__dict__["snaplock_configuration"] = snaplock_configuration
            __props__.__dict__["snapshot_policy"] = snapshot_policy
            __props__.__dict__["storage_efficiency_enabled"] = storage_efficiency_enabled
            if storage_virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_virtual_machine_id'")
            __props__.__dict__["storage_virtual_machine_id"] = storage_virtual_machine_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tiering_policy"] = tiering_policy
            __props__.__dict__["volume_style"] = volume_style
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["arn"] = None
            __props__.__dict__["file_system_id"] = None
            __props__.__dict__["flexcache_endpoint_type"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["uuid"] = None
        super(OntapVolume, __self__).__init__(
            'aws:fsx/ontapVolume:OntapVolume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregate_configuration: Optional[pulumi.Input[Union['OntapVolumeAggregateConfigurationArgs', 'OntapVolumeAggregateConfigurationArgsDict']]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            bypass_snaplock_enterprise_retention: Optional[pulumi.Input[_builtins.bool]] = None,
            copy_tags_to_backups: Optional[pulumi.Input[_builtins.bool]] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            flexcache_endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
            junction_path: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ontap_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_style: Optional[pulumi.Input[_builtins.str]] = None,
            size_in_bytes: Optional[pulumi.Input[_builtins.str]] = None,
            size_in_megabytes: Optional[pulumi.Input[_builtins.int]] = None,
            skip_final_backup: Optional[pulumi.Input[_builtins.bool]] = None,
            snaplock_configuration: Optional[pulumi.Input[Union['OntapVolumeSnaplockConfigurationArgs', 'OntapVolumeSnaplockConfigurationArgsDict']]] = None,
            snapshot_policy: Optional[pulumi.Input[_builtins.str]] = None,
            storage_efficiency_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tiering_policy: Optional[pulumi.Input[Union['OntapVolumeTieringPolicyArgs', 'OntapVolumeTieringPolicyArgsDict']]] = None,
            uuid: Optional[pulumi.Input[_builtins.str]] = None,
            volume_style: Optional[pulumi.Input[_builtins.str]] = None,
            volume_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'OntapVolume':
        """
        Get an existing OntapVolume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OntapVolumeAggregateConfigurationArgs', 'OntapVolumeAggregateConfigurationArgsDict']] aggregate_configuration: The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name of the volune.
        :param pulumi.Input[_builtins.bool] bypass_snaplock_enterprise_retention: Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] copy_tags_to_backups: A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
        :param pulumi.Input[_builtins.str] file_system_id: Describes the file system for the volume, e.g. `fs-12345679`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] final_backup_tags: A map of tags to apply to the volume's final backup.
        :param pulumi.Input[_builtins.str] flexcache_endpoint_type: Specifies the FlexCache endpoint type of the volume, Valid values are `NONE`, `ORIGIN`, `CACHE`. Default value is `NONE`. These can be set by the ONTAP CLI or API and are use with FlexCache feature.
        :param pulumi.Input[_builtins.str] junction_path: Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        :param pulumi.Input[_builtins.str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input[_builtins.str] ontap_volume_type: Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] security_style: Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
        :param pulumi.Input[_builtins.str] size_in_bytes: Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        :param pulumi.Input[_builtins.int] size_in_megabytes: Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        :param pulumi.Input[_builtins.bool] skip_final_backup: When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[Union['OntapVolumeSnaplockConfigurationArgs', 'OntapVolumeSnaplockConfigurationArgsDict']] snaplock_configuration: The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
        :param pulumi.Input[_builtins.str] snapshot_policy: Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
        :param pulumi.Input[_builtins.bool] storage_efficiency_enabled: Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        :param pulumi.Input[_builtins.str] storage_virtual_machine_id: Specifies the storage virtual machine in which to create the volume.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['OntapVolumeTieringPolicyArgs', 'OntapVolumeTieringPolicyArgsDict']] tiering_policy: The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
        :param pulumi.Input[_builtins.str] uuid: The Volume's UUID (universally unique identifier).
        :param pulumi.Input[_builtins.str] volume_style: Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
        :param pulumi.Input[_builtins.str] volume_type: The type of volume, currently the only valid value is `ONTAP`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OntapVolumeState.__new__(_OntapVolumeState)

        __props__.__dict__["aggregate_configuration"] = aggregate_configuration
        __props__.__dict__["arn"] = arn
        __props__.__dict__["bypass_snaplock_enterprise_retention"] = bypass_snaplock_enterprise_retention
        __props__.__dict__["copy_tags_to_backups"] = copy_tags_to_backups
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["final_backup_tags"] = final_backup_tags
        __props__.__dict__["flexcache_endpoint_type"] = flexcache_endpoint_type
        __props__.__dict__["junction_path"] = junction_path
        __props__.__dict__["name"] = name
        __props__.__dict__["ontap_volume_type"] = ontap_volume_type
        __props__.__dict__["region"] = region
        __props__.__dict__["security_style"] = security_style
        __props__.__dict__["size_in_bytes"] = size_in_bytes
        __props__.__dict__["size_in_megabytes"] = size_in_megabytes
        __props__.__dict__["skip_final_backup"] = skip_final_backup
        __props__.__dict__["snaplock_configuration"] = snaplock_configuration
        __props__.__dict__["snapshot_policy"] = snapshot_policy
        __props__.__dict__["storage_efficiency_enabled"] = storage_efficiency_enabled
        __props__.__dict__["storage_virtual_machine_id"] = storage_virtual_machine_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tiering_policy"] = tiering_policy
        __props__.__dict__["uuid"] = uuid
        __props__.__dict__["volume_style"] = volume_style
        __props__.__dict__["volume_type"] = volume_type
        return OntapVolume(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aggregateConfiguration")
    def aggregate_configuration(self) -> pulumi.Output[Optional['outputs.OntapVolumeAggregateConfiguration']]:
        """
        The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
        """
        return pulumi.get(self, "aggregate_configuration")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name of the volune.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="bypassSnaplockEnterpriseRetention")
    def bypass_snaplock_enterprise_retention(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "bypass_snaplock_enterprise_retention")

    @_builtins.property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
        """
        return pulumi.get(self, "copy_tags_to_backups")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        Describes the file system for the volume, e.g. `fs-12345679`
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="finalBackupTags")
    def final_backup_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to apply to the volume's final backup.
        """
        return pulumi.get(self, "final_backup_tags")

    @_builtins.property
    @pulumi.getter(name="flexcacheEndpointType")
    def flexcache_endpoint_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the FlexCache endpoint type of the volume, Valid values are `NONE`, `ORIGIN`, `CACHE`. Default value is `NONE`. These can be set by the ONTAP CLI or API and are use with FlexCache feature.
        """
        return pulumi.get(self, "flexcache_endpoint_type")

    @_builtins.property
    @pulumi.getter(name="junctionPath")
    def junction_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        """
        return pulumi.get(self, "junction_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ontapVolumeType")
    def ontap_volume_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        """
        return pulumi.get(self, "ontap_volume_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
        """
        return pulumi.get(self, "security_style")

    @_builtins.property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        """
        return pulumi.get(self, "size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="sizeInMegabytes")
    def size_in_megabytes(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
        """
        return pulumi.get(self, "size_in_megabytes")

    @_builtins.property
    @pulumi.getter(name="skipFinalBackup")
    def skip_final_backup(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "skip_final_backup")

    @_builtins.property
    @pulumi.getter(name="snaplockConfiguration")
    def snaplock_configuration(self) -> pulumi.Output[Optional['outputs.OntapVolumeSnaplockConfiguration']]:
        """
        The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
        """
        return pulumi.get(self, "snaplock_configuration")

    @_builtins.property
    @pulumi.getter(name="snapshotPolicy")
    def snapshot_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
        """
        return pulumi.get(self, "snapshot_policy")

    @_builtins.property
    @pulumi.getter(name="storageEfficiencyEnabled")
    def storage_efficiency_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        """
        return pulumi.get(self, "storage_efficiency_enabled")

    @_builtins.property
    @pulumi.getter(name="storageVirtualMachineId")
    def storage_virtual_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the storage virtual machine in which to create the volume.

        The following arguments are optional:
        """
        return pulumi.get(self, "storage_virtual_machine_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> pulumi.Output[Optional['outputs.OntapVolumeTieringPolicy']]:
        """
        The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
        """
        return pulumi.get(self, "tiering_policy")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The Volume's UUID (universally unique identifier).
        """
        return pulumi.get(self, "uuid")

    @_builtins.property
    @pulumi.getter(name="volumeStyle")
    def volume_style(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
        """
        return pulumi.get(self, "volume_style")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of volume, currently the only valid value is `ONTAP`.
        """
        return pulumi.get(self, "volume_type")

