# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['S3AccessPointAttachmentArgs', 'S3AccessPointAttachment']

@pulumi.input_type
class S3AccessPointAttachmentArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openzfs_configuration: Optional[pulumi.Input['S3AccessPointAttachmentOpenzfsConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_access_point: Optional[pulumi.Input['S3AccessPointAttachmentS3AccessPointArgs']] = None,
                 timeouts: Optional[pulumi.Input['S3AccessPointAttachmentTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a S3AccessPointAttachment resource.
        :param pulumi.Input[_builtins.str] type: Type of S3 access point. Valid values: `OpenZFS`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] name: Name of the S3 access point.
        :param pulumi.Input['S3AccessPointAttachmentOpenzfsConfigurationArgs'] openzfs_configuration: Configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS volume. See `openzfs_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['S3AccessPointAttachmentS3AccessPointArgs'] s3_access_point: S3 access point configuration. See `s3_access_point` Block for details.
        """
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openzfs_configuration is not None:
            pulumi.set(__self__, "openzfs_configuration", openzfs_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_access_point is not None:
            pulumi.set(__self__, "s3_access_point", s3_access_point)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of S3 access point. Valid values: `OpenZFS`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the S3 access point.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openzfsConfiguration")
    def openzfs_configuration(self) -> Optional[pulumi.Input['S3AccessPointAttachmentOpenzfsConfigurationArgs']]:
        """
        Configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS volume. See `openzfs_configuration` Block for details.
        """
        return pulumi.get(self, "openzfs_configuration")

    @openzfs_configuration.setter
    def openzfs_configuration(self, value: Optional[pulumi.Input['S3AccessPointAttachmentOpenzfsConfigurationArgs']]):
        pulumi.set(self, "openzfs_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3AccessPoint")
    def s3_access_point(self) -> Optional[pulumi.Input['S3AccessPointAttachmentS3AccessPointArgs']]:
        """
        S3 access point configuration. See `s3_access_point` Block for details.
        """
        return pulumi.get(self, "s3_access_point")

    @s3_access_point.setter
    def s3_access_point(self, value: Optional[pulumi.Input['S3AccessPointAttachmentS3AccessPointArgs']]):
        pulumi.set(self, "s3_access_point", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['S3AccessPointAttachmentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['S3AccessPointAttachmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _S3AccessPointAttachmentState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openzfs_configuration: Optional[pulumi.Input['S3AccessPointAttachmentOpenzfsConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_access_point: Optional[pulumi.Input['S3AccessPointAttachmentS3AccessPointArgs']] = None,
                 s3_access_point_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_access_point_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['S3AccessPointAttachmentTimeoutsArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering S3AccessPointAttachment resources.
        :param pulumi.Input[_builtins.str] name: Name of the S3 access point.
        :param pulumi.Input['S3AccessPointAttachmentOpenzfsConfigurationArgs'] openzfs_configuration: Configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS volume. See `openzfs_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['S3AccessPointAttachmentS3AccessPointArgs'] s3_access_point: S3 access point configuration. See `s3_access_point` Block for details.
        :param pulumi.Input[_builtins.str] s3_access_point_alias: S3 access point's alias.
        :param pulumi.Input[_builtins.str] s3_access_point_arn: S3 access point's ARN.
        :param pulumi.Input[_builtins.str] type: Type of S3 access point. Valid values: `OpenZFS`.
               
               The following arguments are optional:
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openzfs_configuration is not None:
            pulumi.set(__self__, "openzfs_configuration", openzfs_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_access_point is not None:
            pulumi.set(__self__, "s3_access_point", s3_access_point)
        if s3_access_point_alias is not None:
            pulumi.set(__self__, "s3_access_point_alias", s3_access_point_alias)
        if s3_access_point_arn is not None:
            pulumi.set(__self__, "s3_access_point_arn", s3_access_point_arn)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the S3 access point.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openzfsConfiguration")
    def openzfs_configuration(self) -> Optional[pulumi.Input['S3AccessPointAttachmentOpenzfsConfigurationArgs']]:
        """
        Configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS volume. See `openzfs_configuration` Block for details.
        """
        return pulumi.get(self, "openzfs_configuration")

    @openzfs_configuration.setter
    def openzfs_configuration(self, value: Optional[pulumi.Input['S3AccessPointAttachmentOpenzfsConfigurationArgs']]):
        pulumi.set(self, "openzfs_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3AccessPoint")
    def s3_access_point(self) -> Optional[pulumi.Input['S3AccessPointAttachmentS3AccessPointArgs']]:
        """
        S3 access point configuration. See `s3_access_point` Block for details.
        """
        return pulumi.get(self, "s3_access_point")

    @s3_access_point.setter
    def s3_access_point(self, value: Optional[pulumi.Input['S3AccessPointAttachmentS3AccessPointArgs']]):
        pulumi.set(self, "s3_access_point", value)

    @_builtins.property
    @pulumi.getter(name="s3AccessPointAlias")
    def s3_access_point_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        S3 access point's alias.
        """
        return pulumi.get(self, "s3_access_point_alias")

    @s3_access_point_alias.setter
    def s3_access_point_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_access_point_alias", value)

    @_builtins.property
    @pulumi.getter(name="s3AccessPointArn")
    def s3_access_point_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        S3 access point's ARN.
        """
        return pulumi.get(self, "s3_access_point_arn")

    @s3_access_point_arn.setter
    def s3_access_point_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_access_point_arn", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['S3AccessPointAttachmentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['S3AccessPointAttachmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of S3 access point. Valid values: `OpenZFS`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:fsx/s3AccessPointAttachment:S3AccessPointAttachment")
class S3AccessPointAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openzfs_configuration: Optional[pulumi.Input[Union['S3AccessPointAttachmentOpenzfsConfigurationArgs', 'S3AccessPointAttachmentOpenzfsConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_access_point: Optional[pulumi.Input[Union['S3AccessPointAttachmentS3AccessPointArgs', 'S3AccessPointAttachmentS3AccessPointArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['S3AccessPointAttachmentTimeoutsArgs', 'S3AccessPointAttachmentTimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Amazon FSx S3 Access Point attachment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.fsx.S3AccessPointAttachment("example",
            name="example-attachment",
            type="OPENZFS",
            openzfs_configuration={
                "volume_id": example_aws_fsx_openzfs_volume["id"],
                "file_system_identity": {
                    "type": "POSIX",
                    "posix_user": {
                        "uid": 1001,
                        "gid": 1001,
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import FSx S3 Access Point attachments using the `name`. For example:

        ```sh
        $ pulumi import aws:fsx/s3AccessPointAttachment:S3AccessPointAttachment example example-attachment
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the S3 access point.
        :param pulumi.Input[Union['S3AccessPointAttachmentOpenzfsConfigurationArgs', 'S3AccessPointAttachmentOpenzfsConfigurationArgsDict']] openzfs_configuration: Configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS volume. See `openzfs_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['S3AccessPointAttachmentS3AccessPointArgs', 'S3AccessPointAttachmentS3AccessPointArgsDict']] s3_access_point: S3 access point configuration. See `s3_access_point` Block for details.
        :param pulumi.Input[_builtins.str] type: Type of S3 access point. Valid values: `OpenZFS`.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: S3AccessPointAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon FSx S3 Access Point attachment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.fsx.S3AccessPointAttachment("example",
            name="example-attachment",
            type="OPENZFS",
            openzfs_configuration={
                "volume_id": example_aws_fsx_openzfs_volume["id"],
                "file_system_identity": {
                    "type": "POSIX",
                    "posix_user": {
                        "uid": 1001,
                        "gid": 1001,
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import FSx S3 Access Point attachments using the `name`. For example:

        ```sh
        $ pulumi import aws:fsx/s3AccessPointAttachment:S3AccessPointAttachment example example-attachment
        ```

        :param str resource_name: The name of the resource.
        :param S3AccessPointAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(S3AccessPointAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openzfs_configuration: Optional[pulumi.Input[Union['S3AccessPointAttachmentOpenzfsConfigurationArgs', 'S3AccessPointAttachmentOpenzfsConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_access_point: Optional[pulumi.Input[Union['S3AccessPointAttachmentS3AccessPointArgs', 'S3AccessPointAttachmentS3AccessPointArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['S3AccessPointAttachmentTimeoutsArgs', 'S3AccessPointAttachmentTimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = S3AccessPointAttachmentArgs.__new__(S3AccessPointAttachmentArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["openzfs_configuration"] = openzfs_configuration
            __props__.__dict__["region"] = region
            __props__.__dict__["s3_access_point"] = s3_access_point
            __props__.__dict__["timeouts"] = timeouts
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["s3_access_point_alias"] = None
            __props__.__dict__["s3_access_point_arn"] = None
        super(S3AccessPointAttachment, __self__).__init__(
            'aws:fsx/s3AccessPointAttachment:S3AccessPointAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            openzfs_configuration: Optional[pulumi.Input[Union['S3AccessPointAttachmentOpenzfsConfigurationArgs', 'S3AccessPointAttachmentOpenzfsConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            s3_access_point: Optional[pulumi.Input[Union['S3AccessPointAttachmentS3AccessPointArgs', 'S3AccessPointAttachmentS3AccessPointArgsDict']]] = None,
            s3_access_point_alias: Optional[pulumi.Input[_builtins.str]] = None,
            s3_access_point_arn: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['S3AccessPointAttachmentTimeoutsArgs', 'S3AccessPointAttachmentTimeoutsArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'S3AccessPointAttachment':
        """
        Get an existing S3AccessPointAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the S3 access point.
        :param pulumi.Input[Union['S3AccessPointAttachmentOpenzfsConfigurationArgs', 'S3AccessPointAttachmentOpenzfsConfigurationArgsDict']] openzfs_configuration: Configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS volume. See `openzfs_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['S3AccessPointAttachmentS3AccessPointArgs', 'S3AccessPointAttachmentS3AccessPointArgsDict']] s3_access_point: S3 access point configuration. See `s3_access_point` Block for details.
        :param pulumi.Input[_builtins.str] s3_access_point_alias: S3 access point's alias.
        :param pulumi.Input[_builtins.str] s3_access_point_arn: S3 access point's ARN.
        :param pulumi.Input[_builtins.str] type: Type of S3 access point. Valid values: `OpenZFS`.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _S3AccessPointAttachmentState.__new__(_S3AccessPointAttachmentState)

        __props__.__dict__["name"] = name
        __props__.__dict__["openzfs_configuration"] = openzfs_configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_access_point"] = s3_access_point
        __props__.__dict__["s3_access_point_alias"] = s3_access_point_alias
        __props__.__dict__["s3_access_point_arn"] = s3_access_point_arn
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["type"] = type
        return S3AccessPointAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the S3 access point.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="openzfsConfiguration")
    def openzfs_configuration(self) -> pulumi.Output[Optional['outputs.S3AccessPointAttachmentOpenzfsConfiguration']]:
        """
        Configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS volume. See `openzfs_configuration` Block for details.
        """
        return pulumi.get(self, "openzfs_configuration")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3AccessPoint")
    def s3_access_point(self) -> pulumi.Output[Optional['outputs.S3AccessPointAttachmentS3AccessPoint']]:
        """
        S3 access point configuration. See `s3_access_point` Block for details.
        """
        return pulumi.get(self, "s3_access_point")

    @_builtins.property
    @pulumi.getter(name="s3AccessPointAlias")
    def s3_access_point_alias(self) -> pulumi.Output[_builtins.str]:
        """
        S3 access point's alias.
        """
        return pulumi.get(self, "s3_access_point_alias")

    @_builtins.property
    @pulumi.getter(name="s3AccessPointArn")
    def s3_access_point_arn(self) -> pulumi.Output[_builtins.str]:
        """
        S3 access point's ARN.
        """
        return pulumi.get(self, "s3_access_point_arn")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.S3AccessPointAttachmentTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of S3 access point. Valid values: `OpenZFS`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

