# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetArnResult',
    'AwaitableGetArnResult',
    'get_arn',
    'get_arn_output',
]

@pulumi.output_type
class GetArnResult:
    """
    A collection of values returned by getArn.
    """
    def __init__(__self__, account=None, arn=None, id=None, partition=None, region=None, resource=None, service=None):
        if account and not isinstance(account, str):
            raise TypeError("Expected argument 'account' to be a str")
        pulumi.set(__self__, "account", account)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource and not isinstance(resource, str):
            raise TypeError("Expected argument 'resource' to be a str")
        pulumi.set(__self__, "resource", resource)
        if service and not isinstance(service, str):
            raise TypeError("Expected argument 'service' to be a str")
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def account(self) -> _builtins.str:
        """
        The [ID](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html) of the AWS account that owns the resource, without the hyphens.
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> _builtins.str:
        """
        Partition that the resource is in.
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region the resource resides in.
        Note that the ARNs for some resources do not include a Region, so this component might be omitted.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> _builtins.str:
        """
        Content of this part of the ARN varies by service.
        It often includes an indicator of the type of resource—for example, an IAM user or Amazon RDS database —followed by a slash (/) or a colon (:), followed by the resource name itself.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The [service namespace](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces) that identifies the AWS product.
        """
        return pulumi.get(self, "service")


class AwaitableGetArnResult(GetArnResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetArnResult(
            account=self.account,
            arn=self.arn,
            id=self.id,
            partition=self.partition,
            region=self.region,
            resource=self.resource,
            service=self.service)


def get_arn(arn: Optional[_builtins.str] = None,
            id: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetArnResult:
    """
    Parses an ARN into its constituent parts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    db_instance = aws.get_arn(arn="arn:aws:rds:eu-west-1:123456789012:db:mysql-db")
    ```


    :param _builtins.str arn: ARN to parse.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:index/getArn:getArn', __args__, opts=opts, typ=GetArnResult).value

    return AwaitableGetArnResult(
        account=pulumi.get(__ret__, 'account'),
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        partition=pulumi.get(__ret__, 'partition'),
        region=pulumi.get(__ret__, 'region'),
        resource=pulumi.get(__ret__, 'resource'),
        service=pulumi.get(__ret__, 'service'))
def get_arn_output(arn: Optional[pulumi.Input[_builtins.str]] = None,
                   id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetArnResult]:
    """
    Parses an ARN into its constituent parts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    db_instance = aws.get_arn(arn="arn:aws:rds:eu-west-1:123456789012:db:mysql-db")
    ```


    :param _builtins.str arn: ARN to parse.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:index/getArn:getArn', __args__, opts=opts, typ=GetArnResult)
    return __ret__.apply(lambda __response__: GetArnResult(
        account=pulumi.get(__response__, 'account'),
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        partition=pulumi.get(__response__, 'partition'),
        region=pulumi.get(__response__, 'region'),
        resource=pulumi.get(__response__, 'resource'),
        service=pulumi.get(__response__, 'service')))
