# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetBillingServiceAccountResult',
    'AwaitableGetBillingServiceAccountResult',
    'get_billing_service_account',
    'get_billing_service_account_output',
]

@pulumi.output_type
class GetBillingServiceAccountResult:
    """
    A collection of values returned by getBillingServiceAccount.
    """
    def __init__(__self__, arn=None, id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the AWS billing service account.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the AWS billing service account.
        """
        return pulumi.get(self, "id")


class AwaitableGetBillingServiceAccountResult(GetBillingServiceAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBillingServiceAccountResult(
            arn=self.arn,
            id=self.id)


def get_billing_service_account(id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBillingServiceAccountResult:
    """
    Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    main = aws.get_billing_service_account()
    billing_logs = aws.s3.Bucket("billing_logs", bucket="my-billing-tf-test-bucket")
    billing_logs_acl = aws.s3.BucketAcl("billing_logs_acl",
        bucket=billing_logs.id,
        acl="private")
    allow_billing_logging = pulumi.Output.all(
        billingLogsArn=billing_logs.arn,
        billingLogsArn1=billing_logs.arn
    ).apply(lambda resolved_outputs: aws.iam.get_policy_document(statements=[
        {
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [main.arn],
            }],
            "actions": [
                "s3:GetBucketAcl",
                "s3:GetBucketPolicy",
            ],
            "resources": [resolved_outputs['billingLogsArn']],
        },
        {
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [main.arn],
            }],
            "actions": ["s3:PutObject"],
            "resources": [f"{resolved_outputs['billingLogsArn1']}/*"],
        },
    ]))

    allow_billing_logging_bucket_policy = aws.s3.BucketPolicy("allow_billing_logging",
        bucket=billing_logs.id,
        policy=allow_billing_logging.json)
    ```


    :param _builtins.str id: ID of the AWS billing service account.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:index/getBillingServiceAccount:getBillingServiceAccount', __args__, opts=opts, typ=GetBillingServiceAccountResult).value

    return AwaitableGetBillingServiceAccountResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'))
def get_billing_service_account_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBillingServiceAccountResult]:
    """
    Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    main = aws.get_billing_service_account()
    billing_logs = aws.s3.Bucket("billing_logs", bucket="my-billing-tf-test-bucket")
    billing_logs_acl = aws.s3.BucketAcl("billing_logs_acl",
        bucket=billing_logs.id,
        acl="private")
    allow_billing_logging = pulumi.Output.all(
        billingLogsArn=billing_logs.arn,
        billingLogsArn1=billing_logs.arn
    ).apply(lambda resolved_outputs: aws.iam.get_policy_document(statements=[
        {
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [main.arn],
            }],
            "actions": [
                "s3:GetBucketAcl",
                "s3:GetBucketPolicy",
            ],
            "resources": [resolved_outputs['billingLogsArn']],
        },
        {
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [main.arn],
            }],
            "actions": ["s3:PutObject"],
            "resources": [f"{resolved_outputs['billingLogsArn1']}/*"],
        },
    ]))

    allow_billing_logging_bucket_policy = aws.s3.BucketPolicy("allow_billing_logging",
        bucket=billing_logs.id,
        policy=allow_billing_logging.json)
    ```


    :param _builtins.str id: ID of the AWS billing service account.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:index/getBillingServiceAccount:getBillingServiceAccount', __args__, opts=opts, typ=GetBillingServiceAccountResult)
    return __ret__.apply(lambda __response__: GetBillingServiceAccountResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id')))
