# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceServiceAccountTokenArgs', 'WorkspaceServiceAccountToken']

@pulumi.input_type
class WorkspaceServiceAccountTokenArgs:
    def __init__(__self__, *,
                 seconds_to_live: pulumi.Input[_builtins.int],
                 service_account_id: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceServiceAccountToken resource.
        :param pulumi.Input[_builtins.int] seconds_to_live: Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
        :param pulumi.Input[_builtins.str] service_account_id: The ID of the service account for which to create a token.
        :param pulumi.Input[_builtins.str] workspace_id: The Grafana workspace with which the service account token is associated.
        :param pulumi.Input[_builtins.str] name: A name for the token to create. The name must be unique within the workspace.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "seconds_to_live", seconds_to_live)
        pulumi.set(__self__, "service_account_id", service_account_id)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="secondsToLive")
    def seconds_to_live(self) -> pulumi.Input[_builtins.int]:
        """
        Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
        """
        return pulumi.get(self, "seconds_to_live")

    @seconds_to_live.setter
    def seconds_to_live(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "seconds_to_live", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the service account for which to create a token.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Grafana workspace with which the service account token is associated.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the token to create. The name must be unique within the workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _WorkspaceServiceAccountTokenState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceServiceAccountToken resources.
        :param pulumi.Input[_builtins.str] created_at: Specifies when the service account token was created.
        :param pulumi.Input[_builtins.str] expires_at: Specifies when the service account token will expire.
        :param pulumi.Input[_builtins.str] key: The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and authorize the requests.
        :param pulumi.Input[_builtins.str] name: A name for the token to create. The name must be unique within the workspace.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] seconds_to_live: Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
        :param pulumi.Input[_builtins.str] service_account_id: The ID of the service account for which to create a token.
        :param pulumi.Input[_builtins.str] service_account_token_id: Identifier of the service account token in the given Grafana workspace.
        :param pulumi.Input[_builtins.str] workspace_id: The Grafana workspace with which the service account token is associated.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if seconds_to_live is not None:
            pulumi.set(__self__, "seconds_to_live", seconds_to_live)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if service_account_token_id is not None:
            pulumi.set(__self__, "service_account_token_id", service_account_token_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies when the service account token was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies when the service account token will expire.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and authorize the requests.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the token to create. The name must be unique within the workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secondsToLive")
    def seconds_to_live(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
        """
        return pulumi.get(self, "seconds_to_live")

    @seconds_to_live.setter
    def seconds_to_live(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "seconds_to_live", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the service account for which to create a token.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountTokenId")
    def service_account_token_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the service account token in the given Grafana workspace.
        """
        return pulumi.get(self, "service_account_token_id")

    @service_account_token_id.setter
    def service_account_token_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_token_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Grafana workspace with which the service account token is associated.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("aws:grafana/workspaceServiceAccountToken:WorkspaceServiceAccountToken")
class WorkspaceServiceAccountToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.grafana.WorkspaceServiceAccount("example",
            name="example-admin",
            grafana_role="ADMIN",
            workspace_id=example_aws_grafana_workspace["id"])
        example_workspace_service_account_token = aws.grafana.WorkspaceServiceAccountToken("example",
            name="example-key",
            service_account_id=example.service_account_id,
            seconds_to_live=3600,
            workspace_id=example_aws_grafana_workspace["id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: A name for the token to create. The name must be unique within the workspace.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] seconds_to_live: Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
        :param pulumi.Input[_builtins.str] service_account_id: The ID of the service account for which to create a token.
        :param pulumi.Input[_builtins.str] workspace_id: The Grafana workspace with which the service account token is associated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceServiceAccountTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.grafana.WorkspaceServiceAccount("example",
            name="example-admin",
            grafana_role="ADMIN",
            workspace_id=example_aws_grafana_workspace["id"])
        example_workspace_service_account_token = aws.grafana.WorkspaceServiceAccountToken("example",
            name="example-key",
            service_account_id=example.service_account_id,
            seconds_to_live=3600,
            workspace_id=example_aws_grafana_workspace["id"])
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceServiceAccountTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceServiceAccountTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceServiceAccountTokenArgs.__new__(WorkspaceServiceAccountTokenArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if seconds_to_live is None and not opts.urn:
                raise TypeError("Missing required property 'seconds_to_live'")
            __props__.__dict__["seconds_to_live"] = seconds_to_live
            if service_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_id'")
            __props__.__dict__["service_account_id"] = service_account_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["expires_at"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["service_account_token_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WorkspaceServiceAccountToken, __self__).__init__(
            'aws:grafana/workspaceServiceAccountToken:WorkspaceServiceAccountToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            seconds_to_live: Optional[pulumi.Input[_builtins.int]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_token_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceServiceAccountToken':
        """
        Get an existing WorkspaceServiceAccountToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Specifies when the service account token was created.
        :param pulumi.Input[_builtins.str] expires_at: Specifies when the service account token will expire.
        :param pulumi.Input[_builtins.str] key: The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and authorize the requests.
        :param pulumi.Input[_builtins.str] name: A name for the token to create. The name must be unique within the workspace.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] seconds_to_live: Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
        :param pulumi.Input[_builtins.str] service_account_id: The ID of the service account for which to create a token.
        :param pulumi.Input[_builtins.str] service_account_token_id: Identifier of the service account token in the given Grafana workspace.
        :param pulumi.Input[_builtins.str] workspace_id: The Grafana workspace with which the service account token is associated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceServiceAccountTokenState.__new__(_WorkspaceServiceAccountTokenState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["seconds_to_live"] = seconds_to_live
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["service_account_token_id"] = service_account_token_id
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceServiceAccountToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies when the service account token was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies when the service account token will expire.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and authorize the requests.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A name for the token to create. The name must be unique within the workspace.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secondsToLive")
    def seconds_to_live(self) -> pulumi.Output[_builtins.int]:
        """
        Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
        """
        return pulumi.get(self, "seconds_to_live")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the service account for which to create a token.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccountTokenId")
    def service_account_token_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the service account token in the given Grafana workspace.
        """
        return pulumi.get(self, "service_account_token_id")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Grafana workspace with which the service account token is associated.
        """
        return pulumi.get(self, "workspace_id")

