# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationConfigurationArgs', 'OrganizationConfiguration']

@pulumi.input_type
class OrganizationConfigurationArgs:
    def __init__(__self__, *,
                 auto_enable_organization_members: pulumi.Input[_builtins.str],
                 detector_id: pulumi.Input[_builtins.str],
                 datasources: Optional[pulumi.Input['OrganizationConfigurationDatasourcesArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationConfiguration resource.
        :param pulumi.Input[_builtins.str] auto_enable_organization_members: Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization.
               Valid values are `ALL`, `NEW`, `NONE`.
        :param pulumi.Input[_builtins.str] detector_id: The detector ID of the GuardDuty account.
        :param pulumi.Input['OrganizationConfigurationDatasourcesArgs'] datasources: Configuration for the collected datasources. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `guardduty.OrganizationConfigurationFeature` resources.
               
               > **NOTE:** One of `auto_enable` or `auto_enable_organization_members` must be specified.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "auto_enable_organization_members", auto_enable_organization_members)
        pulumi.set(__self__, "detector_id", detector_id)
        if datasources is not None:
            warnings.warn("""datasources is deprecated. Use \"guardduty.OrganizationConfigurationFeature\" resources instead.""", DeprecationWarning)
            pulumi.log.warn("""datasources is deprecated: datasources is deprecated. Use \"guardduty.OrganizationConfigurationFeature\" resources instead.""")
        if datasources is not None:
            pulumi.set(__self__, "datasources", datasources)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="autoEnableOrganizationMembers")
    def auto_enable_organization_members(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization.
        Valid values are `ALL`, `NEW`, `NONE`.
        """
        return pulumi.get(self, "auto_enable_organization_members")

    @auto_enable_organization_members.setter
    def auto_enable_organization_members(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auto_enable_organization_members", value)

    @_builtins.property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> pulumi.Input[_builtins.str]:
        """
        The detector ID of the GuardDuty account.
        """
        return pulumi.get(self, "detector_id")

    @detector_id.setter
    def detector_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "detector_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""datasources is deprecated. Use \"guardduty.OrganizationConfigurationFeature\" resources instead.""")
    def datasources(self) -> Optional[pulumi.Input['OrganizationConfigurationDatasourcesArgs']]:
        """
        Configuration for the collected datasources. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `guardduty.OrganizationConfigurationFeature` resources.

        > **NOTE:** One of `auto_enable` or `auto_enable_organization_members` must be specified.
        """
        return pulumi.get(self, "datasources")

    @datasources.setter
    def datasources(self, value: Optional[pulumi.Input['OrganizationConfigurationDatasourcesArgs']]):
        pulumi.set(self, "datasources", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _OrganizationConfigurationState:
    def __init__(__self__, *,
                 auto_enable_organization_members: Optional[pulumi.Input[_builtins.str]] = None,
                 datasources: Optional[pulumi.Input['OrganizationConfigurationDatasourcesArgs']] = None,
                 detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationConfiguration resources.
        :param pulumi.Input[_builtins.str] auto_enable_organization_members: Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization.
               Valid values are `ALL`, `NEW`, `NONE`.
        :param pulumi.Input['OrganizationConfigurationDatasourcesArgs'] datasources: Configuration for the collected datasources. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `guardduty.OrganizationConfigurationFeature` resources.
               
               > **NOTE:** One of `auto_enable` or `auto_enable_organization_members` must be specified.
        :param pulumi.Input[_builtins.str] detector_id: The detector ID of the GuardDuty account.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if auto_enable_organization_members is not None:
            pulumi.set(__self__, "auto_enable_organization_members", auto_enable_organization_members)
        if datasources is not None:
            warnings.warn("""datasources is deprecated. Use \"guardduty.OrganizationConfigurationFeature\" resources instead.""", DeprecationWarning)
            pulumi.log.warn("""datasources is deprecated: datasources is deprecated. Use \"guardduty.OrganizationConfigurationFeature\" resources instead.""")
        if datasources is not None:
            pulumi.set(__self__, "datasources", datasources)
        if detector_id is not None:
            pulumi.set(__self__, "detector_id", detector_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="autoEnableOrganizationMembers")
    def auto_enable_organization_members(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization.
        Valid values are `ALL`, `NEW`, `NONE`.
        """
        return pulumi.get(self, "auto_enable_organization_members")

    @auto_enable_organization_members.setter
    def auto_enable_organization_members(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_enable_organization_members", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""datasources is deprecated. Use \"guardduty.OrganizationConfigurationFeature\" resources instead.""")
    def datasources(self) -> Optional[pulumi.Input['OrganizationConfigurationDatasourcesArgs']]:
        """
        Configuration for the collected datasources. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `guardduty.OrganizationConfigurationFeature` resources.

        > **NOTE:** One of `auto_enable` or `auto_enable_organization_members` must be specified.
        """
        return pulumi.get(self, "datasources")

    @datasources.setter
    def datasources(self, value: Optional[pulumi.Input['OrganizationConfigurationDatasourcesArgs']]):
        pulumi.set(self, "datasources", value)

    @_builtins.property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detector ID of the GuardDuty account.
        """
        return pulumi.get(self, "detector_id")

    @detector_id.setter
    def detector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detector_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:guardduty/organizationConfiguration:OrganizationConfiguration")
class OrganizationConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable_organization_members: Optional[pulumi.Input[_builtins.str]] = None,
                 datasources: Optional[pulumi.Input[Union['OrganizationConfigurationDatasourcesArgs', 'OrganizationConfigurationDatasourcesArgsDict']]] = None,
                 detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the GuardDuty Organization Configuration in the current AWS Region. The AWS account utilizing this resource must have been assigned as a delegated Organization administrator account, e.g., via the `guardduty.OrganizationAdminAccount` resource. More information about Organizations support in GuardDuty can be found in the [GuardDuty User Guide](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html).

        > **NOTE:** This is an advanced resource. The provider will automatically assume management of the GuardDuty Organization Configuration without import and perform no actions on removal from the resource configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.guardduty.Detector("example", enable=True)
        example_organization_configuration = aws.guardduty.OrganizationConfiguration("example",
            auto_enable_organization_members="ALL",
            detector_id=example.id,
            datasources={
                "s3_logs": {
                    "auto_enable": True,
                },
                "kubernetes": {
                    "audit_logs": {
                        "enable": True,
                    },
                },
                "malware_protection": {
                    "scan_ec2_instance_with_findings": {
                        "ebs_volumes": {
                            "auto_enable": True,
                        },
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import GuardDuty Organization Configurations using the GuardDuty Detector ID. For example:

        ```sh
        $ pulumi import aws:guardduty/organizationConfiguration:OrganizationConfiguration example 00b00fd5aecc0ab60a708659477e9617
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_enable_organization_members: Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization.
               Valid values are `ALL`, `NEW`, `NONE`.
        :param pulumi.Input[Union['OrganizationConfigurationDatasourcesArgs', 'OrganizationConfigurationDatasourcesArgsDict']] datasources: Configuration for the collected datasources. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `guardduty.OrganizationConfigurationFeature` resources.
               
               > **NOTE:** One of `auto_enable` or `auto_enable_organization_members` must be specified.
        :param pulumi.Input[_builtins.str] detector_id: The detector ID of the GuardDuty account.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the GuardDuty Organization Configuration in the current AWS Region. The AWS account utilizing this resource must have been assigned as a delegated Organization administrator account, e.g., via the `guardduty.OrganizationAdminAccount` resource. More information about Organizations support in GuardDuty can be found in the [GuardDuty User Guide](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html).

        > **NOTE:** This is an advanced resource. The provider will automatically assume management of the GuardDuty Organization Configuration without import and perform no actions on removal from the resource configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.guardduty.Detector("example", enable=True)
        example_organization_configuration = aws.guardduty.OrganizationConfiguration("example",
            auto_enable_organization_members="ALL",
            detector_id=example.id,
            datasources={
                "s3_logs": {
                    "auto_enable": True,
                },
                "kubernetes": {
                    "audit_logs": {
                        "enable": True,
                    },
                },
                "malware_protection": {
                    "scan_ec2_instance_with_findings": {
                        "ebs_volumes": {
                            "auto_enable": True,
                        },
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import GuardDuty Organization Configurations using the GuardDuty Detector ID. For example:

        ```sh
        $ pulumi import aws:guardduty/organizationConfiguration:OrganizationConfiguration example 00b00fd5aecc0ab60a708659477e9617
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable_organization_members: Optional[pulumi.Input[_builtins.str]] = None,
                 datasources: Optional[pulumi.Input[Union['OrganizationConfigurationDatasourcesArgs', 'OrganizationConfigurationDatasourcesArgsDict']]] = None,
                 detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationConfigurationArgs.__new__(OrganizationConfigurationArgs)

            if auto_enable_organization_members is None and not opts.urn:
                raise TypeError("Missing required property 'auto_enable_organization_members'")
            __props__.__dict__["auto_enable_organization_members"] = auto_enable_organization_members
            __props__.__dict__["datasources"] = datasources
            if detector_id is None and not opts.urn:
                raise TypeError("Missing required property 'detector_id'")
            __props__.__dict__["detector_id"] = detector_id
            __props__.__dict__["region"] = region
        super(OrganizationConfiguration, __self__).__init__(
            'aws:guardduty/organizationConfiguration:OrganizationConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_enable_organization_members: Optional[pulumi.Input[_builtins.str]] = None,
            datasources: Optional[pulumi.Input[Union['OrganizationConfigurationDatasourcesArgs', 'OrganizationConfigurationDatasourcesArgsDict']]] = None,
            detector_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationConfiguration':
        """
        Get an existing OrganizationConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_enable_organization_members: Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization.
               Valid values are `ALL`, `NEW`, `NONE`.
        :param pulumi.Input[Union['OrganizationConfigurationDatasourcesArgs', 'OrganizationConfigurationDatasourcesArgsDict']] datasources: Configuration for the collected datasources. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `guardduty.OrganizationConfigurationFeature` resources.
               
               > **NOTE:** One of `auto_enable` or `auto_enable_organization_members` must be specified.
        :param pulumi.Input[_builtins.str] detector_id: The detector ID of the GuardDuty account.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationConfigurationState.__new__(_OrganizationConfigurationState)

        __props__.__dict__["auto_enable_organization_members"] = auto_enable_organization_members
        __props__.__dict__["datasources"] = datasources
        __props__.__dict__["detector_id"] = detector_id
        __props__.__dict__["region"] = region
        return OrganizationConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoEnableOrganizationMembers")
    def auto_enable_organization_members(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization.
        Valid values are `ALL`, `NEW`, `NONE`.
        """
        return pulumi.get(self, "auto_enable_organization_members")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""datasources is deprecated. Use \"guardduty.OrganizationConfigurationFeature\" resources instead.""")
    def datasources(self) -> pulumi.Output['outputs.OrganizationConfigurationDatasources']:
        """
        Configuration for the collected datasources. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `guardduty.OrganizationConfigurationFeature` resources.

        > **NOTE:** One of `auto_enable` or `auto_enable_organization_members` must be specified.
        """
        return pulumi.get(self, "datasources")

    @_builtins.property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> pulumi.Output[_builtins.str]:
        """
        The detector ID of the GuardDuty account.
        """
        return pulumi.get(self, "detector_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

