# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AWSPrincipalArgs',
    'AWSPrincipalArgsDict',
    'FederatedPrincipalArgs',
    'FederatedPrincipalArgsDict',
    'PolicyDocumentArgs',
    'PolicyDocumentArgsDict',
    'PolicyStatementArgs',
    'PolicyStatementArgsDict',
    'RoleInlinePolicyArgs',
    'RoleInlinePolicyArgsDict',
    'ServicePrincipalArgs',
    'ServicePrincipalArgsDict',
    'GetPolicyDocumentStatementArgs',
    'GetPolicyDocumentStatementArgsDict',
    'GetPolicyDocumentStatementConditionArgs',
    'GetPolicyDocumentStatementConditionArgsDict',
    'GetPolicyDocumentStatementNotPrincipalArgs',
    'GetPolicyDocumentStatementNotPrincipalArgsDict',
    'GetPolicyDocumentStatementPrincipalArgs',
    'GetPolicyDocumentStatementPrincipalArgsDict',
    'GetPrincipalPolicySimulationContextArgs',
    'GetPrincipalPolicySimulationContextArgsDict',
]

MYPY = False

if not MYPY:
    class AWSPrincipalArgsDict(TypedDict):
        """
        When you use an AWS account identifier as the principal in a policy, the permissions in the policy statement can be granted to all identities contained in that account. This includes IAM users and roles in that account.
        """
        aws: pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]
        """
        AWS account identifier or ARN.
        """
elif False:
    AWSPrincipalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AWSPrincipalArgs:
    def __init__(__self__, *,
                 aws: pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]):
        """
        When you use an AWS account identifier as the principal in a policy, the permissions in the policy statement can be granted to all identities contained in that account. This includes IAM users and roles in that account.
        :param pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]] aws: AWS account identifier or ARN.
        """
        pulumi.set(__self__, "aws", aws)

    @_builtins.property
    @pulumi.getter(name="AWS")
    def aws(self) -> pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]:
        """
        AWS account identifier or ARN.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "aws", value)


if not MYPY:
    class FederatedPrincipalArgsDict(TypedDict):
        """
        Federated principal for identity providers.
        """
        federated: pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]
        """
        The federated principal identifier.
        """
elif False:
    FederatedPrincipalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FederatedPrincipalArgs:
    def __init__(__self__, *,
                 federated: pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]):
        """
        Federated principal for identity providers.
        :param pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]] federated: The federated principal identifier.
        """
        pulumi.set(__self__, "federated", federated)

    @_builtins.property
    @pulumi.getter(name="Federated")
    def federated(self) -> pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The federated principal identifier.
        """
        return pulumi.get(self, "federated")

    @federated.setter
    def federated(self, value: pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "federated", value)


if not MYPY:
    class PolicyDocumentArgsDict(TypedDict):
        """
        Represents an AWS IAM policy document that defines permissions for AWS resources and actions.
        """
        statement: pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgsDict']]]
        version: pulumi.Input['PolicyDocumentVersion']
        id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    PolicyDocumentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyDocumentArgs:
    def __init__(__self__, *,
                 statement: pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]],
                 version: pulumi.Input['PolicyDocumentVersion'],
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Represents an AWS IAM policy document that defines permissions for AWS resources and actions.
        """
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "version", version)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="Statement")
    def statement(self) -> pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]]:
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]]):
        pulumi.set(self, "statement", value)

    @_builtins.property
    @pulumi.getter(name="Version")
    def version(self) -> pulumi.Input['PolicyDocumentVersion']:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input['PolicyDocumentVersion']):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="Id")
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class PolicyStatementArgsDict(TypedDict):
        """
        The Statement element is the main element for a policy. This element is required. It can include multiple elements (see the subsequent sections in this page). The Statement element contains an array of individual statements.
        """
        effect: pulumi.Input['PolicyStatementEffect']
        """
        Indicate whether the policy allows or denies access.
        """
        action: NotRequired[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]
        """
        Include a list of actions that the policy allows or denies. Required (either Action or NotAction)
        """
        condition: NotRequired[pulumi.Input[Mapping[str, Any]]]
        """
        Specify the circumstances under which the policy grants permission.
        """
        not_action: NotRequired[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]
        """
        Include a list of actions that are not covered by this policy. Required (either Action or NotAction)
        """
        not_principal: NotRequired[pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgsDict', 'ServicePrincipalArgsDict', 'FederatedPrincipalArgsDict']]]
        """
        Indicate the account, user, role, or federated user to which this policy does not apply.
        """
        not_resource: NotRequired[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]
        """
        A list of resources that are specifically excluded by this policy.
        """
        principal: NotRequired[pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgsDict', 'ServicePrincipalArgsDict', 'FederatedPrincipalArgsDict']]]
        """
        Indicate the account, user, role, or federated user to which you would like to allow or deny access. If you are creating a policy to attach to a user or role, you cannot include this element. The principal is implied as that user or role.
        """
        resource: NotRequired[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]
        """
        A list of resources to which the actions apply.
        """
        sid: NotRequired[pulumi.Input[_builtins.str]]
        """
        An optional statement ID to differentiate between your statements.
        """
elif False:
    PolicyStatementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyStatementArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input['PolicyStatementEffect'],
                 action: Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]] = None,
                 condition: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 not_action: Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]] = None,
                 not_principal: Optional[pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgs', 'ServicePrincipalArgs', 'FederatedPrincipalArgs']]] = None,
                 not_resource: Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]] = None,
                 principal: Optional[pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgs', 'ServicePrincipalArgs', 'FederatedPrincipalArgs']]] = None,
                 resource: Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]] = None,
                 sid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The Statement element is the main element for a policy. This element is required. It can include multiple elements (see the subsequent sections in this page). The Statement element contains an array of individual statements.
        :param pulumi.Input['PolicyStatementEffect'] effect: Indicate whether the policy allows or denies access.
        :param pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]] action: Include a list of actions that the policy allows or denies. Required (either Action or NotAction)
        :param pulumi.Input[Mapping[str, Any]] condition: Specify the circumstances under which the policy grants permission.
        :param pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]] not_action: Include a list of actions that are not covered by this policy. Required (either Action or NotAction)
        :param pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgs', 'ServicePrincipalArgs', 'FederatedPrincipalArgs']] not_principal: Indicate the account, user, role, or federated user to which this policy does not apply.
        :param pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]] not_resource: A list of resources that are specifically excluded by this policy.
        :param pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgs', 'ServicePrincipalArgs', 'FederatedPrincipalArgs']] principal: Indicate the account, user, role, or federated user to which you would like to allow or deny access. If you are creating a policy to attach to a user or role, you cannot include this element. The principal is implied as that user or role.
        :param pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]] resource: A list of resources to which the actions apply.
        :param pulumi.Input[_builtins.str] sid: An optional statement ID to differentiate between your statements.
        """
        pulumi.set(__self__, "effect", effect)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if not_action is not None:
            pulumi.set(__self__, "not_action", not_action)
        if not_principal is not None:
            pulumi.set(__self__, "not_principal", not_principal)
        if not_resource is not None:
            pulumi.set(__self__, "not_resource", not_resource)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)

    @_builtins.property
    @pulumi.getter(name="Effect")
    def effect(self) -> pulumi.Input['PolicyStatementEffect']:
        """
        Indicate whether the policy allows or denies access.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input['PolicyStatementEffect']):
        pulumi.set(self, "effect", value)

    @_builtins.property
    @pulumi.getter(name="Action")
    def action(self) -> Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]:
        """
        Include a list of actions that the policy allows or denies. Required (either Action or NotAction)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="Condition")
    def condition(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Specify the circumstances under which the policy grants permission.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="NotAction")
    def not_action(self) -> Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]:
        """
        Include a list of actions that are not covered by this policy. Required (either Action or NotAction)
        """
        return pulumi.get(self, "not_action")

    @not_action.setter
    def not_action(self, value: Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]):
        pulumi.set(self, "not_action", value)

    @_builtins.property
    @pulumi.getter(name="NotPrincipal")
    def not_principal(self) -> Optional[pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgs', 'ServicePrincipalArgs', 'FederatedPrincipalArgs']]]:
        """
        Indicate the account, user, role, or federated user to which this policy does not apply.
        """
        return pulumi.get(self, "not_principal")

    @not_principal.setter
    def not_principal(self, value: Optional[pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgs', 'ServicePrincipalArgs', 'FederatedPrincipalArgs']]]):
        pulumi.set(self, "not_principal", value)

    @_builtins.property
    @pulumi.getter(name="NotResource")
    def not_resource(self) -> Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]:
        """
        A list of resources that are specifically excluded by this policy.
        """
        return pulumi.get(self, "not_resource")

    @not_resource.setter
    def not_resource(self, value: Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]):
        pulumi.set(self, "not_resource", value)

    @_builtins.property
    @pulumi.getter(name="Principal")
    def principal(self) -> Optional[pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgs', 'ServicePrincipalArgs', 'FederatedPrincipalArgs']]]:
        """
        Indicate the account, user, role, or federated user to which you would like to allow or deny access. If you are creating a policy to attach to a user or role, you cannot include this element. The principal is implied as that user or role.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[Union[_builtins.str, 'AWSPrincipalArgs', 'ServicePrincipalArgs', 'FederatedPrincipalArgs']]]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="Resource")
    def resource(self) -> Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]:
        """
        A list of resources to which the actions apply.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter(name="Sid")
    def sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional statement ID to differentiate between your statements.
        """
        return pulumi.get(self, "sid")

    @sid.setter
    def sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sid", value)


if not MYPY:
    class RoleInlinePolicyArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the role policy.
        """
        policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Policy document as a JSON formatted string.
        """
elif False:
    RoleInlinePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoleInlinePolicyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Name of the role policy.
        :param pulumi.Input[_builtins.str] policy: Policy document as a JSON formatted string.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the role policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy document as a JSON formatted string.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)


if not MYPY:
    class ServicePrincipalArgsDict(TypedDict):
        """
        IAM roles that can be assumed by an AWS service are called service roles. Service roles must include a trust policy. A service principal is an identifier that is used to grant permissions to a service.
        """
        service: pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]
        """
        The service principal identifier.
        """
elif False:
    ServicePrincipalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServicePrincipalArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]):
        """
        IAM roles that can be assumed by an AWS service are called service roles. Service roles must include a trust policy. A service principal is an identifier that is used to grant permissions to a service.
        :param pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]] service: The service principal identifier.
        """
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter(name="Service")
    def service(self) -> pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The service principal identifier.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[Union[_builtins.str, Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service", value)


if not MYPY:
    class GetPolicyDocumentStatementArgsDict(TypedDict):
        actions: NotRequired[Sequence[_builtins.str]]
        """
        List of actions that this statement either allows or denies. For example, `["ec2:RunInstances", "s3:*"]`.
        """
        conditions: NotRequired[Sequence['GetPolicyDocumentStatementConditionArgsDict']]
        """
        Configuration block for a condition. Detailed below.
        """
        effect: NotRequired[_builtins.str]
        """
        Whether this statement allows or denies the given actions. Valid values are `Allow` and `Deny`. Defaults to `Allow`.
        """
        not_actions: NotRequired[Sequence[_builtins.str]]
        """
        List of actions that this statement does *not* apply to. Use to apply a policy statement to all actions *except* those listed.
        """
        not_principals: NotRequired[Sequence['GetPolicyDocumentStatementNotPrincipalArgsDict']]
        """
        Like `principals` except these are principals that the statement does *not* apply to.
        """
        not_resources: NotRequired[Sequence[_builtins.str]]
        """
        List of resource ARNs that this statement does *not* apply to. Use to apply a policy statement to all resources *except* those listed. Conflicts with `resources`.
        """
        principals: NotRequired[Sequence['GetPolicyDocumentStatementPrincipalArgsDict']]
        """
        Configuration block for principals. Detailed below.
        """
        resources: NotRequired[Sequence[_builtins.str]]
        """
        List of resource ARNs that this statement applies to. This is required by AWS if used for an IAM policy. Conflicts with `not_resources`.
        """
        sid: NotRequired[_builtins.str]
        """
        Sid (statement ID) is an identifier for a policy statement.
        """
elif False:
    GetPolicyDocumentStatementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPolicyDocumentStatementArgs:
    def __init__(__self__, *,
                 actions: Optional[Sequence[_builtins.str]] = None,
                 conditions: Optional[Sequence['GetPolicyDocumentStatementConditionArgs']] = None,
                 effect: Optional[_builtins.str] = None,
                 not_actions: Optional[Sequence[_builtins.str]] = None,
                 not_principals: Optional[Sequence['GetPolicyDocumentStatementNotPrincipalArgs']] = None,
                 not_resources: Optional[Sequence[_builtins.str]] = None,
                 principals: Optional[Sequence['GetPolicyDocumentStatementPrincipalArgs']] = None,
                 resources: Optional[Sequence[_builtins.str]] = None,
                 sid: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] actions: List of actions that this statement either allows or denies. For example, `["ec2:RunInstances", "s3:*"]`.
        :param Sequence['GetPolicyDocumentStatementConditionArgs'] conditions: Configuration block for a condition. Detailed below.
        :param _builtins.str effect: Whether this statement allows or denies the given actions. Valid values are `Allow` and `Deny`. Defaults to `Allow`.
        :param Sequence[_builtins.str] not_actions: List of actions that this statement does *not* apply to. Use to apply a policy statement to all actions *except* those listed.
        :param Sequence['GetPolicyDocumentStatementNotPrincipalArgs'] not_principals: Like `principals` except these are principals that the statement does *not* apply to.
        :param Sequence[_builtins.str] not_resources: List of resource ARNs that this statement does *not* apply to. Use to apply a policy statement to all resources *except* those listed. Conflicts with `resources`.
        :param Sequence['GetPolicyDocumentStatementPrincipalArgs'] principals: Configuration block for principals. Detailed below.
        :param Sequence[_builtins.str] resources: List of resource ARNs that this statement applies to. This is required by AWS if used for an IAM policy. Conflicts with `not_resources`.
        :param _builtins.str sid: Sid (statement ID) is an identifier for a policy statement.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_principals is not None:
            pulumi.set(__self__, "not_principals", not_principals)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of actions that this statement either allows or denies. For example, `["ec2:RunInstances", "s3:*"]`.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetPolicyDocumentStatementConditionArgs']]:
        """
        Configuration block for a condition. Detailed below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetPolicyDocumentStatementConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> Optional[_builtins.str]:
        """
        Whether this statement allows or denies the given actions. Valid values are `Allow` and `Deny`. Defaults to `Allow`.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[_builtins.str]):
        pulumi.set(self, "effect", value)

    @_builtins.property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of actions that this statement does *not* apply to. Use to apply a policy statement to all actions *except* those listed.
        """
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "not_actions", value)

    @_builtins.property
    @pulumi.getter(name="notPrincipals")
    def not_principals(self) -> Optional[Sequence['GetPolicyDocumentStatementNotPrincipalArgs']]:
        """
        Like `principals` except these are principals that the statement does *not* apply to.
        """
        return pulumi.get(self, "not_principals")

    @not_principals.setter
    def not_principals(self, value: Optional[Sequence['GetPolicyDocumentStatementNotPrincipalArgs']]):
        pulumi.set(self, "not_principals", value)

    @_builtins.property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of resource ARNs that this statement does *not* apply to. Use to apply a policy statement to all resources *except* those listed. Conflicts with `resources`.
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "not_resources", value)

    @_builtins.property
    @pulumi.getter
    def principals(self) -> Optional[Sequence['GetPolicyDocumentStatementPrincipalArgs']]:
        """
        Configuration block for principals. Detailed below.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[Sequence['GetPolicyDocumentStatementPrincipalArgs']]):
        pulumi.set(self, "principals", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of resource ARNs that this statement applies to. This is required by AWS if used for an IAM policy. Conflicts with `not_resources`.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter
    def sid(self) -> Optional[_builtins.str]:
        """
        Sid (statement ID) is an identifier for a policy statement.
        """
        return pulumi.get(self, "sid")

    @sid.setter
    def sid(self, value: Optional[_builtins.str]):
        pulumi.set(self, "sid", value)


if not MYPY:
    class GetPolicyDocumentStatementConditionArgsDict(TypedDict):
        test: _builtins.str
        """
        Name of the [IAM condition operator](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html) to evaluate.
        """
        values: Sequence[_builtins.str]
        """
        Values to evaluate the condition against. If multiple values are provided, the condition matches if at least one of them applies. That is, AWS evaluates multiple values as though using an "OR" boolean operation.
        """
        variable: _builtins.str
        """
        Name of a [Context Variable](http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html#AvailableKeys) to apply the condition to. Context variables may either be standard AWS variables starting with `aws:` or service-specific variables prefixed with the service name.
        """
elif False:
    GetPolicyDocumentStatementConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPolicyDocumentStatementConditionArgs:
    def __init__(__self__, *,
                 test: _builtins.str,
                 values: Sequence[_builtins.str],
                 variable: _builtins.str):
        """
        :param _builtins.str test: Name of the [IAM condition operator](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html) to evaluate.
        :param Sequence[_builtins.str] values: Values to evaluate the condition against. If multiple values are provided, the condition matches if at least one of them applies. That is, AWS evaluates multiple values as though using an "OR" boolean operation.
        :param _builtins.str variable: Name of a [Context Variable](http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html#AvailableKeys) to apply the condition to. Context variables may either be standard AWS variables starting with `aws:` or service-specific variables prefixed with the service name.
        """
        pulumi.set(__self__, "test", test)
        pulumi.set(__self__, "values", values)
        pulumi.set(__self__, "variable", variable)

    @_builtins.property
    @pulumi.getter
    def test(self) -> _builtins.str:
        """
        Name of the [IAM condition operator](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html) to evaluate.
        """
        return pulumi.get(self, "test")

    @test.setter
    def test(self, value: _builtins.str):
        pulumi.set(self, "test", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Values to evaluate the condition against. If multiple values are provided, the condition matches if at least one of them applies. That is, AWS evaluates multiple values as though using an "OR" boolean operation.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def variable(self) -> _builtins.str:
        """
        Name of a [Context Variable](http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html#AvailableKeys) to apply the condition to. Context variables may either be standard AWS variables starting with `aws:` or service-specific variables prefixed with the service name.
        """
        return pulumi.get(self, "variable")

    @variable.setter
    def variable(self, value: _builtins.str):
        pulumi.set(self, "variable", value)


if not MYPY:
    class GetPolicyDocumentStatementNotPrincipalArgsDict(TypedDict):
        identifiers: Sequence[_builtins.str]
        """
        List of identifiers for principals. When `type` is `AWS`, these are IAM principal ARNs, e.g., `arn:aws:iam::12345678901:role/yak-role`.  When `type` is `Service`, these are AWS Service roles, e.g., `lambda.amazonaws.com`. When `type` is `Federated`, these are web identity users or SAML provider ARNs, e.g., `accounts.google.com` or `arn:aws:iam::12345678901:saml-provider/yak-saml-provider`. When `type` is `CanonicalUser`, these are [canonical user IDs](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId), e.g., `79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be`.
        """
        type: _builtins.str
        """
        Type of principal. Valid values include `AWS`, `Service`, `Federated`, `CanonicalUser` and `*`.
        """
elif False:
    GetPolicyDocumentStatementNotPrincipalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPolicyDocumentStatementNotPrincipalArgs:
    def __init__(__self__, *,
                 identifiers: Sequence[_builtins.str],
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identifiers: List of identifiers for principals. When `type` is `AWS`, these are IAM principal ARNs, e.g., `arn:aws:iam::12345678901:role/yak-role`.  When `type` is `Service`, these are AWS Service roles, e.g., `lambda.amazonaws.com`. When `type` is `Federated`, these are web identity users or SAML provider ARNs, e.g., `accounts.google.com` or `arn:aws:iam::12345678901:saml-provider/yak-saml-provider`. When `type` is `CanonicalUser`, these are [canonical user IDs](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId), e.g., `79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be`.
        :param _builtins.str type: Type of principal. Valid values include `AWS`, `Service`, `Federated`, `CanonicalUser` and `*`.
        """
        pulumi.set(__self__, "identifiers", identifiers)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def identifiers(self) -> Sequence[_builtins.str]:
        """
        List of identifiers for principals. When `type` is `AWS`, these are IAM principal ARNs, e.g., `arn:aws:iam::12345678901:role/yak-role`.  When `type` is `Service`, these are AWS Service roles, e.g., `lambda.amazonaws.com`. When `type` is `Federated`, these are web identity users or SAML provider ARNs, e.g., `accounts.google.com` or `arn:aws:iam::12345678901:saml-provider/yak-saml-provider`. When `type` is `CanonicalUser`, these are [canonical user IDs](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId), e.g., `79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be`.
        """
        return pulumi.get(self, "identifiers")

    @identifiers.setter
    def identifiers(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "identifiers", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of principal. Valid values include `AWS`, `Service`, `Federated`, `CanonicalUser` and `*`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: _builtins.str):
        pulumi.set(self, "type", value)


if not MYPY:
    class GetPolicyDocumentStatementPrincipalArgsDict(TypedDict):
        identifiers: Sequence[_builtins.str]
        """
        List of identifiers for principals. When `type` is `AWS`, these are IAM principal ARNs, e.g., `arn:aws:iam::12345678901:role/yak-role`.  When `type` is `Service`, these are AWS Service roles, e.g., `lambda.amazonaws.com`. When `type` is `Federated`, these are web identity users or SAML provider ARNs, e.g., `accounts.google.com` or `arn:aws:iam::12345678901:saml-provider/yak-saml-provider`. When `type` is `CanonicalUser`, these are [canonical user IDs](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId), e.g., `79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be`.
        """
        type: _builtins.str
        """
        Type of principal. Valid values include `AWS`, `Service`, `Federated`, `CanonicalUser` and `*`.
        """
elif False:
    GetPolicyDocumentStatementPrincipalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPolicyDocumentStatementPrincipalArgs:
    def __init__(__self__, *,
                 identifiers: Sequence[_builtins.str],
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identifiers: List of identifiers for principals. When `type` is `AWS`, these are IAM principal ARNs, e.g., `arn:aws:iam::12345678901:role/yak-role`.  When `type` is `Service`, these are AWS Service roles, e.g., `lambda.amazonaws.com`. When `type` is `Federated`, these are web identity users or SAML provider ARNs, e.g., `accounts.google.com` or `arn:aws:iam::12345678901:saml-provider/yak-saml-provider`. When `type` is `CanonicalUser`, these are [canonical user IDs](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId), e.g., `79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be`.
        :param _builtins.str type: Type of principal. Valid values include `AWS`, `Service`, `Federated`, `CanonicalUser` and `*`.
        """
        pulumi.set(__self__, "identifiers", identifiers)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def identifiers(self) -> Sequence[_builtins.str]:
        """
        List of identifiers for principals. When `type` is `AWS`, these are IAM principal ARNs, e.g., `arn:aws:iam::12345678901:role/yak-role`.  When `type` is `Service`, these are AWS Service roles, e.g., `lambda.amazonaws.com`. When `type` is `Federated`, these are web identity users or SAML provider ARNs, e.g., `accounts.google.com` or `arn:aws:iam::12345678901:saml-provider/yak-saml-provider`. When `type` is `CanonicalUser`, these are [canonical user IDs](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId), e.g., `79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be`.
        """
        return pulumi.get(self, "identifiers")

    @identifiers.setter
    def identifiers(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "identifiers", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of principal. Valid values include `AWS`, `Service`, `Federated`, `CanonicalUser` and `*`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: _builtins.str):
        pulumi.set(self, "type", value)


if not MYPY:
    class GetPrincipalPolicySimulationContextArgsDict(TypedDict):
        key: _builtins.str
        """
        The context _condition key_ to set.

        If you have policies containing `Condition` elements or using dynamic interpolations then you will need to provide suitable values for each condition key your policies use. See [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to find the various condition keys that are normally provided for real requests to each action of each AWS service.
        """
        type: _builtins.str
        """
        An IAM value type that determines how the policy simulator will interpret the strings given in `values`.

        For more information, see the `ContextKeyType` field of [`iam.ContextEntry`](https://docs.aws.amazon.com/IAM/latest/APIReference/API_ContextEntry.html) in the underlying API.
        """
        values: Sequence[_builtins.str]
        """
        A set of one or more values for this context entry.
        """
elif False:
    GetPrincipalPolicySimulationContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPrincipalPolicySimulationContextArgs:
    def __init__(__self__, *,
                 key: _builtins.str,
                 type: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: The context _condition key_ to set.
               
               If you have policies containing `Condition` elements or using dynamic interpolations then you will need to provide suitable values for each condition key your policies use. See [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to find the various condition keys that are normally provided for real requests to each action of each AWS service.
        :param _builtins.str type: An IAM value type that determines how the policy simulator will interpret the strings given in `values`.
               
               For more information, see the `ContextKeyType` field of [`iam.ContextEntry`](https://docs.aws.amazon.com/IAM/latest/APIReference/API_ContextEntry.html) in the underlying API.
        :param Sequence[_builtins.str] values: A set of one or more values for this context entry.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The context _condition key_ to set.

        If you have policies containing `Condition` elements or using dynamic interpolations then you will need to provide suitable values for each condition key your policies use. See [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to find the various condition keys that are normally provided for real requests to each action of each AWS service.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: _builtins.str):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        An IAM value type that determines how the policy simulator will interpret the strings given in `values`.

        For more information, see the `ContextKeyType` field of [`iam.ContextEntry`](https://docs.aws.amazon.com/IAM/latest/APIReference/API_ContextEntry.html) in the underlying API.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: _builtins.str):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A set of one or more values for this context entry.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


